﻿
var myApp = angular.module('myApp', []);

myApp.factory("datasource", function () {
    return {
        items: [],       
        update: function () {
            var mainScope = $("#main").scope();
            mainScope.items = this.items;
            mainScope.$apply();
        }
    }
});
var _datasource = angular.injector(["myApp"]).get("datasource");

function bindRecords(data) {
    _datasource.items = data._APP_RESULT_LIST2;
    _datasource.update();
}



myApp.controller("myres.ctr", ['datasource', '$scope', function (datasource, $scope) {

    $scope.items = datasource.items

    $scope.title = function (suffix) {
        return suffix === "epub" ? "Coursewaretitle" : "TeachingNotestitle";
    };

    $scope.downLoad = function (file_id) {
        ucbook.postWebPageMessage(JSON.stringify({ action: "downLoad", arguments: file_id }));
    };


    $scope.delRes = function (file_id) {
        ucbook.postWebPageMessage(JSON.stringify({ action: "DelRes", arguments: file_id }));
    };
} ]);





$(function () {
    ucbook.postWebPageMessage("ready");
    document.addEventListener("contextmenu", function (ev) {
        ev.preventDefault();
    },false);
});
