function loadCss() {
	$("<link>", {"type":"text/css","rel":"stylesheet","href":"../css/main.css"}).appendTo( $("body") );
};

$(function() {
	loadCss();
});

function myres_click() {
    ucbook.postWebPageMessage(JSON.stringify({ action: "SelectBook", arguments:0 }));
}


var bookPath, subjectId, chapterListTemplatFunc, chapterContentTemplateFunc, testRecordTemplateFunc;

var exerciseBook = (function () {
    var questionsData = null, curChapterId;

    function transData(a, idStr, pidStr, chindrenStr) {
        var r = [], hash = {}, id = idStr, pid = pidStr, children = chindrenStr, i = 0, j = 0, len = a.length;
        for (; i < len; i++) {
            hash[a[i][id]] = a[i];
        }
        for (; j < len; j++) {
            var aVal = a[j], hashVP = hash[aVal[pid]];
            if (hashVP) {
                var ary = aVal.cha_number.split(".");
                var orderNum = ary[ary.length - 1];
                !hashVP[children] && (hashVP[children] = []);
                hashVP[children][orderNum - 1] = aVal;
            } else {
                r[Number(aVal.cha_number) - 1] = aVal;
            }
        }
        return r;
    }

    function bindTocEvents() {
        $("#directory-toc").on('click', 'li div', function () {
            var $this = $(this);
            $("#" + curChapterId).attr("style", "");
            $this.css("background-color", "#82CE4A");
            if ($this.closest("ul").siblings("div").length > 0) {
                $this.closest('li').siblings("li").find("div").css("background-color", "#FFFFFF");

                curChapterId = this.id;
                $this.closest("ul").siblings("div").attr("style", "");
                loadChapterContent(curChapterId);
            }

            $this.siblings('ul').toggle();
            if ($this.find("span.collapsed").length > 0) {
                $this.css("color", "#31A4D9");
                $this.find('span').attr('class', 'expanded');
                var $lis = $this.closest('li').siblings('li');
                $lis.find('span').attr('class', 'collapsed');
                $lis.find('ul').hide();
                $lis.find('div').attr("style", "");
            } else if ($this.find("span.expanded").length > 0) {
                $this.find('span').attr('class', 'collapsed');
            }

            return false;
        }, true);
    }

    function layout() {
        var clientHeight = document.body.clientHeight,
				containerHeight = clientHeight;

        $("#chapter_list").height(containerHeight);
        $(".directory-panel").css("height", containerHeight);
    }

    function loadChaptersNew(chapterList) {
        var tocData = transData(chapterList, 'id', 'up_id', 'children'),
				$data = chapterListTemplatFunc({ "children": tocData });
        $(".directory-panel").html($data);
        bindTocEvents();
        curChapterId = tocData[0].children[0].id;
        $("#" + curChapterId).css("background-color", "#82CE4A");
        loadChapterContent(curChapterId);
        layout();
        window.onresize = layout;
    }
    function loadChapters() {

        loadFile(bookPath + "/chapter.xml", function (chapterList) {
            var tocData = transData(chapterList, 'id', 'up_id', 'children'),
				$data = chapterListTemplatFunc({ "children": tocData });
            $(".directory-panel").html($data);
            bindTocEvents();
            curChapterId = tocData[0].children[0].id;
            $("#" + curChapterId).css("background-color", "#82CE4A");
            loadChapterContent(curChapterId);
            layout();
            window.onresize = layout;
        }, function (error) { alert("open exercise book erro:" + error) })
    }

    function loadChapterContent(chapterId) {

        loadFile(bookPath + "/Entity/" + chapterId + ".json", function (chapterContent) {
            if (!chapterContent || chapterContent.length == 0) {
                $("#chapter_content").html('<h3>˽ݡ</h3>').show();
                return;
            };

        }, function (error) { alert("open exercise book erro:" + error) })
    }



    function bind() {
        $(".arrow").on("click", function () {
            $(this).hide();
            $("#chapter_list").data("expanded", true).show();
            $("#chapter_content").addClass("slideRight");
            layout();
        })

        $("#chapter_content").on("click", function () {
            if ($("#chapter_list").data("expanded")) {
                $(this).removeClass("slideRight");
                $("#chapter_list").data("expanded", false).hide();
                $(".arrow").show();
            }
        })


    }
    return {
        getResrouceRootPath: function () {
            return bookPath;
        },

        load: function (chapters) {
            bookPath = "";
            loadChaptersNew(chapters);
            bind();
        }
    }
} ());

function initTemplates() {
    chapterListTemplatFunc = templateLoader.load("js/template/chapterlist.tpl");
}
function onMessage(message) {
    try {
        var msg = JSON.parse(message);
        switch (msg.action) {
            case "loadchapter":
                exerciseBook.load(msg.arguments);
                break;
            default:
                break;
        }
    } catch (e) {
        console.log(e + ":" + message);
        return;
    }
};


function loadFile(filePath, onSuccess, onError) {
    $.ajax({
        type: "GET",
        url: filePath,
        dataType: "json",
        async: false,
        timeout: 300,
        success: onSuccess,
        error: onError
    });

}




window.onload = function () {
    ucbook.onWebPageMessage = onMessage;
    ucbook.postWebPageMessage("ready");
    Common.registerHandlebarsHelper();
    initTemplates();
//    components = window.location.href.split("#")[1];
//    if (!components) return;
//    var arguments = components.split("&"),
//			bookInfo = {};

//    for (var i = 0; i < arguments.length; i++) {
//        var kv = arguments[i].split("=");
//        bookInfo[kv[0]] = decodeURIComponent(kv[1]);
//    }
//    exerciseBook.load(bookInfo);
};

var templateLoader = (function() {
	function getSource(tpl) {
		var xhr = new XMLHttpRequest();
		xhr.open("GET", tpl, false);
		xhr.send();
		if(xhr.readyState == 4 && (xhr.status == 0 || xhr.status == 200)) {
			return xhr.responseText;
		}
		return null;
	}
	
	return {
		load: function(tpl) {
			return Handlebars.compile(getSource(tpl));
		}
	}
}());