// JavaScript Document
/** 
*
*	@param {"action": "showExerciseBook", "arguments": "章的数据结构"} //展示章节节点;
*	@param {"action": "showChapterContent", "arguments" : "内容数据结构"} //展示右侧内容;
*	@param {"action": "getChoosedQuestions", "arguments" : "题目数据"}); //发布作业接口;
*	@param {"action": "previewHomework"} //展示预览;
*	@param {"action": "closePreview"}; //关闭预览;
*
**/
var examinations = {},
	bookid, 
	subjectId, 
	chapterid, 
	chapterName, 
	homeworkpath, 
	questionContent, 
	content, 
	chapterlist, 
	resultContent, 
	homeWorkTopicStatus, 
	flag = 0,
	view_model;

//右侧题目显示的模版;
var template = Handlebars.compile($("#exercise_template").html());
//左侧的目录模版;
var directory_template = Handlebars.compile($('#directory-list-template').html());

var questionTypeOrders = {
    "100": {
		"主观题" : 0,
        "单项选择": 1,
        "多项选择": 2,
        "基础题": 3,
        "阅读题": 4,
        "作文": 5,
        "复合题": 6,
        "其他": 7
    },
    "103": {
		"主观题" : 0,
        "单项选择": 1,
        "多项选择": 2,
        "填空题": 3,
        "判断题": 4,
        "解答题": 5,
        "复合题": 6
    },
    "104": {
		"主观题" : 0,
        "语音题": 1,
        "听力题": 2,
        "单项选择": 3,
        "单项填空": 4,
        "填空题": 5,
        "英汉互译": 6,
        "补全对话": 7,
        "句型转换": 8,
        "完形填空": 9,
        "完型填空": 10,
        "完成对话": 11,
        "看图填词句": 12,
        "词汇填空": 13,
        "改错题": 14,
        "连词成句": 15,
        "阅读填空": 16,
        "阅读理解": 17,
        "匹配题": 18,
        "复合题": 19,
        "其他": 20
    },
    "106": {
		"主观题" : 0,
        "单项选择": 1,
        "多项选择": 2,
        "填空题": 3,
        "综合题": 4,
        "复合题": 5,
        "其他": 6
    },
    "107": {
		"主观题" : 0,
        "单项选择": 1,
        "多项选择": 2,
        "填空题": 3,
        "复合题": 4
    },
    "165": {
		"主观题" : 0,
        "单项选择": 1,
        "多项选择": 2,
        "非选择题": 3,
        "复合题": 4
    },
    "166": {
		"主观题" : 0,
        "单项选择": 1,
        "多项选择": 2,
        "综合题": 3,
        "复合题": 4
    },
    "265": {
		"主观题" : 0,
        "单项选择": 1,
        "多项选择": 2,
        "问答题": 3,
        "复合题": 4
    },
    "105": {
		"主观题" : 0,
        "单项选择": 1,
        "多项选择": 2,
        "判断题": 3,
        "探究实践题": 4,
        "分析说明题": 5,
        "复合题": 6
    }
}

//把题目根据各种题目类型进行分类和排列;
function rearrangeQuestions(questions) {
    var count = questions.length,
    questionCollections = [],
    typeMap = {},
    mapIndex = 0;
	//subjectId  表示标题Id;
	
	//通过这些东西进行排序;
    var curOrder = questionTypeOrders[subjectId];
    for (var i = 0; i < count; i++) {
		//修复获取的题目类型;
        var type = questions[i].type; // data[0].topic.topic_type;
        if (type == "" || type == undefined) {
            type = "其他";
        } else if (type == "选择题") {
			//判断内部数据的值;
            var t = questions[i].data[0].topic.topic_type;
            if (t == 0) type = "单项选择";
            else if (t == 2) type = "多项选择";
            else if (t == 3) type = "复合题";
			//对这个值重新赋值, 所以外面的数据questions[i].type是要的,现在是对这个类型进行细分;
            questions[i].type = type;
        };
		//对type进行修复;
		
		//题目对应 (curOrder ===  {单项选择: 1, 多项选择: 2, 基础题: 3, 阅读题: 4, 作文: 5})
        var typeid = curOrder[type];
		
		//设置typeMap  ==>>  为不同的题目设置递增的index;
        if (typeMap[typeid] === undefined) {
            typeMap[typeid] = mapIndex;
            questionCollections[mapIndex] = {
                type: type,
                questions: []
            };
            mapIndex++;
        };
		//把题目push到对应的类型下
        questionCollections[typeMap[typeid]].questions.push(questions[i]);
    };
	
	//根据题目类型进行排列;
    questionCollections.sort(function(collection1, collection2) {
        var curOrder = questionTypeOrders[subjectId];
		//根据类型进行排序;
        return curOrder[collection1.type] - curOrder[collection2.type];

    });
	
    return {
        count: count,
        questionCollections: questionCollections
    }
}

Handlebars.registerHelper("isShortAnswerType",
function(type, options) {
    if (type !== 1 && (typeof type === "string" && type !== "1")) {
		//调用else的options, 把this传进去..;
        return options.inverse(this);
    } else {
        return options.fn(this);
    };
});

Handlebars.registerHelper("isMultiChoiceType",
function(type, options) {
    if (type !== 0 && (typeof type === "string" && type !== "0")) {
        return options.inverse(this);
    } else {
        return options.fn(this);
    };
});

Handlebars.registerHelper("get_alpha_index",
function(index) {
    return String.fromCharCode('A'.charCodeAt(0) + index);
});
//unless
Handlebars.registerHelper("isCorrectAnswer",
function(correct, options) {
    if (correct !== 1 && (typeof correct === "string" && correct !== "1")) {
        return options.inverse(this);
    } else {
        return options.fn(this);
    }
});

/*把所有的图片相对的地址转化成绝对定位的;*/
function getHTMLContent(text) {
    try {
        var container = $("<div>" + text + "</div>");
        container.find("img").each(function(index, elem) {
            var relativePath = elem.getAttribute("src"),
            //图片是base64数据类型或者是绝对路径的话,
                isDataUrl = (relativePath.indexOf("data") == 0)||(relativePath.indexOf("http") == 0);
            if (isDataUrl) return;
			//如果第一个不是"/"就在最后添加"/";
            if (relativePath[0] !== "/") relativePath += "/";

            var index = homeworkpath.indexOf("file://");
			//就是一堆判断＞﹏＜;
            if (index == -1) {
                elem.src = "file://" + homeworkpath + relativePath;
            } else elem.src = homeworkpath + relativePath;
        });
        return new Handlebars.SafeString(container.html());
    } catch(e) {
        return "";
    }
};

function getAnalysisContent(data) {
	//debugger;
    var content = "";
    if (data[0].topic.topic_analytic) {
        content = extractAnalysisContent(data[0].topic.topic_analytic);
    } else {
        for (var i = 1,
        length = data.length; i < length; i++) {
            content += extractAnalysisContent(data[i].topic.topic_analytic);
        }
    }

    return getHTMLContent(!content ? "略": content);
};

function extractAnalysisContent(text) {
    var analysisKeys = ["思路解析", "分析", "解析", "提示"],
    answerKeyss = ["参考答案", "答案", "解"],
    suggestionKeys = ["点拨"],
    suffixPattern = "((<[^>]*>){2,})?[:：]?",
    topicAnalytic = text.trim();

    function findPos(keys) {
        var pos = -1,
        re = null,
        result = null;
        for (var i = 0,
        length = keys.length; i < length; i++) {
            re = new RegExp(keys[i] + suffixPattern);
            result = topicAnalytic.match(re);
            if (result) break;
        }
        return result;
    };

    function trimAnswerContent(text) {
        var result = text.match(/^(<[^>]*>)*((\(\d\))?[ABCD]\s*)+(<\/[^>]*>)*/i);
        return ! result ? text: text.substr(result.index + result[0].length);
    };

    function trimContent(content) {
        var start = content[0] == '<' ? content.indexOf('>') + 1 : 0,
        end = content[content.length - 1] == '>' ? content.lastIndexOf('<') : content.length;
        return content.slice(start, end);
    }

    function extractContent(contentPos, pos1, pos2) {
        if (!contentPos) return "";
        var end = topicAnalytic.length;
        if (pos1 && pos1.index > contentPos.index) end = pos1.index;
        if (pos2 && pos2.index > contentPos.index && pos2.index < end) end = pos2.index;
        return trimContent(topicAnalytic.slice(contentPos.index + contentPos[0].length, end));
    }

    var result = null,
		analysisPos = findPos(analysisKeys),
		answerPos = findPos(answerKeyss),
		suggestionPos = findPos(suggestionKeys),
		analysisContent = null;

    if (!analysisPos && !answerPos && !suggestionPos) {
        analysisContent = trimAnswerContent(topicAnalytic);
    } else if (!analysisPos && !suggestionPos) {
        analysisContent = trimAnswerContent(topicAnalytic.substr(answerPos.index + answerPos[0].length));
    } else {
        analysisContent = extractContent(analysisPos, answerPos, suggestionPos) + extractContent(suggestionPos, answerPos, analysisPos);
    }
    return analysisContent;
};

Handlebars.registerHelper("get_html_content", getHTMLContent);

Handlebars.registerHelper("get_analysis_content", getAnalysisContent);

Handlebars.registerHelper("inc",
function(index) {
    return index + 1;
});

Handlebars.registerHelper("isRightAnswer",
function(str, options) {
    if (str !== "0") {
        return options.fn(this);
    }
});

//迭代左侧的目录树Helper;
var audaciousFn;
Handlebars.registerHelper('recursive',
function(children, options) {
    var out = '';
    if (options.fn !== undefined) {
        audaciousFn = options.fn;
    }
    children.forEach(function(child) {
        out = out + audaciousFn(child);
    });
    return out;
});

function renderToc() {
    //按照"children"的值进行排列, 目前这边用不到children;
    var tocData = transData(chapterlist, 'id', 'up_id', 'children');
    //左侧的目录模版渲染的结果;
    var $data = directory_template({
        "children": tocData
    });
    chapterid = tocData[0].id;
    //第一个章节的内容;
    chapterName = tocData[0].cha_name;
    $(".directory-panel").html($data);
    var directoryList = document.getElementById("directory-toc");
    if (directoryList) {
        //无语..
        this.listItem = function(li) {
            if (li.getElementsByTagName("ul").length > 0) {
                //里面有UL就把UL隐藏;
                var ul = li.getElementsByTagName("ul")[0];
                ul.style.display = "none";
                var span = document.createElement("span");
                span.className = "collapsed";
                $(span).insertBefore($(li).find('a')[0]);
            }
        }
        var items = directoryList.getElementsByTagName("li");
        for (var i = 0; i < items.length; i++) {
            listItem(items[i]);
        }
    }
}

function transData(a, idStr, pidStr, chindrenStr) {
    var r = [],
    hash = {},
    id = idStr,
    pid = pidStr,
    children = chindrenStr,
    i = 0,
    j = 0,
    len = a.length;
    for (; i < len; i++) {
        hash[a[i][id]] = a[i];
    }
    for (; j < len; j++) {
        var aVal = a[j],
        hashVP = hash[aVal[pid]];
        if (hashVP) {
            var ary = aVal.cha_number.split(".");
            var orderNum = ary[ary.length - 1]; ! hashVP[children] && (hashVP[children] = []);
            hashVP[children][orderNum - 1] = aVal;
        } else {
            r.push(aVal);
        }
    };
	//最后要对返回章进行最后一次排序;
	r.sort(function( obj0, obj1) {
		return obj0.cha_number - obj1.cha_number;
	});
    return r;
};

function bindTocEvents() {
    $("#directory-toc").on('click', 'li div',
    function() {
		//这个是节
        if ($(this).closest("ul").siblings("div").length > 0) {
            //$(this).closest('li').siblings("li").find("div").css("background-color", "#FFFFFF");
            //$(this).css("background-color", "#E7F1FF");
            chapterid = this.id;
            chapterName = $(this).find("a").html();
            getChapterContent();
        }else{
			//这个就是章了;
			chapterid = this.id;
            chapterName = $(this).find("a").html();
            getChapterContent();
		};
		//包含章
		$("div",$(this).closest(".directory-toc")).css("background-color", "#FFFFFF")
		$(this).css("background-color", "#E7F1FF");
        $(this).siblings('ul').toggle();
        if ($(this).find('span').hasClass('expanded')) {
            $(this).find('span').attr('class', 'collapsed');
        } else {
            $(this).find('span').attr('class', 'expanded');
        }
        $(this).closest('li').siblings('li').find('span').attr('class', 'collapsed');
        $(this).closest('li').siblings('li').find('ul').hide();
        return false;
    })
}

function bindCheckboxEvents() {
    $('input[name="group_selection"]').on("click",
    function() {
        if ($(this).data("type")) {
            var isChecked = $(this).prop("checked");
            var collection = $(".question_collection[data-type=" + $(this).data("type") + "]");
            collection.find(".question_number input[type='checkbox']").prop("checked", isChecked);
            var questions = collection.find(".question");
            for (var i = 0; i < questions.length; i++) {
                var id = $(questions[i]).attr("id");
                if (isChecked) {
                    var obj = content.questionCollections[collection.data("index")].questions[i];
                    obj.bookid = bookid;
                    examinations[id] = obj;
                    //alert("into..."+JSON.stringify(examinations));
                } else {
                    if (examinations[id]) {
                        delete examinations[id];
                    }
                }
            }
        } else {
            var selectAll = $(this).closest(".question").siblings(".question_collection_header").find("input[type='checkbox']");
            var id = $(this).closest(".question").attr("id");
            if ($(this).prop("checked")) {
                $(this).prop("checked", true);
                if (!examinations[id]) {
                    var questionIndex = $(this).closest(".question").data("index");
                    var collectionIndex = $(this).closest(".question_collection").data("index");
                    var obj = content.questionCollections[collectionIndex].questions[questionIndex];
                    obj.bookid = bookid;
                    examinations[id] = obj;
                }
                var otherSelect = $(this).closest(".question").siblings(".question").find("input[type='checkbox']");
                var count = 0;
                if (otherSelect) {
                    for (var i = 0; i < otherSelect.length; i++) {
                        if ($(otherSelect[i]).prop("checked")) {
                            count += 1;
                        }
                    }
                    if (count == otherSelect.length) {
                        if (!selectAll.prop("checked")) {
                            selectAll.prop("checked", true);
                        }
                    }
                }
            } else {
                $(this).prop("checked", false);
                if (examinations[id]) {
                    delete examinations[id];
                }
                if (selectAll.prop("checked")) {
                    selectAll.prop("checked", false);
                }
            }
        }

    })
}

function hideContents() {
    $("#chapter_content").hide();
    $("#exercise_result").hide();
    $("#exercise_preview").hide();
}

function resultRate() {
    var q = $(".question");

    if (homeWorkTopicStatus.length > 0) {

        for (var i = 0; i < q.length; i++) {
            var questionId = q[i].id;

            for (var j = 0; j < homeWorkTopicStatus.length; j++) {
                if (homeWorkTopicStatus[j].topicId == questionId) {
                    var rate = homeWorkTopicStatus[j].rate;
                    var rateDom = $(q[i]).find(".question_result p").first();
                    rateDom.css("color", changeRateStyle(rate)).html(rate + "%");
                }
            }
        }
    } else {
        $(".question_result .rate").css("color", "#FF3300");
    }
}

function changeRateStyle(rate) {
    if (rate >= 80 && rate <= 100) {
        return "#66CC00";
    } else if (rate >= 60 && rate < 80) {
        return "#FFC108";
    } else if (rate < 60) {
        return "#FF3300";
    }
}

function reCheckQuestions() {
    var questions = $(".question");
    var collections = $(".question_collection");
    for (var i = 0; i < questions.length; i++) {
        for (var j in examinations) {
            if ($(questions[i]).attr("id") == j) {
                $(questions[i]).find("input[name='group_selection']").prop("checked", true);
            }
        }
    }

    for (var k = 0; k < collections.length; k++) {
        if ($(collections[k]).find(".question_number input:checked").length == $(collections[k]).find(".question").length) {
            $(collections[k]).find(".question_collection_header input").prop("checked", true);
        }
    }
}

function showChapterContent( questionContent ) {
    hideContents();
    if (flag == 0) {
        topic = "";
    } else {
        if (!questionContent || questionContent.length == 0) {

            $("#chapter_panel").html(topic + '<h3>此节暂无内容。</h3>').show();
            $("#chapter_content").show();
            //blindinithandler();
            return;
        };
    }
    //这个先过, 处理数据;
    content = rearrangeQuestions(questionContent);
    //l(content);
    $("#chapter_panel").html( template(content ));
    $("#chapter_content").show();
    //l(examinations);
    if (examinations) {
        reCheckQuestions();
    }

    bindCheckboxEvents();
    //blindinithandler();
    $("body").css("overflow", "hidden");
    flag++;
};

function showExerciseResult() {
    var result = rearrangeQuestions(resultContent);
    $("#exercise_result").html(template(result));
    resultRate();
    $("#exercise_result").show();
    $("#exercise_result .question_collection").css("margin", "0px");
    $("body").css("overflow", "auto");
};

function exercisePreview() {
    var questions = [];
    if (!isEmptyObject(examinations)) {
        var count = 0;
        for (var i in examinations) {
            questions[count] = examinations[i];
            count++;
        }
    }
    //都要对数据进行重新处理
    var previewContent = rearrangeQuestions(questions);
    hideContents();
    //加载内容;
    $("#exercise_preview").html(template(previewContent));
    $("#exercise_preview").show();
    $("body").css("overflow", "auto");
}

function backToChapterFromPreview() {
    $("#exercise_result").hide();
    $("#chapter_content").show();
	$("#exercise_preview").hide();
    $("body").css("overflow", "hidden");
};

function isEmptyObject(obj) {
    for (var name in obj) {
        return false;
    }
    return true;
}

window.l = function(msg) {
    msg = typeof msg === "object" ? JSON.stringify(msg) : msg;
    $("<div>", {
        width: "100%",
        height: "100%"
    }).css({
        position: "fixed",
        left: 0,
        top: 0
    }).click(function() {
        $(this).remove();
    }).html(msg).appendTo($("body"));
};

function onMessage(message) {
	var msg;
    try {
        //console.log(message);
        msg = JSON.parse(message);
    } catch(e) {
		alert(e);
        //console.log(e + ":" + message);
        return;
    }
    switch (msg.action) {
    case "showExerciseBook":
        flag = 0;
        bookid = msg.arguments[0].bookid;
        //第一个bookId
        subjectId = msg.arguments[0].subjectId || "100";
        homeworkpath = msg.arguments[0].homeworkpath;
        //全局变量;
        chapterid = msg.arguments[0].chapterid;
        chapterlist = msg.arguments[0].chapterlist;
        //console.log("aaaa" + msg.arguments[0].viewModel);
        view_model = msg.arguments[0].viewModel;
        //view_model = false;
		/*
        if (msg.arguments[0].viewModel) {

            $("#chapter_content").addClass("view_model");
        } else {
            $("#navbar").addClass("view_model");
        };
		*/
        $(".header_center").html(msg.arguments[0].bookTitle);
        renderToc();
        bindTocEvents();
		
        //bookid, chapterid, chapterName
        //获取内容;
		//getChapterContent();
        //返回键的事件;
        //bindbutton();
        break;
    case "showChapterContent":
        var questionContent = msg.arguments;
        showChapterContent( questionContent );
        if (view_model) {
            $(".question_bar").addClass("view_model");
            $(".addtopic").addClass("view_model");
            $(".question_model_answer").addClass("view_model");
        } else {
            $(".showanswerbar").addClass("view_model");
        };
		initEventsForSlider();
        break;

    case "previewHomework":
        exercisePreview();
        break;
    case "closePreview":
        backToChapterFromPreview();
        break;
    case "showHomeworkResult":
        //这个在这个页面没有用到;
        resultContent = msg.arguments.examinations;
        homeworkpath = msg.arguments.homeworkpath;
        homeWorkTopicStatus = msg.arguments.homeWorkTopicSta;
        subjectId = msg.arguments.subjectId;
        $("#navbar").addClass("view_model");
        showExerciseResult();
        break;
    case "getChoosedQuestions":
        var results = [];
        for (item in examinations) {
            var obj = examinations[item];
            if (typeof question !== "object") {
                results.push(obj);
            }
        }
        return ucbook.postWebPageMessage(JSON.stringify({
            action: "setChooseQuestions",
            arguments: results
        }));
        break;
    }
};

function initEventsForSlider() {
	$.sliderX(".slider",{
		onDrag : function() {
			var val = parseInt(this.getPercent()/100*20);
			$(".question_bar_header" ,this.obj.closest(".question_bar") ).html( val+"分" );
			
			//获取元素
			var questionIndex = $(this.obj).closest(".question").data("index");
			var collectionIndex = $(this.obj).closest(".question_collection").data("index");
			var obj = content.questionCollections[collectionIndex].questions[questionIndex];
			//console.log( this.obj.closest(".question_bar") );
			//console.log( this.obj );
			//examinations[id] = obj;
			//console.log(obj);
			
			obj.score = val;
		},
		triggerSetValue : function(val) {
			$(this.obj).closest(".question_bar").find(".question_bar_header").html(val*20+ "分");
		}
	});
	$(".slider").each(function(i,e) {
		e.drag.setValue(0.5);
	});
};

function getChapterContent() {
    var cmdJSON = JSON.stringify({
        action: "getChapterContent",
        arguments: [bookid, chapterid, chapterName]
    });
    window.ucbook&&ucbook.postWebPageMessage(cmdJSON);
	//for test
	//!window.ucbook&&onMessage(JSON.stringify(contentData));
	!window.ucbook&&onMessage(JSON.stringify(contentData1));
	//右侧的滑动条事件;
	//initEventsForSlider();
};

window.onload = function() {
    if (typeof ucbook === "object") {
        ucbook.onWebPageMessage = onMessage;
        ucbook.postWebPageMessage("ready");
    } else {
        // for test;
        onMessage(JSON.stringify(data));
		onMessage(JSON.stringify(contentData));
    };
    document.oncontextmenu = new Function("return false;")
	
    window.addEventListener("dragover",
    function(e) {
        e = e || event;
        e.preventDefault();
    },
    false);
    window.addEventListener("drop",
    function(e) {
        e = e || event;
        e.preventDefault();
    },
    false);
};