﻿// JavaScript Document
var questionTypeOrders = {
    "100": {
        "单项选择": 1,
        "多项选择": 2,
        "基础题": 3,
        "阅读题": 4,
        "作文": 5,
        "复合题": 6,
        "其他": 7,
		"主观题" : 8
    },
    "103": {
        "单项选择": 1,
        "多项选择": 2,
        "填空题": 3,
        "判断题": 4,
        "解答题": 5,
        "复合题": 6,
		"主观题" : 7
    },
    "104": {
        "语音题": 1,
        "听力题": 2,
        "单项选择": 3,
        "单项填空": 4,
        "填空题": 5,
        "英汉互译": 6,
        "补全对话": 7,
        "句型转换": 8,
        "完形填空": 9,
        "完型填空": 10,
        "完成对话": 11,
        "看图填词句": 12,
        "词汇填空": 13,
        "改错题": 14,
        "连词成句": 15,
        "阅读填空": 16,
        "阅读理解": 17,
        "匹配题": 18,
        "复合题": 19,
        "其他": 20,
		"主观题" : 21
    },
    "106": {
        "单项选择": 1,
        "多项选择": 2,
        "填空题": 3,
        "综合题": 4,
        "复合题": 5,
        "其他": 6,
		"主观题" : 7
    },
    "107": {
        "单项选择": 1,
        "多项选择": 2,
        "填空题": 3,
        "复合题": 4,
		"主观题" : 5
    },
    "165": {
        "单项选择": 1,
        "多项选择": 2,
        "非选择题": 3,
        "复合题": 4,
		"主观题" : 5
    },
    "166": {
        "单项选择": 1,
        "多项选择": 2,
        "综合题": 3,
        "复合题": 4,
		"主观题" : 5
    },
    "265": {
        "单项选择": 1,
        "多项选择": 2,
        "问答题": 3,
        "复合题": 4,
		"主观题" : 5
    },
    "105": {
        "单项选择": 1,
        "多项选择": 2,
        "判断题": 3,
        "探究实践题": 4,
        "分析说明题": 5,
        "复合题": 6,
		"主观题" : 7
    }
};

//简单的用jQ弄的发布者和订阅者;
(function() {
	window.Publish = function() {
		this.nullEl = $("<div />");
	};
	
	Publish.prototype.publish = function(type) {
		this.nullEl.trigger(type);
	};
	
	Publish.prototype.subscribe = function(type,fn) {
		this.nullEl.bind(type, fn);
	};
})();

var question = (function() {
    function appendStudentAnswer(questionData, result, topicStatics) {
        var curId = questionData[0].topic.id;
        questionData[0].correct = result.correct;
        questionData[0].partlyCorrect = result.partlyCorrect;
        if (topicStatics && topicStatics[curId]) {
            questionData[0].classCorrectRate = topicStatics[curId].rate;
        }

        if (questionData[0].topic.topic_type == "0" || questionData[0].topic.topic_type == "2") {
            questionData[0].studentAnswer = result.answer.join(",");
        } else if (questionData[0].topic.topic_type == "1") {
            for (var j = 0; j < questionData[0].topindexs.length; j++) {
                questionData[0].topindexs[j].studentAnswer = result.answer[j];
            }
        } else if (questionData[0].topic.topic_type == "4") {
           for (var j = 0; j < result.answer.length; j++) {
                questionData[0].topindexs[j] = questionData[0].topindexs[j] || {};
                questionData[0].topindexs[j].studentAnswer = result.answer[j].extra;
            };
		}else{
            for (var k = 0; k < result.answer.length; k++) {
                appendStudentAnswer([questionData[k + 1]], result.answer[k], topicStatics);
            }
        }
    }

    return {
        rearrangeQuestions: function(questions, subject) {
            var count = questions.length,
            curQuestion = null,
            curNumber = 1,
            questionCollections = [],
            typeMap = {},
            mapIndex = 0;

            var curOrder = questionTypeOrders[subject];
            for (var i = 0; i < count; i++) {
                var type = questions[i].type; // data[0].topic.topic_type;
                if (questions[i].type == "选择题") {
                    var t = questions[i].data[0].topic.topic_type;
                    if (t == 0) ltype = "单项选择";
                    else if (t == 2) ltype = "多项选择";
                    else if (t == 3) ltype = "复合题";
                    type = ltype;
                }
                var typeid = curOrder[type];

                if (typeMap[typeid] === undefined) {
                    typeMap[typeid] = mapIndex;
                    questionCollections[mapIndex] = {
                        type: type,
                        questions: []
                    };
                    mapIndex++;
                }
                questionCollections[typeMap[typeid]].questions.push(questions[i]);
            }
            questionCollections.sort(function(collection1, collection2) {
                var curOrder = questionTypeOrders[subject];
                return curOrder[collection1.type] - curOrder[collection2.type];
            });

            for (var i = 0; i < questionCollections.length; i++) {
                for (var j = 0; j < questionCollections[i].questions.length; j++) {
                    curQuestion = questionCollections[i].questions[j];
                    curQuestion.id = curQuestion.data[0].topic.id;
                    curQuestion.number = curNumber;
                    curQuestion.collectionIndex = i;
                    curNumber++;
                }
            }
            return {
                count: count,
                questionCollections: questionCollections
            }
        },

        mergeResult: function(questionsData, answerResult) {
            var errorCount = 0,
            questionCollection = null;
            try {
                var results = JSON.parse(decodeURIComponent(answerResult.content));
                questionsData.errorCount = answerResult.errorCount;
                questionsData.correctRate = answerResult.correctRate;
                questionsData.starLevel = answerResult.starLevel;

                var topicStatics = {},
                item = null;
                for (var index = 0; index < questionsData.topicStatics.length; index++) {
                    item = questionsData.topicStatics[index];
                    topicStatics[item.topicId] = item;
                }

                for (var i = 0; i < questionsData.questionCollections.length; i++) {
                    errorCount = 0;
                    questionCollection = questionsData.questionCollections[i];

                    for (var j = 0; j < questionCollection.questions.length; j++) {
                        var question = questionCollection.questions[j],
                        result = results[question.data[0].topic.id];
                        appendStudentAnswer(question.data, result, topicStatics);
                        if (!result.correct) errorCount++;
                    }
                    questionCollection.errorCount = errorCount;
                }
            } catch(e) {};
        }
    }
} ());

var studentsViewFunc, homeworkViewFunc, resourcePath, appModel;
var homeworkViewer = (function() {
    var classId, homeworkId, subjectId, questionsData;

    function bind() {
        $(".student").on("click",
        function() {
            var self = $(this);
            questionsData.userId = this.id;;
            questionsData.userName = self.find(".student_name").text();
            if (self.hasClass("student_select")) return;
            $(".student_select").removeClass("student_select");
            self.addClass("student_select");
            ucbook.postWebPageMessage(JSON.stringify({
                action: "getUserHomeworkAnswer",
                arguments: [classId, questionsData.userId, subjectId, homeworkId, resourcePath]
            }));
        });

		$(document).delegate(".extra-file","click",function(ev) {
			ucbook.postWebPageMessage(JSON.stringify({
						action: "getUploadTopicInfo",
						arguments: [ $(this).attr("href") ]
					}));
			ev.preventDefault();
			return false;
		});
    };

	function bindShowWorkResult() {
		
		$(".question_produce").delegate("span", "click",
		function() {
			var topicId = $(this).parent().parent().parent().parent().attr("id");

			ucbook.postWebPageMessage(JSON.stringify({
				action: "setUserHomeworkproduce",
				arguments: [resourcePath, questionsData.userId, topicId]
			}));
		});
		$("#socre_history_btn").on("click",function() {
			ucbook.postWebPageMessage(JSON.stringify({
				action: "viewUserScoreHistory",
				arguments: [questionsData.userId, subjectId]
			}));
		});

		$.sliderX(".slider", {
            onDrag: function() {
                //获取老师设定的分数;
                var maxValue = parseInt(this.obj.closest(".score_parent").find(".max-score").html());
                var val = parseInt(this.getPercent() / 100 * maxValue);
                $(this.obj).closest(".question_answer_result").find(".question_bar_header").html(val + "分");
            },
            triggerSetValue : function(val) {
                var maxValue = parseInt(this.obj.closest(".score_parent").find(".max-score").html());
                $(this.obj).closest(".question_answer_result").find(".question_bar_header").html(val*maxValue+ "分");
            }
		});
	};
	
    return {
        load: function(data) {
            resourcePath = data.homeworkPath;
            $("#studentsView").html(studentsViewFunc(data));
            bind();
            $("#" + data.curStudent.userId).addClass("student_select");
            classId = data.students[0].classId;
            subjectId = data.subjectId;
            homeworkId = data.homeworkId;

            questionsData = question.rearrangeQuestions(data.homeworkContent, subjectId);
            questionsData.classCorrectRate = data.classCorrectRate;
            questionsData.topicStatics = data.topicStatics;
            questionsData.userId = data.curStudent.userId;
            questionsData.serverUrl = data.serverUrl;
            questionsData.userName = data.curStudent.userName;
            questionsData.mode = appModel;
            this.showHomeworkResult(data.curStudentHomeworkResult);

        },

        showHomeworkResult: function(result) {
            question.mergeResult(questionsData, result);
			//foo = questionsData;
			//console.log("questionsData");
			//console.log(JSON.stringify(questionsData));
            $("#homeworkView").html(homeworkViewFunc(questionsData));
			
			bindShowWorkResult();
			
			afterRender.publish("renderOk");
			
        }
    }
} ());

//新建发布者;
window.afterRender = new Publish();

//重写mergeResult;
(function(  ) {
	var original = question.mergeResult;
	var results;
    var flag = false;
    var oHasBeAppraised = null;

	question.mergeResult = function(questionsData, answerResult) {
		try {
		  //如果是教师评论过的就会 parse数据, 否则直接返回answerResult.content
          results = typeof answerResult.content === "string" ? JSON.parse(decodeURIComponent(answerResult.content)) : answerResult.content;
		  //window.da = results;
		}catch(e){
			throw new Error("呵呵, parseResult出问题了");
			return;
		};
        
        //我们要显示老师的评语的情况, 只走一次;
        if(!flag) {
            flag = true;
            //当界面加载完毕的时候会触发, 为了不改动原来的代码;
		    afterRender.subscribe("renderOk",function(){
			    //老师评价			
			    oHasBeAppraised.appraisesText&&$(".appraise_string").html( oHasBeAppraised.appraisesText || " ");
			    //老师批语;
			    oHasBeAppraised.appraisesLevel&&$("[name=appraise-value]").eq(oHasBeAppraised.appraisesLevel).attr("checked","checked");
			
			    //debugger;
                results =  typeof results === "string" ? JSON.parse( results ) : results;
			    for(var topicId in results) {
				    var result = results[topicId];
				    //匹配出主观题;
				    if( result.appraiseText ) {
					    //$("input",$("#"+topicId)).val(result.appraiseText);
                        $(".topicAppraise",$("#"+topicId)).text(result.appraiseText);
				    };
                    if(result.appraiseValue) {
                        var maxScore = parseInt($("#"+topicId).find(".max-score").text());
                        $(".slider",$("#"+topicId)).length && $(".slider",$("#"+topicId))[0].drag.setValue(result.appraiseValue/maxScore);
                    }
			    };
		    });
        };

        if( !results.appraisesLevel ) {
            oHasBeAppraised = {appraisesText:" ", appraisesLevel: 2};
            //老师没有批改过这个作业
		    original.apply($, arguments);
        }else{
            //老师批改过
            oHasBeAppraised = results;
            results = oHasBeAppraised.content;

            //重新包装数据, 渲染学生答题结果主界面;
            original.call( $, arguments[0],$.extend(true,answerResult,{content:encodeURIComponent( results )}) );
        };
	};
    //添加老师评语;
	var mergeAppraise = function() {
        results =  typeof results === "object" ? JSON.stringify( results ) : results;
		//处理result, 添加综合评和教师评语;
		var postData = {
			appraisesText : $(".appraise_string").html(),
			appraisesLevel : $("[name=appraise-value]:checked").val(),
			content :  $.extend(true, {}, JSON.parse(results))
		};
		
		//添加老师打分和老师评论
		$(".question").each( function() {
			var id = $(this).prop("id");
			//添加题目分数和题目的评论;

			//如果是主观题的话;
			if( $(this).closest( ".question_type_4" ).size() ) {
				postData.content[ id ].appraiseText = $("input",this).val();
				postData.content[ id ].appraiseValue = parseInt($(".question_bar_header", this).text(), 10);
			}else{
				postData.content[ id ].appraiseValue = Boolean( $(".is-right",this).data("right") ) ? $(".is-right",this).data("score-value") : 0;
			};
		});
		
		postData.content = JSON.stringify(postData.content);
		return postData;
	};
	
	$(function() {
		$(document).delegate("#submit_btn","click", function(ev) {
			//获取值
			var postData = mergeAppraise.call(this);
            var enCodeContentPostData = encodeURIComponent(JSON.stringify(postData));
			//发送给客户端;
			//console.log( postData );

			ucbook.postWebPageMessage(JSON.stringify({
					action: "markTopicesInfo",
					arguments: [ postData , enCodeContentPostData]
			}));
		});
	});
})(question.mergeResult);

function registerHandlebarsHelpers(data) {
    Handlebars.registerHelper("get_score_level",
    function(rate) {
        var score = Number(rate);
        var text = "差",
        textColor = "#f27a6a";
        if (score >= 90) {
            text = "优秀",
            color = "#6fae3a"
        } else if (score >= 80) {
            text = "良好",
            color = "#f8ad46"
        } else if (score >= 60) {
            text = "中等",
            color = "#f8ad46"
        }

        var html = '<span style="font-size:18px;font-wieght:bold;color:' + textColor + '">' + text + '</span>';
        return new Handlebars.SafeString(html);
    });

    Handlebars.registerHelper("get_alpha_index",
    function(index) {
        return String.fromCharCode('A'.charCodeAt(0) + index);
    });
	
	Handlebars.registerHelper("isSubjectType", function(type , options) {
		type = Number( type );
		if( type == 4 ) {
			return options.fn(this);
		}else{
			return options.inverse(this);
		};
	});
	
    Handlebars.registerHelper("isShortAnswerType",
    function(type, options) {
		//console.log(this);
        if ( type === "2"  || type === "0" ) {
            return options.inverse(this);
        } else if( type === "1" ){
            return options.fn(this);
        };
    });

    Handlebars.registerHelper("isCorrectAnswer",
    function(correct, options) {
        if (correct !== 1 && (typeof correct === "string" && correct !== "1")) {
            return options.inverse(this);
        } else {
            return options.fn(this);
        }
    });

    Handlebars.registerHelper("isCompositeQuestion",
    function(type, options) {
        if (type !== 3 && (typeof type === "string" && type !== "3")) {
            return options.inverse(this);
        } else {
            return options.fn(this);
        }
    });

    Handlebars.registerHelper("isMultiChoiceType",
    function(type, options) {
        if (type !== 0 && (typeof type === "string" && type !== "0")) {
            return options.inverse(this);
        } else {
            return options.fn(this);
        }
    });
    Handlebars.registerHelper("get_html_content", getHTMLContent);

    function getHTMLContent(text) {
		
        try {
            var container = $("<div>" + text + "</div>");
            container.find("img").each(function(index, elem) {
                var relativePath = elem.getAttribute("src");
                if (relativePath.length > 4) {
                    var bz = relativePath.substring(0, 4);
                    if (bz != "data") {
                        
                        elem.src =  relativePath;
                    }
                } else {
                   
                    elem.src = relativePath;
		
                }
            });
            return new Handlebars.SafeString(container.html());
        } catch(e) {
            return "aaaaaaaaaaaaa" + e;
        }
    }
    Handlebars.registerHelper("inc",
    function(index) {
        return index + 1;
    });

    Handlebars.registerHelper("loop",
    function(count, options) {
        var out = "";
        for (var i = 0; i < count; i++) {
            out += options.fn(this);
        }
        return out;
    });
};

function getUrlParams() {
    var search = window.location.search;
    // 写入数据字典
    var tmparray = search.substr(1, search.length).split("&");
    var paramsArray = new Array;
    if (tmparray != null) {
        for (var i = 0; i < tmparray.length; i++) {
            var reg = /[=|^==]/; // 用=进行拆分，但不包括==
            var set1 = tmparray[i].replace(reg, '&');
            var tmpStr2 = set1.split('&');
            var array = new Array;
            array[tmpStr2[0]] = tmpStr2[1];
            paramsArray.push(array);
        }
    }
    // 将参数数组进行返回
    return paramsArray;
}

// 根据参数名称获取参数值
function getParamValue(name) {
    var paramsArray = getUrlParams();
    if (paramsArray != null) {
        for (var i = 0; i < paramsArray.length; i++) {
            for (var j in paramsArray[i]) {
                if (j == name) {
                    return paramsArray[i][j];
                }
            }
        }
    }
    return null;
};

function onMessage(message) {
    //test = message;
    try {
        var msg = JSON.parse(message);
    } catch(e) {
        console.log(e + ":" + message);
        return;
    };
	
    switch (msg.action) {
    case "setStudentHomeworkContent":
        //console.log("msg:" + message);
        homeworkViewer.load(msg.arguments[0]);
        break;
    case "setUserHomeworkAnswer":
		//debugger;
        homeworkViewer.showHomeworkResult(msg.arguments[0]);
        break;
    default:
        break;
    }
};

window.onload = function() {
    registerHandlebarsHelpers();
    appModel = getParamValue("mode");
    if (appModel) studentsViewFunc = Handlebars.compile($("#students_template2").html());
    else studentsViewFunc = Handlebars.compile($("#students_template").html());

    homeworkViewFunc = Handlebars.compile($("#homework_template").html());
	
    if( typeof window.ucbook === "undefined" ) {
		onMessage(JSON.stringify(homeWorkData));
	}else{
		ucbook.onWebPageMessage = onMessage;
    		ucbook.postWebPageMessage("ready");
	};
	
	document.oncontextmenu = new Function("return false;")
	window.addEventListener("dragover", function (e) {
		e = e || event;
		e.preventDefault();
	}, false);
	window.addEventListener("drop", function (e) {
		e = e || event;
		e.preventDefault();
	}, false);
};
