// JavaScript Document
/**
 * onMessage
 * 	@param { "action" : "showExerciseBook" , "arguments" : 左侧目录树的数据传进来}
 *	@param { "action" : "edit" , "arguments" : 题目数据传进来 }
 *   @param { "action" : "save" }  //前台会执行客户端注入JS 的 cbook.postWebPageMessage方法,action的行为为saveTopicData,arguments参数整个就是对应的JSON题目数据
 *	@param { "action" : "new" , "arguments" : " 1 (填空题)| 2 (单选题和多选题)| 4 (主观题)"}
 */
var options = {
    iconsPath: 'js/nicEdit/nicEditorIcons.gif', //相对引用的html文件即可
    //buttonList : [ 'fontSize', 'bold', 'italic', 'subscript', 'superscript', 'image', 'upload' ],
    // ['fontSize','bold','italic','underline','strikeThrough','subscript','superscript','html','image']}).panelInstance('area4');
    fullPanel: true
};
var localQid = 0; // 试题的本地id，自增。与服务器端的试题id无关。服务器端的试题的id，是 .question 的属性
var classForEdit = [".questionBody", ".optionBody", ".blankBody", ".answerBody", ".questionComment"];
var tplMultiOption = $('#sampleEditorPane .question[data-questiontype="multiOption"]'); //多选和单选的编辑模版;
var tplFree = $('#sampleEditorPane .question[data-questiontype="free"]'); //主观题编辑模版;
var tplFillbank = $('#sampleEditorPane .question[data-questiontype="fillBlank"]'); //填空题编辑模版;
var questionTypeMap = { singleOption: "单选", multiOption: "多选", bool: "判断", fillBlank: "填空", free: "问答" };
var elMainEdit = $(".container-edit-body"); //编辑的内容
var chapterid = ""; //选择当前左侧目录的ID
var myNicEditor = new nicEditor(options); // 一个编辑器实例可用于多个编辑区
myNicEditor.setPanel('nicEditPanel');

//初始化事件;
elMainEdit.delegate(".new-blankBody", "click", function () {
    $(this).closest("tr").prev().clone(true).insertBefore($(this).closest("tr")).find("td").eq(0).html(function () {
        //把当前的index加1
        return ++arguments[1];
    });
}).delegate(".delete-blankBody", "click", function () {
    var el = $(this).closest("tr").prev();
    if (el.index() !== 0) {
        el.remove(true);
    };
});

//初始化模版Handlebars
(function () {
    Handlebars.registerHelper('recursive', function (children, options) {
        var out = '';
        if (options.fn !== undefined) {
            audaciousFn = options.fn;
        }
        children.forEach(function (child) {
            out = out + audaciousFn(child);
        });
        return out;
    });
    Handlebars.registerHelper( "inc", function( data,opt) {
        return Number(data)+1;
    });
})();

var RenderTable = P({
    init : function(el, data) {
        this.el = $(el);
        this.tpl || (this.tpl = Handlebars.compile( $("#table-tpl").html() ));
        this.data = data;
        this.render();
    },
    render : function() {
        this.el.html( this.tpl( this.data ) );
    }
});

//左侧目录目录树模块**********************************************************************
var tocRender = (function (tocRender) {

    //平面的数据转变成树状数据;
    function transData(a, idStr, pidStr, chindrenStr) {
        var r = [],
            hash = {},
            id = idStr,
            pid = pidStr,
            children = chindrenStr,
            i = 0,
            j = 0,
            len = a.length;
        for (; i < len; i++) {
            hash[a[i][id]] = a[i];
        }
        for (; j < len; j++) {
            var aVal = a[j],
                hashVP = hash[aVal[pid]];
            if (hashVP) {
                var ary = aVal.cha_number.split(".");
                var orderNum = ary[ary.length - 1]; !hashVP[children] && (hashVP[children] = []);
                hashVP[children][orderNum - 1] = aVal;
            } else {
                r.push(aVal);
            }
        }
        return r;
    };

    function bindTocEvents() {
        $("#directory-toc").on('click', 'li div',
            function () {
                if ($(this).closest("ul").siblings("div").length > 0) {
                    //只有节
                    //$(this).closest('li').siblings("li").find("div").css("background-color", "#FFFFFF");
                    //$(this).css("background-color", "#E7F1FF");
                    chapterid = this.id;
                    chapterName = $(this).find("a").html();
                    //getChapterContent();
                } else {
                    //这个就是章了;
                    chapterid = this.id;
                    chapterName = $(this).find("a").html();
                    //getChapterContent();
                    //return;
                };
                //包含章
                $("div", $(this).closest(".directory-toc")).css("background-color", "#FFFFFF")
                $(this).css("background-color", "#E7F1FF");

                $(this).siblings('ul').toggle();
                if ($(this).find('span').hasClass('expanded')) {
                    $(this).find('span').attr('class', 'collapsed');
                } else {
                    $(this).find('span').attr('class', 'expanded');
                }
                $(this).closest('li').siblings('li').find('span').attr('class', 'collapsed');
                $(this).closest('li').siblings('li').find('ul').hide();
                return false;
            });
    };

    function renderToc() {
        //按照"children"的值进行排列, 目前这边用不到children;
        var directory_template = Handlebars.compile($('#directory-list-template').html());
        var tocData = transData(chapterlist, 'id', 'up_id', 'children');
        //左侧的目录模版渲染的结果;
        var $data = directory_template({ "children": tocData });
        chapterid = tocData[0].id;
        //第一个章节的内容;
        chapterName = tocData[0].cha_name;
        $(".directory-panel").html($data);
        var directoryList = document.getElementById("directory-toc");
        if (directoryList) {
            //呵呵;
            var listItem = function (li) {
                if (li.getElementsByTagName("ul").length > 0) {
                    //里面有UL就把UL隐藏;
                    var ul = li.getElementsByTagName("ul")[0];
                    ul.style.display = "none";
                    var span = document.createElement("span");
                    span.className = "collapsed";
                    $(span).insertBefore($(li).find('a')[0]);
                };
            };
            var items = directoryList.getElementsByTagName("li");
            for (var i = 0; i < items.length; i++) {
                listItem(items[i]);
            };
        };
    };

    //主动触发左侧列表;
    window.triggerLeftChapter = function (id) {
        id = id.indexOf("#") === 0 ? id : "#" + id;
        //$(id).click().closest("ul").show();
        $(id).click().parents("ul").show();
    };

    return {
        renderToc: renderToc,
        bindTocEvents: bindTocEvents
    };
})(tocRender || {});
//目录树END**********************************************************************


//右侧内容编辑区域函数初始化
function innerHtmlIfNotEmpty(elem) {
    elem = $(elem);
    if (elem.find('img, embeded, object').length === 0) {
        var txt = $.trim(elem.text());
        if (!txt)
            return txt;
    }
    return elem.html();
};
//随机生成题目ID,提供编辑器插件进行实例化;
function guid() {
    function S4() {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    }
    return (S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4());
};
//根据模版生成==>>碎片节点;
function addQuestion(type, position) {
    if (!isFinite(position))
        position = -1;
    type = (type === "0" || type === "2") ? "multiOption" :
        type === "4" ? "free" : "fillBlank";

    var templType = (type === 'singleOption') ? 'multiOption' : type;
    var ques = $(
        '.question[data-questionType="' + templType
            + '"]').clone();
    // ques[0].id = (localQid++) + "-question";
    ques.attr('data-questionType', type);
    var tid = guid();
    ques.attr('data-questionId', tid);
    //ques.find('.questionType').html(questionTypeMap[type]);
    ques.find(classForEdit.join(',')).empty();

    return ques;
    //topics.enableEditQuestion( ques );
    //$("body").html( ques )
};

//右侧内容编辑区域的渲染**********************************************************************
var topics = {

    //新建多选或者是选择题;
    multiOption: function (tar) {
        elMainEdit.html(tplMultiOption);
        topics.edit(tar);
    },

    //新建主观题;
    question: function (tar) {
        elMainEdit.html(tplFree);
        topics.edit(tar);
    },

    fillbank: function (tar) {
        elMainEdit.html(tplFillbank);
        topics.edit(tar);
    },

    //设置编辑选项;
    edit: function (el) {
        $(el).find(".question").each(function (i, e) {
            //把所有包含.question的变成可以编辑的状态
            topics.enableEditQuestion(this);
        });
    },
    //设置题目为可编辑状态并设置ID;
    enableEditQuestion: function (quesElem) {
        //为元素新建id;
        if (!quesElem.id)
            quesElem.id = localQid + "-question";

        for (var k = 0; k < classForEdit.length; k++) {
            var clazz = classForEdit[k];

            //[".questionBody", ".optionBody", ".blankBody", ".answerBody", ".questionComment"];
            $(quesElem).find(clazz).each(function (j) {
                //有id就直接实例化;
                if (this.id && myNicEditor.instanceById(this.id))
                    return;
                // question 元素的 id 的结构是 localQid-clazz-n
                var eid = localQid + "-" + clazz.slice(1) + "-" + j;
                this.id = eid;
                //没有id就新建id,实例化
                myNicEditor.addInstance(eid);
            });
        };
        //localQid避免重复;
        localQid++;
        return quesElem;
    },
    //把数据导出;
    quizSheetToJS: function (tar) {
        tar = tar == null ? ".container-edit-body" : tar;
        var zs = {};
        zs.titile = "无题";
        var ques = zs.questions = [];
        $(tar).find(".question").each(function (i) {
            var q = ques[i] = {};
            var thiz = $(this);
            q.body = thiz.find(".questionBody").html();
            q.type = thiz.attr('data-questionType');
            zs.chapertId = chapterid; //全局变量
            var qid = thiz.attr('data-questionId');
            var aid = thiz.attr('data-answerId');
            var comment = innerHtmlIfNotEmpty(thiz.find(".questionComment"));
            if (qid)
                q.id = qid;
            q.answer = {};
            if (aid)
                q.answer.id = aid;
            if (comment)
                q.answer.comment = comment;
            switch (q.type) {
                case "singleOption":
                case "multiOption":
                    q.options = [];
                    thiz.find(".optionBody").each(function (j) {
                        var body = innerHtmlIfNotEmpty(this);
                        if (body)
                            q.options[j] = body;
                    });
                    thiz.find(".questionOptions input").each(function (j) {
                        //this.getAttribute('checked') === 'checked' 是不合适的，因为它不会因为用户的选择而改变。
                        if (this.checked) {
                            if (!q.answer.content)
                                q.answer.content = [];
                            q.answer.content.push( j + 1 );
                        }
                    });
                    break;
                case "fillBlank":
                    thiz.find(".blankBody").each(function (j) {
                        var body = innerHtmlIfNotEmpty(this);
                        if (body) {
                            if (!q.answer.content)
                                q.answer.content = [];
                            q.answer.content[j] = body;
                        }
                    });
                    break;
                case "bool":
                    var checkBoxes = thiz.find(".questionOptions input");
                    if (checkBoxes[0].checked)
                        q.answer.content = true;
                    else if (checkBoxes[1].checked)
                        q.answer.content = false;
                    break;
                case "free":
                    var body = innerHtmlIfNotEmpty(thiz.find(".answerBody")[0]);
                    if (body)
                        q.answer.content = body;
                    var arrOptions = thiz.find(".questionOptions tbody tr").slice(0,-1);
                    arrOptions.each(function(i, e){
                        q.options = q.options || [];
                        q.options.push( $(e).find(".blankBody").html() );
                    });

                    break;
            } //end switch
            if (!('content' in q.answer || 'comment' in q.answer))
                delete q.answer;
        }); //end each
        //alert( JSON.stringify(zs) );
        return zs;
    },
    //加载外部发送过来的数据到右侧编辑器;
    editQuizSheet: function (data) {
        var quizSheet = (typeof data === "string") ? JSON.parse(data) : data;
        /*
         主观题的数据;
         quizSheet = {
         title : "hehe",
         questions : [
         {
         answer : {
         comment : '<body> (1)钾离子的电子式就是它的离子符号，氯离子最外层得到一个电子就变成八个电子带一个单位负电荷；二氧化碳的碳最外层本来4个电子要想形成8个电子的稳定结构就需要共用4对电子，氧原先最外层6个电子，变成8电子稳定结构需要共用2对电子。  <br \="">（2）用电子式表示下列化合物的形成过程需要注意离子化合物的电子式和共价化合物的电子式的区别，还有就是标出最外层的8个电子，电荷数与化合价的区别。</body>',
         content : [
         "1"
         ]
         },
         body : '<body> <div class="ques_content" id="main_content">   <div>    （8分）    <br>（1）写出电子式：    <br>KCl    <u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</u>；CO    <sub>2</sub>    <u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</u>    <br>（2）用电子式表示下列化合物的形成过程：    <br>CaF    <sub>2</sub>：    <u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</u>    <br>NH    <sub>3</sub>：    <u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</u>   </div>  </div></body>',
         id : "14Q1056724",
         type : "4",
         options : [
         '<div class="ques_content" id="qestion_answer">  <div>  <br>（1）写出电子式：  <img src="http://static.zujuan.com/Upload/2012-04/12/fea29ba7-2162-483d-ae38-6de8e31e7b02/paper.files/image006.jpg" style="vertical-align:middle;">  <br>（2）用电子式表示下列化合物的形成过程：  <br>  <img src="http://static.zujuan.com/Upload/2012-04/12/fea29ba7-2162-483d-ae38-6de8e31e7b02/paper.files/image007.jpg" style="vertical-align:middle;">&nbsp;&nbsp;  <img src="http://static.zujuan.com/Upload/2012-04/12/fea29ba7-2162-483d-ae38-6de8e31e7b02/paper.files/image008.jpg" style="vertical-align:middle;"> </div> </div>'
         ]
         }
         ]
         };
         */
        /*{
         "titile": "无题",
         "questions": [
         {
         "body": "选xuǎn一yī选xuǎn。 \n\n\n\n(    )\n\n\nA．八、二　 　 　B．七、十      C．六、十    \n",
         "id": "5c984d634db146e58055ba6e26ebdb24",
         "type": "singleOption",
         "answer": {
         "comment": "C",
         "content": []
         },
         "options": [
         "ccc",
         "ccc",
         "ccc\n",
         "ccc"
         ]
         }
         ]
         }
         */
        /*{
         "titile": "无题",
         "questions": [
         {
         "body": "多选多选多选\n\t",
         "id": "3927a16ab408f85cf38aeed8b637c70e",
         "type": "multiOption",
         "answer": {
         "comment": "错误错误错误题目解析题目解析\n\t",
         "content": []
         },
         "options": [
         "正确",
         "正确\n\t",
         "错误",
         "错误\n\t"
         ]
         }
         ]
         };
         */
        quizSheetTitile = quizSheet.titile;
        var ques = quizSheet.questions;
        for (var i = 0; i < ques.length; i++) {
            var qElem = addQuestion(ques[i].type);
            qElem = $(qElem);
            //内容;
            qElem.find(".questionBody").html(ques[i].body);
            if (ques[i].answer && ques[i].answer.comment);
            //解题答案和content;
            qElem.find(".questionComment").html(ques[i].answer.comment);
            qElem.attr("data-questionId", ques[i].id);
            //content为用户输入或者选择的答案;
            var ans = ques[i].answer && ques[i].answer.content;
            if( ques[i].type == "4" ) {
                console.log(ques[i])
            };
            if (ques[i].answer)
                qElem.attr("data-answerId", ques[i].answer.id);
            //信息初始化完毕;
            switch (ques[i].type) {
                case "0":
                case "2":
                    //alert(ques[i].type)
                    qElem.find(".optionBody").each(function (j) {
                        if (j < ques[i].options.length)
                            this.innerHTML = ques[i].options[j];
                    });
                    var checkBoxes = qElem.find(".questionOptions input");
                    if (ans) {
                        for (var k = 0; k < ans.length; k++) {
                            if (ans[k] < checkBoxes.length+1)
                                checkBoxes.eq(ans[k] - 1).attr("checked", "checked");
                        }
                    }
                    break;
                case "1":
                    //           			alert( JSON.stringify(ans) );
                    //					ans = ques[i].options.length ? ques[i].options : ans;
                    //填空题的class为.blankBody，每一个填空题对应的为填空题的选项;
                    var blankBodysLen = ans.length;
                    var elTr = qElem.find(".blankBody").closest("tr").eq(0);
                    while (--blankBodysLen) {                    
                        elTr.find("td").eq(0).html(blankBodysLen + 1);
                        elTr.clone(true).insertAfter( elTr );
                    };
                    elTr.find("td").eq(0).html(1);

                    var test = qElem.find(".blank-body-template");
                    qElem.find(".blankBody").each(function (j) {
                        if (ans && j < ans.length)
                            this.innerHTML = ans[j];
                    });
                    break;
                case "bool":
                    //答案的是否选中;
                    if (typeof ans === 'boolean') {
                        var checkBoxes = qElem.find(".questionOptions input");
                        var idx = ans ? 0 : 1;
                        checkBoxes[idx].checked = true;
                    }
                    break;
                case "4":
                    //ques[i].answer && ques[i].answer
                    if (ans) {
                        //qElem.find(".answerBody").html( ans.toString() );
                    };
                    if( ques[i].answer && ques[i].answer.comment ) {
                        qElem.find(".questionComment").html( ques[i].answer && ques[i].answer.comment.toString() );
                    };
                    if( ques[i].options.length ) {
                        new RenderTable(qElem.find(".questionOptions-wrap"),ques[i].options);
                    };
                    break;
            } //end switch
        } //end for
        //把内容用合成的数据填充;
        $(".container-edit-body").html(qElem[0].outerHTML);
        //把题目设置为可以编辑的状态,通过插件实例化;
        topics.enableEditQuestion($(".container-edit-body"));
        return qElem;
    }
};

//右侧内容编辑区域的渲染**********************************************************************


function onMessage(message) {
    try {
        //		console.log("onMessage");	
        var msg = JSON.parse(message);
    } catch (e) {
        //		console.log(e + ":" + message);
        return;
    };

    switch (msg.action) {
        case "showExerciseBook":
            flag = 0;
            bookid = msg.arguments[0].bookid;
            //第一个bookId或者激活的id;
            subjectId = msg.activeSubjectId || msg.arguments[0].subjectId;
            homeworkpath = msg.arguments[0].homeworkpath;
            //全局变量;
            chapterid = msg.arguments[0].chapterid;
            chapterlist = msg.arguments[0].chapterlist;
            //			console.log("aaaa" + msg.arguments[0].viewModel);
            view_model = msg.arguments[0].viewModel;

            tocRender.renderToc();

            setTimeout("triggerLeftChapter( subjectId )", 0);
            //左侧列表
            tocRender.bindTocEvents();
            //bookid, chapterid, chapterName
            //getChapterContent();
            //返回键的事件;
            //bindbutton();
            break;
        case "edit":
            //alert( JSON.stringify(msg.arguments) );
            topics.editQuizSheet(msg.arguments)
            break;
        case "save":
            //往客户端发送数据;multiOption
            //debugger;
            ucbook.postWebPageMessage(JSON.stringify({ action: "saveTopicData",
                arguments: { content: topics.quizSheetToJS(".container-edit-body"), chaperName: $("#" + chapterid).text() }
            }));
            break;
        case "new":
        default:
            //多选单选; 1 (填空题)| 2 (单选题和多选题)| 4 (主观题)"}
            if (msg.arguments == "2") {
                new topics.multiOption(".container-edit-body");
            }
            //主观题
            else if (msg.arguments == "4") {
                new topics.question(".container-edit-body");
            }
            //填空题;
            else if (msg.arguments == "1") {
                new topics.fillbank(".container-edit-body");
            }
            break;
    };
};


window.onload = function () {
    if (typeof window.ucbook !== "undefined") {
        ucbook.onWebPageMessage = onMessage;
        ucbook.postWebPageMessage("ready");
    } else {
        //for test;
        //onMessage(JSON.stringify(toc));
    };
};