﻿(function () {
    "use strict";
    var mathml_css_path = getMathmlCSSPath();
    function getCurrentFolderPath() {
        var scripts = document.getElementsByTagName('script'),
            current_script = scripts[scripts.length - 1],
            script_path = current_script.src,
            folder_path = script_path.substr(0, script_path.lastIndexOf('/') + 1);
        return folder_path;
    }

    function getMathmlCSSPath() {
        return getCurrentFolderPath() + "mathml.css";
    }

    window.addEventListener("load", function () {
        var mfrac_html_str = "<div style='position:absolute;display:inline-block'><math><mfrac><mi>xx</mi><mi>yy</mi></mfrac></math></div>";
        document.body.insertAdjacentHTML("afterbegin", mfrac_html_str);
        var div = document.body.firstChild;
        if (div.offsetHeight < div.offsetWidth) {
            var link = document.createElement("link");
            link.href = mathml_css_path;
            link.rel = "stylesheet";
            document.head.appendChild(link);
        }
        document.body.removeChild(div);
    })
}());