//修正 XULRunner 应用中 iframe 的问题（1）事件突破边界：
//iframe 的所有事件都会传播到主文档中，造成主文档接收到多个 DOMContentLoaded 事件。
//（2）iframe不会发出 load 事件。
//此问题只影响 XULRunner 应用，不影响 FF 扩展和 Geckofx。
//Bug: https://bugzilla.mozilla.org/show_bug.cgi?id=972336
//TODO 这里只修正了 DOMContentLoaded 事件，其它事件怎么办？
window.dump && window.addEventListener('DOMContentLoaded', function onDCL(ev) {
  if (ev.target === document) { //正常 DCL 事件，不做处理
    dump('onDCL: normal event, nothing to do\n');
    return;
  }
  if (!ev.bubbles) { //我们自己合成的不冒泡的 DCL 事件，不做处理
    dump('onDCL: DCL fired by myself, nothing to do\n');
    return;
  }
  dump('onDCL: firing load event on: ' + ev.target.URL + '\n');
  ev.stopImmediatePropagation();
  var le = new Event('load',  { 'bubbles' : false, 'cancelable' : true});
  var frame = ev.target.defaultView.frameElement;
  frame.dispatchEvent(le);
  //由于 iframe 中的 DCL 被父文档拦截和停止了，子文档将无法收到自己的 DCL，
  //所以我们合成假的、不冒泡的 DCL 事件，在子文档的 document 和 window 上触发，
  //这样子文档可以收到 DCL，但不会冒泡到父文档。
  var dcle = new Event('DOMContentLoaded',  { 'bubbles' : false, 'cancelable' : true});
  ev.target.dispatchEvent(dcle);
  ev.target.defaultView.dispatchEvent(dcle);
}, true);
