(function (mainbo_wordteaching) {
    function init(el) {
        setEditing(el);
    }
    mainbo_wordteaching.init = init;
    function setEditing(el) {
        if (!el._wordteachingproperty) {
            el._wordteachingproperty = {};
        }
        if (el._wordteachingproperty.setintervaldrawlinecontinue) {
            clearInterval(el._wordteachingproperty.setintervaldrawlinecontinue);
            el._wordteachingproperty.setintervaldrawlinecontinue = 0;
            el.querySelectorAll('.countfloat div')[0].removeAttribute('style');
            el.querySelectorAll('.countfloat div')[1].removeAttribute('style');
        }
        if (el.querySelectorAll('.countfloat')) {
            Array.prototype.slice.call(el.querySelectorAll('.countfloat div'), 0).forEach(function (item, index) {
                if (index == 0) {
                    item.addEventListener('click', linecontinue);
                }
                if (index == 1) {
                    item.addEventListener('click', linestep);
                }
            });
        }
        if (el.querySelector('.audiopro')) {
            el.querySelector('.audiopro').style.display = 'none';
            Array.prototype.slice.call(el.querySelectorAll('.audiopro div'), 0).forEach(function (item, index) {
                if (item.querySelector('audio')) {
                    item.addEventListener('click', audiopaly);
                }
            });
        }
        el.addEventListener('dragstart', ondragstart);
        el.querySelector('.operate-pronunciation').addEventListener('click', clickpronuciation);
        el.querySelector('.operate-radicals').addEventListener('click', clickradicals);
        el.querySelector('.operate-linecount').addEventListener('click', clicklinecount);
        el.querySelector('.operate-struct').addEventListener('click', clickstruct);
        el.querySelector('.operate-draw').addEventListener('click', clickdraw);
        el.querySelector('.operate-example').addEventListener('click', clickexample);
        el.querySelector('.word-svg-pen').addEventListener('click', pendown);
        el.querySelector('.word-svg-eraser').addEventListener('click', eraser);
        Array.prototype.slice.call(el.querySelectorAll('.content-example .hanzi-edit p'), 0).forEach(function (item, index) {
            item.removeAttribute('contenteditable');
        });

    }
    function ondragstart(ev) {
        ev.preventDefault();
    }
    function clickpronuciation(ev) {
        //获取控件元素
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        //删除笔画
        if (this_el.querySelector('.countfloat')) {
            this_el.querySelector('.countfloat').style.display = 'none';
        }
        Array.prototype.slice.call(this_el.querySelectorAll('.content-item'), 0).forEach(function (item, index) {
            if (item.style.display == 'block') {
                item.removeAttribute('style');
            }
        });
        Array.prototype.slice.call(this_el.querySelectorAll('.operate-item a'), 0).forEach(function (item, index) {
            if (item.classList.contains('item-current')) {
                item.removeAttribute('class');
            }
        });
        this_el.querySelector('.operate-pronunciation a').setAttribute('class', 'item-current');
        this_el.querySelector('.content-pronunciation').style.display = 'block';
        if (this_el.querySelector('.audiopro')) {
            this_el.querySelector('.audiopro').style.display = 'block';
        }
    }
    function clickradicals(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        if (this_el.querySelector('.countfloat')) {
            this_el.querySelector('.countfloat').style.display = 'none';
        }
        if (this_el.querySelector('.audiopro')) {
            this_el.querySelector('.audiopro').style.display = 'none';
        }
        Array.prototype.slice.call(this_el.querySelectorAll('.content-item'), 0).forEach(function (item, index) {
            if (item.style.display == 'block') {
                item.removeAttribute('style');
            }
        });
        Array.prototype.slice.call(this_el.querySelectorAll('.operate-item a'), 0).forEach(function (item, index) {
            if (item.classList.contains('item-current')) {
                item.removeAttribute('class');
            }
        });
        this_el.querySelector('.operate-radicals a').setAttribute('class', 'item-current');
        this_el.querySelector('.content-radicals').style.display = 'block';
    }
    function clicklinecount(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        //初始分布
        this_el._wordteachingproperty.countstep = 0;
        //初始连续
        if (this_el._wordteachingproperty.setintervaldrawlinecontinue) {
            clearInterval(this_el._wordteachingproperty.setintervaldrawlinecontinue);
            this_el._wordteachingproperty.setintervaldrawlinecontinue = 0;
            this_el.querySelectorAll('.countfloat div')[0].removeAttribute('style');
            this_el.querySelectorAll('.countfloat div')[1].removeAttribute('style');
        }
        var el_linecount = this_el.querySelector('.content-linecount');
        Array.prototype.slice.call(this_el.querySelectorAll('.content-item'), 0).forEach(function (item, index) {
            if (item.style.display == 'block' && item != el_linecount) {
                item.removeAttribute('style');
            }
        });
        el_linecount.style.display = 'block';
        if (this_el.querySelector('.countfloat')) {
            this_el.querySelector('.countfloat').style.display = 'block';
        }
        if (this_el.querySelector('.audiopro')) {
            this_el.querySelector('.audiopro').style.display = 'none';
        }
        Array.prototype.slice.call(this_el.querySelectorAll('.operate-item a'), 0).forEach(function (item, index) {
            if (item.classList.contains('item-current')) {
                item.removeAttribute('class');
            }
        });
        this_el.querySelector('.operate-linecount a').setAttribute('class', 'item-current');
        var svg = this_el.querySelector('.content-linecount svg');
        if (svg.children.length > 1) {
            svg.children[1].setAttribute('d', '');
            this_el.querySelectorAll('.countfloat div')[0].innerHTML = '连续';
            this_el.querySelectorAll('.countfloat div')[1].innerHTML = '分步';
            this_el.querySelectorAll('.countfloat div')[0].removeAttribute('style');
            this_el.querySelectorAll('.countfloat div')[1].removeAttribute('style');
        }
        clearInterval(this_el['setintervaldrawlinecontinue']);
    }
    function clickstruct(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        if (this_el.querySelector('.countfloat')) {
            this_el.querySelector('.countfloat').style.display = 'none';
        }
        if (this_el.querySelector('.audiopro')) {
            this_el.querySelector('.audiopro').style.display = 'none';
        }
        Array.prototype.slice.call(this_el.querySelectorAll('.content-item'), 0).forEach(function (item, index) {
            if (item.style.display == 'block') {
                item.removeAttribute('style');
            }
        });
        Array.prototype.slice.call(this_el.querySelectorAll('.operate-item a'), 0).forEach(function (item, index) {
            if (item.classList.contains('item-current')) {
                item.removeAttribute('class');
            }
        });
        this_el.querySelector('.operate-struct a').setAttribute('class', 'item-current');
        this_el.querySelector('.content-struct').style.display = 'block';
    }
    function clickdraw(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        var el_draw = this_el.querySelector('.content-draw');
        Array.prototype.slice.call(this_el.querySelectorAll('.content-item'), 0).forEach(function (item, index) {
            if (item.style.display == 'block' && item != el_draw) {
                item.removeAttribute('style');
            }
        });
        el_draw.style.display = 'block';
        if (this_el.querySelector('.countfloat')) {
            this_el.querySelector('.countfloat').style.display = 'none';
        }
        if (this_el.querySelector('.audiopro')) {
            this_el.querySelector('.audiopro').style.display = 'none';
        }
        Array.prototype.slice.call(this_el.querySelectorAll('.operate-item a'), 0).forEach(function (item, index) {
            if (item.classList.contains('item-current')) {
                item.removeAttribute('class');
            }
        });
        this_el.querySelector('.operate-draw a').setAttribute('class', 'item-current');
    }
    function clickexample(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        if (this_el.querySelector('.countfloat')) {
            this_el.querySelector('.countfloat').style.display = 'none';
        }
        if (this_el.querySelector('.audiopro')) {
            this_el.querySelector('.audiopro').style.display = 'none';
        }
        Array.prototype.slice.call(this_el.querySelectorAll('.content-item'), 0).forEach(function (item, index) {
            if (item.style.display == 'block') {
                item.removeAttribute('style');
            }
        });
        Array.prototype.slice.call(this_el.querySelectorAll('.operate-item a'), 0).forEach(function (item, index) {
            if (item.classList.contains('item-current')) {
                item.removeAttribute('class');
            }
        });
        this_el.querySelector('.operate-example a').setAttribute('class', 'item-current');
        this_el.querySelector('.content-example').style.display = 'block';
    }
    function linecontinue(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        this_el._wordteachingproperty.countstep = 0
        this_el.querySelectorAll('.countfloat div')[0].style.pointerEvents = 'none';
        this_el.querySelectorAll('.countfloat div')[1].style.pointerEvents = 'none';
        var svg = this_el.querySelector('.content-linecount svg');
        if (svg && svg.children.length > 1 && svg.children[0].localName == 'path') {
            svg.removeChild(svg.firstChild.nextSibling);
        }
        var secondpath = this_el.ownerDocument.createElementNS('http://www.w3.org/2000/svg', 'path');
        secondpath.setAttribute('d', '');
        secondpath.setAttribute('fill', 'red');
        svg.appendChild(secondpath);
        var orpath = svg.firstChild;
        var orpathd = orpath.getAttribute('d');
        var pathlines = orpathd.split('Z');
        var count = 0;
        function drawlinecontinue() {
            if (count > pathlines.length - 2) {
                clearInterval(this_el._wordteachingproperty.setintervaldrawlinecontinue);
                this_el._wordteachingproperty.setintervaldrawlinecontinue = 0;
                this_el.querySelectorAll('.countfloat div')[0].removeAttribute('style');
                this_el.querySelectorAll('.countfloat div')[1].removeAttribute('style');
                secondpath.setAttribute('d', '');
                count = 0;
                return;
            }
            var secondpathd = secondpath.getAttribute('d');
            secondpath.setAttribute('d', secondpathd + pathlines[count] + 'Z');
            secondpath.style.cssText = '-moz-transform:rotateX(180deg) translate(0px,-221px);-webkit-transform:rotateX(180deg) translate(0px,-221px);transform:rotateX(180deg) translate(0px,-221px);';
            //var orctm = orpath.getCTM();
            //var sectm = secondpath.getCTM();
            //var movex = (orctm.e - sectm.e);
            //var movey = (orctm.f - sectm.f);
            //secondpath.style.cssText = '-moz-transform:rotateX(180deg) translate(' + movex + 'px,' + (-movey) + 'px);-webkit-transform:rotateX(180deg) translate(' + movex + 'px,' + (-movey) + 'px);transform:rotateX(180deg) translate(' + movex + 'px,' + (-movey) + 'px);';
            count++;
        }
        this_el._wordteachingproperty.setintervaldrawlinecontinue = setInterval(drawlinecontinue, 1000);
    }
    function linestep(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        this_el.querySelectorAll('.countfloat div')[0].style.pointerEvents = 'none';
        var svg = this_el.querySelector('.content-linecount svg');
        var orpath = svg.firstChild;
        var orpathd = orpath.getAttribute('d');
        var pathlines = orpathd.split('Z');
        if (svg.children.length < 2) {
            //第一次分步 创建第二条路径
            var secondpath = this_el.ownerDocument.createElementNS('http://www.w3.org/2000/svg', 'path');
            secondpath.setAttribute('fill', 'red');
            var secondpathd = secondpath.getAttribute('d');
            secondpath.setAttribute('d', pathlines[this_el._wordteachingproperty.countstep] + 'Z');
            secondpath.style.cssText = '-moz-transform:rotateX(180deg) translate(0px,-221px);-webkit-transform:rotateX(180deg) translate(0px,-221px);transform:rotateX(180deg) translate(0px,-221px);';
            svg.appendChild(secondpath);
            //var orctm = orpath.getCTM();
            //var sectm = secondpath.getCTM();
            //var movex = (orctm.e - sectm.e);
            //var movey = (orctm.f - sectm.f);
            ev.target.innerHTML = '下一步';
            this_el._wordteachingproperty.countstep++;
        }
        else {
            if (!svg.children[1].getAttribute('d')) {
                svg.children[1].setAttribute('d', pathlines[this_el._wordteachingproperty.countstep] + 'Z');
                ev.target.innerHTML = '下一步';
                this_el._wordteachingproperty.countstep++;
            }
            else {
                if (!svg.children[1].getAttribute('d')) {
                    svg.children[1].setAttribute('d', pathlines[this_el._wordteachingproperty.countstep] + 'Z');
                    svg.children[1].style.cssText = '-moz-transform:rotateX(180deg) translate(0px,-221px);-webkit-transform:rotateX(180deg) translate(0px,-221px);transform:rotateX(180deg) translate(0px,-221px);';
                    ev.target.innerHTML = '下一步';
                    this_el._wordteachingproperty.countstep++;
                } else {
                    if (this_el._wordteachingproperty.countstep > pathlines.length - 2) {
                        this_el._wordteachingproperty.countstep = 0;
                        svg.children[1].setAttribute('d', '');
                        ev.target.innerHTML = '分步';
                        this_el.querySelectorAll('.countfloat div')[0].removeAttribute('style');
                        return;
                    }
                    else {
                        var secondpathd = svg.children[1].getAttribute('d');
                        svg.children[1].setAttribute('d', secondpathd + pathlines[this_el._wordteachingproperty.countstep] + 'Z');
                        svg.children[1].style.cssText = '-moz-transform:rotateX(180deg) translate(0px,-221px);-webkit-transform:rotateX(180deg) translate(0px,-221px);transform:rotateX(180deg) translate(0px,-221px);';
                        //var orctm = orpath.getCTM();
                        //var sectm = svg.children[1].getCTM();
                        //var movex = (orctm.e - sectm.e);
                        //var movey = (orctm.f - sectm.f);
                        //secondpath.style.cssText = '-moz-transform-origin:50% 50%;-webkit-transform-origin:50% 50%;transform-origin:50% 50%;-moz-transform:translate(' + movex + 'px,' + movey + 'px) rotateX(180deg);-webkit-transform:translate(' + movex + 'px,' + movey + 'px) rotateX(180deg);transform:translate(' + movex + 'px,' + movey + 'px) rotateX(180deg)';
                        //secondpath.style.transform = '-moz-transform:rotateX(180deg) translateY(' + movey + 'px);-webkit-transform:rotateX(180deg) translateY(' + movey + 'px);transform:rotateX(180deg) translateY(' + movey + 'px)';
                        //svg.children[1].style.cssText = '-moz-transform:rotateX(180deg) translate(' + movex + 'px,' + (-movey) + 'px);-webkit-transform:rotateX(180deg) translate(' + movex + 'px,' + (-movey) + 'px);transform:rotateX(180deg) translate(' + movex + 'px,' + (-movey) + 'px);';
                        ev.target.innerHTML = this_el._wordteachingproperty.countstep === pathlines.length - 2 ? '清除' : '下一步';
                        this_el._wordteachingproperty.countstep++;
                    }
                }
            }
        }
    }
    function audiopaly(ev) {
        if (ev.target.querySelector('audio')) {
            var audiop = ev.target.querySelector('audio');
            if (audiop.src) {
                audiop.play();
            }
        }
    }
    function pendown(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        if (!this_el._wordteachingproperty.isDrawing) {
            this_el.querySelector('.word-svg-pen').classList.add('word-pen-down');
            if (!this_el._wordteachingproperty.overlay) {
                var ol;
                ol = this_el._wordteachingproperty.overlay = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
                ol.setAttribute('class', 'wordoverlay');
                ol.setAttribute('style', 'position:absolute; width:100%; height:100%; top:0;left:0;z-index:1;overflow:visible;');
                this_el.querySelector('.content-draw .hanzi-font-single').appendChild(ol);
                ol.addEventListener('pointerdown', wordsvgstart);
                ol.addEventListener('pointermove', wordsvgmove);
                ol.addEventListener('pointerup', wordsvgup);
            }
            else {
                if (this_el.querySelector('.content-draw .wordoverlay')) {
                    var wordsvgoverlay = this_el.querySelector('.content-draw .wordoverlay');
                    wordsvgoverlay.addEventListener('pointerdown', wordsvgstart);
                    wordsvgoverlay.addEventListener('pointermove', wordsvgmove);
                    wordsvgoverlay.addEventListener('pointerup', wordsvgup);
                }
            }
            this_el._wordteachingproperty.isDrawing = true;
        }
        else {
            this_el.querySelector('.content-draw .word-svg-pen').classList.remove('word-pen-down');
            if (this_el.querySelector('.content-draw .wordoverlay')) {
                var wordsvgoverlay = this_el.querySelector('.content-draw .wordoverlay');
                wordsvgoverlay.removeEventListener('pointerdown', wordsvgstart);
                wordsvgoverlay.removeEventListener('pointermove', wordsvgmove);
                wordsvgoverlay.removeEventListener('pointerup', wordsvgup);
            }
            this_el._wordteachingproperty.isDrawing = false;
        }
    }
    function eraser(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        var wordclear = this_el.querySelector('.wordoverlay');
        if (wordclear) {
            for (var i = wordclear.children.length - 1; i >= 0; i--) {
                wordclear.removeChild(wordclear.children[i]);
            }
        }
    }
    function wordsvgstart(ev) {
        var x = ev.clientX, y = ev.clientY;
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        if (!this_el._wordteachingproperty.pointerId || this_el._wordteachingproperty.pointerId < 0) {
            this_el._wordteachingproperty.pointerId = 1;
            this_el._wordteachingproperty.path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
            this_el._wordteachingproperty.path.style.stroke = 'red';
            this_el._wordteachingproperty.path.style.strokeWidth = '5';
            this_el._wordteachingproperty.path.style.fill = 'none';
            //if (this._itm) {
            //  // svg 元素的css transform 和 transform 属性在 getBoundingClientRect 时的结果不同,
            //  // 前者得到变换前的结果，后者得到变换后的结果；html 元素是变换后的结果。TODO 这是 bug 还是规范？
            //  p.setAttribute('transform', SVGUtils.matToCSS(this._tm));
            //  var v = SVGUtils.newPoint(x, y).matrixTransform(this._itm);
            //  x = v.x;
            //  y = v.y;
            //}
            var svgbox = this_el.querySelector('.wordoverlay').getBoundingClientRect();
            var dx = x - svgbox.left;
            var dy = y - svgbox.top;
            this_el._wordteachingproperty.path.pathSegList.appendItem(this_el._wordteachingproperty.path.createSVGPathSegMovetoAbs(dx, dy));
            if (this_el._wordteachingproperty.overlay) {
                this_el._wordteachingproperty.overlay.appendChild(this_el._wordteachingproperty.path);
            }
        }
        this_el._wordteachingproperty.lastx = x;
        this_el._wordteachingproperty.lasty = y;
    }
    function wordsvgmove(ev) {
        var x = ev.clientX, y = ev.clientY;
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        if (this_el._wordteachingproperty.path) {
            var p = this_el._wordteachingproperty.path;
            if (this_el._wordteachingproperty.pointerId === 1) {
                var dx = x - this_el._wordteachingproperty.lastx, dy = y - this_el._wordteachingproperty.lasty;
                p.pathSegList.appendItem(p.createSVGPathSegLinetoRel(dx, dy));
            }
        }
        this_el._wordteachingproperty.lastx = x;
        this_el._wordteachingproperty.lasty = y;
    }
    function wordsvgup(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        if (this_el._wordteachingproperty.path) {
            this_el.querySelector('.wordoverlay').appendChild(this_el._wordteachingproperty.path);
        }
        this_el._wordteachingproperty.pointerId = -1;
        this_el._wordteachingproperty.path = null;
        this_el._wordteachingproperty.lastx = 0;
        this_el._wordteachingproperty.lasty = 0;
    }
    function getAncestors(node, filter) {
        var ret = [];
        var docType = Node.DOCUMENT_NODE;
        for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
            try {
                if (filter && filter(cur))
                    ret.push(cur);
            }
            catch (e) {
                console.warn(e.stack || e);
            }
        }
        return ret;
    }
})(mainbo_wordteaching = etb_controls.mainbo_wordteaching || (etb_controls.mainbo_wordteaching = {}));
