(function (mainbo_imatch) {
    function init(el) {
        setEditing(el);
    }
    mainbo_imatch.init = init;
    function setEditing(el) {
        if (!el._imatch) {
            el._imatch = {};
        }
        //bool arr
        if (el._imatch.check_bool_arr && el._imatch.check_bool_arr.length > 0) {
            el._imatch.check_bool_arr.length = 0;
        } else {
            el._imatch.check_bool_arr = [];
        }
        Array.prototype
       .slice
       .call(el.querySelectorAll('.answer'), 0)
       .forEach(function (item) {
           item.addEventListener('dragstart', ondragstart)
           item.addEventListener('pointerdown', onpointerdown);
           item.addEventListener('pointermove', onpointermove);
           item.addEventListener('pointerup', onpointerup);
       });
        el.querySelector('.mainbo_imatch_mask').addEventListener('click', checkmask);

        Array.prototype
       .slice
       .call(el.querySelectorAll('.answer > p'), 0)
       .forEach(function (item) {
           item.style.display = 'block';
           item.style.cursor = 'move';
       });
        el._imatch.ClientRectquest = el.querySelector('.answer').getBoundingClientRect();

        Array.prototype
       .slice
       .call(el.querySelectorAll('p'))
       .forEach(function (item) {
           item.removeAttribute('contenteditable');
       });

        Array.prototype
       .slice
       .call(el.querySelectorAll('.item'))
       .forEach(function (item) {
           if (item.getAttribute('value') == 'check') {
               item.addEventListener('click', check);
           } else if (item.getAttribute('value') == 'show') {
               item.addEventListener('click', show)
           } else if (item.getAttribute('value') == 'repeat') {
               item.addEventListener('click', repeat);
           }
       });

        var el_width_height = { width: parseFloat(el.style.width), height: parseFloat(el.style.height) };
        var el_answery = el_width_height;
        var el_answerWy = el_answery.width;
        var el_answerHy = el_answery.height * 0.8 * 0.7;
        var el_imatch_bor = el.querySelectorAll('.imatch_bor');
        for (var i = 0, len = el_imatch_bor.length; i < len; i++) {
            var imatch_bor = el_imatch_bor[i];
            //questioncount <= answercount
            if (parseFloat(el.dataset['questioncount']) <= parseFloat(el.dataset['answercount'])) {

                var el_imatch_bor_width = el_answerWy / parseFloat(el.dataset['answercount']) * 0.8;
                imatch_bor.style.width = el_imatch_bor_width + 'px';

                imatch_bor.style.height = el_answerHy / 0.7 * 0.3 * 0.8 + 'px';

                var el_imatch_bor_width_all = el_imatch_bor_width * parseFloat(el.dataset['questioncount']);
                var shdintence = (el_answerWy - el_imatch_bor_width_all) / (parseFloat(el.dataset['questioncount']) + 1);
                imatch_bor.style.left = (shdintence * (i + 1) + el_imatch_bor_width * i) + 'px';

                imatch_bor.style.top = el_answerHy * 0.1 + 'px';

            } else {
                var el_imatch_bor_width = el_answerWy / parseFloat(el.dataset['questioncount']) * 0.8;
                imatch_bor.style.width = el_imatch_bor_width + 'px';

                imatch_bor.style.height = el_answerHy / 0.7 * 0.3 * 0.8 + 'px';

                var el_imatch_bor_width_all = el_imatch_bor_width * parseFloat(el.dataset['questioncount']);
                var shdintence = (el_answerWy - el_imatch_bor_width_all) / (parseFloat(el.dataset['questioncount']) + 1);
                imatch_bor.style.left = (shdintence * (i + 1) + el_imatch_bor_width * i) + 'px';

                imatch_bor.style.top = el_answerHy * 0.1 + 'px';
            }
            imatch_bor.style.display = 'block';
        }

        var el_answer_p = el.querySelectorAll('.answer > p');

        //随机数序列 
        if (el._imatch.srandom && el._imatch.srandom.length > 0) {
            el._imatch.srandom.length = 0;
        } else {
            el._imatch.srandom = [];
            el._imatch.length = 0;
        }
        for (var i = 0, len = el_answer_p.length; i < len; i++) {
            el._imatch.srandom.push(i);
        }
        el._imatch.srandom.sort(function (a, b) {
            return Math.random() - 0.5;
        });

        for (var i = 0, len = el_answer_p.length; i < len; i++) {
            var el_answerp = el_answer_p[i];
            if (parseFloat(el.dataset['questioncount']) <= parseFloat(el.dataset['answercount'])) {

                var el_answerp_width = el_answerWy / parseFloat(el.dataset['answercount']) * 0.8;
                el_answerp.style.width = el_answerp_width + 'px';

                el_answerp.style.height = el_answerHy / 0.7 * 0.3 * 0.8 + 'px';

                var el_answerp_width_all = el_answerp_width * parseFloat(el.dataset['answercount']);
                var shdintence = (el_answerWy - el_answerp_width_all) / (parseFloat(el.dataset['answercount']) + 1);
                if (el._imatch.srandom) {
                    el_answerp.style.left = (shdintence * (el._imatch.srandom[i] + 1) + el_answerp_width * el._imatch.srandom[i]) + 'px';
                }

                el_answerp.style.top = el_answerHy * 0.6 + 'px';
            } else {
                var el_answerp_width = el_answerWy / parseFloat(el.dataset['questioncount']) * 0.8;
                el_answerp.style.width = el_answerp_width + 'px';

                el_answerp.style.height = el_answerHy / 0.7 * 0.3 * 0.8 + 'px';

                var el_answerp_width_all = el_answerp_width * parseFloat(el.dataset['answercount']);
                var shdintence = (el_answerWy - el_answerp_width_all) / (parseFloat(el.dataset['answercount']) + 1);
                if (el._imatch.srandom) {
                    el_answerp.style.left = (shdintence * (el._imatch.srandom[i] + 1) + el_answerp_width * el._imatch.srandom[i]) + 'px';
                }

                el_answerp.style.top = el_answerHy * 0.6 + 'px';
            }
            el_answerp.style.display = 'block';
        }
    }
    //check answer
    function check(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control') }).pop();
        Array.prototype.slice.call(this_el.querySelectorAll('.item'), 0).forEach(function (item) {
            if (item.getAttribute('value') == 'check') {
                item.setAttribute('hidden', 'hidden')
            }
            if (item.getAttribute('value') == 'show') {
                item.removeAttribute('hidden');
            }
        });
        var el_imatch_bor = this_el.querySelectorAll('.imatch_bor');
        var el_answer_p = this_el.querySelectorAll('.answer > p');
        var c_imatch_bor = [];
        var c_answer = [];
        for (var i = 0, len = el_imatch_bor.length; i < len; i++) {
            c_imatch_bor.push(el_imatch_bor[i].getBoundingClientRect());
        }
        for (var i = 0, len = el_answer_p.length; i < len; i++) {
            c_answer.push(el_answer_p[i].getBoundingClientRect());
        }
        if (this_el._imatch.check_bool_arr.length > 0) {
            this_el._imatch.check_bool_arr.length = 0;
        }
        if (this_el.dataset['_type'] == 'result') {
            var questioncount = parseFloat(this_el.dataset['questioncount']);
            var answercount = parseFloat(this_el.dataset['answercount']);
            if (questioncount <= answercount) {
                for (var i = 0; i < answercount; i++) {
                    if (i > questioncount - 1) {
                        for (var j = 0; j < questioncount; j++) {
                            if (_detectCollision(c_answer[i], c_imatch_bor[j])) {
                                this_el._imatch.check_bool_arr.push(false);
                            }
                        }
                    }
                    else {
                        if (_detectCollision(c_answer[i], c_imatch_bor[i])) {
                            this_el._imatch.check_bool_arr.push(true);
                        }
                        else {
                            this_el._imatch.check_bool_arr.push(false);
                        }
                    }
                }
            }
            else {
                for (var i = 0; i < questioncount; i++) {
                    if (i > answercount - 1) {
                        //for (var j = 0; j < c_answer.length; j++) {
                        //if (_detectCollision(c_answer[j], c_imatch_bor[i])) {
                        this_el._imatch.check_bool_arr.push(false);
                        //}
                        //}
                    }
                    else {
                        if (_detectCollision(c_answer[i], c_imatch_bor[i])) {
                            this_el._imatch.check_bool_arr.push(true);
                        }
                        else {
                            this_el._imatch.check_bool_arr.push(false);
                        }
                    }
                }
            }
        }
        else {
            var questioncount = parseFloat(this_el.dataset['questioncount']);
            var answercount = parseFloat(this_el.dataset['answercount']);
            if (questioncount <= answercount) {
                for (var i = 0, len = questioncount; i < len; i++) {
                    if (_detectCollision(c_answer[i], c_imatch_bor[i])) {
                        this_el._imatch.check_bool_arr.push(true);
                    } else {
                        this_el._imatch.check_bool_arr.push(false);
                    }
                }
            } else {
                for (var i = 0, len = answercount; i < len; i++) {
                    if (_detectCollision(c_answer[i], c_imatch_bor[i])) {
                        this_el._imatch.check_bool_arr.push(true);
                    } else {
                        this_el._imatch.check_bool_arr.push(false);
                    }
                }
            }
        }
        for (var i = 0; i < this_el._imatch.check_bool_arr.length; i++) {
            if (i < c_imatch_bor.length) {
                var ibo_mask = this_el.ownerDocument.createElement('div');
                ibo_mask.setAttribute('class', 'mainbo_imatch_ibrmask');
                if (this_el._imatch.check_bool_arr[i] == true) {
                    ibo_mask.appendChild(createCorrectMark(this_el));
                }
                else {
                    ibo_mask.appendChild(createErrorMark(this_el));
                }
                el_imatch_bor[i].appendChild(ibo_mask);
            }
        }
    }
    //show answer
    function show(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        var check_ibr = this_el.querySelectorAll('mainbo_imatch_ibrmask')
        for (var i = 0; i < check_ibr.length; i++) {
            check_ibr[0].parentNode.removeChild(check_ibr[0]);
        }
        var el_answer = this_el.querySelector('.answer').getBoundingClientRect();
        var el_answerW = parseFloat(this_el.style.width);
        var el_answerH = parseFloat(this_el.style.height) * 0.8 * 0.7;
        var el_imatch_bor = this_el.querySelectorAll('.imatch_bor');
        var el_answer_p = this_el.querySelectorAll('.answer > p');
        this_el.querySelector('.mainbo_imatch_mask').style.display = 'none';
        if (parseFloat(this_el.dataset['questioncount']) <= parseFloat(this_el.dataset['answercount'])) {
            for (var i = 0, len = el_answer_p.length; i < len; i++) {
                var el_answerp = el_answer_p[i];
                if (i > parseFloat(this_el.dataset['questioncount']) - 1) {
                    el_answerp.style.display = 'none';
                }
                else {
                    var el_imatchbor = el_imatch_bor[i];
                    var el_imatchborW = el_imatchbor.getBoundingClientRect().width;
                    var el_imatchborH = el_imatchbor.getBoundingClientRect().height;
                    el_answerp.style.display = 'block';
                    var el_imatch_bor_width = el_answerW / parseFloat(this_el.dataset['answercount']) * 0.8;
                    el_answerp.style.width = el_imatch_bor_width + 'px';

                    el_answerp.style.height = el_answerH / 0.7 * 0.3 * 0.8 + 'px';

                    var el_imatch_bor_width_all = el_imatch_bor_width * parseFloat(this_el.dataset['questioncount']);
                    var shdintence = (el_answerW - el_imatch_bor_width_all) / (parseFloat(this_el.dataset['questioncount']) + 1);
                    el_answerp.style.left = (shdintence * (i + 1) + el_imatch_bor_width * i) + 'px';

                    el_answerp.style.top = el_answerH * 0.1 + 'px';
                }
            }
        } else {
            for (var i = 0, len = el_answer_p.length; i < len; i++) {
                var el_answerp = el_answer_p[i];

                var el_imatchbor = el_imatch_bor[i];
                var el_imatchborW = el_imatchbor.getBoundingClientRect().width;
                var el_imatchborH = el_imatchbor.getBoundingClientRect().height;
                el_answerp.style.display = 'block';
                var el_imatch_bor_width = el_answerW / parseFloat(this_el.dataset['questioncount']) * 0.8;
                el_answerp.style.width = el_imatch_bor_width + 'px';

                el_answerp.style.height = el_answerH / 0.7 * 0.3 * 0.8 + 'px';

                var el_imatch_bor_width_all = el_imatch_bor_width * parseFloat(this_el.dataset['questioncount']);
                var shdintence = (el_answerW - el_imatch_bor_width_all) / (parseFloat(this_el.dataset['questioncount']) + 1);
                el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_imatch_bor_width * this_el._imatch.srandom[i]) + 'px';

                el_answerp.style.top = el_answerH * 0.1 + 'px';

            }
        }
    }
    //repeat again 
    function repeat(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        this_el._imatch.this_check_bool = false;
        var check_ibr = this_el.querySelectorAll('.mainbo_imatch_ibrmask')
        if (check_ibr) {
            for (var i = 0; i < check_ibr.length; i++) {
                check_ibr[i].parentNode.removeChild(check_ibr[i]);
            }
        }
        var el_mainbo_imatch_mask = this_el.querySelector('.mainbo_imatch_mask');
        el_mainbo_imatch_mask.style.display = 'none';
        Array.prototype.slice.call(this_el.querySelectorAll('.item'), 0).forEach(function (item) {
            if (item.getAttribute('value') == 'check') {
                item.removeAttribute('hidden');
            } else if (item.getAttribute('value') == 'show') {
                item.setAttribute('hidden', 'hidden');
            } else {

            }
        });

        var el_answer = this_el.querySelector('.answer').getBoundingClientRect();
        var el_answerW = parseFloat(this_el.style.width);
        var el_answerH = parseFloat(this_el.style.height) * 0.8 * 0.7;
        var el_imatch_bor = this_el.querySelectorAll('.imatch_bor');
        for (var i = 0, len = el_imatch_bor.length; i < len; i++) {
            var imatch_bor = el_imatch_bor[i];
            if (parseFloat(this_el.dataset['questioncount']) <= parseFloat(this_el.dataset['answercount'])) {

                var el_imatch_bor_width = el_answerW / parseFloat(this_el.dataset['answercount']) * 0.8;
                imatch_bor.style.width = el_imatch_bor_width + 'px';

                imatch_bor.style.height = el_answerH / 0.7 * 0.3 * 0.8 + 'px';

                var el_imatch_bor_width_all = el_imatch_bor_width * parseFloat(this_el.dataset['questioncount']);
                var shdintence = (el_answerW - el_imatch_bor_width_all) / (parseFloat(this_el.dataset['questioncount']) + 1);
                imatch_bor.style.left = (shdintence * (i + 1) + el_imatch_bor_width * i) + 'px';

                imatch_bor.style.top = el_answerH * 0.1 + 'px';
            } else {

            }
            imatch_bor.style.display = 'block';
        }

        var el_answer_p = this_el.querySelectorAll('.answer > p');
        for (var i = 0, len = el_answer_p.length; i < len; i++) {
            var el_answerp = el_answer_p[i];
            if (parseFloat(this_el.dataset['questioncount']) <= parseFloat(this_el.dataset['answercount'])) {

                var el_answerp_width = el_answerW / parseFloat(this_el.dataset['answercount']) * 0.8;
                el_answerp.style.width = el_answerp_width + 'px';

                el_answerp.style.height = el_answerH / 0.7 * 0.3 * 0.8 + 'px';

                var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
                var shdintence = (el_answerW - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
                el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_answerp_width * this_el._imatch.srandom[i]) + 'px';

                el_answerp.style.top = el_answerH * 0.6 + 'px';
            } else {
                var el_answerp_width = el_answerW / parseFloat(this_el.dataset['questioncount']) * 0.8;
                el_answerp.style.width = el_answerp_width + 'px';

                el_answerp.style.height = el_answerH / 0.7 * 0.3 * 0.8 + 'px';

                var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
                var shdintence = (el_answerW - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
                el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_answerp_width * this_el._imatch.srandom[i]) + 'px';

                el_answerp.style.top = el_answerH * 0.6 + 'px';
            }
            el_answerp.style.display = 'block';
        }
    }
    //mainbo_imatch_mask 
    function checkmask(ev) {
        if (ev.target.classList.contains('mainbo_imatch_mask')) {
            ev.target.style.display = 'none';
            ev.target.children.forEach(function (item) {
                item.style.display = 'none';
            });
        }
    }
    //retangle
    function _detectCollision(Bs1, Bs2) {
        return (Math.max(Bs1.right - Bs2.left, Bs2.right - Bs1.left) < Bs1.width + Bs2.width) && (Math.max(Bs1.bottom - Bs2.top, Bs2.bottom - Bs1.top) < Bs1.height + Bs2.height);
    }
    //contains Bs1为被包含(小) Bs2为包含(大)
    function _containCollision(Bs1, Bs2) {
        return Bs1.top > Bs2.top && Bs1.right < Bs2.right && Bs1.bottom < Bs2.bottom && Bs1.left > Bs2.left;
    }
    //get Ancestors
    function getAncestors(node, filter) {
        var ret = [];
        var docType = Node.DOCUMENT_NODE;
        for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
            try {
                if (filter && filter(cur))
                    ret.push(cur);
            }
            catch (e) {
                console.warn(e.stack || e);
            }
        }
        return ret;
    }
    function ondragstart(ev) {
        ev.preventDefault();
    }
    //pointdown event
    function onpointerdown(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        if (ev.button == 0) {
            var allp = null;
            if (ev.target.classList.contains('all_p')) {
                allp = ev.target;
            } else {
                allp = getAncestors(ev.target, function (el) {
                    if (el.classList.contains('all_p')) {
                        return true;
                    }
                }).pop();
            }
            this_el._imatch.dragt = allp;
            if (allp) {
                this_el._imatch.dragt.style.zIndex = '1';
                this_el._imatch.pos = {
                    x: ev.clientX,
                    y: ev.clientY,
                    l: parseFloat(allp.style.left),
                    t: parseFloat(allp.style.top),
                };
            }
        }
        else {
            return;
        }
    }
    //pointmove event
    function onpointermove(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        if (this_el._imatch.dragt) {
            this_el._imatch.temp = {
                x: ev.clientX,
                y: ev.clientY
            };
            var ClientRectquest = this_el.querySelector('.answer').getBoundingClientRect();
            var xfa = Math.min(Math.max(this_el._imatch.temp.x - this_el._imatch.pos.x + this_el._imatch.pos.l, 0), ClientRectquest.right - ClientRectquest.left - parseFloat(this_el._imatch.dragt.style.width));
            var yfa = Math.min(Math.max(this_el._imatch.temp.y - this_el._imatch.pos.y + this_el._imatch.pos.t, 0), ClientRectquest.bottom - ClientRectquest.top - parseFloat(this_el._imatch.dragt.style.height));
            this_el._imatch.dragt.style.left = xfa + 'px';
            this_el._imatch.dragt.style.top = yfa + 'px';
            if (this_el._imatch.temp.x < ClientRectquest.left || this_el._imatch.temp.y < ClientRectquest.top || this_el._imatch.temp.x > ClientRectquest.right || this_el._imatch.temp.y > ClientRectquest.bottom) {
                if (this_el._imatch.dragt) {
                    if (this_el._imatch.dragt.style.zIndex) {
                        this_el._imatch.dragt.style.removeProperty('z-index');
                    }
                    this_el._imatch.dragt = null;
                }
            }
        }
        else {
            if (this_el._imatch.dragt) {
                if (this_el._imatch.dragt.style.zIndex) {
                    this_el._imatch.dragt.style.removeProperty('z-index');
                }
                this_el._imatch.dragt = null;
            }
        }
    }
    //pointup event
    function onpointerup(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        this_el._imatch.temp = {
            x: ev.clientX,
            y: ev.clientY
        };
        if (this_el._imatch.dragt) {
            var el_answery = this_el.querySelector('.answer').getBoundingClientRect();
            var el_answerWy = parseFloat(this_el.style.width);
            var el_answerHy = parseFloat(this_el.style.height) * 0.8 * 0.7;
            var el_imatch_bor = this_el.querySelectorAll('.imatch_bor');
            var el_answer_p = this_el.querySelectorAll('.answer > p');
            var dragclient = this_el._imatch.dragt.getBoundingClientRect();
            var dragtimatchs = [];
            dragtimatchs.length = 0;
            if (this_el.dataset['_type'] == 'process') {
                for (var j = 0; j < el_imatch_bor.length; j++) {
                    var el_imatchbor = el_imatch_bor[j];
                    var c_el_imatchbor = el_imatchbor.getBoundingClientRect();
                    var el_imatchbor_centerpoint = { x: c_el_imatchbor.left + (c_el_imatchbor.right - c_el_imatchbor.left) / 2, y: c_el_imatchbor.top + (c_el_imatchbor.bottom - c_el_imatchbor.top) };
                    var el_imatch_bor = this_el.querySelectorAll('.imatch_bor');
                    var dragtgetrect = this_el._imatch.dragt.getBoundingClientRect();
                    var imatch_bor_rect = el_imatch_bor[j].getBoundingClientRect();
                    if (_detectCollision(dragtgetrect, imatch_bor_rect)) {
                        var dragtimatch = [];
                        dragtimatch.push(this_el._imatch.dragt);
                        dragtimatch.push(el_imatch_bor[j]);
                        dragtimatchs.push(dragtimatch);
                    }
                }
                //判断当前拖动元素与匹配区域的数量
                if (dragtimatchs.length == 1) {
                    var imatchb = dragtimatchs[0][1];
                    if (parseInt(this_el._imatch.dragt.getAttribute('data-imatch')) == parseInt(imatchb.getAttribute('data-ibor'))) {
                        //相交并且匹配成功
                    } else {
                        //相交但匹配不成功,归位
                        for (var i = 0; i < el_answer_p.length; i++) {
                            var el_answerp = el_answer_p[i];
                            if (this_el._imatch.dragt === el_answerp) {
                                if (parseFloat(this_el.dataset['questioncount']) <= parseFloat(this_el.dataset['answercount'])) {

                                    var el_answerp_width = el_answerWy / parseFloat(this_el.dataset['answercount']) * 0.8;
                                    el_answerp.style.width = el_answerp_width + 'px';

                                    el_answerp.style.height = el_answerHy / 0.7 * 0.3 * 0.8 + 'px';

                                    var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
                                    var shdintence = (el_answerWy - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
                                    el_answerp.style.left = (shdintence * (i + 1) + el_answerp_width * i) + 'px';

                                    el_answerp.style.top = el_answerHy * 0.6 + 'px';
                                    break;
                                } else {
                                    var el_answerp_width = el_answerWy / parseFloat(this_el.dataset['questioncount']) * 0.8;
                                    el_answerp.style.width = el_answerp_width + 'px';

                                    el_answerp.style.height = el_answerHy / 0.7 * 0.3 * 0.8 + 'px';

                                    var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
                                    var shdintence = (el_answerWy - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
                                    el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_answerp_width * this_el._imatch.srandom[i]) + 'px';

                                    el_answerp.style.top = el_answerHy * 0.6 + 'px';
                                    break;
                                }
                            } else {

                            }
                        }
                    }
                } else {
                    //归位
                    for (var i = 0; i < el_answer_p.length; i++) {
                        var el_answerp = el_answer_p[i];
                        if (this_el._imatch.dragt === el_answerp) {
                            if (parseFloat(this_el.dataset['questioncount']) <= parseFloat(this_el.dataset['answercount'])) {

                                var el_answerp_width = el_answerWy / parseFloat(this_el.dataset['answercount']) * 0.8;
                                el_answerp.style.width = el_answerp_width + 'px';

                                el_answerp.style.height = el_answerHy / 0.7 * 0.3 * 0.8 + 'px';

                                var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
                                var shdintence = (el_answerWy - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
                                el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_answerp_width * this_el._imatch.srandom[i]) + 'px';

                                el_answerp.style.top = el_answerHy * 0.6 + 'px';
                                break;
                            } else {
                                var el_answerp_width = el_answerWy / parseFloat(this_el.dataset['questioncount']) * 0.8;
                                el_answerp.style.width = el_answerp_width + 'px';

                                el_answerp.style.height = el_answerHy / 0.7 * 0.3 * 0.8 + 'px';

                                var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
                                var shdintence = (el_answerWy - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
                                el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_answerp_width * this_el._imatch.srandom[i]) + 'px';

                                el_answerp.style.top = el_answerHy * 0.6 + 'px';
                                break;
                            }
                        } else {
                        }
                    }
                }

                if (this_el._imatch.dragt && this_el._imatch.dragt.style.zIndex) {
                    this_el._imatch.dragt.style.removeProperty('z-index');
                }
                this_el._imatch.dragt = null;
            } else {
                var el_imatch_bor = this_el.querySelectorAll('.imatch_bor');
                var react_bool = [];
                react_bool.length = 0;
                for (var i = 0, len = el_imatch_bor.length; i < len; i++) {
                    var dragtgetrect = this_el._imatch.dragt.getBoundingClientRect();
                    var imatch_bor_rect = el_imatch_bor[i].getBoundingClientRect();
                    if (_detectCollision(dragtgetrect, imatch_bor_rect)) {
                        react_bool.push(i);
                    }
                }
                if (react_bool.length > 1) {
                    for (var i = 0; i < el_answer_p.length; i++) {
                        var el_answerp = el_answer_p[i];
                        if (this_el._imatch.dragt === el_answerp) {
                            if (parseFloat(this_el.dataset['questioncount']) <= parseFloat(this_el.dataset['answercount'])) {

                                var el_answerp_width = el_answerWy / parseFloat(this_el.dataset['answercount']) * 0.8;
                                el_answerp.style.width = el_answerp_width + 'px';

                                el_answerp.style.height = el_answerHy / 0.7 * 0.3 * 0.8 + 'px';

                                var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
                                var shdintence = (el_answerWy - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
                                el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_answerp_width * this_el._imatch.srandom[i]) + 'px';

                                el_answerp.style.top = el_answerHy * 0.6 + 'px';
                                break;
                            } else {
                                var el_answerp_width = el_answerWy / parseFloat(this_el.dataset['questioncount']) * 0.8;
                                el_answerp.style.width = el_answerp_width + 'px';

                                el_answerp.style.height = el_answerHy / 0.7 * 0.3 * 0.8 + 'px';

                                var el_answerp_width_all = el_answerp_width * parseFloat(this_el.dataset['answercount']);
                                var shdintence = (el_answerWy - el_answerp_width_all) / (parseFloat(this_el.dataset['answercount']) + 1);
                                el_answerp.style.left = (shdintence * (this_el._imatch.srandom[i] + 1) + el_answerp_width * this_el._imatch.srandom[i]) + 'px';

                                el_answerp.style.top = el_answerHy * 0.6 + 'px';
                                break;
                            }
                        } else {

                        }
                    }
                }
                if (this_el._imatch.dragt && this_el._imatch.dragt.style.zIndex) {
                    this_el._imatch.dragt.style.removeProperty('z-index');
                }
                this_el._imatch.dragt = null;
            }
        }
    }
    //right mark
    function createCorrectMark(el) {
        var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'), path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
        svg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
        svg.setAttribute('class', 'svgmask imatch_svgright');
        svg.style.transform = 'scale(0.3) translate(-100%,-100%)';
        path.setAttribute('stroke', 'green');
        path.setAttribute('fill', 'green');
        path.setAttribute('d', 'M 3 68 c 0 0 10 -11 22 -12 c 0 0 7 11 15 10 C 40 64 52 5 98 0 c 0 0 -38 22 -42 82 c -0.8 1.6 -19 12 -21 12 C 32 93 12 65 3 68z');
        svg.appendChild(path);
        return svg;
    }
    //false mark
    function createErrorMark(el) {
        var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'), path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
        svg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
        svg.setAttribute('class', 'svgmask imatch_svgmistake');
        svg.style.transform = 'scale(0.3) translate(-100%,-100%)';
        path.setAttribute('stroke', 'red');
        path.setAttribute('fill', 'red');
        path.setAttribute('d', 'M 89 0 L 51 38 L 13 0 C 8 4 4 8 0 13 l 38 38 L 0 90 c 4 5 8 9 13 13 L 50 65 L 90 100 c 5 -4 9 -8 13 -13 L 65 50 L 100 13 C 98 8 94 4 90 0z');
        svg.appendChild(path);
        return svg;
    }
})(etb_controls.mainbo_imatch || (etb_controls.mainbo_imatch = {}));

