﻿(function (mainbo_freedrag) {
    function init(el) {
        if (!el._freedragproperty) {
            el._freedragproperty = {};
            el._freedragproperty.pointdown = false;
            el._freedragproperty.this_editing = false;
            el._freedragproperty.dragt = null;
            el._freedragproperty.pos = { x: 0, y: 0, l: 0, t: 0 };
            el._freedragproperty.temp = { x: 0, y: 0 }
            el._freedragproperty.percentO = {
                pW: 1,
                pH: 1
            }
        }
        var content = el.querySelector('.mainbo_freedrag_content');
        var answer = el.querySelector('.mainbo_freedrag_content_answer');
        content.addEventListener('dragstart', ondragstart);
        content.addEventListener('pointerdown', onpointdown);
        content.addEventListener('pointermove', onpointermove);
        content.addEventListener('pointerup', onpointerup);
        for (var i = 0 ; i < el.querySelectorAll('.item').length; i++) {
            var item = el.querySelectorAll('.item')[i];
            if (item.getAttribute('value') == 'check') {
                item.addEventListener('click', check);
            }
            else if (item.getAttribute('value') == 'show') {
                item.addEventListener('click', show);
            }
            else if (item.getAttribute('value') == 'repeat') {
                item.addEventListener('click', repeat);
            }
        };
        content.querySelector('.mainbo_freedrag_svgmask').addEventListener('click', function (ev) {
            content.querySelector('.mainbo_freedrag_svgmask').style.display = 'none';
        })
        for (var i = 0, len = answer.children.length; i < len; i++) {
            var answer_client = answer.getBoundingClientRect();
            var answer_c_client = answer.children[i].getBoundingClientRect();
            var answer_c_el_left = Math.random() * (answer_client.right - answer_client.left - answer_c_client.width);
            var answer_c_el_top = Math.random() * (answer_client.bottom - answer_client.top - answer_c_client.height);
            answer.children[i].style.left = answer_c_el_left + 'px';
            answer.children[i].style.top = answer_c_el_top + 'px';
            answer.children[i].dataset['rposition'] = answer_c_el_left + ',' + answer_c_el_top;
        }
    }
    mainbo_freedrag.init = init;
    //drag area content
    function ondragstart(ev) {
        ev.preventDefault();
    }
    function onpointdown(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        if (ev.button == 0) {
            this_el._freedragproperty.pointdown = true;
            if (this_el.querySelector('.mainbo_freedrag_content_answer').compareDocumentPosition(ev.target) == 20) {
                this_el._freedragproperty.dragt = ev.target;
                this_el._freedragproperty.dragt.style.zIndex = '1';
                if (ev.target) {
                    this_el._freedragproperty.pos = {
                        x: ev.clientX,
                        y: ev.clientY,
                        l: parseFloat(ev.target.style.left),
                        t: parseFloat(ev.target.style.top),
                    };
                }
            }
        }
        else {
            return;
        }
    }
    function onpointermove(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        this_el._freedragproperty.temp = {
            x: ev.clientX,
            y: ev.clientY
        };
        var ClientRectquest = this_el.querySelector('.mainbo_freedrag_content').getBoundingClientRect();
        var ClientA = this_el.querySelector('.mainbo_freedrag_content_answer').getBoundingClientRect();
        if (this_el._freedragproperty.pointdown) {
            if (this_el._freedragproperty.dragt) {
                var xfa = Math.min(Math.max((this_el._freedragproperty.temp.x - this_el._freedragproperty.pos.x + this_el._freedragproperty.pos.l), ClientRectquest.left - ClientA.left), ClientRectquest.right - ClientA.left - parseFloat(this_el._freedragproperty.dragt.style.width));
                var yfa = Math.min(Math.max((this_el._freedragproperty.temp.y - this_el._freedragproperty.pos.y + this_el._freedragproperty.pos.t), ClientRectquest.top - ClientA.top), ClientRectquest.bottom - ClientA.top - parseFloat(this_el._freedragproperty.dragt.style.height));
                this_el._freedragproperty.dragt.style.left = xfa + 'px';
                this_el._freedragproperty.dragt.style.top = yfa + 'px';
            }
            if (this_el._freedragproperty.temp.x < ClientRectquest.left || this_el._freedragproperty.temp.y < ClientRectquest.top || this_el._freedragproperty.temp.x > ClientRectquest.right || this_el._freedragproperty.temp.y > ClientRectquest.bottom) {
                if (this_el._freedragproperty.dragt) {
                    if (this_el._freedragproperty.dragt.style.zIndex) {
                        this_el._freedragproperty.dragt.style.removeProperty('z-index');
                    }
                    this_el._freedragproperty.dragt = null;
                }
            }
        }
        else {
            if (this_el._freedragproperty.dragt) {
                if (this_el._freedragproperty.dragt.style.zIndex) {
                    this_el._freedragproperty.dragt.style.removeProperty('z-index');
                }
                this_el._freedragproperty.dragt = null;
            }
        }
    }
    function onpointerup(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        var this_el_answer = this_el.querySelector('.mainbo_freedrag_content_answer');
        if (this_el._freedragproperty.dragt) {
            for (var i = 0; i < this_el_answer.children.length; i++) {
                if (this_el._freedragproperty.dragt === this_el_answer.children[i]) {
                    var this_c_el = this_el.querySelector('.mainbo_freedrag_content');
                    //若为编辑状态则赋值 否则做判断
                    var dragt_relationp = _relativep(this_el._freedragproperty.dragt.getBoundingClientRect(), this_c_el.getBoundingClientRect());
                    var dragt_datap = {
                        top: parseFloat(this_el_answer.children[i].dataset['relativeposition'].split(',')[0]),
                        right: parseFloat(this_el_answer.children[i].dataset['relativeposition'].split(',')[1]),
                        bottom: parseFloat(this_el_answer.children[i].dataset['relativeposition'].split(',')[2]),
                        left: parseFloat(this_el_answer.children[i].dataset['relativeposition'].split(',')[3]),
                        width: parseFloat(this_el_answer.children[i].dataset['relativeposition'].split(',')[4]),
                        height: parseFloat(this_el_answer.children[i].dataset['relativeposition'].split(',')[5]),
                    }
                    var this_clientRect_a_resize = _resize(dragt_datap, true);
                    if (_containrelationp(dragt_relationp, this_clientRect_a_resize)) {
                    }
                    else {
                        //过程判断
                        if (this_el.dataset['_type'] != 'result') {
                            this_el_answer.children[i].style.left = this_el_answer.children[i].dataset['rposition'].split(',')[0] + 'px';
                            this_el_answer.children[i].style.top = this_el_answer.children[i].dataset['rposition'].split(',')[1] + 'px';
                        }

                    }
                }
            }
            if (this_el._freedragproperty.dragt && this_el._freedragproperty.dragt.style.zIndex) {
                this_el._freedragproperty.dragt.style.removeProperty('z-index');
            }
            this_el._freedragproperty.pointdown = false;
            this_el._freedragproperty.dragt = null;
        }
    }
    function checkmask(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        this_el.querySelector('.mainbo_freedrag_svgmask').style.display = 'none';
    }
    //get the percent of the img
    function getPercentImg(el) {
        var question = el.querySelector('.mainbo_freedrag_content_question');
        var questionR = question.getBoundingClientRect();
        //if exist the backgroundImage return the percent  else return the 100% origin 
        if (question.style.backgroundImage) {
            var imgurl = mbe_core.CSSUtils.parseUrls(question.style.backgroundImage);
            var image = el.ownerDocument.createElement('img');
            image.src = imgurl[0];
            var percentW = questionR.width / image.naturalWidth;
            var percentH = questionR.height / image.naturalHeight;
            return {
                pW: percentW,
                pH: percentH
            };
        }
        else {
            if (question.children.length != 0) {
                var image = el.ownerDocument.createElement('img');
                image.src = question.childNodes[0].src;
                var percentW = questionR.width / image.naturalWidth;
                var percentH = questionR.height / image.naturalHeight;
                return {
                    pW: percentW,
                    pH: percentH
                };
            }
            else {
                return {
                    pW: 1,
                    pH: 1
                };
            }
        }
    }
    //check
    function check(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        var f = false;
        var right_answer = [];
        var check_arr = [];
        check_arr.length = 0;
        right_answer.length = 0;
        var this_c_el = this_el.querySelector('.mainbo_freedrag_content');
        var question = this_el.querySelector('.mainbo_freedrag_content_question');
        var answer = this_el.querySelector('.mainbo_freedrag_content_answer');
        var mask = this_el.querySelector('.mainbo_freedrag_svgmask');
        //filter right answer
        for (var i = 0; i < answer.children.length; i++) {
            var questionrelationp = _relativep(question.getBoundingClientRect(), this_c_el.getBoundingClientRect());
            //var answer_children_rp = _relativep(answer.children[i].getBoundingClientRect(), this_c_el.getBoundingClientRect())
            var datasetp = answer.children[i].dataset['relativeposition'].split(',');
            var dragt_datap = {
                top: parseFloat(datasetp[0]),
                right: parseFloat(datasetp[1]),
                bottom: parseFloat(datasetp[2]),
                left: parseFloat(datasetp[3]),
                width: parseFloat(datasetp[4]),
                height: parseFloat(datasetp[5]),
            }
            if (_containrelationp(dragt_datap, questionrelationp)) {
                right_answer.push(answer.children[i]);
            } else {
                continue;
            }
        }
        for (var i = 0 ; i < right_answer.length; i++) {
            //是否在左边区域
            //var questionrelationp = _relativep(question.getBoundingClientRect(), this_c_el.getBoundingClientRect());
            var answer_children_rp = _relativep(right_answer[i].getBoundingClientRect(), this_c_el.getBoundingClientRect())
            //if (_containrelationp(answer_children_rp, questionrelationp)) {
            var datasetp = right_answer[i].dataset['relativeposition'].split(',');
            var dragt_datap = {
                top: parseFloat(datasetp[0]),
                right: parseFloat(datasetp[1]),
                bottom: parseFloat(datasetp[2]),
                left: parseFloat(datasetp[3]),
                width: parseFloat(datasetp[4]),
                height: parseFloat(datasetp[5]),
            }
            var this_clientRect_a_resize = _resize(dragt_datap, true);
            if (this_el.dataset['_type'] == 'result') {
                if (_containrelationp(answer_children_rp, this_clientRect_a_resize)) {
                    check_arr.push(true);
                }
                else {
                    check_arr.push(false);
                }
            } else {
                return;
            }
            //}
        }

        var f = check_arr.every(function (item) {
            return item === true && check_arr.length == right_answer.length;
        });

        if (f) {
            mask.innerHTML = '';
            mask.style.display = 'block';
            mask.appendChild(createCorrectMark(this_el));
        }
        else {
            mask.innerHTML = '';
            mask.style.display = 'block';
            mask.appendChild(createErrorMark(this_el));
        }
    }
    //show
    function show(ev) {
    }
    //repeat
    function repeat(ev) {
        var this_el = getAncestors(ev.target, function (el) { return el.hasAttribute('data-control'); }).pop();
        this_el.querySelector('.mainbo_freedrag_svgmask').style.display = 'none';
        //重做一次的 第一种 方式 恢复到最初的形式
        //var answer = this_el.querySelector('.mainbo_freedrag_content_answer');
        //for (var i = 0; i < answer.children.length; i++) {
        //    answer.children[i].style.left = answer.children[i].dataset['rposition'].split(',')[0] + 'px';
        //    answer.children[i].style.top = answer.children[i].dataset['rposition'].split(',')[1] + 'px';
        //}
        //重做一次的 第二种形式 重新随机排列
        var answer = this_el.querySelector('.mainbo_freedrag_content_answer');
        for (var i = 0, len = answer.children.length; i < len; i++) {
            var answer_client = answer.getBoundingClientRect();
            var answer_c_client = answer.children[i].getBoundingClientRect();
            var answer_c_el_left = Math.random() * (answer_client.right - answer_client.left - answer_c_client.width);
            var answer_c_el_top = Math.random() * (answer_client.bottom - answer_client.top - answer_c_client.height);
            answer.children[i].dataset['rposition'] = answer_c_el_left + ',' + answer_c_el_top;
            answer.children[i].style.left = answer_c_el_left + 'px';
            answer.children[i].style.top = answer_c_el_top + 'px';
        }
    }
    //right mark
    function createCorrectMark(el) {
        var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'), path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
        svg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
        svg.setAttribute('class', 'svgmask imatch_svgright');
        path.setAttribute('stroke', 'green');
        path.setAttribute('fill', 'green');
        path.setAttribute('d', 'M 3 68 c 0 0 10 -11 22 -12 c 0 0 7 11 15 10 C 40 64 52 5 98 0 c 0 0 -38 22 -42 82 c -0.8 1.6 -19 12 -21 12 C 32 93 12 65 3 68z');
        svg.appendChild(path);
        return svg;
    }
    //false mark
    function createErrorMark(el) {
        var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'), path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
        svg.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
        svg.setAttribute('class', 'svgmask imatch_svgmistake');
        path.setAttribute('stroke', 'red');
        path.setAttribute('fill', 'red');
        path.setAttribute('d', 'M 89 0 L 51 38 L 13 0 C 8 4 4 8 0 13 l 38 38 L 0 90 c 4 5 8 9 13 13 L 50 65 L 90 100 c 5 -4 9 -8 13 -13 L 65 50 L 100 13 C 98 8 94 4 90 0z');
        svg.appendChild(path);
        return svg;
    }
    //retangle
    function _detectCollision(Bs1, Bs2) {
        return (Math.max(Bs1.right - Bs2.left, Bs2.right - Bs1.left) < Bs1.width + Bs2.width) && (Math.max(Bs1.bottom - Bs2.top, Bs2.bottom - Bs1.top) < Bs1.height + Bs2.height);
    }
    //reSize  bool为true 表示范围扩大   false 表示范围缩小
    function _resize(Bs1, bool) {
        if (bool) {
            return {
                left: Bs1.left - Bs1.width * 0.2,
                right: Bs1.right - Bs1.width * 0.2,
                top: Bs1.top - Bs1.height * 0.2,
                bottom: Bs1.bottom - Bs1.height * 0.2,
                width: Bs1.width,
                height: Bs1.height
            };
        }
        else {
            return {
                left: Bs1.left + Bs1.width * 0.2,
                right: Bs1.right + Bs1.width * 0.2,
                top: Bs1.top + Bs1.height * 0.2,
                bottom: Bs1.bottom + Bs1.height * 0.2,
                width: Bs1.width,
                height: Bs1.height
            };
        }
    }
    //Bs1为小  Bs2为大
    function _containrelationp(Bs1, Bs2) {
        return Bs1.left > Bs2.left && Bs1.right > Bs2.right && Bs1.top > Bs2.top && Bs1.bottom > Bs2.bottom;
    }
    //contains Bs1为被包含(小) Bs2为包含(大) 误差为20% Bs2扩大20%
    function _containCollision(Bs1, Bs2) {
        return Bs1.top > Bs2.top && Bs1.right < Bs2.right && Bs1.bottom < Bs2.bottom && Bs1.left > Bs2.left;
    }
    //Bs1为被包含(小) Bs2为包含(大)  均为正值
    function _relativep(Bs1, Bs2) {
        var relative_position = {
            left: Bs1.left - Bs2.left,
            right: Bs2.right - Bs1.right,
            bottom: Bs2.bottom - Bs1.bottom,
            top: Bs1.top - Bs2.top,
            width: Bs1.width,
            height: Bs1.height
        };
        return relative_position;
    }
    //get Ancestors
    function getAncestors(node, filter) {
        var ret = [];
        var docType = Node.DOCUMENT_NODE;
        for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
            try {
                if (filter && filter(cur))
                    ret.push(cur);
            }
            catch (e) {
                console.warn(e.stack || e);
            }
        }
        return ret;
    }
})(etb_controls.mainbo_freedrag || (etb_controls.mainbo_freedrag = {}))