(function (choice_question) {

  function init(el) {
    setEditing(el, false);
  }

  choice_question.init = init;

  function setEditing(el, editing) {
    var options = el.querySelector('ol').getElementsByTagName('span');
    setOptionsNum(el, options);
    setEvent(el, editing);
    clearAnswer(options);
    enableEditor(el, editing);
    if (editing) {
      clearAnswerMark(el);
      if (el.dataset['answer'])
        setAnswer(el, options, el.dataset['answer'].split(','), 'teacher-answer');
      el.querySelector('footer button').textContent = '检查答案';
      if (el.querySelectorAll('footer button')[0].dataset['continueAnswer']) {
        el.querySelector('footer button').removeAttribute('data-continue-answer');
      }
    }
 }

  choice_question.setEditing = setEditing;

  function setOptionsNum(el, options) {
    if (isBooleanSelection(el)) return;
    for (var i = 0, j = 65, len = options.length; i < len; i++, j++) {
      options[i].textContent = String.fromCharCode(j);
    }
  }

  function clearAnswer(options) {
    for (var i = 0, len = options.length; i < len; i++) {
      options[i].removeAttribute('class');
    }
  }

  function enableEditor(el, editing) {
    var editP = el.querySelectorAll('ol p'), question = el.querySelector('dt p'), showTeacherAnalysis = el.querySelector('section');
    if (editing) {
      question.setAttribute('contenteditable', 'true');
      showTeacherAnalysis.removeAttribute('hidden');
      for (var i = 0, len = editP.length; i < len; i++) {
        editP[i].setAttribute('contenteditable', 'true');
      }
    }
    else {
      question.removeAttribute('contenteditable');
      showTeacherAnalysis.setAttribute('hidden', '');
      for (var i = 0, len = editP.length; i < len; i++) {
        editP[i].removeAttribute('contenteditable');
      }
    }
  }

  function getAnswer(options, classname) {
    for (var i = 0, optionsLen = options.length, arr = []; i < optionsLen; i++) {
      if (options[i].className && (options[i].classList.contains(classname)))
        arr.push(i);
    }
    for (var i = 0, arrLen = arr.length; i < arrLen; i++) {
      if (arr.length)
        return arr.join();
    }
    return false;
  }

  function setAnswer(el, options, answer, classname) {
    if (isBooleanSelection(el)) {
      (Number(answer[0]) !== undefined) && options[0].classList.add(classname);
      var val = classname == 'student-answer' ? answer[0] : el.dataset['answer'];
      switch (val) {
        case '0':
          options[0].textContent = '√';
          break;
        case '1':
          options[0].textContent = '×';
          break;
        default:
          options[0].textContent = '';
          break;
      }
    } else {
      answer.forEach(function (value, index) {
        (Number(value) !== undefined) && options[value].classList.add(classname);
      });
    }
  }
  
  function clearAnswerMark(el) {
    if (el.querySelector('dd svg'))
      el.querySelector('dd').removeChild(el.querySelector('dd svg'));
  }

  function showTeacherAnalysis(el, displayState) {
    var say = el.querySelector('section'), content = say.querySelector('div p');
    switch (displayState) {
      case true:
        say.removeAttribute('hidden');
        content.setAttribute('contenteditable', 'true');
        break;
      default:
        say.setAttribute('hidden', '');
        content.removeAttribute('contenteditable');
    }
  }

  function createCorrectMark() {
    var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'),
        path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    path.setAttribute('stroke', 'green');
    path.setAttribute('d', 'M 2 6 L 12 18 M 12 18 L 37 0');
    svg.appendChild(path);
    return svg;
  }

  function createErrorMark() {
    var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'),
        path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
    path.setAttribute('stroke', 'red');
    path.setAttribute('d', 'M 0 0 L 40 20 M 0 20 L 40 0');
    svg.appendChild(path);
    return svg;
  }

  function arrayEquals(arr1, arr2) {
    if (arr1.length === arr2.length) {
      return arr1.every(function (value, index) {
        return value === arr2[index] ? true : false;
      });
    }
  }

  function isSingleOrMultiple(el) {
    switch (el.dataset['control']) {
      case 'mainbo_single_selection':
        return true;
      default:
        return false;
    }
  }

  function isBooleanSelection(el) {
    switch (el.dataset['control']) {
      case 'mainbo_boolean_selection':
        return true;
      default:
        return false;
    }
  }

function setEvent(el, editing) {
  var selectorBox = el.querySelector('dd'),
      options = selectorBox.getElementsByTagName('span'),
      button = el.querySelector('footer').getElementsByTagName('button'),
      li = el.querySelector('ol').getElementsByTagName('li');
  if (editing) {
    for (var i = 0, optionsLen = options.length; i < optionsLen; i++) {
      li[i].onclick = null;
      if (li[i].hasAttribute('style')) {
        li[i].removeAttribute('style');
      }
      if (isBooleanSelection(el)) {
        if (this.textContent == '') {
          this.classList.add('teacher-answer');
          this.textContent = '√';
          el.dataset['answer'] = '0';
        } else if (this.textContent == '√') {
          this.textContent = '×';
          el.dataset['answer'] = '1';
        } else if (this.textContent == '×') {
          clearAnswer(options);
          this.textContent = '';
          el.removeAttribute('data-answer');
        }
      } else {
        options[i].onclick = function () {
          if (isSingleOrMultiple(el)) {
            if (this.classList.contains('teacher-answer')) {
              this.classList.remove('teacher-answer');
            }else {
               clearAnswer(options);
               this.classList.add('teacher-answer');
            }
          } else {
            this.classList.toggle('teacher-answer')
          }
          if (getAnswer(options, 'teacher-answer')){
            el.dataset['answer'] = getAnswer(options, 'teacher-answer')
          }else{
            el.removeAttribute('data-answer')
          }
        }
      }
    }
    button[1].onclick = button[0].onclick = null;
  }else {
    var section = el.querySelector('section');
    for (var i = 0, optionsLen = options.length; i < optionsLen; i++) {
      if (isBooleanSelection(el)) {
        options[0].onclick = null;
        li[0].style.cursor = 'pointer';
        li[0].querySelector('span').textContent = '';
        li[0].onclick = function () {
          if (li[0].querySelector('span').textContent == '') {
            li[0].querySelector('span').classList.add('student-answer');
            li[0].querySelector('span').textContent = '√';
            el.booleanAnswer = ['0'];
          } else if (li[0].querySelector('span').textContent == '√') {
            li[0].querySelector('span').textContent = '×';
            el.booleanAnswer = ['1'];
          } else if (li[0].querySelector('span').textContent == '×') {
            clearAnswer(options);
            li[0].querySelector('span').textContent = '';
            el.booleanAnswer = undefined;
          }
        }
      }
      else {
        options[i].onclick = null;
        li[i].style.cursor = 'pointer';
        li[i].onclick = function () {
          if (isSingleOrMultiple(el)) {
            if (this.querySelector('span').classList.contains('student-answer')){
              this.querySelector('span').classList.remove('student-answer')
            }else {
               clearAnswer(options);
               this.querySelector('span').classList.add('student-answer')
            }
            el.singleAnswer = getAnswer(options, 'student-answer') !== undefined ? getAnswer(options, 'student-answer').split(',') : undefined;
          }else {
            this.querySelector('span').classList.toggle('student-answer');
            el.multipleAnswer = getAnswer(options, 'student-answer') ? getAnswer(options, 'student-answer').split(',') : undefined;
          }
        }
      }
      
    }
    button[0].onclick = function () {
      showTeacherAnalysis(el, false);
      if (el.dataset['answer']) {
        if (isBooleanSelection(el)) {
          li[0].querySelector('span').textContent = '';
        }
        clearAnswer(options)
      }
      for (var i = 0, optionsLen = options.length; i < optionsLen; i++) {
        if (isBooleanSelection(el)) {
          li[0].onclick = function () {
            if (li[0].querySelector('span').textContent == '') {
              li[0].querySelector('span').classList.add('student-answer');
              li[0].querySelector('span').textContent = '√';
              el.booleanAnswer = ['0'];
            } else if (li[0].querySelector('span').textContent == '√') {
              li[0].querySelector('span').textContent = '×';
              el.booleanAnswer = ['1'];
            } else if (li[0].querySelector('span').textContent == '×') {
              clearAnswer(options);
              li[0].querySelector('span').textContent = '';
              el.booleanAnswer = undefined;
            }
          }
        }
        else {
          li[i].onclick = function () {
            if (isSingleOrMultiple(el)) {
              if (this.querySelector('span').classList.contains('student-answer'))
                this.querySelector('span').classList.remove('student-answer');
              else {
                clearAnswer(options);
                this.querySelector('span').classList.add('student-answer')
              }
              el.singleAnswer = getAnswer(options, 'student-answer') ? getAnswer(options, 'student-answer').split(',') : undefined;
            }else {
               this.querySelector('span').classList.toggle('student-answer');
               el.multipleAnswer = getAnswer(options, 'student-answer') ? getAnswer(options, 'student-answer').split(',') : undefined
            }
          }
        }
      }
      switch (this.dataset.continueAnswer) {
        case undefined:
          if (!el.dataset['answer'])
            return alert('老师没给答案');
          if (isBooleanSelection(el)) {
            if(!el.booleanAnswer){
              return alert('请作答');
            }
          }
          else if ((isSingleOrMultiple(el) && !el.singleAnswer) || (!isSingleOrMultiple(el) && !el.multipleAnswer)) {
             return alert('请作答');
         }
          clearAnswer(options);
          setAnswer(el, options, isBooleanSelection(el) ? el.booleanAnswer : isSingleOrMultiple(el) ? el.singleAnswer : el.multipleAnswer, 'student-answer');
          switch (arrayEquals(el.dataset['answer'].split(','), isBooleanSelection(el) ? el.booleanAnswer : isSingleOrMultiple(el) ? el.singleAnswer : el.multipleAnswer)) {
            case true:
              selectorBox.appendChild(createCorrectMark());
              break;
            default:
              selectorBox.appendChild(createErrorMark());
            }
          this.textContent = '继续做答';
          this.dataset.continueAnswer = true;
          for (var i = 0, optionsLen = options.length; i < optionsLen; i++) {
            li[i].onclick = null;
          }
          break;
        case 'true':
          clearAnswerMark(el);
          clearAnswer(options);
          isBooleanSelection(el) ? (el.booleanAnswer = undefined) : isSingleOrMultiple(el) ? (el.singleAnswer = undefined) : (el.multipleAnswer = undefined);
          this.textContent = '检查答案';
          this.removeAttribute('data-continue-answer');
          for (var i = 0, optionsLen = options.length; i < optionsLen; i++) {
            if (isBooleanSelection(el)) {
              li[0].onclick = function () {
                if (li[0].querySelector('span').textContent == '') {
                  li[0].querySelector('span').classList.add('student-answer');
                  li[0].querySelector('span').textContent = '√';
                  el.booleanAnswer = ['0'];
                } else if (li[0].querySelector('span').textContent == '√') {
                  li[0].querySelector('span').textContent = '×';
                  el.booleanAnswer = ['1'];
                } else if (li[0].querySelector('span').textContent == '×') {
                  clearAnswer(options);
                  li[0].querySelector('span').textContent = '';
                  el.booleanAnswer = undefined;
                }
              }
            }
            else {
              li[i].onclick = function () {
                if (isSingleOrMultiple(el)) {
                  if (this.querySelector('span').classList.contains('student-answer'))
                    this.querySelector('span').classList.remove('student-answer');
                  else {
                    clearAnswer(options);
                    this.querySelector('span').classList.add('student-answer');
                  }
                  el.singleAnswer = getAnswer(options, 'student-answer') ? getAnswer(options, 'student-answer').split(',') : undefined;
                } else {
                  this.querySelector('span').classList.toggle('student-answer');
                  el.multipleAnswer = getAnswer(options, 'student-answer') ? getAnswer(options, 'student-answer').split(',') : undefined;
                }
              }
            }
          }
      }
    }
    button[1].onclick = function () {
      clearAnswerMark(el);
      clearAnswer(options);
      if (!el.dataset['answer']) {
        if (isBooleanSelection(el)) el.querySelector('ol li span').textContent = '';
        return alert('老师没给答案');
      }
      for (var i = 0, optionsLen = options.length; i < optionsLen; i++) {
        li[i].onclick = null;
      }
      setAnswer(el, options, el.dataset['answer'].split(','), 'teacher-answer');
      showTeacherAnalysis(el, true);
      el.querySelector('section div p').removeAttribute('contenteditable');
    }
  }
}
})(etb_controls.mainbo_choice_question || (etb_controls.mainbo_choice_question = {}));

(function(etb_controls){
  etb_controls.mainbo_single_selection = etb_controls.mainbo_choice_question;
  etb_controls.mainbo_mutiple_selection = etb_controls.mainbo_choice_question;
  etb_controls.mainbo_boolean_selection = etb_controls.mainbo_choice_question;
})(etb_controls || (etb_controls = {}));
