var etb_tools;
(function (etb_tools) {
    var SVGUtils;
    (function (SVGUtils) {
        SVGUtils.NS_SVG = 'http://www.w3.org/2000/svg';
        var svg;
        function newPoint(x, y) {
            var m = svg.createSVGMatrix();
            m = m.translate(x, y);
            var p = svg.createSVGPoint();
            return p.matrixTransform(m);
        }
        SVGUtils.newPoint = newPoint;
        function newMatrix() {
            return svg.createSVGMatrix();
        }
        SVGUtils.newMatrix = newMatrix;
        function transformDelta(v, m) {
            var o1 = svg.createSVGPoint().matrixTransform(m);
            var v1 = v.matrixTransform(m);
            return newPoint(v1.x - o1.x, v1.y - o1.y);
        }
        SVGUtils.transformDelta = transformDelta;
        function matToCSS(mat) {
            return 'matrix(' + mat.a + ',' + mat.b + ',' + mat.c + ',' + mat.d + ',' + mat.e + ',' + mat.f + ')';
        }
        SVGUtils.matToCSS = matToCSS;
        function moduleInit() {
            svg = document.createElementNS(SVGUtils.NS_SVG, 'svg');
        }
        moduleInit();
    })(SVGUtils = etb_tools.SVGUtils || (etb_tools.SVGUtils = {}));
})(etb_tools || (etb_tools = {}));
///<reference path='../../html5plus.d.ts'/>
///<reference path='SVGUtils.ts'/>
var etb_tools;
(function (etb_tools) {
    var NS_SVG = etb_tools.SVGUtils.NS_SVG;
    var SVGPen = (function () {
        function SVGPen(canvasParent) {
            this.canvasParent = canvasParent;
            this._isDrawing = false;
            this._overlay = null;
            this._path = null;
            this._lastX = 0;
            this._lastY = 0;
            this._pointerId = -1;
            this._scale = 1;
            this.onPathDrawn = null;
        }
        Object.defineProperty(SVGPen.prototype, "isDrawing", {
            get: function () { return this._isDrawing; },
            set: function (draw) {
                if (draw === this._isDrawing)
                    return;
                this._isDrawing = draw;
                if (draw)
                    this._enableDrawing();
                else
                    this._disableDrawing();
            },
            enumerable: true,
            configurable: true
        });
        SVGPen.prototype.setTransform = function (scale, ox, oy) {
            this._scale = scale;
            if (scale === 1) {
                this._tm = this._itm = null;
                return;
            }
            this._tm = etb_tools.SVGUtils.newMatrix().translate(-ox, -oy).scale(scale).translate(ox, oy);
            this._itm = this._tm.inverse();
        };
        SVGPen.prototype.removeAll = function (el) {
            var strokes = el.querySelectorAll('svg.etb-temp-stroke');
            for (var i = 0; i < strokes.length; i++) {
                if (strokes[i].parentNode)
                    strokes[i].parentNode.removeChild(strokes[i]);
            }
        };
        SVGPen.prototype._enableDrawing = function () {
            var ol = this._overlay = document.createElementNS(NS_SVG, 'svg');
            ol.setAttribute('class', 'etb-SvgPenOverlay');
            ol.setAttribute('style', 'position:fixed; width:100%; height:100%; top:0');
            this.canvasParent.appendChild(ol);
            var handler = this._drawingPointerHandler.bind(this);
            ['pointerdown', 'pointermove', 'pointerup'].forEach(function (type) {
                return ol.addEventListener(type, handler);
            });
        };
        SVGPen.prototype._disableDrawing = function () {
            this.canvasParent.removeChild(this._overlay);
            this._overlay = null;
        };
        SVGPen.prototype._startDraw = function (x, y) {
            var p = this._path = document.createElementNS(NS_SVG, 'path');
            p.style.stroke = 'red';
            p.style.strokeWidth = '2';
            p.style.fill = 'none';
            if (this._itm) {
                // svg 元素的css transform 和 transform 属性在 getBoundingClientRect 时的结果不同,
                // 前者得到变换前的结果，后者得到变换后的结果；html 元素是变换后的结果。TODO 这是 bug 还是规范？
                p.setAttribute('transform', etb_tools.SVGUtils.matToCSS(this._tm));
                var v = etb_tools.SVGUtils.newPoint(x, y).matrixTransform(this._itm);
                x = v.x;
                y = v.y;
            }
            p.pathSegList.appendItem(p.createSVGPathSegMovetoAbs(x, y));
            this._overlay.appendChild(p);
        };
        SVGPen.prototype._movePenBy = function (dx, dy) {
            var p = this._path;
            if (this._itm) {
                dx = dx / this._scale;
                dy = dy / this._scale;
            }
            // TODO make curve work
            // if (p.pathSegList.numberOfItems !== 0)
            //   p.pathSegList.appendItem(p.createSVGPathSegCurvetoQuadraticSmoothRel(dx, dy));
            // else
            //   p.pathSegList.appendItem(p.createSVGPathSegLinetoRel(dx, dy));
            p.pathSegList.appendItem(p.createSVGPathSegLinetoRel(dx, dy));
        };
        SVGPen.prototype._endDraw = function () {
            var p = this._path;
            if (this.onPathDrawn) {
                var evt = { path: p, canvas: null };
                this.onPathDrawn(evt);
                if (evt.canvas) {
                    var c = evt.canvas;
                    var pbox = p.getBoundingClientRect();
                    var cbox = c.getBoundingClientRect();
                    var start = p.pathSegList.getItem(0);
                    var s = this._scale;
                    if (c.namespaceURI !== NS_SVG) {
                        var svg = document.createElementNS(NS_SVG, 'svg');
                        svg.setAttribute('class', 'etb-temp-stroke');
                        svg.setAttribute('style', 'position:absolute; top:' + (pbox.top - cbox.top) / s
                            + 'px; left:' + (pbox.left - cbox.left) / s + 'px; width:'
                            + pbox.width / s + 'px; height:' + pbox.height / s + 'px; overflow:visible');
                        svg.appendChild(p);
                        var pbx = pbox.left, pby = pbox.top;
                        if (this._itm) {
                            var pbo = etb_tools.SVGUtils.newPoint(pbox.left, pbox.top).matrixTransform(this._itm);
                            pbx = pbo.x;
                            pby = pbo.y;
                        }
                        var nx = start.x - pbx, ny = start.y - pby;
                        start = p.createSVGPathSegMovetoAbs(nx, ny);
                        p.pathSegList.replaceItem(start, 0);
                        p.removeAttribute('transform');
                        c.appendChild(svg);
                    }
                }
            }
            this._path = null;
        };
        SVGPen.prototype._drawingPointerHandler = function (ev) {
            var x = ev.clientX, y = ev.clientY;
            switch (ev.type) {
                case 'pointerdown':
                    if (this._pointerId < 0) {
                        this._startDraw(x, y);
                        this._pointerId = ev.pointerId;
                    }
                    break;
                case 'pointermove':
                    if (ev.pointerId === this._pointerId)
                        this._movePenBy(x - this._lastX, y - this._lastY);
                    break;
                case 'pointerup':
                    if (ev.pointerId === this._pointerId) {
                        this._endDraw();
                        this._pointerId = -1; //TODO -1 是否总是非法的 id？
                    }
                    break;
            }
            this._lastX = x;
            this._lastY = y;
        };
        return SVGPen;
    })();
    etb_tools.SVGPen = SVGPen;
})(etb_tools || (etb_tools = {}));
// book.r.ts 和 book.e.ts 的共享代码
var etb_book;
(function (etb_book) {
    // normal：原有位置弹出，center：弹出到页面中心，none：不弹出
    etb_book.popupOptions = ['none', 'normal', 'center'];
    function getControlById(id, doc) {
        if (!id)
            return null;
        return doc.querySelector('[data-id="' + id + '"]');
    }
    etb_book.getControlById = getControlById;
    function enableControlConnection(doc, enable) {
        if (enable) {
            doc.addEventListener('click', triggerConnection);
        }
        else {
            doc.removeEventListener('click', triggerConnection);
        }
    }
    etb_book.enableControlConnection = enableControlConnection;
    function resetPopups(node, hideTarget) {
        forEach(node.querySelectorAll('[data-mainbo-popup]'), function (el) {
            if (!isPopup(el.getAttribute('data-mainbo-popup')))
                return;
            var targ = getControlById(el.getAttribute('data-mainbo-connection-src'), node);
            targ && dismissPopup(targ, hideTarget);
        });
        dismissAllPopups(node, hideTarget);
    }
    etb_book.resetPopups = resetPopups;
    // data-mainbo-popup 的值是否是有效的弹出形式
    function isPopup(popupType) {
        return etb_book.popupOptions.indexOf(popupType) > 0;
    }
    etb_book.isPopup = isPopup;
    function forEach(array, fn) {
        Array.prototype.forEach.call(array, fn);
    }
    function triggerConnection(ev) {
        var el = ev.target;
        var trigers = etb_book.getAncestors(el, function (el) { return el.hasAttribute('data-mainbo-connection-src')
            || el.hasAttribute('xlink:href') || el.classList.contains('mainbo-popup'); }); //TODO NS?
        if (!trigers.some(function (el) { return el.hasAttribute('data-mainbo-popup') ||
            el.classList.contains('mainbo-popup'); })) {
            var page = etb_book.getAncestors(el, function (el) { return el.classList.contains('etb-page'); })[0];
            page && dismissAllPopups(page, true);
        }
        trigers.forEach(playConnection);
    }
    function dismissAllPopups(node, hideTarget) {
        forEach(node.querySelectorAll('.mainbo-popup'), function (el) { return dismissPopup(el, hideTarget); });
    }
    function dismissPopup(pp, hideTarget) {
        pp.classList.remove('mainbo-popup');
        if (pp.classList.contains('mainbo-center')) {
            pp.classList.remove('mainbo-center');
        }
        var oldStyle = pp.getAttribute('data-etb-saved-style');
        if (oldStyle) {
            pp.setAttribute('style', oldStyle);
            pp.removeAttribute('data-etb-saved-style');
        }
        if (hideTarget) {
            pp.setAttribute('hidden', '');
        }
        else {
            pp.removeAttribute('hidden');
        }
        // pause media on dismiss
        if (typeof pp['pause'] === 'function') {
            pp['pause']();
        }
    }
    function doPopup(trigger, target) {
        var popup = trigger.getAttribute('data-mainbo-popup');
        if (!isPopup(popup))
            return false;
        // 关闭已经弹出的目标
        if (target.classList.contains('mainbo-popup')) {
            dismissPopup(target, true);
            return false;
        }
        var oldStyle = target.getAttribute('style');
        if (popup === 'center') {
            target.style.left = '50%';
            target.style.top = '50%';
            var win = target.ownerDocument.defaultView;
            var w = parseInt(win.getComputedStyle(target, null).width);
            var h = parseInt(win.getComputedStyle(target, null).height);
            target.style.marginLeft = (-w / 2) + 'px';
            target.style.marginTop = (-h / 2) + 'px';
        }
        target.removeAttribute('hidden');
        target.setAttribute('data-etb-saved-style', oldStyle);
        target.classList.add('mainbo-popup');
        if (popup === 'center') {
            target.classList.add('mainbo-center');
        }
        return true;
    }
    function doLink(el) {
        var xl = el.getAttribute('xlink:href');
        if (!xl)
            return false;
        if (etb_book.isEditing(el))
            return true;
        // 这是针对 firefox android 的一个 hack, 目的是允许用外部应用打开 flash 文件，因为 firefox android 中的 flash 不支持拖拽。
        // TODO 彻底去除 flash 支持后，简单地打开链接即可：
        // (<Window>el.ownerDocument.defaultView).open(xl);
        var i = xl.lastIndexOf('/');
        var fn = i >= 0 ? xl.slice(i + 1) : xl;
        i = fn.lastIndexOf('.');
        var ext = i >= 0 ? fn.slice(i + 1) : '';
        var doc = el.ownerDocument;
        var a = doc.createElement('a');
        a.href = xl;
        if (ext === 'swf')
            a['download'] = fn;
        else
            a.target = '_blank'; //总是新窗口打开
        a.hidden = true;
        doc.body.appendChild(a);
        a.onclick = function (ev) {
            ev.stopPropagation(); // 避免被 triggerConnection 接收到。
            doc.body.removeChild(a);
        };
        a.click();
        return true;
    }
    function playConnection(el) {
        // TODO 合并 xlink:href and data-mainbo-connection-src?
        doLink(el);
        var src = el.getAttribute('data-mainbo-connection-src');
        var target = getControlById(src, el.ownerDocument);
        if (!target)
            return;
        var popup = doPopup(el, target);
        if (popup || typeof target['play'] !== 'function') {
            //popup 默认不会立即播放
            return;
        }
        var media = target;
        var aBegin = el.getAttribute('data-mainbo-media-begin');
        var begin = parseFloat(aBegin) || 0;
        var end = parseFloat(el.getAttribute('data-mainbo-media-end')) || -1;
        media.currentTime = begin;
        media.addEventListener('timeupdate', onTimeupdate);
        media.addEventListener('ended', onEnded);
        media.play();
        function onTimeupdate(ev) {
            var el = ev.target;
            if (end > 0 && el.currentTime >= end) {
                el.pause();
                cleanUp(el);
            }
        }
        function onEnded(ev) {
            cleanUp(ev.target);
        }
        function cleanUp(el) {
            el.removeEventListener('timeupdate', onTimeupdate);
            el.removeEventListener('ended', onEnded);
        }
    }
})(etb_book || (etb_book = {}));
///<reference path='../../html5plus.d.ts'/>
///<reference path='../tools/SVGPen.ts' />
///<reference path="./book.shared.ts"/>
/**
 * 用于reader的etb_book模块
 */
var etb_controls;
(function (etb_controls) {
    var a = 1; // TODO 空模块会被编译器认为不存在
})(etb_controls || (etb_controls = {}));
;
var etb_config;
(function (etb_config) {
})(etb_config || (etb_config = {}));
var etb_book;
(function (etb_book) {
    // 使用非活动的文档作为换出元素的所属文档，并适时调用
    // HTMLMediaElement.load() 是目前释放媒体内存的较好方法。
    var swapDoc;
    // 利用 MO 尽早换出页面。
    // 这对 chrome 帮助不大，因为它基本是在文档解析完以后才发送Mutation事件，但chrome似乎延迟加载其他资源。
    // 这对 firefox 帮助较大，firefox 会较早发送Mutation事件，也会较早加载其他资源。
    var observer;
    var observingEtbPages = false;
    etb_book.currentPage;
    etb_book.currentPageNumber;
    function moduleInit() {
        if (!etb_config.useExternalDoc) {
            window.addEventListener("DOMContentLoaded", init0);
            window.addEventListener("load", init1);
            if (window.MutationObserver) {
                observer = new window.MutationObserver(mutHandler);
                observer.observe(document, { childList: true, subtree: true });
            }
        }
        else {
            window.addEventListener("load", readExternalDoc);
        }
        swapDoc = document.implementation.createDocument('http://www.w3.org/1999/xhtml', 'html', null);
        console.log('moduleInit');
    }
    moduleInit();
    function mutHandler(muts) {
        console.log('mutHandler:' + muts.length);
        for (var i = 0; i < muts.length; i++) {
            var adds = muts[i].addedNodes;
            if (!adds)
                continue;
            var targetToChange;
            for (var j = 0; j < adds.length; j++) {
                var el = adds[j];
                //console.log(el.nodeName);
                if (!el.classList) {
                    continue;
                }
                else if (el.classList.contains('etb-page')) {
                    console.log('mutHandler:etb-page');
                    // TODO firefox 31 可能会漏掉 etb-pages，所以在这里做补偿。
                    if (!observingEtbPages) {
                        targetToChange = el.parentNode;
                        observingEtbPages = true;
                    }
                    var prev = el.previousElementSibling;
                    if (prev && prev.classList.contains('etb-page'))
                        swapOut(prev);
                }
                else if (el.classList.contains('etb-pages')) {
                    console.log('mutHandler:etb-pages');
                    targetToChange = el;
                }
            }
        }
        if (targetToChange) {
            console.log('mutHandler:targetToChange');
            observer.disconnect();
            observer.observe(targetToChange, { childList: true });
            observingEtbPages = true;
        }
    }
    function init0(doc) {
        console.log('begin init0');
        if (doc.nodeType != Node.DOCUMENT_NODE)
            doc = document;
        observer && observer.disconnect();
        observer = null;
        var pgs = doc.querySelectorAll('.etb-page');
        for (var i = 0; i < pgs.length; i++) {
            swapOut(pgs[i]);
        }
        console.log('end init0');
    }
    function init1(doc) {
        console.log('begin init1');
        if (doc.nodeType != Node.DOCUMENT_NODE) {
            doc = document;
        }
        //initSignalMap(doc);
        etb_book.enableControlConnection(doc, true);
        initMenu(doc);
        onScrolled(doc);
        doc.addEventListener('scroll', onScroll);
        console.log('end init1');
    }
    function getDocUrl() {
        var match = location.hash.match(/docUrl=(.+)/);
        if (match)
            return match[1];
        return etb_config.externalDocUrl || 'content.xhtml';
    }
    function readExternalDoc() {
        var docUrl = getDocUrl();
        console.log('readExternalDoc:' + docUrl);
        var xhr = new XMLHttpRequest();
        try {
            xhr.open('GET', docUrl);
            xhr.responseType = 'document';
            xhr.send();
        }
        catch (e) {
            fallback(e, 'open/send');
        }
        xhr.onload = function () {
            var st = xhr.status;
            if (st >= 200 && st < 300 || st === 304 || st === 0) {
                processExternalDoc(xhr.response);
            }
            else {
                fallback(new Error('XHR status:' + st), 'http-' + st);
            }
        };
        xhr.onerror = function (err) {
            fallback(err, 'network');
        };
        function fallback(err, stage) {
            if (stage === void 0) { stage = ''; }
            console.error('readExternalDoc:error:' + stage + ':url=' + docUrl, err);
            if (!etb_config.noRedirection) {
                console.warn('readExternalDoc:redirect:' + docUrl);
                location.href = docUrl;
            }
            else {
                document.body.innerHTML = "<p>加载失败：" + docUrl + "</p>";
            }
        }
    }
    function processExternalDoc(xdoc) {
        var doc = document;
        var base = doc.createElement('base');
        base.href = xdoc.URL;
        doc.head.appendChild(base);
        var res = xdoc.querySelectorAll('script, link[rel=stylesheet]');
        var resCount = 0;
        if (!etb_config.stripCodes) {
            for (var i = 0; i < res.length; i++) {
                var el = res[i];
                doc.adoptNode(el);
                var src = el.getAttribute('src');
                if (src && /(controls\/_book|jsgen)\/book.js$/.test(src))
                    continue;
                // 直接插入来自别的文档的 script 元素似乎无法执行，只好在本文档上创建
                if (el.localName === 'script' && src) {
                    var script = doc.createElement('script');
                    script.src = src;
                    el = script;
                }
                doc.head.appendChild(el);
                ++resCount;
                el['onload'] = onResLoad;
            }
        }
        var xheads = xdoc.querySelectorAll('head>*');
        for (var i = 0, n = xheads.length; i < n; i++) {
            var el = xheads[i];
            if (el.localName === 'script')
                continue;
            if ((el.localName === 'link') && (el.getAttribute('rel') === 'stylesheet'))
                continue;
            if (etb_config.stripCodes && el.localName === 'style' && el.hasAttribute('data-href'))
                continue;
            doc.head.appendChild(el);
        }
        // 改用外部文档的标题，如果有的话
        var titles = doc.head.querySelectorAll('title');
        if (titles.length > 1)
            titles[0].parentNode.removeChild(titles[0]);
        var pgContaner = xdoc.querySelector('.etb-pages');
        var pgs = pgContaner.children;
        for (var j = 0; j < pgs.length; j++)
            swapOut(pgs[j]);
        doc.body.innerHTML = '';
        var outline = xdoc.querySelector('.etb-outline');
        outline && doc.body.appendChild(outline);
        doc.body.appendChild(pgContaner);
        if (resCount === 0) {
            finish();
            return;
        }
        var finishTimer = setTimeout(finish, 3000);
        function onResLoad() {
            --resCount;
            console.log('onResLoad:' + resCount);
            if (resCount === 0)
                finish();
        }
        function finish() {
            clearTimeout(finishTimer);
            init1(doc);
        }
    }
    function reloadMedias(node) {
        var medias = node.querySelectorAll('video, audio');
        for (var i = 0; i < medias.length; i++)
            medias[i].load();
    }
    function swapOut(p) {
        if (p.etbrSwap)
            return false;
        console.log('do swapOut');
        var swap = swapDoc.createDocumentFragment();
        while (p.firstChild)
            swap.appendChild(p.firstChild);
        reloadMedias(swap); //故意引发错误，导致释放内存。
        p.etbrSwap = swap;
        return true;
    }
    function swapIn(p) {
        if (!p.etbrSwap)
            return false;
        p.appendChild(p.etbrSwap);
        delete p.etbrSwap;
        initPage(p);
        reloadMedias(p); //不可缺少，因为已经出错的媒体不一定会自动重新加载，甚至可能变得不可见。
        return true;
    }
    function initPage(page) {
        if (page.etbrInit)
            return false;
        etb_book.resetPopups(page, true);
        initControls(page);
        page.etbrInit = true;
        return false;
    }
    function onScrolled(doc) {
        //console.log('onScrolled');
        if (Fscreen.isFullScreen()) {
            console.warn('onScrolled called when fullscreened, abort.');
            return;
        }
        var curr = null, cpn = -1;
        var pgs = doc.querySelector('.etb-pages').children;
        for (var i = 0; i < pgs.length; i++) {
            var p = pgs[i];
            if (elemCenterInViewport(p)) {
                swapIn(p);
                if (!curr) {
                    curr = p;
                    cpn = i;
                }
            }
            else {
                swapOut(p);
            }
        }
        etb_book.currentPage = curr;
        etb_book.currentPageNumber = cpn;
        //logState();
        updatePageSelection();
    }
    var scrollTimer = null;
    function onScroll(ev) {
        //console.log('onScroll');
        if (scrollTimer !== null)
            clearTimeout(scrollTimer);
        scrollTimer = setTimeout(onScrolled, 300, ev.target);
    }
    function elemCenterInViewport(el) {
        var rect = el.getBoundingClientRect();
        var ecx = (rect.left + rect.right) / 2;
        var ecy = (rect.top + rect.bottom) / 2;
        var vcx = innerWidth / 2;
        var vcy = innerHeight / 2;
        return ecx > 0 && ecy > 0 && ecx < innerWidth && ecy < innerHeight ||
            vcx > rect.left && vcx < rect.right && vcy > rect.top && vcy < rect.bottom;
    }
    function elemInViewport(el) {
        return elemIntersectBox(el, 0, 0, innerWidth, innerHeight);
    }
    function elemIntersectBox(el, x0, y0, x1, y1) {
        var rect = el.getBoundingClientRect();
        return rect.bottom > y0 && rect.top < y1 && rect.right > x0 && rect.left < x1;
    }
    function getControlOf(el) {
        var ctrName = el.getAttribute('data-control');
        if (ctrName === '')
            return etb_controls[el.localName];
        else
            return etb_controls[ctrName];
    }
    function initControls(elemsOrDoc) {
        var nodes = elemsOrDoc.nodeType ? elemsOrDoc.querySelectorAll('[data-control]') : elemsOrDoc;
        for (var i = 0; i < nodes.length; i++) {
            var node = nodes[i];
            var ctr = getControlOf(node);
            if (ctr)
                ctr.init(node);
        }
    }
    // getAncestors 和 isEditing 是供 book.shared.ts 调用
    function getAncestors(node, filter) {
        var ret = [];
        var docType = Node.DOCUMENT_NODE;
        for (var cur = node; cur && cur.nodeType !== docType; cur = cur.parentNode) {
            try {
                if (filter && filter(cur))
                    ret.push(cur);
            }
            catch (e) {
                console.warn(e.stack || e);
            }
        }
        return ret;
    }
    etb_book.getAncestors = getAncestors;
    function isEditing(contenxt) { return false; }
    etb_book.isEditing = isEditing;
    var Fscreen;
    (function (Fscreen) {
        function fullscreenElement() {
            return document.fullscreenElement || document.mozFullScreenElement || document.webkitFullscreenElement;
        }
        Fscreen.fullscreenElement = fullscreenElement;
        function isFullScreen() {
            return !!fullscreenElement();
        }
        Fscreen.isFullScreen = isFullScreen;
        function isDocFullScreen() {
            return fullscreenElement() === document.body;
        }
        Fscreen.isDocFullScreen = isDocFullScreen;
        function launchFullScreen() {
            var element = document.body;
            var requestFullscreen = element.requestFullscreen
                || element.mozRequestFullScreen
                || element.webkitRequestFullScreen;
            requestFullscreen.call(element, Element['ALLOW_KEYBOARD_INPUT']);
        }
        Fscreen.launchFullScreen = launchFullScreen;
        function cancelFullscreen() {
            var doc = document;
            var exitFullscreen = doc.exitFullscreen
                || doc.mozCancelFullScreen
                || doc.webkitCancelFullScreen;
            exitFullscreen.call(doc);
        }
        Fscreen.cancelFullscreen = cancelFullscreen;
        function updateFullscreenButton() {
            var btn = document.getElementsByClassName('etb-full')[0];
            var fclass = 'etb-full-attr';
            if (isFullScreen()) {
                btn.classList.add(fclass);
                btn['title'] = btn.dataset['normal'];
            }
            else {
                btn.classList.remove(fclass);
                btn['title'] = btn.dataset['full'];
            }
        }
        Fscreen.updateFullscreenButton = updateFullscreenButton;
        //指定某一个etbPage播放
        function showOneElement(obj) {
            var aNode = document.getElementsByClassName("etb-page"), curNode = Array.prototype.indexOf.call(aNode, obj);
            Array.prototype.forEach.call(aNode, function (e, i) {
                if (i < curNode) {
                    swapOut(e);
                    e.classList.remove("cur");
                    e.classList.remove("next");
                    e.classList.add("pre");
                }
                else if (i > curNode) {
                    swapOut(e);
                    e.classList.remove("cur");
                    e.classList.remove("pre");
                    e.classList.add("next");
                }
                else {
                    swapIn(e);
                    e.classList.remove("next");
                    e.classList.remove("pre");
                    e.classList.add("cur");
                    etb_book.currentPage = e;
                    svgPen.setTransform(e.etbScale, innerWidth / 2, innerHeight / 2);
                }
            });
        }
        Fscreen.showOneElement = showOneElement;
        function scaleToScreen() {
            // TODO chrome 36 的 innerHeight 报告的是进入全屏前的，但似乎没什么好办法。
            //console.log('innerWidth:' + innerWidth + ', innerHeight:' + innerHeight);
            Array.prototype.forEach.call(document.getElementsByClassName("etb-page"), function (e, i) {
                var w = parseInt(getComputedStyle(e, null).width), h = parseInt(getComputedStyle(e, null).height);
                //console.log('w:' + w + ', h:' + h);
                var scale = Math.min(innerWidth / w, innerHeight / h);
                e.etbScale = scale;
                var tr = "scale(" + scale + ")";
                e.style.transform = tr;
                e.style.webkitTransform = tr;
                e.style.margin = -h / 2 + 'px 0 0 ' + (-w / 2) + 'px';
            });
        }
        Fscreen.scaleToScreen = scaleToScreen;
        function restoreScale() {
            Array.prototype.forEach.call(document.getElementsByClassName("etb-page"), function (e, i) {
                e.etbScale = 1;
                e.classList.remove("cur");
                e.classList.remove("next");
                e.classList.remove("pre");
                e.style.webkitTransform = "";
                e.style.transform = "";
                e.style.margin = "";
            });
            svgPen.setTransform(1, 0, 0);
        }
        Fscreen.restoreScale = restoreScale;
    })(Fscreen || (Fscreen = {}));
    var svgPen;
    function updatePageSelection() {
        //更新当前幻灯片的值到 select 元素的值
        document.getElementsByClassName("etb-page-select")[0]
            .selectedIndex = etb_book.currentPageNumber;
    }
    function gotoPage(pnOrPage) {
        var pn = -1, page = null;
        if (typeof pnOrPage === 'number') {
            pn = pnOrPage;
            page = document.getElementsByClassName("etb-page")[pn];
        }
        else if (pnOrPage && pnOrPage.classList && pnOrPage.classList.contains('etb-page')) {
            pn = Array.prototype.indexOf.call(pnOrPage.parentNode.children, pnOrPage);
            page = pnOrPage;
        }
        if (pn < 0 || !page) {
            console.error('gotoPage: bad param:', pnOrPage);
            return;
        }
        if (Fscreen.isFullScreen() && !Fscreen.isDocFullScreen()) {
            return;
        }
        etb_book.currentPage = page;
        etb_book.currentPageNumber = pn;
        if (Fscreen.isDocFullScreen())
            Fscreen.showOneElement(etb_book.currentPage);
        else
            etb_book.currentPage.scrollIntoView();
        updatePageSelection();
    }
    function showMenu(show) {
        //console.log('showMenu', show);
        var menu = document.getElementsByClassName("etb-menu")[0];
        if (show)
            menu.classList.add('show');
        else
            menu.classList.remove('show');
    }
    function toggleMenu() {
        //console.log('toggleMenu');
        document.getElementsByClassName("etb-menu")[0].classList.toggle('show');
    }
    function showOutline(show) {
        var ol = document.getElementsByClassName("etb-outline")[0];
        if (!ol)
            return;
        if (show) {
            ol.classList.remove('hidden');
            ol.classList.add('shown');
        }
        else {
            ol.classList.remove('shown');
            ol.classList.add('hidden');
        }
    }
    function toggleOutline() {
        var ol = document.getElementsByClassName("etb-outline")[0];
        if (!ol)
            return;
        showOutline(!ol.classList.contains('shown'));
    }
    function triggerOutline(a) {
        var href = a.getAttribute('href') || '';
        var pos = href.lastIndexOf('#');
        if (pos < 0)
            return;
        var id = href.slice(pos + 1);
        var targ = document.getElementById(id);
        gotoPage(targ);
    }
    function eventInThirdParty(evTarget, widget) {
        var ans = getAncestors(evTarget, function (e) {
            return e.hasAttribute('data-control') || e === widget;
        });
        return !ans.length;
    }
    function initMenu(document) {
        insertMenutHtml();
        var etbFull = document.getElementsByClassName("etb-full")[0], etbMenu = document.getElementsByClassName("etb-menu")[0], len = document.querySelectorAll(".etb-page").length, eSelect = document.getElementsByClassName("etb-page-select")[0], etbPages = document.getElementsByClassName("etb-pages")[0], etbPage = document.getElementsByClassName("etb-page"), penToolbar = document.getElementsByClassName("etb-penToolbar")[0], etbOutline = document.getElementsByClassName("etb-outline")[0], fullscreenchange = "onwebkitfullscreenchange" in document ? "webkitfullscreenchange" :
            "onmozfullscreenchange" in document ? "mozfullscreenchange" : "fullscreenchange", 
        //延缓页面滚动时候事件触发的个数
        timeOut = {
            timer: null,
            scroll: function (fn) {
                clearInterval(timeOut.timer);
                timeOut.timer = setTimeout(fn(), 400);
            }
        };
        Fscreen.updateFullscreenButton();
        if (etbOutline)
            etbOutline.classList.add('hidden');
        var ste = document.createElement('style');
        document.body.appendChild(ste);
        ste.sheet.insertRule(".cur{left:50%;}", 0);
        ste.sheet.insertRule(".pre{left:-50%; opacity:0;}", 0);
        ste.sheet.insertRule(".next{left:150%; opacity:0;}", 0);
        //添加select下的option;
        addOptions();
        function addOptions() {
            for (var i = 0; i < len; i++) {
                eSelect.add(new Option((i + 1) + '', i + ''));
            }
        }
        function prev() {
            gotoPage(etb_book.currentPageNumber - 1);
        }
        function next() {
            gotoPage(etb_book.currentPageNumber + 1);
        }
        var slider = (function () {
            var timer = 0;
            return {
                resetTimer: function () {
                    timer = 0;
                },
                addTimer: function () {
                    setTimeout(function () {
                        timer = 0;
                    }, 1000);
                    timer++;
                    if (timer > 4) {
                        timer = 0;
                        return true;
                    }
                }
            };
        })();
        function keyFn(event) {
            switch (event.keyCode) {
                case 37:
                case 38:
                    prev();
                    break;
                case 39:
                case 40:
                    next();
                    break;
            }
        }
        function mouseFn(event) {
            //console.log(event.type);
            switch (event.type) {
                case "pointermove":
                    var mx = event.clientX, my = event.clientY;
                    // 	leftCursor = document.getElementsByClassName("etb-pre-cursor")[0],
                    // 	rightCursor = document.getElementsByClassName("etb-next-cursor")[0];
                    //         if ((mx < etbPages.offsetLeft) && currentPageNumber !== 0) {
                    //           leftCursor.classList.add("opacity100");
                    //         } else if ((mx > (etbPages.offsetLeft + etbPages.offsetWidth)) && (currentPageNumber !== etbPage.length - 1)) {
                    //           rightCursor.classList.add("opacity100");
                    //         } else {
                    //           leftCursor.classList.remove("opacity100");
                    //           rightCursor.classList.remove("opacity100");
                    //         };
                    showMenu(my > etbMenu.offsetTop || etbMenu.contains(event.target));
                    break;
                case "DOMMouseScroll":
                case "mousewheel":
                    if (!Fscreen.isDocFullScreen())
                        return;
                    event.delta = (event.wheelDelta) ? event.wheelDelta / 120 : -(event.detail || 0) / 3;
                    if (event.delta > 0) {
                        if (slider.addTimer())
                            prev();
                    }
                    else {
                        if (slider.addTimer())
                            next();
                    }
                    break;
                case "pointerdown":
                    // var mx = event.clientX;
                    // if (mx < innerWidth / 4 && currentPageNumber > 0) {
                    //   judgeAndScroll(currentPageNumber - 1);
                    // }
                    // if ((mx > 3 * innerWidth / 4) && (currentPageNumber < etbPage.length - 1)) {
                    //   judgeAndScroll(currentPageNumber + 1);
                    // }
                    break;
                case "click":
                    var targ = event.target;
                    if (eventInThirdParty(targ, etbMenu)) {
                        toggleMenu();
                        toggleOutline();
                    }
                    else {
                        showOutline(false);
                    }
                    if (targ.localName === 'a' && etbOutline && etbOutline.contains(targ)) {
                        event.preventDefault();
                        triggerOutline(targ);
                    }
                default:
                    break;
            }
            updatePageSelection();
        }
        function jugeNowPage() {
            var arr = [], 
            //CHROME && FF;
            scrollTop = document.body.scrollTop || document.documentElement.scrollTop;
            Array.prototype.forEach.call(etbPage, function (e, i) {
                arr.push({ top: (e.offsetTop + e.offsetHeight - 16 - scrollTop), el: e });
            });
            arr = arr.filter(function (o) {
                return o.top > 0;
            });
            arr.sort(function (a, b) { if (a.top < b.top) {
                return -1;
            }
            else {
                return 1;
            } });
            var arr2 = [];
            Array.prototype.forEach.call(etbPage, function (e, i) {
                arr2.push({ top: (document.documentElement.clientHeight + scrollTop - e.offsetTop), el: e });
            });
            arr2 = arr2.filter(function (o) {
                return o.top > 0;
            });
            arr2.sort(function (a, b) { if (a.top < b.top) {
                return -1;
            }
            else {
                return 1;
            } });
            try {
                if (arr[0].top < arr2[0].top) {
                    return arr2[0].el;
                }
            }
            catch (e) {
                return arr2[0].el;
            }
            return arr[0].el;
        }
        ;
        /*事件*/
        etbFull.addEventListener("click", function () {
            if (!Fscreen.isFullScreen()) {
                Fscreen.launchFullScreen();
                gotoPage(etb_book.currentPageNumber);
            }
            else
                Fscreen.cancelFullscreen();
        });
        eSelect.addEventListener("change", function (ev) {
            gotoPage(this.selectedIndex);
        }, false);
        // window.addEventListener("scroll", function () {
        //   timeOut.scroll(function () {
        //     Fscreen.now = Array.prototype.indexOf.call(etbPages.children, jugeNowPage());
        //     eSelect.selectedIndex = Fscreen.now;
        //   })
        // }, false);
        document.querySelector(".etb-prev").addEventListener("click", prev, false);
        document.querySelector(".etb-next").addEventListener("click", next, false);
        document.addEventListener(fullscreenchange, function (ev) {
            if (Fscreen.isFullScreen()) {
                //console.log('fullscreenchange:true');
                if (Fscreen.isDocFullScreen()) {
                    Fscreen.scaleToScreen();
                    gotoPage(etb_book.currentPageNumber);
                }
            }
            else {
                //console.log('fullscreenchange:false');
                Fscreen.restoreScale();
                gotoPage(etb_book.currentPageNumber);
            }
            ;
            Fscreen.updateFullscreenButton();
        }, false);
        /*mousewheel要先绑定，要么chrome无效*/
        window.addEventListener("mousewheel", mouseFn, false);
        window.addEventListener("DOMMouseScroll", mouseFn, false);
        //自从播放模式下
        document.body.addEventListener("pointerdown", mouseFn, false);
        document.body.addEventListener("pointermove", mouseFn, false);
        document.addEventListener('click', mouseFn);
        window.addEventListener("keydown", keyFn, false);
        /*事件绑定*/
        svgPen = new etb_tools.SVGPen(document.body);
        svgPen.onPathDrawn = onPathDrawn;
        initSVGPenBar();
    }
    function initSVGPenBar() {
        var draw = document.querySelector('.etb-SvgPenDraw');
        draw.addEventListener('click', function (ev) {
            svgPen.isDrawing = !svgPen.isDrawing;
            if (svgPen.isDrawing)
                draw.classList.add('etb-down');
            else
                draw.classList.remove('etb-down');
        });
        var removeAll = document.querySelector('.etb-SvgPenRemoveAll');
        removeAll.addEventListener('click', function (ev) { return etb_book.currentPage && svgPen.removeAll(etb_book.currentPage); });
    }
    function onPathDrawn(event) {
        event.canvas = etb_book.currentPage;
    }
    function insertMenutHtml() {
        var html = [
            '<div class="etb-menu">',
            '<div class="etb-fullScreen">',
            '<button class="etb-full" data-full="全屏播放" data-normal="退出全屏" title="全屏播放"> </button>',
            '</div> ',
            ' <div class="etb-pageNav">',
            '	<button class="etb-prev" title="上一页"></button> ',
            ' <select class="etb-page-select">',
            '</select> ',
            '<button class="etb-next" title="下一页"></button>',
            '<button class="etb-SvgPenDraw" title="笔画"></button>',
            '<button class="etb-SvgPenRemoveAll" title="删除笔画"></button>',
            '</div> ',
            '</div> ',
        ].join('\n');
        document.body.insertAdjacentHTML('afterbegin', html);
    }
})(etb_book || (etb_book = {}));
//# sourceMappingURL=book.js.map