var Common={
	/**
	 * set body = headerDIV + containerDIV
	 * @param {Object} headerDiv .header
	 * @param {Object} containerDiv .container
	 */
	setContainerHeightAuto : function(headerDivSelector, containerDivSelector){
		var headerHeight = $(headerDivSelector).offset().height;
		var containerHeight = document.body.clientHeight - headerHeight;
		$(containerDivSelector).css('height', containerHeight);
	},
	setContainerWidthAuto : function(leftDivSelector, containerDivSelector){
		var leftWidth = $(leftDivSelector).offset().width;
		var containerWidth = document.body.clientWidth - leftWidth;
		$(containerDivSelector).css('width', containerWidth);
	},
	
	isExistParentByClass:function(dom, klass){
		if (!dom.parentElement)
			return false;
		if (dom.parentElement.className === klass || dom.className === klass)
			return true;
		else
			return this.isExistParentByClass(dom.parentElement, klass);
	},
	
	updatePopupExitBoxPosition:function(selector, boxWidth, boxHeight){
		var width = document.body.clientWidth;
		var height = document.body.clientHeight;
		width =(width - boxWidth)/2;
		height =(height - boxHeight)/2;
		$(selector).css('left',width);
		$(selector).css('top',height);
	},
	
	registerHandlebarsHelper: function() {
		var audaciousFn;
		Handlebars.registerHelper('recursive', function(children, options) {
			var out = '';
			if (options.fn !== undefined) {
				audaciousFn = options.fn;
			}
			children.forEach(function(child) {
				out = out + audaciousFn(child);
			});
			return out;
		});
	},
	/**
	 * 
	 * @param {Object} a --json array object JSON.parse()
	 * @param {Object} idStr --row id
	 * @param {Object} pidStr	--parent id
	 * @param {Object} chindrenStr
	 * @param {Object} orderNumber
	 */
	transData: function(a, idStr, pidStr, chindrenStr, orderNumber) {
		var r = [], hash = {}, id = idStr, pid = pidStr, children = chindrenStr, i = 0, j = 0, len = a.length;
		for (; i < len; i++) {
			hash[a[i][id]] = a[i];
		}
		for (; j < len; j++) {
			var aVal = a[j], hashVP = hash[aVal[pid]];
			if (hashVP) {
				var orderNum = aVal[orderNumber];
				!hashVP[children] && (hashVP[children] = []);
				hashVP[children][orderNum - 1] = aVal;
			} else {
				r.push(aVal);
			}
		}
		return r;
	},

	alertView: (function(){
		var showed = false, $alertView = null, $overlay = null;
		function createView(config) {
			if(!config) return;
			if(!config.width) config.width = 178;
			if(!config.height) config.height = 100;
			$alertView = $("<div>").css({
				"maring": 0,
				"padding": 0,
				"position":"fixed",
				"width": config.width,
				"min-height": config.height,
				"color": "white",
				"font-family": "Microsoft YaHei",
				"font-size": "24px",
				"background": "#33B5E5",
				"text-shadow": "none",
				"border": "3px solid #FFFFFF",
				"z-index": 999})
			.append($("<div>")
				.css({
					"margin": 0,
					"padding": 0,
					"height": "70%",
					"min-height": "65px",
					"text-align": "center",
					"border-bottom": "3px solid #FFFFFF"
					})
				.append($("<p>").css({
						"margin":0,
						"padding":"15px 15%",
						"width": "70%"
					})
					.text(config.text)))
			.append($("<div>").css({
						"padding-top":"8px",
						"text-align":"center",
						"font-size":0,
						"-webkit-user-select": "none",
						"min-height": "40px"})
					.append($("<div>")
						.addClass("button cancel")
						.css({
						"display":"inline-block",
						"width":"48%",
						"height":"40px",
						"line-height": "40px",
						"vertical-align": "middle",
						"font-size":"24px"
					}).text("取消"))
					.append($("<div>")
						.css({
							"margin": 0,
							"padding": 0,
							"width": "2px",
							"height": "30px",
							"display":"inline-block",
							"vertical-align": "middle",
							"background":"#FFFFFF"
						}).text('  '))
					.append($("<div>")
						.addClass("button ok")
						.css({
						"display":"inline-block",
						"width":"48%",
						"height": "40px",
						"line-height": "40px",
						"vertical-align": "middle",
						"font-size":"24px"
					}).text("确定"))
				);
			$overlay = $("<div></div>").css({
				"margin": 0,
				"padding": 0,
				"position":"absolute",
				"top": 0,
				"left": 0,
				"z-index": 998,
				"opacity": 0.3,
				"background": "black"
			});
		}
		
		function layout() {
			var bodyOffset = $("body").offset(),
				viewOffset = $alertView.offset();
			$alertView.css({
				left: (bodyOffset.width - viewOffset.width) / 2,
				top: (bodyOffset.height - viewOffset.height) / 2
			});
			$overlay.css({
				width: bodyOffset.width,
				height: bodyOffset.height
			});
		}
		
		function bind(onOK, onCancel){
			$alertView.find('div.button').on('click', function(){
				close();
				if($(this).hasClass("cancel")){
					if(typeof onCancel === "function") onCancel();
				} else {
					if(typeof onOK === "function") onOK();
				}
			})
		}

		function close(){
			window.removeEventListener("resize", layout);
			$alertView.remove();
			$overlay.remove();
		}
		
		return {
		 	show: function(config, onOK, onCancel){
				if(showed) return;
				createView(config);
				bind(onOK, onCancel);
				$overlay.appendTo("body");
				$alertView.appendTo("body");
				layout();
				window.addEventListener("resize", layout, false);
			}
		}
	}())
};
