<html>
    <head>
        <title>Winds | Powered by GetStream.io</title>
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:300,400,500">
        <style type="text/css">
            html,
            body {
                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif;
                background-color: #F7F7F7;
            }
            svg {
                margin-right: 20px;
                max-width: 14px;
            }
            #wrapper {
                margin-top: 15%;
                text-align: center;
            }
            #cta {
                display: flex;
                flex-wrap: wrap;
            }
            #download {
                font-size: 13px;
                background: #000000;
                border-radius: 5px;
                color: #ffffff;
                height: 48px;
                display: flex;
                display: -webkit-box;
                display: -webkit-flex;
                display: -ms-flexbox;
                -webkit-align-items: center;
                -webkit-box-align: center;
                -ms-flex-align: center;
                align-items: center;
                break-after: always;
                padding: 0 16px;
                margin: 0 auto 0 auto;
                -webkit-text-decoration: none;
                -webkit-transition: background 0.12s ease-in-out;
                text-decoration: none;
            }
            #download:hover {
                background: #44bc75;
                transition: 300ms;
                transition-timing-function: ease-in-out;
                -webkit-transition: 300ms;
                -webkit-transition-timing-function: ease-in-out;
            }
            #download strong {
                margin-top: 2px;
            }
            #other-downloads {
                margin-top: 24px;
                color: #000000;
            }
            #other-downloads > a {
                color: #000000;
                text-decoration: none;
            }
            #other-downloads > svg {
                margin-top: 24px;
            }
            #content {
                display: block;
                margin: 0 auto;
                width: 600px;
                margin-top: 24px;
            }
            #content h2 {
                float: left;
            }
            table {
                font-size: 13px;
                min-width: 600px;
                border-color: #000000;
                color: #000000;
                margin: 24px auto 0 auto;
                border-collapse: collapse;
            }
            tbody {
                color: #000000;
            }
            tr {
            }
            td {
                min-width: 50%;
                padding: 10px;
                vertical-align: top;
                border: 1px solid #444;
                position: relative;
                word-break: break-word;
            }
            #invisible-top-left {
                border: none;
            }
            .center {
                text-align: center;
            }
            .download-alt {
                text-align: center;
                padding-left: 30px;
            }
            .download-alt:hover svg {
                fill: #44bc75;
                transition: 300ms;
                transition-timing-function: ease-in-out;
                -webkit-transition: 300ms;
                -webkit-transition-timing-function: ease-in-out;
            }
        </style>
    </head>
    <body>
        <div id="wrapper">
            <div id="cta"></div>
            <div id="other-downloads">
                <a href="#" class="next">Other Downloads</a>
                <br />
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M509.1 126c-3.8-3.8-10.1-3.8-13.9 0L256 365.2 16.8 126c-3.8-3.8-10.1-3.8-13.9 0 -3.8 3.8-3.8 10.1 0 13.9l246.2 246.2c1.8 1.8 4.3 2.9 6.9 2.9 2.6 0 5.1-1 6.9-2.9l246.2-246.2C513 136 513 129.8 509.1 126z" fill="rgb(0, 0, 0)"/></svg>
            </div>
            <div id="content">
                <h2>Downloads</h2>
                <table>
                    <tbody>
                        <tr>
                            <td id="invisible-top-left"></td>
                            <td style="width:33.333%" class="center">64-bit</td>
                        </tr>
                        <tr>
                            <td><b>macOS</b> (.dmg)</td>
                            <td id="td-mac-os" class="download-alt">
                                <a href="https://s3.amazonaws.com/winds-2.0-releases/releases/Winds-${version}.dmg" title="macOS">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 59 59">
                                        <path d="M20.2 28.3c-0.4-0.4-1-0.4-1.4 0s-0.4 1 0 1.4l10 10C28.9 39.9 29.2 40 29.5 40c0 0 0 0 0 0 0 0 0 0 0 0 0.3 0 0.6-0.2 0.8-0.4l9.9-9.9c0.4-0.4 0.4-1 0-1.4s-1-0.4-1.4 0L30.5 36.5V1c0-0.6-0.4-1-1-1s-1 0.4-1 1v35.6L20.2 28.3z" class="a"/>
                                        <path d="M36.5 16c-0.6 0-1 0.4-1 1s0.4 1 1 1h13v39h-40V18h13c0.6 0 1-0.4 1-1s-0.4-1-1-1h-15v43h44V16H36.5z" class="a"/>
                                    </svg>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td><b>Windows</b> (.exe)</td>
                            <td id="td-win" class="download-alt">
                                <a href="https://s3.amazonaws.com/winds-2.0-releases/releases/Winds%20Setup%20${version}.exe" title="Windows">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 59 59">
                                        <path d="M20.2 28.3c-0.4-0.4-1-0.4-1.4 0s-0.4 1 0 1.4l10 10C28.9 39.9 29.2 40 29.5 40c0 0 0 0 0 0 0 0 0 0 0 0 0.3 0 0.6-0.2 0.8-0.4l9.9-9.9c0.4-0.4 0.4-1 0-1.4s-1-0.4-1.4 0L30.5 36.5V1c0-0.6-0.4-1-1-1s-1 0.4-1 1v35.6L20.2 28.3z" class="a"/>
                                        <path d="M36.5 16c-0.6 0-1 0.4-1 1s0.4 1 1 1h13v39h-40V18h13c0.6 0 1-0.4 1-1s-0.4-1-1-1h-15v43h44V16H36.5z" class="a"/>
                                    </svg>
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td><b>Linux Distros</b> (.AppImage)</td>
                            <td id="td-appimage" class="download-alt">
                                <a href="https://s3.amazonaws.com/winds-2.0-releases/releases/winds-${version}-x86_64.AppImage" title="AppImage">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 59 59">
                                        <path d="M20.2 28.3c-0.4-0.4-1-0.4-1.4 0s-0.4 1 0 1.4l10 10C28.9 39.9 29.2 40 29.5 40c0 0 0 0 0 0 0 0 0 0 0 0 0.3 0 0.6-0.2 0.8-0.4l9.9-9.9c0.4-0.4 0.4-1 0-1.4s-1-0.4-1.4 0L30.5 36.5V1c0-0.6-0.4-1-1-1s-1 0.4-1 1v35.6L20.2 28.3z" class="a"/>
                                        <path d="M36.5 16c-0.6 0-1 0.4-1 1s0.4 1 1 1h13v39h-40V18h13c0.6 0 1-0.4 1-1s-0.4-1-1-1h-15v43h44V16H36.5z" class="a"/>
                                    </svg>
                                </a>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <script type="text/javascript">
            var os = navigator.appVersion;
            var el = document.getElementById('cta');

            if (os.indexOf('Mac') != -1) {
                el.innerHTML = `
                    <a href="https://itunes.apple.com/us/app/winds-by-getstream-io/id1381446741" title="macOS" id="download">
                        <svg width="20px" height="24px" viewBox="0 0 20 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <defs></defs>
                            <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g id="iconmonstr-apple-os-1" fill="#FFFFFF" fill-rule="nonzero">
                                    <path d="M20,17.607 C19.214,19.887 16.861,23.924 14.437,23.968 C12.829,23.999 12.312,23.015 10.474,23.015 C8.637,23.015 8.062,23.938 6.542,23.998 C3.97,24.097 0,18.171 0,13.003 C0,8.256 3.308,5.903 6.198,5.86 C7.748,5.832 9.212,6.905 10.157,6.905 C11.106,6.905 12.884,5.615 14.753,5.804 C15.535,5.837 17.732,6.119 19.142,8.181 C15.401,10.623 15.984,15.73 20,17.607 Z M14.778,0 C11.952,0.114 9.646,3.079 9.968,5.531 C12.58,5.734 15.086,2.806 14.778,0 Z" id="Shape"></path>
                                </g>
                            </g>
                        </svg>
                        <strong>Download Winds from the macOS store</strong>
                    </a>
                `;
            } else if (os.indexOf('Linux') != -1 || os.indexOf('X11') != -1) {
                el.innerHTML = `
                    <a href="https://snapcraft.io/winds" title="Linux" id="download">
                        <svg width="18px" height="24px" viewBox="0 0 18 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <defs></defs>
                            <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g id="iconmonstr-linux-os-1" fill="#ffffff" fill-rule="nonzero">
                                    <path d="M17.581,19.049 C17.031,18.603 17.245,17.618 16.674,17.132 C17.227,13.767 15.677,10.801 13.829,8.9 C12.278,7.305 12.778,5.753 12.778,4.41 C12.778,2.264 11.897,-1.77635684e-15 9.228,-1.77635684e-15 C6.375,-1.77635684e-15 5.593,2.38 5.565,3.738 C5.497,7 6.224,7.848 4.315,10.222 C2.069,13.015 1.738,15.801 2.245,17.279 C2.008,17.555 1.688,17.861 1.09,18.114 C-0.562,18.834 0.649,20.039 0.192,20.894 C0.062,21.137 4.4408921e-16,21.391 4.4408921e-16,21.634 C4.4408921e-16,22.384 0.596,23.033 1.679,22.936 C3.14,22.806 4.488,23.841 5.36,23.841 C6.13,23.841 6.762,23.403 7.056,22.8 C8.433,22.461 10.133,22.504 11.509,22.859 C11.756,23.55 12.426,24 13.171,24 C14.802,24 15.116,22.151 16.987,21.525 C17.661,21.3 18,20.646 18,20.037 C18,19.647 17.861,19.276 17.581,19.049 Z M8.434,8.584 C8.115,8.584 7.851,8.326 7.434,8.016 C6.906,7.624 6.369,7.398 6.375,6.986 C6.375,6.703 6.754,6.616 7.244,6.305 C7.77,5.972 7.975,5.634 8.493,5.634 C9.023,5.634 9.183,5.902 9.903,6.213 C10.611,6.52 11.104,6.64 11.104,6.986 C11.104,7.341 10.363,7.595 9.946,7.854 C9.333,8.232 9.018,8.584 8.434,8.584 Z M10.099,3.369 C10.981,3.51 11.08,5.06 10.658,5.823 L10.303,5.678 C10.487,5.135 10.484,4.241 9.868,4.184 C9.477,4.148 9.225,4.664 9.171,5.106 C9.018,5.042 8.851,4.996 8.648,4.979 C8.71,4.056 9.306,3.242 10.099,3.369 Z M6.696,3.7 C7.372,3.532 7.771,4.318 7.774,5.135 L7.464,5.325 C7.422,4.982 7.269,4.428 6.885,4.546 C6.474,4.674 6.541,5.629 6.77,5.825 L6.464,5.995 C6.044,5.288 6.045,3.862 6.696,3.7 Z M4.581,22.943 C2.618,22.05 1.951,22.253 1.576,22.253 C0.799,22.253 0.545,21.674 0.837,21.126 C1.085,20.661 1.008,20.174 0.947,19.783 C0.853,19.184 0.836,18.989 1.425,18.731 C2.24,18.385 2.602,17.94 2.872,17.607 C3.63,16.67 4.395,18.144 5.022,19.457 C5.429,20.308 6.23,20.739 6.477,21.682 C6.704,22.553 5.767,23.483 4.581,22.943 Z M11.568,21.069 C10.184,21.742 8.421,22.051 7.102,21.368 C6.907,20.805 6.595,20.441 6.259,20.075 C6.798,19.933 7.198,19.261 6.719,18.586 C6.208,17.865 5.164,17.362 4.109,16.546 C3.122,15.783 2.81,13.902 4.154,11.8 C3.499,13.662 3.882,15.378 4.211,15.869 C4.279,14.881 4.357,13.231 5.707,11.254 C6.388,10.256 6.398,8.938 6.413,8.114 L7.033,8.538 C7.489,8.875 7.871,9.246 8.419,9.246 C9.229,9.246 9.677,8.78 10.301,8.393 C10.545,8.243 10.914,8.091 11.224,7.88 C11.744,10.356 13.898,13.334 14.019,15.03 C14.52,13.998 13.877,11.516 13.877,11.516 C14.719,12.801 14.786,13.872 14.823,15.186 C15.412,15.427 16.044,16.055 16.102,16.882 L15.857,16.854 C15.731,15.935 13.25,14.585 13.027,16.315 C11.837,16.496 12.27,18.381 12.03,19.603 C11.92,20.162 11.716,20.604 11.568,21.069 Z M16.414,21.028 C15.429,21.408 14.764,22.215 14.307,22.716 C13.427,23.682 12.263,23.219 12.139,22.315 C12.008,21.349 12.499,20.822 12.711,19.741 C12.904,18.754 12.688,17.235 13.142,17.073 C13.437,18.826 15.208,18.089 15.612,17.611 C16.269,17.611 16.324,17.833 16.471,18.448 C16.563,18.833 16.69,19.157 17.049,19.538 C17.467,19.985 17.339,20.671 16.414,21.028 Z M8.414,8.022 C7.763,8.022 7.276,7.589 6.88,7.253 C6.677,7.082 6.93,6.766 7.133,6.938 C7.52,7.266 7.91,7.613 8.414,7.613 C9.021,7.613 9.556,7.094 10.281,6.808 C10.528,6.711 10.669,7.093 10.424,7.19 C9.72,7.467 9.155,8.022 8.414,8.022 Z" id="Shape"></path>
                                </g>
                            </g>
                            </svg>
                        <strong>Download Winds from the Snapcraft store</strong>
                    </a>
                `;
            } else if (os.indexOf('Windows') != -1 || os.indexOf('Win64') != -1) {
                el.innerHTML = `
                    <a href="https://s3.amazonaws.com/winds-2.0-releases/releases/Winds%20Setup%20${version}.exe" title="Windows" id="download">
                        <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                            <defs></defs>
                            <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g id="iconmonstr-windows-os-1" fill="#ffffff" fill-rule="nonzero">
                                    <path d="M0,12 L0,3.354 L10,1.999 L10,12 L0,12 Z M11,12 L24,12 L24,0 L11,1.807 L11,12 Z M10,13 L0,13 L0,20.646 L10,22.001 L10,13 Z M11,13 L11,22.194 L24,24 L24,13 L11,13 Z" id="Shape"></path>
                                </g>
                            </g>
                        </svg>
                        <strong>Download the Winds installer for Windows</strong>
                    </a>
                `;
            } else {
                document.getElementById('cta').outerHTML = '';
                document.getElementById('other-downloads').outerHTML = '';
            }
        </script>
    </body>
</html>
