/************************************************************************
 *                                                                      *
 * PCI Compliance Workgroup Confidential                                *
 *                                                                      *
 * This code is intended for the exclusive use of the PCI Compliance    *
 * Workgroup.  Redistribution of this code is not permitted.            *
 *                                                                      *
 ************************************************************************/

/*
 * pcibios.h
 */

/*
 * Supported Functions
 */
#define PCI_FUNCTION_ID         0xb1
#define PCI_BIOS_PRESENT        0x01
#define FIND_PCI_DEVICE         0x02
#define FIND_PCI_CLASS_CODE     0x03
#define GENERATE_SPECIAL_CYC    0x06
#define READ_CONFIG_BYTE        0x08
#define READ_CONFIG_WORD        0x09
#define READ_CONFIG_DWORD       0x0a
#define WRITE_CONFIG_BYTE       0x0b
#define WRITE_CONFIG_WORD       0x0c
#define WRITE_CONFIG_DWORD      0x0d

/*
 * Supported Return Codes
 */
#define SUCCESSFUL              0x00
#define FUNC_NOT_SUPPORTED      0x81
#define BAD_VENDOR_ID           0x83
#define DEVICE_NOT_FOUND        0x86
#define BAD_REGISTER_NUMBER     0x87

/*
 * Modes Of Operation
 */
#define REALMODE                0
#define PROT16MODE              2
#define PROT32MODE              1

/*
 * Bit Definitions For Register Consistency Checking
 *
 * Note that certain registers imply that other registers are consistent.  For
 * example, consistency of ax implies consistency of ah and al.  These
 * definitions reflect this.
 */
#define AH_M    0x80000000
#define AL_M    0x40000000
#define BH_M    0x20000000
#define BL_M    0x10000000
#define CH_M    0x08000000
#define CL_M    0x04000000
#define DH_M    0x02000000
#define DL_M    0x01000000

#define AX_M    ( AH_M | AL_M )
#define BX_M    ( BH_M | BL_M )
#define CX_M    ( CH_M | CL_M )
#define DX_M    ( DH_M | DL_M )
#define SI_M    0x00800000
#define DI_M    0x00400000

#define EAX_M   ( 0x00200000 | AX_M )
#define EBX_M   ( 0x00100000 | BX_M )
#define ECX_M   ( 0x00080000 | CX_M )
#define EDX_M   ( 0x00040000 | DX_M )
#define ESI_M   ( 0x00020000 | SI_M )
#define EDI_M   ( 0x00010000 | DI_M )

/*
 * Isolation Masks For Register Consistency Checking
 */
#define HBYTE_M 0xffff00ff
#define LBYTE_M 0xffffff00
#define LWORD_M 0xffff0000
#define HWORD_M 0x0000ffff

/*
 * Description Of Which Registers Can Be Change For Each Supported Function
 */
#define PCI_BIOS_PRESENT_M      AX_M | BX_M | CL_M | EDX_M
#define FIND_PCI_DEVICE_M       AH_M | BX_M
#define FIND_PCI_CLASS_CODE_M   AH_M | BX_M
#define GENERATE_SPECIAL_CYC_M  AH_M
#define READ_CONFIG_BYTE_M      AH_M | CL_M
#define READ_CONFIG_WORD_M      AH_M | CX_M
#define READ_CONFIG_DWORD_M     AH_M | ECX_M
#define WRITE_CONFIG_BYTE_M     AH_M
#define WRITE_CONFIG_WORD_M     AH_M
#define WRITE_CONFIG_DWORD_M    AH_M

