/****************************************************************
 *                                                              *
 * Copyright (C) 1995 Macronix International corp.              *
 * Hardware related equates.                                    *
 *                                                              *
 * Revision History:                                            *
 * Date     Who                   Comments                      *
 * 12/01/94 Luke Huang                                          *
 *                                                              *
 ****************************************************************/

#define  PCIBIOS           0x1a
#define  KEYBOARD          0x16
#define  VIDEO             0x10
#define  DWORD             0x08
#define  WORD              0x04
#define  BYTE              0x02
#define  FORWARD           0x01
#define  BACKWARD          0x00
#define  FAIL              (unsigned int)0xcdef
#define  PASS              (unsigned int)0x90ab
#define  YES               (unsigned int)0xcdef
#define  NO                (unsigned int)0x90ab
#define  UP                0x01
#define  DOWN              0x00
#define  TEST              0x12
#define  DEBUG             0x34
#define  VARIABLE			(unsigned char)0xab
#define  AT_N				(unsigned char)0x07
#define  AT_F              (unsigned char)0x87
#define  AT_E              (unsigned char)0x0f
#define  AT_R              (unsigned char)0x70
#define  AT_FE             (unsigned char)0x8f
#define  AT_FR             (unsigned char)0xf0
#define  AT_ER             (unsigned char)0x78
#define  AT_FER            (unsigned char)0xf8

#define  ATC_N             (unsigned char)0x17
#define  ATC_R             (unsigned char)0x47
#define  ATC_YE				(unsigned char)0x0e
#define  ATC_GE				(unsigned char)0x0a
#define  ATC_GEB			(unsigned char)0x1a
#define  ATC_WE            (unsigned char)0x0f
#define  ATC_YEB           (unsigned char)0x1e
#define  ATC_YER           (unsigned char)0x4e
#define  ATC_BEB           (unsigned char)0x1b
#define  ATC_BEBR          (unsigned char)0x4b
#define  ATC_YEBF          (unsigned char)0x9e
#define  ATC_REF           (unsigned char)0x8c
#define  EOI               0x20
#define  PIC_1             0x20
#define  PIC_2             0xa0
#define  PCAT              ((unsigned char far *) (0xf000fffeL))
#define  MONO_VIDEO_BASE   ((unsigned char far *) (0xB0000000L))
#define  CO80_VIDEO_BASE   ((unsigned char far *) (0xB8000000L))
#define  VIDEO_MODE        ((unsigned char far *) (0x00400049L))

#define  CSR0              0x00
#define  CSR1              0x08
#define  CSR2              0x10
#define  CSR3              0x18
#define  CSR4              0x20
#define  CSR5              0x28
#define  CSR6              0x30
#define  CSR7              0x38
#define  CSR8              0x40
#define  CSR9              0x48
#define  CSR10             0x50
#define  CSR11             0x58
#define  CSR12             0x60
#define  CSR13             0x68
#define  CSR14             0x70
#define  CSR15             0x78
#define  CSR16             0x80
#define  CSR17             0x88
#define  CSR18             0x90
#define  CSR19             0x98
#define  CSR20             0xa0
#define  CSR21             0xa8

#define  CSR0_L_SWR        (unsigned long)0x01
#define  CSR0_DSL_1        (unsigned long)0x04
#define  CSR0_DSL_2        (unsigned long)0x08
#define  CSR0_DSL_4        (unsigned long)0x10
#define  CSR0_DSL_8        (unsigned long)0x20
#define  CSR0_DSL_16       (unsigned long)0x40
#define  CSR0_BAR          (unsigned long)0x02
#define  CSR0_BLE          (unsigned long)0x080
#define  CSR0_DAS          (unsigned long)0x010000
#define  CSR0_CAL_8        (unsigned long)0x4000
#define  CSR0_TAP_200      (unsigned long)0x20000
#define  CSR0_TAP_800      (unsigned long)0x40000
#define  CSR0_TAP_16       (unsigned long)0x60000

#define  CSR5_TI           (unsigned long)0x01
#define  CSR5_TPS          (unsigned long)0x02
#define  CSR5_TU           (unsigned long)0x04
#define  CSR5_TJT          (unsigned long)0x08
#define  CSR5_UNF          (unsigned long)0x020
#define  CSR5_RI           (unsigned long)0x040
#define  CSR5_RU           (unsigned long)0x080
#define  CSR5_RPS          (unsigned long)0x0100
#define  CSR5_RWT          (unsigned long)0x0200
#define  CSR5_AT           (unsigned long)0x0400
#define  CSR5_GTE          (unsigned long)0x0800
#define  CSR5_LNF          (unsigned long)0x01000
#define  CSR5_FBE          (unsigned long)0x02000
#define  CSR5_AIS          (unsigned long)0x08000
#define  CSR5_NIS          (unsigned long)0x010000
#define  CSR5_RS           (unsigned long)0x0E0000
#define  CSR5_TS           (unsigned long)0x0700000
#define  CSR5_EB           (unsigned long)0x03800000
#define  CSR5_TS_SUSP      (unsigned long)0x0600000
#define  CSR5_TS_RUN_FETCH_DESC         (unsigned long)0x0100000
#define  CSR5_TS_RUN_WAIT_END_OF_TX     (unsigned long)0x0200000
#define  CSR5_TS_RUN_READIND_BUFFER     (unsigned long)0x0300000
#define  CSR5_EB_PARITY_ABORT           (unsigned long)0x000000
#define  CSR5_EB_MASTER_ABORT           (unsigned long)0x800000
#define  CSR5_EB_TARGET_ABORT           (unsigned long)0x1000000
#define  CSR5_RS_SUSP      (unsigned long)0x080000
#define  CSR5_RS_RUN       (unsigned long)0x060000
#define  CSR5_MB1          (unsigned long)0xfc000000
#define  CSR5_DONTCARE     (unsigned long)0xfc005410

#define  TX_THRESHOLD_72   (unsigned long)0x0
#define  TX_THRESHOLD_96   (unsigned long)0x1
#define  TX_THRESHOLD_128  (unsigned long)0x2
#define  TX_THRESHOLD_160  (unsigned long)0x3
#define  TX_THRESHOLD_DEF  TX_THRESHOLD_160
#define  CSR6_HP           (unsigned long)0x1
#define  CSR6_SR           (unsigned long)0x2
#define  CSR6_HO           (unsigned long)0x4
#define  CSR6_PB           (unsigned long)0x8
#define  CSR6_IF           (unsigned long)0x10
#define  CSR6_SB           (unsigned long)0x20
#define  CSR6_PR           (unsigned long)0x40
#define  CSR6_PM           (unsigned long)0x80
#define  CSR6_FKD          (unsigned long)0x100
#define  CSR6_FD           (unsigned long)0x200
#define  CSR6_OM_INT       (unsigned long)0x400
#define  CSR6_OM_EXT       (unsigned long)0x800
#define  CSR6_FC           (unsigned long)0x1000
#define  CSR6_ST           (unsigned long)0x2000
#define  CSR6_TR0          (unsigned long)0x4000
#define  CSR6_TR1          (unsigned long)0x8000
#define  CSR6_CA           (unsigned long)0x20000
#define  CSR6_PS           (unsigned long)0x40000
#define  CSR6_HBD          (unsigned long)0x80000
#define  CSR6_IMM          (unsigned long)0x100000
#define  CSR6_SF           (unsigned long)0x200000
#define  CSR6_TTM          (unsigned long)0x400000
#define  CSR6_PCS          (unsigned long)0x800000
#define  CSR6_SCR          (unsigned long)0x1000000
#define  CSR6_TM0          (unsigned long)0x2000000
#define  CSR6_TM1          (unsigned long)0x4000000
#define  CSR6_TM2          (unsigned long)0x8000000
#define  CSR6_TM3          (unsigned long)0x10000000

#define  CSR7_NI           (unsigned long)0x10000
#define  CSR7_AI           (unsigned long)0x8000
#define  CSR7_SE           (unsigned long)0x2000
#define  CSR7_RI           (unsigned long)0x40
#define  CSR7_UN           (unsigned long)0x20
#define  CSR7_TJ           (unsigned long)0x8
#define  CSR7_TU           (unsigned long)0x4
#define  CSR7_TI           (unsigned long)0x1
#define  CSR7_LF           (unsigned long)0x1000
#define  CSR7_GPT          (unsigned long)0x800
#define  CSR7_AT           (unsigned long)0x400
#define  CSR7_RW           (unsigned long)0x200
#define  CSR7_RS           (unsigned long)0x100
#define  CSR7_RU           (unsigned long)0x80
#define  CSR7_TS           (unsigned long)0x2
#define  CSR7_No mal_Int_mask       CSR7_NIM+CSR7_RIM+CSR7_TIM+CSR7_TUM
#define  CSR7_Abnormal_Int_mask     CSR7_AIM+CSR7_SEM+CSR7_TJM+CSR7_UNM
#define  CSR7_INTERRUPTS_MASK_VAL   CSR7_Normal_Int_mask+CSR7_Abnormal_Int_mask

#define  CSR9_MDI         (unsigned long)0x080000
#define  CSR9_MMD         (unsigned long)0x040000
#define  CSR9_MDO         (unsigned long)0x020000
#define  CSR9_MDC         (unsigned long)0x010000
#define  CSR9_SRO         (unsigned long)0x04000

#define  CSR14_T4          (unsigned long)0x40000
#define  CSR14_TXF         (unsigned long)0x20000
#define  CSR14_TXH         (unsigned long)0x10000
#define  CSR14_LTE         (unsigned long)0x1000
#define  CSR14_RQS         (unsigned long)0x100
#define  CSR14_ANE         (unsigned long)0x80
#define  CSR14_HDE         (unsigned long)0x40
#define  CSR14_DREN        (unsigned long)0x4
#define  CSR14_LBK         (unsigned long)0x2

#define  CSR15_JBD         (unsigned long)0x01
#define  CSR15_HUJ         (unsigned long)0x02
#define  CSR15_JCK         (unsigned long)0x04
#define  CSR15_RWD         (unsigned long)0x10
#define  CSR15_RWR         (unsigned long)0x20

#define  CAL_0             (unsigned long)0
#define  CAL_1             (unsigned long)1
#define  CAL_2             (unsigned long)2
#define  CAL_3             (unsigned long)3
#define  DEF_CAL           CAL_2
#define  MIN_CAL           CAL_1
#define  MAX_CAL           CAL_3

#define  UNDEF_USER_PBL    (unsigned long)0xFh
#define  PBL_0             (unsigned long)0
#define  PBL_1             (unsigned long)1
#define  PBL_2             (unsigned long)2
#define  PBL_4             (unsigned long)4
#define  PBL_8             (unsigned long)8
#define  PBL_16            (unsigned long)16
#define  PBL_32            (unsigned long)32
#define  DEF_PBL           PBL_16
#define  MIN_PBL           PBL_0
#define  MAX_PBL           PBL_16

#define  MIN_NUM_TX_DESC   2
#define  DEF_NUM_TX_DESC   4
#define  MAX_NUM_TX_DESC   4
#define  MIN_NUM_RX_DESC   2
#define  DEF_NUM_RX_DESC   4
#define  MAX_NUM_RX_DESC   4

#define  RDES0_OF                     (unsigned int)0x1
#define  RDES0_CE                     (unsigned int)0x2
#define  RDES0_DB                     (unsigned int)0x4
#define  RDES0_RW                     (unsigned int)0x10
#define  RDES0_FT                     (unsigned int)0x20
#define  RDES0_CS                     (unsigned int)0x40
#define  RDES0_TL                     (unsigned int)0x80
#define  RDES0_LS                     (unsigned int)0x100
#define  RDES0_FS                     (unsigned int)0x200
#define  RDES0_MF                     (unsigned int)0x400
#define  RDES0_RF                     (unsigned int)0x800
#define  RDES0_DT0                    (unsigned int)0x1000
#define  RDES0_DT1                    (unsigned int)0x2000
#define  RDES0_DE                     (unsigned int)0x4000
#define  RDES0_ES                     (unsigned int)0x8000

#define  RDES0_DATA_TYPE_MASK         (unsigned int)0x3000
#define  RDES0_DATA_TYPE_POS          (unsigned int)0xC
#define  RDES0_OWN_BIT                (unsigned int)0x8000
#define  RDES0_ER0  RDES0_ES + RDES0_DE
#define  RDES0_ER1  RDES0_RF + RDES0_TL
#define  RDES0_ER2  RDES0_CS + RDES0_RW + RDES0_OF
#define  RDES0_NP   RDES0_DB + RDES0_CE
#define  RDES0_NON_PROMISCUOUS_VALUE  RDES0_ER0 + RDES0_ER1 + RDES0_ER2 + RDES0_NP
#define  RDES0_PROMISCUOUS_VALUE      RDES0_ER0 + RDES0_ER1 + RDES0_ER2

#define  RDES0_RCVWATCHDOG_MASK       (unsigned int)0xd1ba

#define  RDES1_RCH_BIT                0x01000000
#define  RDES1_RER_BIT                0x02000000
#define  RDES1_BUFF                   RX_BUFFER_SIZE + RDES1_RCH_BIT
#define  RDES1_BUFF_LAST              RX_BUFFER_SIZE + RDES1_RER_BIT

#define  TDES0_DE                     (unsigned int)0x01
#define  TDES0_UF                     (unsigned int)0x02
#define  TDES0_CC_MASK                (unsigned int)0x078
#define  TDES0_HF                     (unsigned int)0x080
#define  TDES0_EC                     (unsigned int)0x0100
#define  TDES0_LC                     (unsigned int)0x0200
#define  TDES0_NC                     (unsigned int)0x0400
#define  TDES0_LO                     (unsigned int)0x0800
#define  TDES0_TO                     (unsigned int)0x4000
#define  TDES0_ES                     (unsigned int)0x8000
#define  TDES0_OWN_BIT                (unsigned char)0x80

#define  TDES0_JABBER_MASK            (unsigned int)0xf000
#define  TDES0_UNF_MASK               (unsigned int)0xb002
#define  TDES0_INTLBK100_MASK         (unsigned int)0xbc00
#define  TDES0_INTLBK10_MASK          (unsigned int)0xbc80
#define  TDES0_FORCECOLLISION_MASK    (unsigned int)0xb178
#define  TDES0_DEFFERRED_MASK         (unsigned int)0x3001


#define  TDES1_IC_BIT                 (unsigned long)0x80000000
#define  TDES1_LS_BIT                 (unsigned long)0x40000000
#define  TDES1_FS_BIT                 (unsigned long)0x20000000
#define  TDES1_SET_BIT                (unsigned long)0x08000000
#define  TDES1_AC_BIT                 (unsigned long)0x04000000
#define  TDES1_TER_BIT                (unsigned long)0x02000000
#define  TDES1_TCH_BIT                (unsigned long)0x01000000
#define  TDES1_DPD_BIT                (unsigned long)0x800000
#define  TDES1_HP_BIT                 (unsigned long)0x400000
#define  TDES1_FT0_BIT                (unsigned long)0x400000
#define  TDES1_FT1_BIT                (unsigned long)0x10000000
#define  TDES1_DEFAULT                TDES1_TCH_BIT
#define  TDES1_BUFF                   TDES1_DPD_BIT+TDES1_FS_BIT+TDES1_LS_BIT+TDES1_IC_BIT+TDES1_TCH_BIT
#define  TDES1_BUFF_FS                TDES1_DPD_BIT+TDES1_FS_BIT+TDES1_IC_BIT+TDES1_TCH_BIT
#define  TDES1_BUFF_LS                TDES1_DPD_BIT+TDES1_LS_BIT+TDES1_IC_BIT+TDES1_TCH_BIT
#define  TDES1_BUFF_MI                TDES1_DPD_BIT+TDES1_IC_BIT+TDES1_TCH_BIT
#define  TDES1_BUFF_LAST              TDES1_BUFF + TDES1_TER_BIT

#define  TDES1_SETUP                  (TDES1_IC_BIT + TDES1_TCH_BIT + TDES1_SET_BIT) + 192
#define  TDES1_SETUP_LAST             TDES1_SETUP + TDES1_TER_BIT
#define  TDES1_SETUP_HASH             TDES1_SETUP + TDES1_FT0_BIT
#define  TDES1_SETUP_HASH_LAST        TDES1_SETUP_HASH + TDES1_TER_BIT
#define  TDES1_SETUP_INVERSE          TDES1_SETUP + TDES1_FT1_BIT
#define  TDES1_SETUP_INVERSE_LAST     TDES1_SETUP_INVERSE + TDES1_TER_BIT
#define  TDES1_SETUP_HASHONLY         TDES1_SETUP + TDES1_FT1_BIT + TDES1_FT0_BIT
#define  TDES1_SETUP_HASHONLY_LAST    TDES1_SETUP_HASHONLY + TDES1_TER_BIT


#define NumTXBuffers       6
#define NumRXBuffers       6
#define RX_BUFFER_SIZE     0x600
#define TX_BUFFER_SIZE     0x600
#define TX_PROCESS         0x01
#define RX_PROCESS         0x00
#define RING               0xef
#define CHAIN              0x00
#define TEST_PKT_SIZE      0x401
unsigned char M_code;
unsigned char A_code;
unsigned char Attr_N;
unsigned char Attr_R;
unsigned char Attr_Y;
unsigned char Attr_YE;
unsigned char Attr_GE;
unsigned char Attr_GEB;
unsigned char Attr_WE;
unsigned char Attr_YEB;
unsigned char Attr_YER;
unsigned char Attr_BEB;
unsigned char Attr_BEBR;
unsigned char Attr_YEBF;
unsigned char Attr_REF;
unsigned char Attr_WEB;


struct PCI_register
        {
        unsigned int offset;
        unsigned long value;
        unsigned int row;
        unsigned int col;
        unsigned int IOtype;
        };

struct TX_RESOURCE
        {
        unsigned int  tstatus;
        unsigned char tdes0_unused;
        unsigned char ownership;
        unsigned long command;
        unsigned long buff_1_addr;
        unsigned long buff_2_addr;
        unsigned char tx_buffer_data[TX_BUFFER_SIZE];
        };

struct RX_RESOURCE
        {
        unsigned int  rstatus;
        unsigned int  frame_length;
        unsigned long command;
        unsigned long buff_1_addr;
        unsigned long buff_2_addr;
        unsigned char rx_buffer_data[RX_BUFFER_SIZE];
        };

typedef struct _PCI_CFG_ADDRESS {

	unsigned Register : 8;
	unsigned Function : 3;
	unsigned Device   : 5;
	unsigned BusNumber: 8;
	unsigned Reserved : 7;
	unsigned Enable :   1;

}	MXNIC_PCI_CFG_ADDR, *PMXNIC_PCI_CFG_ADDR;


// PCI constants

#define PCI_CONFIG_LOWER_BOUND  0xC000
#define PCI_CONFIG_UPPER_BOUND  0xCF00
#define PCI_CONFIG_OFFSET       0x100

#define PCI_CSE_REG				0x0CF8
#define PCI_CONFIG_ADDRESS		0x0CF8
#define PCI_CONFIG_DATA			0x0CFC
#define ENABLE_PCI_CONFIG		0x10
#define DISABLE_PCI_CONFIG		0x00
