  
/****************************************************************
 *
 * Copyright (C) 1995 Macronix International Corp.
 * MX0513 Diagnose and Test program.
 * pci.c + bmtx.c + mxdiag.c + dwio.asm
 *
 * Revision History:
 * Date     Who                   Comments
 * 07/25/95 Luke Huang
 ******************************************************************/

#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include "pcibios.h"
#include "pci.h"
#define  item_number 20

union    REGS regs;

struct PCI_register   PCI00  ={0x00,0x00, 4,24,DWORD};
struct PCI_register   PCI04  ={0x04,0x00, 5,24,DWORD};
struct PCI_register   PCI08  ={0x08,0x00, 6,24,DWORD};
struct PCI_register   PCI0c  ={0x0c,0x00, 7,24,DWORD};
struct PCI_register   PCI10  ={0x10,0x00, 8,24,DWORD};
struct PCI_register   PCI14  ={0x14,0x00, 9,24,DWORD};
struct PCI_register   PCI18  ={0x18,0x00,10,24,DWORD};
struct PCI_register   PCI1c  ={0x1c,0x00,11,24,DWORD};
struct PCI_register   PCI20  ={0x20,0x00,12,24,DWORD};
struct PCI_register   PCI24  ={0x24,0x00,13,24,DWORD};
struct PCI_register   PCI28  ={0x28,0x00,14,24,DWORD};
struct PCI_register   PCI2c  ={0x2c,0x00,15,24,DWORD};
struct PCI_register   PCI30  ={0x30,0x00,16,24,DWORD};
struct PCI_register   PCI34  ={0x34,0x00,17,24,DWORD};
struct PCI_register   PCI38  ={0x38,0x00,18,24,DWORD};
struct PCI_register   PCI3c  ={0x3c,0x00,19,24,DWORD};
struct PCI_register   PCI40  ={0x40,0x00,20,24,DWORD};
struct PCI_register   PCI44  ={0x44,0x00,21,24,DWORD};
struct PCI_register   PCI48  ={0x48,0x00,22,24,DWORD};
struct PCI_register   PCI4c  ={0x4c,0x00,23,24,DWORD};

struct PCI_register   PCI_item[item_number];
extern long outpdw();
extern long inpdw();

unsigned char far   *video_base;
unsigned int  Vendor_ID=0x01d9;
unsigned int  Device_ID=0x0512;
unsigned int  iobase;
unsigned char far       screen[10][25][80][2];
unsigned char port='Y';
unsigned char screenindex=0;
unsigned int  csr12_io_def,	csr12_io_val;
extern unsigned long  csr0shadow,csr6shadow,csr16shadow,csr14shadow;
extern struct PCI_register csr16;
extern struct PCI_register csr6;
extern struct PCI_register csr1;
extern struct PCI_register csr0;
extern unsigned char far c46[128];
extern unsigned char far sa[8];
extern unsigned char hash[96];
extern unsigned char perfect[96];
extern NIC_write_reg();
extern NIC_matrix_reg_assign();
extern fill_custom_pattern();
extern initialize();
extern unsigned int     intcount;
extern eeprom_process();
extern eeprom_read();
extern eeprom_write();
extern delay10us();
unsigned char		bus_number,dev_number;

/*********************************************************/
main(argc,argv)
/*********************************************************/
int argc;
char *argv[];
{
	FILE *fd10;
	char  item,i,j,index,editmode,zero_flag;
	video_base=VIDEO_MODE;
	if (*video_base == 0x07) {
		video_base=MONO_VIDEO_BASE;
		Attr_N = AT_N;
		Attr_R = AT_R;
		Attr_YE  = AT_E;
		Attr_WE  = AT_E;
		Attr_GE  = AT_E;
		Attr_GEB = AT_E;
		Attr_YEB = AT_E;
		Attr_YER = AT_R;
		Attr_BEB = AT_E;
		Attr_BEBR = AT_R;
		Attr_YEBF = AT_F;
		Attr_REF = AT_F;
	}
	else {
		video_base=CO80_VIDEO_BASE;
		Attr_N   = ATC_N;
		Attr_R   = ATC_R;
		Attr_YE  = ATC_YE;
		Attr_WE  = ATC_WE;
		Attr_GE  = ATC_GE;
		Attr_GEB = ATC_GEB;
		Attr_YEB = ATC_YEB;
		Attr_YER = ATC_YER;
		Attr_BEB = ATC_BEB;
		Attr_BEBR = ATC_BEBR;
		Attr_YEBF = ATC_YEBF;
		Attr_REF = ATC_REF;
	}
	scan_parameters();
	PCI_matrix_reg_assign(FORWARD);
	NIC_matrix_reg_assign(FORWARD);
	cll(0,0,79,24);
	cursor_type('E');
	PCI_Conf_read();
	iobase=PCI10.value & 0xfffe;

	eeprom_read();
	csr0shadow = (CAL_2<<14)|(PBL_32<<8);

	if(( (PCI08.value&0xff)>=0x10 )&&( (PCI00.value&0xffff) ==0x10d9 )) {
		csr16shadow=(unsigned long)0xf3ffec8;
		csr6shadow=(TX_THRESHOLD_DEF<<14)+CSR6_HBD+CSR6_SR+CSR6_ST+CSR6_PCS+CSR6_SCR+CSR6_SF+CSR6_FD;
		port='A';
	}
	else {
		if(c46[0x73]!=0x00) {
			csr16shadow= (unsigned long)0xf37fec8;
		} else {
			csr16shadow=(unsigned long)0xf3ffec8;
		}
		csr6shadow=(TX_THRESHOLD_DEF<<14)+CSR6_HBD+CSR6_PS+CSR6_SR+CSR6_ST+CSR6_PCS+CSR6_SCR+CSR6_SF;
		port='Y';
	}
	csr14shadow =(unsigned long) 0xffffffff;

	if((argc==2)&&(strncmp(argv[1],"eep",3)==0)) { 
		eeprom_auto_programming();
		return(0);
	}

	if((argc==2)&&(strncmp(argv[1],"eepg",4)==0)) { 
		eeprom_write(0x73,0x01);
		return(0);
	}

	if((argc==2)&&(strncmp(argv[1],"100F",4)==0)) { 
		mii_write(0,0,0x2100);
		return(0);
	}
	if((argc==2)&&(strncmp(argv[1],"100H",4)==0)) { 
		mii_write(0,0,0x2000);
		return(0);
	}
	if((argc==2)&&(strncmp(argv[1],"10F",3)==0)) { 
		mii_write(0,0,0x0100);
		return(0);
	}
	if((argc==2)&&(strncmp(argv[1],"10H",3)==0)) { 
		mii_write(0,0,0x00);
		return(0);
	}
	if((argc==2)&&(strncmp(argv[1],"AUTO",3)==0)) { 
		mii_write(0,0,0x8000);
		return(0);
	}
	if(c46[0x70]>=0x1a) {
		prstring("Network ID fail. Press any key to continue!",6,1,Attr_YE);
		getch();
	}
	get_networkID();
	initialize();
	PCI_PanelSetup();
	PCI_PanelUpdate();
	bar_one(8,50,22,Attr_BEBR);
	item=5;
	index=0;
	editmode=1;

	mii_write(0,0,0x2000);
	mii_write(0,0,0x0000);
	mii_write(0,0,0x8000);
	while (editmode)  {
		if (kbhit()) {
			keycode_get();
			if (M_code==0)  {
				switch (A_code)  {
					case 0x40 :                         /*** F6    ***/
						screen_store();
						NIC_read_reg(&csr6);
						NIC_write_reg(&csr6,csr6.value&(~(CSR6_SR|CSR6_ST)));
						fill_custom_pattern();
						NIC_read_reg(&csr6);
						NIC_write_reg(&csr6,csr6.value|(CSR6_SR|CSR6_ST));
						screen_restore();
						break;

					case 0x3f :                         /*** F5    ***/
						screen_store();
						port_select();
						screen_restore();
						switch(port) {							 
							case 'Y': prstring ("Port : SYM       ",16,50, Attr_BEB); break;
							case 'M': prstring ("Port : MII       ",16,50, Attr_BEB); break;
							case 'A': prstring ("Port : AutoSense ",16,50, Attr_BEB); break;
							case 'B': prstring ("Port : 100FD     ",16,50, Attr_BEB); break;
							case 'C': prstring ("Port : 100HD     ",16,50, Attr_BEB); break;
							case 'D': prstring ("Port : 10FD      ",16,50, Attr_BEB); break;
							case 'E': prstring ("Port : 10HD      ",16,50, Attr_BEB); break;
							default : break;
						}
						break;
					case 0x3e :                         /*** F4    ***/
						screen_store();
						PCI_access();
						screen_restore();
						gotoxy(15,60);
						printf("%02x %02x %02x %02x %02x %02x",sa[0],sa[1],sa[2],sa[3],sa[4],sa[5]);
						break;
					case 0x3d :                         /*** F3    ***/
						screen_store();
						eeprom_process();
						screen_restore();
						gotoxy(15,60);
						printf("%02x %02x %02x %02x %02x %02x",sa[0],sa[1],sa[2],sa[3],sa[4],sa[5]);
						break;
					case 0x3c :                         /*** F2    ***/
						screen_store();
						decdiag();
						screen_restore();
						break;
					case 0x3b :                         /*** F1    ***/
						screen_store();
						network_diag();
						screen_restore();
						break;
					case 0x4b :                         /*** Cr LFT ***/
					case 0x48 :                         /*** Cr Up ***/
						bar_one(8+index,50,22,Attr_BEB);
						index--;
						if(index<0) index=item-1;
						bar_one(8+index,50,22,Attr_BEBR);
						break;
					case 0x4d :                         /*** Cr RGT ***/
					case 0x50 :                         /*** Cr Dn ***/
						bar_one(8+index,50,22,Attr_BEB);
						index++;
						if(index>=item) index=0;
						bar_one(8+index,50,22,Attr_BEBR);
						break;
					default   :
						break;
				}
			}
			else {
				switch (M_code)  {
					case 0x0d :                         /*** Enter ***/
						screen_store();
						switch (index)  {
							case 0 :
								network_diag();
								break;
							case 1 :
								decdiag();
								break;
							case 2 :
								eeprom_process();
								break;
							case 3 :
								PCI_access();
								break;
							case 4 :
								port_select();
								break;
							default: break;
			 			} // end of switch (index)
						screen_restore();
						gotoxy(15,60);
						printf("%02x %02x %02x %02x %02x %02x ",sa[0],sa[1],sa[2],sa[3],sa[4],sa[5]);
						switch(port) {
							case 'Y': prstring ("Port : SYM       ",16,50, Attr_BEB); break;
							case 'M': prstring ("Port : MII       ",16,50, Attr_BEB); break;
							case 'A': prstring ("Port : AutoSense ",16,50, Attr_BEB); break;
							case 'B': prstring ("Port : 100FD     ",16,50, Attr_BEB); break;
							case 'C': prstring ("Port : 100HD     ",16,50, Attr_BEB); break;
							case 'D': prstring ("Port : 10FD      ",16,50, Attr_BEB); break;
							case 'E': prstring ("Port : 10HD      ",16,50, Attr_BEB); break;
							default : break;
						}
						break;
					case 0x1b :                         /*** ESC   ***/
						editmode=0;
						break;
					default   :
						break;
			   	}
			} 
		} 
	} 
	NIC_write_reg(&csr6,(unsigned long)0x00);
	NIC_write_reg(&csr0,CSR0_L_SWR);
	cll(0,0,79,24);
	cursor_type('N');
}


get_networkID()
{	
	char  i,j,zero_flag;
	if((PCI00.value&0xffff)==0x10d9) {
		for(i=0;i<6;i++) sa[i]=c46[c46[0x70]+i];  
	} else {
		zero_flag=0;
		for(i=0;i<18;i++) 	zero_flag |= c46[i];
		if(zero_flag==0x00){
			for(i=0;i<6;i++) sa[i]=c46[20+i];	// new version eeprom format
			csr12_io_def=c46[c46[0x1b]+2]+0x100;
			for(j=0;j<c46[c46[0x1b]+3];j++)
				if(c46[(j+1)*4+c46[0x1b]]==0x05){   // SYM_FULL_DUP
					csr12_io_val=c46[(j+1)*4+c46[0x1b]+1];
					j=c46[c46[0x1b]+3];
				}
		} else{
			for(i=0;i<8;i++) sa[i]=c46[i];		// old version eeprom format
			csr12_io_def=0x11f;
			csr12_io_val=0x0b;
		}
	}
}

port_select()
{
	char  index=0,zero_flag;
	char  item,j;
	unsigned char  editmode;
	unsigned long  csr6base,csr14base;
	if(((PCI08.value&0xff) >= 0x10)&&((PCI00.value&0xffff)==0x10d9)) 
		item=5;
	else
		item=2;

	editmode=1;

	if(((PCI08.value&0xff) >= 0x10)&&((PCI00.value&0xffff)==0x10d9)) {
		prstring ("Ŀ", 8 , 30, Attr_BEB);
		prstring (" PORT  SELECT  ", 9 , 30, Attr_BEB);
		prstring ("Ĵ",10 , 30, Attr_BEB);
		prstring (" AutoSense     ",11 , 30, Attr_BEB);
		prstring (" 100 Full_Dup  ",12 , 30, Attr_BEB);
		prstring (" 100 Half_Dup  ",13 , 30, Attr_BEB);
		prstring (" 10  Full_Dup  ",14 , 30, Attr_BEB);
		prstring (" 10  Half_Dup  ",15 , 30, Attr_BEB);
		prstring ("",16 , 30, Attr_BEB);

    } else {
		prstring ("Ŀ", 8 , 30, Attr_BEB);
		prstring (" PORT  SELECT  ", 9 , 30, Attr_BEB);
		prstring ("Ĵ",10 , 30, Attr_BEB);
		prstring (" SYMBOL PORT   ",11 , 30, Attr_BEB);
		prstring (" MII    PORT   ",12 , 30, Attr_BEB);
		prstring ("",13 , 30, Attr_BEB);
	}
	
	bar_one(11+index,31,15,Attr_BEBR);
	while(editmode){
		if(kbhit()){
			keycode_get();
			if(M_code==0){
				switch (A_code){
					case 0x4b :                         /*** Cr LFT ***/
					case 0x48 :                         /*** Cr Up ***/
						bar_one(11+index,31,15,Attr_BEB);
						index--;
						if(index<0) index=item-1;
						bar_one(11+index,31,15,Attr_BEBR);
						break;
					case 0x4d :                         /*** Cr RGT ***/
					case 0x50 :                         /*** Cr Dn ***/
						bar_one(11+index,31,15,Attr_BEB);
						index++;
						if(index>=item) index=0;
						bar_one(11+index,31,15,Attr_BEBR);
						break;
					default   :
						break;
				}
			}
			else {
				if(((PCI08.value&0xff) >= 0x10)&&((PCI00.value&0xffff)==0x10d9)) {
					csr6base=(TX_THRESHOLD_DEF<<14)+CSR6_HBD+CSR6_SR+CSR6_ST+CSR6_SCR+CSR6_PCS+CSR6_SF;
					csr14base=(unsigned long)0xffffffff;
					switch (M_code)  {
						case 0x0d :                         /*** Enter ***/
							switch (index)  {
								case 0 :	// auto-sense
									port='A';
									csr6shadow=csr6base+CSR6_FD;
									csr14shadow = csr14base;
									initialize();
									break;
								case 1 :   // 100F
									port='B';
									csr6shadow=csr6base+CSR6_PS+CSR6_FD;
									csr14shadow = csr14base&(~CSR14_ANE);
									initialize();
									break;
								case 2 :   // 100H
									port='C';
									csr6shadow=csr6base+CSR6_PS;
									csr14shadow = csr14base&(~CSR14_ANE);
									initialize();
									break;
								case 3 :   // 10F
									port='D';
									csr6shadow=csr6base+CSR6_FD;
									csr14shadow = csr14base&(~CSR14_ANE);
									initialize();
									break;
								case 4 :   // 10H
									port='E';
									csr6shadow=csr6base;
									csr14shadow = csr14base&(~CSR14_ANE);
									initialize();
									break;
								default: break;
							}
						case 0x1b :                         /*** ESC   ***/
							editmode=0;
							break;
						default   :
							break;
					}
				} else {
					switch (M_code)  {
						case 0x0d :                         /*** Enter ***/
							switch (index)  {
								case 0 :
									port='Y';
									csr6shadow=(TX_THRESHOLD_DEF<<14)+CSR6_HBD+CSR6_PS+CSR6_SR+CSR6_ST+CSR6_PCS+CSR6_SCR;
									zero_flag=0;
									for(j=0;j<18;j++) 	zero_flag |= c46[j];
									if((zero_flag==0x00)&&(c46[18]==0x01)&&(c46[19]==0x01)){
										for(j=0;j<c46[c46[0x1b]+3];j++)
											if(c46[(j+1)*4+c46[0x1b]]==0x05){   // SYM_FULL_DUP
												csr12_io_val=c46[(j+1)*4+c46[0x1b]+1];
												j=c46[c46[0x1b]+3];
											}
									}
									initialize();
									break;
								case 1 :
									port='M';
									csr6shadow=(TX_THRESHOLD_DEF<<14)+CSR6_HBD+CSR6_PS+CSR6_SR+CSR6_ST;
									initialize();
									break;
								default: break;
							}
						case 0x1b :                         /*** ESC   ***/
							editmode=0;
							break;
						default   :
							break;
					}
				}
			}
		}
	}
}

/******************************************************************
 Assume the PCI_item[n] to be the Registers
******************************************************************/
PCI_matrix_reg_assign(unsigned char direction)
{
	if(direction==FORWARD) {
		PCI_item[0]  = PCI00   ;    PCI_item[11] = PCI2c  ;
		PCI_item[1]  = PCI04   ;    PCI_item[12] = PCI30  ;
		PCI_item[2]  = PCI08   ;    PCI_item[13] = PCI34  ;
		PCI_item[3]  = PCI0c   ;    PCI_item[14] = PCI38  ;
		PCI_item[4]  = PCI10   ;    PCI_item[15] = PCI3c  ;
		PCI_item[5]  = PCI14   ;    PCI_item[16] = PCI40  ;
		PCI_item[6]  = PCI18   ;    PCI_item[17] = PCI44  ;
		PCI_item[7]  = PCI1c   ;    PCI_item[18] = PCI48  ;
		PCI_item[8]  = PCI20   ;    PCI_item[19] = PCI4c  ;
		PCI_item[9]  = PCI24   ;    
		PCI_item[10] = PCI28   ;    
	}					   			
	else {
		PCI00 = PCI_item[0]     ;   PCI2c = PCI_item[11]    ;
		PCI04 = PCI_item[1]     ;   PCI30 = PCI_item[12]    ;
		PCI08 = PCI_item[2]     ;   PCI34 = PCI_item[13]    ;
		PCI0c = PCI_item[3]     ;   PCI38 = PCI_item[14]    ;
		PCI10 = PCI_item[4]     ;   PCI3c = PCI_item[15]    ;
		PCI14 = PCI_item[5]     ;   PCI40 = PCI_item[16]    ;
		PCI18 = PCI_item[6]     ;   PCI44 = PCI_item[17]    ;
		PCI1c = PCI_item[7]     ;   PCI48 = PCI_item[18]    ;
		PCI20 = PCI_item[8]     ;   PCI4c = PCI_item[19]    ;
		PCI24 = PCI_item[9]     ;   
		PCI28 = PCI_item[10]    ;   
	}

}
/******************************************************************
 Check the exist of PCI device and read offset 00--3F
******************************************************************/
PCI_Conf_read()
{
	unsigned char i;
	unsigned int  j,k;
	if(PCI_dev_detect_designate(&bus_number,&dev_number)) {
		Read_reg(&PCI_item[1] ,bus_number,dev_number);
		Write_reg(&PCI_item[1] ,bus_number,dev_number,PCI_item[1].value&0xffffff87);
		for(i=0;i<item_number;i++)
			Read_reg(&PCI_item[i] ,bus_number,dev_number);
		PCI_matrix_reg_assign(BACKWARD);
		return(0);
	} 
	if(PCI_dev_detect_mxic(&bus_number,&dev_number)) {
		Read_reg(&PCI_item[1] ,bus_number,dev_number);
		Write_reg(&PCI_item[1] ,bus_number,dev_number,PCI_item[1].value&0xffffff87);
		for(i=0;i<item_number;i++)
			Read_reg(&PCI_item[i] ,bus_number,dev_number);
		PCI_matrix_reg_assign(BACKWARD);
		return(0);
	} 
	if(PCI_dev_detect_dec(&bus_number,&dev_number)) {
		Read_reg(&PCI_item[1] ,bus_number,dev_number);
		Write_reg(&PCI_item[1] ,bus_number,dev_number,PCI_item[1].value&0xffffff87);
		for(i=0;i<item_number;i++)
			Read_reg(&PCI_item[i] ,bus_number,dev_number);
		PCI_matrix_reg_assign(BACKWARD);
		return(0);
	}
	prstring("Device not found!! ",6,0,Attr_R);
	prstring("Device on the board :",7,0,0x07);
	prstring("Vendor ID --- Device ID ",8,0,0x07);
	gotoxy(9,0);
	FindPciDevice();
	getch();
	cll(0,0,79,24);
	cursor_type('N');
	exit();
}
/******************************************************************
 Check the exist of PCI device and write back to PCI Regs
******************************************************************/
PCI_Conf_write()
{
	unsigned char i;
	for(i=0;i<item_number;i++)
		Write_reg(&PCI_item[i] ,bus_number,dev_number,PCI_item[i].value);
	for(i=0;i<item_number;i++)
		Read_reg(&PCI_item[i] ,bus_number,dev_number);
	PCI_matrix_reg_assign(BACKWARD);
	PCI_PanelUpdate();
}

FindPciDevice()
{
	MXNIC_PCI_CFG_ADDR	CfgRegAddr = {0,0,0,0,0,0};
	unsigned long	Address,Class;
	unsigned long	lCfid;
	int		i, j;
	char	Mech1Flag=0;

	//mechaniasm 1
	CfgRegAddr.Enable = 1;
	for (j = 0; j < 32; j++) {
		CfgRegAddr.Register = 0;
		CfgRegAddr.Device = j;
		outpdw(PCI_CONFIG_ADDRESS,*(unsigned long *)&CfgRegAddr);
		lCfid = inpdw(PCI_CONFIG_DATA);
		if(lCfid!=(unsigned long)0xffffffff) {
			CfgRegAddr.Register = 2 * 4;
			outpdw(PCI_CONFIG_ADDRESS,*(unsigned long *)&CfgRegAddr);
			Class = inpdw(PCI_CONFIG_DATA);
			printf("   %04x   ---  %04x ", (unsigned int)(lCfid&0xffff),(unsigned int)((lCfid>>16)&0xffff) );
			if( ((Class>>24)&0xff) == 0x02 )
				printf(" -> Network Device");
			printf(" \n");
			Mech1Flag=1;
		}
	}
	CfgRegAddr.Enable = 0;
	outpdw(PCI_CONFIG_ADDRESS,*(unsigned long *)&CfgRegAddr);
	if(Mech1Flag) return(0);

	//mechaniasm 2
	outp(PCI_CSE_REG,ENABLE_PCI_CONFIG);
	for (j = 0, Address = 0; Address <= PCI_CONFIG_UPPER_BOUND; Address += PCI_CONFIG_OFFSET, j++) {
		lCfid = inpdw(Address);
		if(lCfid!=(unsigned long)0xffffffff) {
			Class = inpdw(Address+2*4);
			printf("   %04x   ---  %04x ", (unsigned int)(lCfid&0xffff),(unsigned int)((lCfid>>16)&0xffff) );
			if( ((Class>>24)&0xff) == 0x02 )
				printf(" -> Network Device");
			printf(" \n");
		}
	}
	outp(PCI_CSE_REG,DISABLE_PCI_CONFIG);
}



/******************************************************************
*  PCI device detect
*******************************************************************/
PCI_dev_detect_designate(int *bus_number1,int *dev_number1)
{
	regs.h.ah = PCI_FUNCTION_ID;
	regs.h.al = FIND_PCI_DEVICE;
	regs.x.cx = Device_ID;
	regs.x.dx = Vendor_ID;
	regs.x.si = 0;
	int86(PCIBIOS, &regs, &regs);
	if(regs.h.ah==SUCCESSFUL) {
		*bus_number1=regs.h.bh;
		*dev_number1=regs.h.bl/8;
		return(1);
	}
	return(0);
}

PCI_dev_detect_mxic(int *bus_number1,int *dev_number1)
{
	regs.h.ah = PCI_FUNCTION_ID;
	regs.h.al = FIND_PCI_DEVICE;
	regs.x.cx = 0x0512 ;
	regs.x.dx = 0x10d9 ;
	regs.x.si = 0;
	int86(PCIBIOS, &regs, &regs);
	if(regs.h.ah==SUCCESSFUL) {
		*bus_number1=regs.h.bh;
		*dev_number1=regs.h.bl/8;
		return(1);
	}
	return(0);
}
PCI_dev_detect_dec(int *bus_number1,int *dev_number1)
{
	regs.h.ah = PCI_FUNCTION_ID;
	regs.h.al = FIND_PCI_DEVICE;
	regs.x.cx = 0x0009 ;
	regs.x.dx = 0x1011 ;
	regs.x.si = 0;
	int86(PCIBIOS, &regs, &regs);
	if(regs.h.ah==SUCCESSFUL) {
		*bus_number1=regs.h.bh;
		*dev_number1=regs.h.bl/8;
		return(1);
	}
	return(0);
}


scan_parameters()
{
	FILE *fd;
	unsigned char i;
	if ((fd = fopen("mx713.cfg","rb")) != NULL) {
		if(((PCI08.value&0xff) >= 0x10)&&((PCI00.value&0xffff)==0x10d9)) 
			port='A';
		else
			port='Y';
		port='Y';
		fscanf(fd,"Vendor ID               :%x\n",&Vendor_ID);
		fscanf(fd,"Device ID               :%x\n",&Device_ID);
		fclose(fd);
	}
}


PCI_PanelSetup ()
{
	unsigned char i,j;
	cll(0,0,79,24);
	prstring ("Ŀ", 0, 2, Attr_R);
	prstring ("     MXIC FastEthernet NIC Configuration/Diags Program Rev V2.03           ", 1, 2, Attr_R);
	prstring ("", 2, 2, Attr_R);
	prstring ("Ŀ", 3, 2, Attr_N);
	prstring (" PCI00 (PFID)     :                                                        ", 4, 2, Attr_N);
	prstring (" PCI04 (PFCS)     :                           Ŀ     ", 5, 2, Attr_N);
	prstring (" PCI08 (PFRV)     :                             Function Select          ", 6, 2, Attr_N);
	prstring (" PCI0c (PFLT)     :                           Ĵ     ", 7, 2, Attr_N);
	prstring (" PCI10 (PBIO)     :                           F1. Network Diagnose       ", 8, 2, Attr_N);
	prstring (" PCI14 (PBMA)     :                           F2. PMAC Diagnose          ", 9, 2, Attr_N);
	prstring (" PCI18 (BaseAdd1) :                           F3. EEPROM Access          ",10, 2, Attr_N);
	prstring (" PCI1c (BaseAdd2) :                           F4. PCI Access             ",11, 2, Attr_N);
	prstring (" PCI20 (BaseAdd3) :                           F5. PORT Selection         ",12, 2, Attr_N);
	prstring (" PCI24 (BaseAdd4) :                                ",13, 2, Attr_N);
	prstring (" PCI28 (Reserved) :                            <Esc>   - Quit              ",14, 2, Attr_N);
	prstring (" PCI2c (Reserved) :                                                        ",15, 2, Attr_N);
	prstring (" PCI30 (PFER)     :                                                        ",16, 2, Attr_N);
	prstring (" PCI34 (PFCP)     :                                                        ",17, 2, Attr_N);
	prstring (" PCI38 (Reserved) :                                                        ",18, 2, Attr_N);
	prstring (" PCI3c (PFIT)     :                                                        ",19, 2, Attr_N);
	prstring (" PCI40 (PFDA)     :                                                        ",20, 2, Attr_N);
	prstring (" PCI44 (PPMC)     :                                                        ",21, 2, Attr_N);
	prstring (" PCI48 (PPMCSR)   :                                                        ",22, 2, Attr_N);
	prstring (" PCI4c (Reserved) :                                                        ",23, 2, Attr_N);
	prstring ("",24, 2, Attr_N);
	for (i=5;i<=19;i++) for (j=49;j<=76;j++)   pattrib (i,j,Attr_BEB);
	prstring ("Net ID:", 15,50,Attr_BEB);
	gotoxy(15,60);
	printf("%02x %02x %02x %02x %02x %02x ",sa[0],sa[1],sa[2],sa[3],sa[4],sa[5]);
	switch(port) {
		case 'Y': prstring ("Port : SYM       ",16,50, Attr_BEB); break;
		case 'M': prstring ("Port : MII       ",16,50, Attr_BEB); break;
		case 'A': prstring ("Port : AutoSense ",16,50, Attr_BEB); break;
		case 'B': prstring ("Port : 100FD     ",16,50, Attr_BEB); break;
		case 'C': prstring ("Port : 100HD     ",16,50, Attr_BEB); break;
		case 'D': prstring ("Port : 10FD      ",16,50, Attr_BEB); break;
		case 'E': prstring ("Port : 10HD      ",16,50, Attr_BEB); break;
		default : break;
	}
}

/******************************************************************
*  update the PCI panel
*******************************************************************/
PCI_PanelUpdate()
{
	unsigned char i;
	for(i=0;i<item_number;i++) {
		gotoxy(PCI_item[i].row,PCI_item[i].col);
		printf("%08lx",PCI_item[i].value); 
	}
}

/******************************************************************
*  PCI register write
*******************************************************************/
Write_reg(
struct   PCI_register *registers,
unsigned int bus,
unsigned int device,
unsigned long value)
{
	unsigned int TempValue;

	TempValue=value&0xffff;
	regs.h.ah = PCI_FUNCTION_ID;
	regs.h.al = WRITE_CONFIG_WORD;
	regs.h.bh = bus;
	regs.h.bl = device<<3;
	regs.x.di = registers->offset;
	regs.x.cx = TempValue;
	int86(PCIBIOS, &regs, &regs);

	TempValue=(value>>16)&0xffff;
	regs.h.ah = PCI_FUNCTION_ID;
	regs.h.al = WRITE_CONFIG_WORD;
	regs.h.bh = bus;
	regs.h.bl = device<<3;
	regs.x.di = registers->offset + 2 ;
	regs.x.cx = TempValue;
	int86(PCIBIOS, &regs, &regs);
}

/******************************************************************
*  PCI register read
*******************************************************************/
Read_reg(
struct   PCI_register *registers,
unsigned int bus,
unsigned int device)
{
	unsigned long TempValue;

	regs.h.ah = PCI_FUNCTION_ID;
	regs.h.al = READ_CONFIG_WORD;
	regs.h.bh = bus;
	regs.h.bl = device<<3;
	regs.x.di = registers->offset + 2 ;
	int86(PCIBIOS, &regs, &regs);
	TempValue=regs.x.cx;  

	regs.h.ah = PCI_FUNCTION_ID;
	regs.h.al = READ_CONFIG_WORD;
	regs.h.bh = bus;
	regs.h.bl = device<<3;
	regs.x.di = registers->offset;
	int86(PCIBIOS, &regs, &regs);
	TempValue = (TempValue<<16) + regs.x.cx;

	registers->value=TempValue;
}


eeprom_auto_programming()
{
	unsigned long eecount;
	unsigned int i;
	FILE	*fd2; 

	eeprom_auto_upload_c46();

	eecount = (unsigned long)0x10000*c46[c46[0x70]+3]+
			  (unsigned long)0x100*c46[c46[0x70]+4]+c46[c46[0x70]+5];

	eecount++;
	c46[c46[0x70]+5]=eecount;			
	c46[c46[0x70]+4]=eecount>>8; 
	c46[c46[0x70]+3]=eecount>>16;

	printf("Next Network ID    : %02x-%02x-%02x-%02x-%02x-%02x \n",
			c46[c46[0x70]+0],c46[c46[0x70]+1],c46[c46[0x70]+2],c46[c46[0x70]+3],
			c46[c46[0x70]+4],c46[c46[0x70]+5]);

	fd2=fopen("c46.pkt","w");
	for (i=0;i<128;i++){
		if((i%16)==0)  fprintf(fd2,"\n");
		fprintf(fd2,"%02x ",c46[i]);
	}
	fclose(fd2);
}

PCI_access()
{
	int k,i,j;
	char ch,editmode,index;
	PCI_Conf_read();
	PCI_PanelSetup();
	PCI_PanelUpdate();
	bar(&PCI_item[0],Attr_R);
	index=0;
	editmode=1;
	while (editmode) {
		if (kbhit()) {
			keycode_get();
			if (M_code==0) {
				switch (A_code) {
					case 0x4b :                         /*** Cr LFT ***/
					case 0x48 :                         /*** Cr Up ***/
						bar(&PCI_item[index],Attr_N);
						index--;
						if(index<0)index=19;
						bar(&PCI_item[index],Attr_R);
						PCI_PanelUpdate();
						k=0;
						break;
		  			case 0x4d :                         /*** Cr RGT ***/
					case 0x50 :                         /*** Cr Dn ***/
						bar(&PCI_item[index],Attr_N);
						index++;
						if(index>19)index=0;
						bar(&PCI_item[index],Attr_R);
						PCI_PanelUpdate();
						k=0;
						break;
		  			default   :
						break;
				}
			}
			else {
				switch (M_code) {
					case 0x1b :                         /*** ESC   ***/
						editmode=0;
						break;
					case 0x0d :                         /*** Enter ***/
						PCI_Conf_write();
						k=0;
						break;
					default   :
						if((isxdigit(M_code)!=0)&&(k<PCI_item[index].IOtype)) {
							if(k==0) {
								for(i=0;i<PCI_item[index].IOtype;i++)
								prchar(PCI_item[index].row,i+PCI_item[index].col,' ',Attr_R);
								PCI_item[index].value=0;
							}
							prchar(PCI_item[index].row,k+PCI_item[index].col,M_code,Attr_R);
							PCI_item[index].value=(PCI_item[index].value << 4) + hexvalue(M_code);
							k++;
						}
					break;
				}
			}
		}
	}
}


/************ SCREEN EDIT TOOLS *******************/

prstring (
unsigned char *str,
unsigned char row,
unsigned char col,
unsigned char attr)
{
	unsigned char i;
	i=0;
	while (str[i] >0 ) {
		prchar(row,col+i,str[i],attr);
		i++;
	}
}


prchar (
unsigned char row,
unsigned char col,
unsigned char ch,
unsigned char attr)
{
	unsigned char far * char_ptr;
	char_ptr=video_base+row*160+col*2;
	*(char_ptr)=ch;
	*(char_ptr+1)=attr;
}

cll(
unsigned char   x1,
unsigned char   y1,
unsigned char   x2,
unsigned char   y2)
{
	regs.h.ah = 6;
	regs.h.al = 0;
	regs.h.ch = y1;
	regs.h.cl = x1;
	regs.h.dh = y2;
	regs.h.dl = x2;
	regs.h.bh = 0x07;
	int86(VIDEO, &regs, &regs);
}

gotoxy(
unsigned char row,
unsigned char col)
{
	regs.h.ah = 2;              /* set cursor position     */
	regs.h.dh = row;            /* line no   (0 ~ 24)      */
	regs.h.dl = col;            /* column no (0 ~ 79)      */
	regs.h.bh = 0;              /* page no   (0 ~  3)      */
	int86(VIDEO, &regs, &regs);
}

bar(
struct PCI_register *registers,
unsigned char attr)
{
	unsigned char i;
	for (i=0; i<registers->IOtype ; i++)
		pattrib (registers->row,registers->col+i, attr);
}

bar_one(
unsigned char start_row,
unsigned char start_col,
unsigned char length,
unsigned char attr)
{
	unsigned char i;
	for (i=start_col;i<start_col+length;i++) 
		pattrib (start_row,i,attr);
}

pattrib (
unsigned char row,
unsigned char col,
unsigned char attr)
{
	unsigned char far * char_ptr;
	char_ptr=video_base+row*160+col*2;
	*(char_ptr+1)=attr;
}

keycode_get()
{
	regs.h.ah = 0;                   /* read keyboard (two byte)  */
	int86(KEYBOARD,&regs, &regs);
	M_code = regs.h.al;
	A_code = regs.h.ah;
}

cursor_type(unsigned char cr_type)
{
	regs.h.ah = 1;                           /* set cursor size */
	switch (cr_type){
		case 'N': regs.h.ch=12;   break;   /* start line no   */
		case 'F': regs.h.ch=0;    break;   /* start line no   */
		case 'E': regs.h.ch=0x20; break;   /* start line no   */
		default : regs.h.ch=12;   break;   /* start line no   */
	}
	regs.h.cl = 13;                          /* end line no     */
	int86(VIDEO, &regs, &regs);
}
	
/****************************************************************
 * Do a Delay in the unit of millisecond
 ****************************************************************/

delay (unit)
unsigned int unit;
{
	unsigned int i;
	for(i=0;i<unit*100;i++)
		delay10us();
}

screen_store()
{
	unsigned char row,col;
	unsigned char far * char_ptr;
	for(row=0;row<25; row++)
		for(col=0;col<80; col++){
			char_ptr=video_base+row*160+col*2;
			screen[screenindex][row][col][0]= *(char_ptr);
			screen[screenindex][row][col][1]= *(char_ptr+1);
		}
	screenindex++;
}

screen_restore()
{
	unsigned char row,col;
	unsigned char far * char_ptr;
	screenindex--;
	for(row=0;row<25; row++)
		for(col=0;col<80; col++){
			char_ptr=video_base+row*160+col*2;
			*(char_ptr)=  screen[screenindex][row][col][0];
			*(char_ptr+1)=screen[screenindex][row][col][1];
		}
}



/******************************************************************
*  get the hex value of ch
*******************************************************************/
int hexvalue(char ch)
{
	tolower(ch);
	switch(ch) {
	case '0':
		return(0);  break;
	case '1':
		return(1);  break;
	case '2':
		return(2);  break;
	case '3':
		return(3);  break;
	case '4':
		return(4);  break;
	case '5':
		return(5);  break;
	case '6':
		return(6);  break;
	case '7':
		return(7);  break;
	case '8':
		return(8);  break;
	case '9':
		return(9);  break;
	case 'a':
	case 'A':
		return(10); break;
	case 'b':
	case 'B':
		return(11); break;
	case 'c':
	case 'C':
		return(12); break;
	case 'd':
	case 'D':
		return(13); break;
	case 'e':
	case 'E':
		return(14); break;
	case 'f':
	case 'F':
		return(15); break;
	default:         break;
	}
}
