  
/****************************************************************
 *
 * Copyright (C) 1995 Macronix International Corp.
 * MX0513 Diagnose and Test program.
 * pci.c + bmtx.c + decdiag.c + dwio.asm
 *
 * Revision History:
 * Date     Who                   Comments
 * 07/25/95 Luke Huang
 * 11/25/96 Luke Huang 			  Add CSR5_TI don't bit to 
 *								  CSR5 UNF test		
 ******************************************************************/
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <memory.h>
#include <malloc.h>
#include "pci.h"

#define  test_pattern_number   22
extern struct PCI_register csr0;
extern struct PCI_register csr1;
extern struct PCI_register csr2;
extern struct PCI_register csr3;
extern struct PCI_register csr4;
extern struct PCI_register csr5;
extern struct PCI_register csr6;
extern struct PCI_register csr7;
extern struct PCI_register csr8;
extern struct PCI_register csr9;
extern struct PCI_register csr10;
extern struct PCI_register csr11;
extern struct PCI_register csr12;
extern struct PCI_register csr13;
extern struct PCI_register csr14;
extern struct PCI_register csr15;
extern struct PCI_register   PCI3c;
extern unsigned int  intcount;
extern unsigned int  intflag;
extern unsigned char sa[8];
extern unsigned char  port;
extern unsigned char far c46[];
extern struct TX_RESOURCE     *tx_resource[NumTXBuffers];
extern struct RX_RESOURCE     *rx_resource[NumRXBuffers];
unsigned long csr5expect,csr5compare;
extern long csr6shadow;
extern long csr14shadow;
struct test_buffer{
	char attr;
	char address[6];
};

char perfect[96]={0x00, 0x01, 0x02, 0x03, 0xab, 0xc0,
                  0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xc2,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xc3,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xc4,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xc5,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xc6,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xc7,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xc8,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xc9,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xca,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xcb,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xcc,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xcd,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xce,
                  0x00, 0x01, 0x02, 0x03, 0xab, 0xcf};

char hash[96]=   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   //  0 --  5
                  0x00, 0x10, 0x00, 0x00, 0x00, 0x00,   //  6 -- 11
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // 12 -- 17
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x40,   // 18 -- 23
                  0x80, 0x00, 0x00, 0x00, 0x00, 0x00,   // 24 -- 29
                  0x10, 0x00, 0x00, 0x00, 0x00, 0x00,   // 30 -- 35
                  0x00, 0x00, 0x00, 0x10, 0x00, 0x00,   // 36 -- 41
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // 42 -- 47
                  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // 48 -- 53
                  0x01, 0x00, 0x00, 0x00, 0x00, 0x00,   // 54 -- 59
                  0x00, 0x00, 0x40, 0x00, 0xff, 0xff,   // 60 -- 65
                  0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   // 66 -- 71
                  0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   // 72 -- 77
                  0x02, 0x04, 0x06, 0x08, 0xab, 0xcd,   // 78 -- 83
                  0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   // 84 -- 89
                  0xff, 0xff, 0xff, 0xff, 0xff, 0xff};  // 90 -- 96

struct test_buffer  pattern[test_pattern_number]={
                  {'h',{0x7d, 0x48, 0x4d, 0xfd, 0xcc, 0x0a}},     // o : others
                  {'m',{0x27, 0x21, 0x02, 0x03, 0xad, 0xd2}},     // p : perfect
                  {'o',{0x20, 0x21, 0x02, 0x03, 0xa2, 0x22}},     // m : multicast
                  {'h',{0x6b, 0x46, 0x0a, 0x55, 0x2d, 0x7e}},     // h : hash
                  {'h',{0x25, 0x00, 0x25, 0x00, 0x27, 0x00}},     // z : 512h+ 1z
                  {'p',{0x00, 0x01, 0x02, 0x03, 0xab, 0xcd}},
                  {'p',{0x00, 0x01, 0x02, 0x03, 0xab, 0xcb}},
                  {'h',{0xe7, 0xc1, 0x96, 0x36, 0x89, 0xdd}},
                  {'p',{0x00, 0x01, 0x02, 0x03, 0xab, 0xcc}},
                  {'o',{0x20, 0x21, 0x02, 0x03, 0xa5, 0x52}},
                  {'p',{0x00, 0x01, 0x02, 0x03, 0xab, 0xcd}},
                  {'p',{0x00, 0x01, 0x02, 0x03, 0xab, 0xcf}},
                  {'o',{0x20, 0x21, 0x02, 0x03, 0xa1, 0x12}},
                  {'o',{0x20, 0x21, 0x02, 0x03, 0xa4, 0x42}},
                  {'m',{0x23, 0x21, 0x02, 0x03, 0xaa, 0xa2}},
                  {'m',{0x25, 0x21, 0x02, 0x03, 0xab, 0xb2}},
                  {'h',{0x61, 0xcc, 0x28, 0x55, 0xd3, 0xc7}},
                  {'m',{0x25, 0x21, 0x02, 0x03, 0xac, 0xc2}},
                  {'p',{0x00, 0x01, 0x02, 0x03, 0xab, 0xca}},
                  {'m',{0x27, 0x21, 0x02, 0x03, 0xae, 0xe2}},
                  {'o',{0x20, 0x21, 0x02, 0x03, 0xa3, 0x32}},
                  {'z',{0x02, 0x04, 0x06, 0x08, 0xab, 0xcd}}};


loopback(unsigned long mode)
{
	unsigned int i;

	initialize();
	NIC_write_reg(&csr6,csr6.value|CSR6_PR|CSR6_PB|CSR6_PM|mode);
	NIC_write_reg(&csr7,(unsigned long)0xffffffff);
	delay(20);
	fill_txbuffer0(0x300,VARIABLE);
	NIC_write_reg(&csr1,0xffff);
	delay(10);

	for(;;) {

		if(tx_resource[0]->ownership & TDES0_OWN_BIT) break;
		if(mode==CSR6_OM_INT){
			if((rx_resource[0]->rstatus&(RDES0_DT0|RDES0_DT1))!=RDES0_DT0)
			break;
		}else{               // mode==CSR6_OM_EXT

			if(tx_resource[0]->tstatus&TDES0_LO != TDES0_LO)   break;
			if((rx_resource[0]->rstatus&(RDES0_DT0|RDES0_DT1))!=RDES0_DT1)
				break;
		}

		if((rx_resource[0]->rstatus&RDES0_ES)||
			(rx_resource[0]->frame_length & RDES0_OWN_BIT))   break;
		return(PASS);

	}

	return(FAIL);

}

burstlength_test()
{
	unsigned char i,j;

	initialize();
	NIC_write_reg(&csr6, csr6.value&(~CSR6_SR) );
	rx_resource[0]->command=RDES1_BUFF_LAST;
	NIC_write_reg(&csr6,csr6.value|CSR6_SF|CSR6_PR|CSR6_PB|CSR6_PM|CSR6_OM_INT);
	fill_txbuffer0(0x300,VARIABLE);

	for(j=0;j<6;j++) {

		NIC_write_reg(&csr0, CSR0_CAL_8|(0x01<<(j+8)) );

		for(i=0;i<10;i++) {

			gotoxy(20,70);
			printf("%d",(0x01<<j));
			rx_resource[0]->frame_length=RDES0_OWN_BIT;
			fill_txbuffer0(0x64+0x50*i,VARIABLE);
			NIC_write_reg(&csr1,0xffff);
			delay(10);

			if(rx_resource[0]->frame_length != (0x68+0x50*i) )
				return(FAIL);
			if(rx_resource[0]->rstatus&RDES0_ES) 
				return(FAIL);

		}
	}
	return(PASS);
}
 

	
ISR_test()
{
	initialize();
	NIC_write_reg(&csr7,0xffffffff);
	intcount=0;
	NIC_write_reg(&csr1,0xff);      
	delay(20);

	if(intcount>=1) return(PASS);
	else            return(FAIL);

}

eeprom_test()
{
	unsigned int i;
	unsigned char old_c46_value[8];

	eeprom_read();
	for(i=0;i<8;i++)
		old_c46_value[i]=c46[i];

	eeprom_write(0x00,0xf637);
	eeprom_write(0x01,0x8765);
	eeprom_write(0x02,0x1234);
	eeprom_write(0x03,0x55aa);

	eeprom_read();

	for(;;)  {

		if(c46[0]!=0x37)  break;
		if(c46[1]!=0xf6)  break;
		if(c46[2]!=0x65)  break;
		if(c46[3]!=0x87)  break;
		if(c46[4]!=0x34)  break;
		if(c46[5]!=0x12)  break;
		if(c46[6]!=0xaa)  break;
		if(c46[7]!=0x55)  break;
		eeprom_write(0x00,(unsigned int)old_c46_value[0]+(unsigned int)old_c46_value[1]*0x100);
		eeprom_write(0x01,(unsigned int)old_c46_value[2]+(unsigned int)old_c46_value[3]*0x100);
		eeprom_write(0x02,(unsigned int)old_c46_value[4]+(unsigned int)old_c46_value[5]*0x100);
		eeprom_write(0x03,(unsigned int)old_c46_value[6]+(unsigned int)old_c46_value[7]*0x100);
		eeprom_read();
		return(PASS);

	}

	eeprom_write(0x00,(unsigned int)old_c46_value[0]+(unsigned int)old_c46_value[1]*0x100);
	eeprom_write(0x01,(unsigned int)old_c46_value[2]+(unsigned int)old_c46_value[3]*0x100);
	eeprom_write(0x02,(unsigned int)old_c46_value[4]+(unsigned int)old_c46_value[5]*0x100);
	eeprom_write(0x03,(unsigned int)old_c46_value[6]+(unsigned int)old_c46_value[7]*0x100);
	eeprom_read();

	return(FAIL);
}

csr0_test()
{
	unsigned int i;
	prstring("0  ",20,70,Attr_YE);

	initialize();
	fill_pattern(6);
	NIC_read_reg(&csr0);
	NIC_write_reg(&csr6,csr6.value|CSR6_FD);
	NIC_write_reg(&csr0,csr0.value|CSR0_TAP_800);    // TAP function test

	for(i=0;i<6;i++) {

		delay(2);
		tx_resource[i]->ownership=TDES0_OWN_BIT;
		delay(10);
		if((tx_resource[i]->ownership&TDES0_OWN_BIT)==TDES0_OWN_BIT)
			return(FAIL);

	}

	initialize();
	fill_txbuffer0(0x60,VARIABLE);

	for(i=0;i<4;i++)  {

		tx_resource[0]->tx_buffer_data[i]=i;
		rx_resource[0]->rx_buffer_data[i]=0;

	}

	NIC_write_reg(&csr0,csr0.value|CSR0_BLE);
	NIC_write_reg(&csr6,csr6.value|CSR6_OM_INT);
	NIC_write_reg(&csr1,0xffff);
	delay(20);

	if((rx_resource[0]->rx_buffer_data[0]==tx_resource[0]->tx_buffer_data[0])&&
		(rx_resource[0]->rx_buffer_data[1]==tx_resource[0]->tx_buffer_data[1])&&
		(rx_resource[0]->rx_buffer_data[2]==tx_resource[0]->tx_buffer_data[2])&&
		(rx_resource[0]->rx_buffer_data[3]==tx_resource[0]->tx_buffer_data[3]))
		return(FAIL);
	else 
		return(PASS);

}

csr34_test()
{
	unsigned int i;
	prstring("34 ",20,70,Attr_YE);

	initialize();
	NIC_write_reg(&csr6,0);		  

	for(;;)   {

	NIC_write_reg(&csr3,0x55aa55aa);
	NIC_read_reg(&csr3);
	if(  csr3.value!=0x55aa55aa)  break;

	NIC_write_reg(&csr3,0xaa55aa55);
	NIC_read_reg(&csr3);
	if(  csr3.value!=0xaa55aa55)  break;

	NIC_write_reg(&csr4,0x55aa55aa);
	NIC_read_reg(&csr4);
	if(  csr4.value!=0x55aa55aa)  break;

	NIC_write_reg(&csr4,0xaa55aa55);
	NIC_read_reg(&csr4);
	if(  csr4.value!=0xaa55aa55)  break;

	return(PASS);
	}

	return(FAIL);
}

csr5_test()
{
	unsigned long           physicaladdress,csr6temp;

	prstring("5  ",20,70,Attr_YE);
	for(;;) {

		prstring("5.1",20,70,Attr_YE);
	
		initialize();
		NIC_write_reg(&csr0,0x01);
		delay(1);
		NIC_read_reg(&csr5);

		csr5expect=(CSR5_DONTCARE|(unsigned long)(0xfc005410));
		csr5compare=csr5.value|CSR5_DONTCARE;
		if(csr5compare!=csr5expect) break;


		initialize();
		NIC_write_reg(&csr6,csr6.value|CSR6_PM|CSR6_PR|CSR6_PB|CSR6_OM_INT);
		delay(10);
		NIC_write_reg(&csr5,(unsigned long)0xffffffff);
		NIC_read_reg(&csr5);

		csr5expect=(CSR5_DONTCARE|(unsigned long)(0x660000));
		csr5compare=csr5.value|CSR5_DONTCARE;
		if(csr5compare!=csr5expect) break;
	
		prstring("5.2",20,70,Attr_YE);
		NIC_write_reg(&csr7,0xffffffff);
		fill_pattern(1);
		intflag=0x1234;
		NIC_write_reg(&csr1,0xffff);
		delay(20);
		if(intflag != 0xefef )  break;

		csr5expect=(unsigned long)(CSR5_DONTCARE|CSR5_TI|CSR5_TU|
			CSR5_RI|CSR5_NIS|CSR5_TS_SUSP|CSR5_RS_RUN);
		csr5compare=CSR5_DONTCARE|csr5.value;
		if(csr5compare != csr5expect)  break;


		prstring("5.3",20,70,Attr_YE);
		initialize();
		NIC_write_reg(&csr1,0xff);
		delay(10);
		NIC_write_reg(&csr5,(unsigned long)0xffffffff);
		NIC_write_reg(&csr7,0xffffffff);
		intflag=0x1234;
		NIC_write_reg(&csr6,csr6.value&(~(CSR6_ST|CSR6_SR)));
		delay(30);
		if(intflag != 0xefef )  break;
		csr5expect=CSR5_DONTCARE|CSR5_TPS|CSR5_RPS|CSR5_AIS;
		csr5compare=CSR5_DONTCARE|csr5.value;
		if(csr5compare!= csr5expect)   break;
	
		return(PASS);
				 
	}
	return(FAIL);
}


csr6_test()
{
	unsigned int i,j;
	unsigned long temp;
	prstring("6  ",20,70,Attr_YE);

	initialize();
	temp=csr6.value;
	setup_frame(TDES1_SETUP_LAST,perfect);
	NIC_write_reg(&csr7,0xffffffff);

	NIC_write_reg(&csr6,temp|CSR6_OM_INT|CSR6_PB);      // PB test
	delay(1);
	NIC_read_reg(&csr6);
	if(csr6.value != (temp+CSR6_OM_INT+CSR6_PB))  return(FAIL);
	fill_pattern(1);
	tx_resource[0]->command -= (TEST_PKT_SIZE-6);
	NIC_write_reg(&csr1,0xff);
	delay(20);

	csr5expect=CSR5_DONTCARE|CSR5_NIS|CSR5_TU|CSR5_TS_SUSP|CSR5_RS_RUN|CSR5_TI;
	csr5compare=CSR5_DONTCARE|csr5.value;
	if( csr5compare != csr5expect ) return(FAIL);

	NIC_write_reg(&csr6,temp|CSR6_OM_INT|CSR6_PR);      // PR test
	delay(1);
	NIC_read_reg(&csr6);
	if(csr6.value != (temp+CSR6_OM_INT+CSR6_PR))  return(FAIL);
	fill_pattern(1);
	tx_resource[0]->command -= (TEST_PKT_SIZE-6);
	NIC_write_reg(&csr1,0xffff);
	delay(20);

	csr5expect=CSR5_DONTCARE|CSR5_NIS|CSR5_TU|
		CSR5_TS_SUSP|CSR5_RS_RUN|CSR5_TI;
	csr5compare=CSR5_DONTCARE|csr5.value;
	if(csr5compare != csr5expect) return(FAIL);

	NIC_write_reg(&csr6,temp|CSR6_OM_INT|CSR6_PB|CSR6_PR);
	delay(1);
	NIC_read_reg(&csr6);
	if(csr6.value != (temp+CSR6_OM_INT+CSR6_PB+CSR6_PR))  return(FAIL);
	fill_pattern(2);   // first RF only , second RF + MF
	tx_resource[0]->command -= (TEST_PKT_SIZE-6);
	tx_resource[1]->command -= (TEST_PKT_SIZE-6);
	tx_resource[1]->tx_buffer_data[0]=0xff;
	NIC_write_reg(&csr1,0xff);
	delay(20);

	csr5expect=CSR5_DONTCARE|CSR5_NIS|
		CSR5_TU|CSR5_RI|CSR5_TS_SUSP|CSR5_RS_RUN|CSR5_TI;
	csr5compare=CSR5_DONTCARE|csr5.value;
	if(csr5compare != csr5expect) return(FAIL);

	if(rx_resource[0]->rstatus&(RDES0_RF|RDES0_MF) != RDES0_RF)
		return(FAIL);

	if(rx_resource[1]->rstatus&(RDES0_RF|RDES0_MF)!= (RDES0_RF|RDES0_MF))
		return(FAIL);


	initialize();
	setup_frame(TDES1_SETUP_LAST,perfect);
	NIC_write_reg(&csr7,0xffffffff);


	NIC_write_reg(&csr6,temp|CSR6_OM_INT|CSR6_PM);      // PM test
	delay(1);
	NIC_read_reg(&csr6);
	if(csr6.value != (temp+CSR6_OM_INT+CSR6_PM))  return(FAIL);

	for(j=0;j<test_pattern_number;j++) {

		fill_pattern(1);
		for(i=0;i<6;i++)
			tx_resource[0]->tx_buffer_data[i]=pattern[j].address[i];
		NIC_write_reg(&csr1,0xffffffff);
		delay(10);
		if((pattern[j].attr=='h')||(pattern[j].attr=='p')
			||(pattern[j].attr=='m')){

			csr5expect=CSR5_DONTCARE|CSR5_NIS|
				CSR5_TU|CSR5_TS_SUSP|CSR5_RS_RUN|CSR5_RI|CSR5_TI;
			csr5compare=CSR5_DONTCARE|csr5.value;
			if(csr5compare != csr5expect) return(FAIL);

		}else {

			csr5expect=CSR5_DONTCARE|CSR5_NIS|
			CSR5_TU|CSR5_TS_SUSP|CSR5_RS_RUN|CSR5_TI;
			csr5compare=CSR5_DONTCARE|csr5.value;
			if(csr5compare != csr5expect) return(FAIL);

		}
		for(i=0;i<6;i++)
			rx_resource[i]->frame_length=RDES0_OWN_BIT;
	}

	NIC_write_reg(&csr6,temp|CSR6_FC|CSR6_OM_INT);
	delay(1);
	NIC_read_reg(&csr6);
	if(csr6.value != (temp|CSR6_FC|CSR6_OM_INT))    return(FAIL);
	fill_pattern(1);
	NIC_write_reg(&csr1,0xffff);
	delay(200);           // waiting for collision
	if(tx_resource[0]->ownership & TDES0_OWN_BIT) return(FAIL);
	if(tx_resource[0]->tstatus!=TDES0_FORCECOLLISION_MASK) return(FAIL);
	
	NIC_write_reg(&csr6,temp|CSR6_SF|CSR6_OM_INT);             // SF test
	delay(1);
	NIC_read_reg(&csr6);
	if(csr6.value != (temp|CSR6_SF|CSR6_OM_INT))  return(FAIL);
	fill_pattern(2);
	tx_resource[0]->command=TDES1_BUFF_FS+0x420;
	tx_resource[1]->command=TDES1_BUFF_LS+0x100;
	tx_resource[1]->ownership=0x00;
	NIC_write_reg(&csr1,0xffff);
	delay(20);

	csr5expect=CSR5_DONTCARE|CSR5_NIS|CSR5_TU|CSR5_TS_SUSP
		|CSR5_RS_RUN;
	csr5compare=CSR5_DONTCARE|csr5.value;
	if(csr5compare != csr5expect) return(FAIL);
	
	tx_resource[1]->ownership=TDES0_OWN_BIT;
	NIC_write_reg(&csr1,0xffffffff);
	delay(20);
	
	csr5expect=CSR5_DONTCARE|CSR5_NIS|CSR5_TU|CSR5_TI|CSR5_TS_SUSP
		|CSR5_RS_RUN;
	csr5compare=CSR5_DONTCARE|csr5.value;
	if(csr5compare != csr5expect) return(FAIL);
	
	return(PASS);
}



csr7_test()           // disable all interrupt test
{
	prstring("7  ",20,70,Attr_YE);
	for(;;) {

		initialize();
		NIC_write_reg(&csr0,0x01);
		delay(5);
		NIC_read_reg(&csr7);
		csr7.value|=0xfffe0000;
		if((csr7.value!=0xfffe0000)&&(csr7.value!=0xfffe5410)) break;

		initialize();
		NIC_write_reg(&csr6,csr6.value|CSR6_PM|CSR6_PR|CSR6_PB|CSR6_OM_INT);
		delay(10);
		NIC_write_reg(&csr5,0xffffffff);
		fill_pattern(6);
		intflag=0x1234;
		NIC_write_reg(&csr1,0xffff);
		delay(20);
		if(intflag != 0x1234 )  break;


		initialize();
		intflag=0x1234;
		NIC_write_reg(&csr6,csr6.value-CSR6_ST-CSR6_SR);
		delay(5);
		if(intflag != 0x1234 )   break;

		initialize();
		fill_pattern(2);
		tx_resource[0]->command=TDES1_BUFF_FS+0x560;
		tx_resource[1]->command=TDES1_BUFF_LS+0x560;
		tx_resource[1]->ownership=0x00;
		NIC_write_reg(&csr1,0xffffffff);
		delay(20);
		tx_resource[1]->ownership=TDES0_OWN_BIT;
		NIC_write_reg(&csr5,0xffffffff);
		intflag=0x1234;
		NIC_write_reg(&csr1,0xffffffff);
		delay(20);
		if(intflag != 0x1234 ) break;
	
	

		initialize();
		fill_pattern(2);
		tx_resource[0]->command=TDES1_BUFF_FS+0x510;
		tx_resource[1]->command=TDES1_BUFF_LS+0x510;
		intflag=0x1234;
		NIC_write_reg(&csr15,CSR15_JCK);
		NIC_write_reg(&csr1,0xffffffff);
		delay(20);
		if(intflag != 0x1234 ) break;
	
	

		initialize();
		NIC_write_reg(&csr6,csr6.value|CSR6_OM_INT
		|CSR6_PR|CSR6_PM|CSR6_PB);
		fill_pattern(2);
		tx_resource[0]->command=TDES1_BUFF_FS+0x510;
		tx_resource[1]->command=TDES1_BUFF_LS+0x510;
		intflag=0x1234;
		NIC_write_reg(&csr1,0xffffffff);
		delay(20);
		if(intflag != 0x1234 ) break;
	
		return(PASS);
	}
	return(FAIL);
}


csr8_test()
{
	prstring("8  ",20,70,Attr_YE);
	for(;;) {
		initialize();                         // initialize value
		NIC_write_reg(&csr0,0x01);
		delay(5);
		NIC_read_reg(&csr8);
		if((csr8.value!=(unsigned long)0xfffe0000)) break;
	
		initialize();
		NIC_write_reg(&csr6,csr6.value|CSR6_PM|CSR6_PR|CSR6_PB|CSR6_OM_INT);
	
		fill_pattern(6);
		NIC_write_reg(&csr1,0xff);
		delay(20);
		NIC_read_reg(&csr8);

		fill_pattern(6);
		NIC_write_reg(&csr1,0xff);
		delay(20);
		NIC_read_reg(&csr8);
	
		gotoxy(20,70);
		printf("%lx",csr8.value);
		if(csr8.value!=(unsigned long)0xfffe0006 )  break;

		return(PASS);
	}

	return(FAIL);
}


csr11_test()
{
	unsigned int i,j;
	prstring("11      ",20,70,Attr_YE);

	initialize();
	NIC_write_reg(&csr7, CSR7_GPT|CSR7_AI );     // turn on interrupt mask
	NIC_write_reg(&csr5, 0xffffffff);     // clear csr5
	intcount=0;

	NIC_write_reg(&csr11,(unsigned long)0xffff0334);   // continue mode test
	while( intcount <= 10) {
	   delay(10);
	   i++;
	   if(i>200)  return(FAIL);
	}
	csr5expect=CSR5_DONTCARE|CSR5_AIS|CSR5_TS_SUSP|CSR5_RS_RUN|CSR5_GTE;
	csr5compare=CSR5_DONTCARE|csr5.value;
	if(csr5compare != csr5expect) return(FAIL);

	NIC_write_reg(&csr11,(unsigned long)0xfffe0000);
	intflag=0x0000;                           // one-shot mode
	NIC_write_reg(&csr11,(unsigned long)0xfffe0234);
	for(i=0;i<20, intflag!=0xefef ;i++ ) delay(15);
	NIC_read_reg(&csr11);
	if((csr11.value!=(unsigned long)0xfffe0000) || (i>=20) )
	return(FAIL);


	NIC_write_reg(&csr7,0x00000000);
	intflag=0x1234;                        // CSR7_GPT disable test
	NIC_write_reg(&csr11,(unsigned long)0xfffe0014);
	delay(5);

	if(intflag!=0x1234)	return(FAIL);

	return(PASS);

}


csr12_test()
{
//	CSR12 function remove in mx98713

	return(PASS);
}


csr15_test()
{
	unsigned int imm,dly;
//	CSR15 function remove in mx98713
	return(PASS);
}



hash_test()
{
	unsigned int i,j;
	unsigned long temp;

	initialize();
	temp=csr6.value;
	setup_frame(TDES1_SETUP_HASH_LAST,hash);
	NIC_write_reg(&csr7,0xffffffff);
	NIC_write_reg(&csr6,csr6.value|CSR6_OM_INT);
	delay(1);
	NIC_read_reg(&csr6);

	if(csr6.value != (temp+CSR6_HP+CSR6_OM_INT))  return(FAIL);

	for(j=0;j<test_pattern_number-1;j++) {     //Last Pattern Cause error

		fill_pattern(1);
		for(i=0;i<6;i++)
			tx_resource[0]->tx_buffer_data[i]=pattern[j].address[i];
		NIC_write_reg(&csr1,0xffffffff);
		delay(5);

		if((pattern[j].attr=='h')||(pattern[j].attr=='z')){

			csr5expect=CSR5_DONTCARE|CSR5_NIS|CSR5_TU|CSR5_TS_SUSP|
				CSR5_RS_RUN|CSR5_RI|CSR5_TI;
			csr5compare=CSR5_DONTCARE|csr5.value;
			if(csr5compare != csr5expect)  return(FAIL);

		}else {

			csr5expect=CSR5_DONTCARE|CSR5_NIS|CSR5_TU|CSR5_TS_SUSP|
			CSR5_RS_RUN|CSR5_TI;
			csr5compare=CSR5_DONTCARE|csr5.value;
			if(csr5compare != csr5expect)  return(FAIL);

		}

		for(i=0;i<6;i++)
			rx_resource[i]->frame_length=RDES0_OWN_BIT;
	}

	return(PASS);
}


hash_only_test()
{
	unsigned int i,j;
	unsigned long temp;

	initialize();
	temp=csr6.value;
	setup_frame(TDES1_SETUP_HASHONLY_LAST,hash);
	NIC_write_reg(&csr7,0xffffffff);
	NIC_write_reg(&csr6,csr6.value|CSR6_OM_INT);
	delay(1);


	NIC_read_reg(&csr6);
	if(csr6.value != (temp+CSR6_HP+CSR6_HO+CSR6_OM_INT))  return(FAIL);

	for(j=0;j<test_pattern_number;j++) {

		fill_pattern(1);
		for(i=0;i<6;i++)
			tx_resource[0]->tx_buffer_data[i]=pattern[j].address[i];
		NIC_write_reg(&csr1,0xffffffff);
		delay(5);

		if(pattern[j].attr=='h'){

			csr5expect=CSR5_DONTCARE|CSR5_NIS|
			CSR5_TU|CSR5_TS_SUSP|CSR5_RS_RUN|CSR5_RI|CSR5_TI;
			csr5compare=CSR5_DONTCARE|csr5.value;
			if(csr5compare != csr5expect)  return(FAIL);

		}else {

			csr5expect=CSR5_DONTCARE|CSR5_NIS|
			CSR5_TU|CSR5_TS_SUSP|CSR5_RS_RUN|CSR5_TI;
			csr5compare=CSR5_DONTCARE|csr5.value;
			if(csr5compare != csr5expect)  return(FAIL);
		}

		for(i=0;i<6;i++)
		rx_resource[i]->frame_length=RDES0_OWN_BIT;

	}

	return(PASS);
}


perfect_test()
{
	unsigned int i,j;
	unsigned long temp;

	initialize();
	temp=csr6.value;
	setup_frame(TDES1_SETUP_LAST,perfect);
	NIC_write_reg(&csr7,0xffffffff);
	NIC_write_reg(&csr6,csr6.value|CSR6_OM_INT);
	delay(1);


	NIC_read_reg(&csr6);
	if(csr6.value != (temp+CSR6_OM_INT))  return(FAIL);

	for(j=0;j<test_pattern_number;j++) {

		fill_pattern(1);
		for(i=0;i<6;i++)
		tx_resource[0]->tx_buffer_data[i]=pattern[j].address[i];
		NIC_write_reg(&csr1,0xffffffff);
		delay(5);

		if(pattern[j].attr=='p'){

			csr5expect=CSR5_DONTCARE|CSR5_NIS|
				CSR5_TU|CSR5_TS_SUSP|CSR5_RS_RUN|CSR5_RI|CSR5_TI;
			csr5compare=CSR5_DONTCARE|csr5.value;
			if(csr5compare != csr5expect)  return(FAIL);

		}else {

			csr5expect=CSR5_DONTCARE|CSR5_NIS|
				CSR5_TU|CSR5_TS_SUSP|CSR5_RS_RUN|CSR5_TI;
			csr5compare=CSR5_DONTCARE|csr5.value;
			if(csr5compare != csr5expect)  return(FAIL);

		}

		for(i=0;i<6;i++)
			rx_resource[i]->frame_length=RDES0_OWN_BIT;
	}

	return(PASS);
}



inverse_test()
{
	unsigned int i,j;
	unsigned long temp;


	initialize();
	temp=csr6.value;
	setup_frame(TDES1_SETUP_INVERSE_LAST,perfect);
	NIC_write_reg(&csr7,0xffffffff);
	NIC_write_reg(&csr6,csr6.value|CSR6_OM_INT);
	delay(1);

	NIC_read_reg(&csr6);
	if(csr6.value != (temp+CSR6_OM_INT+CSR6_IF))  return(FAIL);

	for(j=1;j<test_pattern_number;j++) {
		fill_pattern(1);
		for(i=0;i<6;i++)
		tx_resource[0]->tx_buffer_data[i]=pattern[j].address[i];
		NIC_write_reg(&csr1,0xffffffff);
		delay(5);

		if(pattern[j].attr=='p'){

			csr5expect=CSR5_DONTCARE|CSR5_NIS|
				CSR5_TU|CSR5_TS_SUSP|CSR5_RS_RUN|CSR5_TI;
			csr5compare=CSR5_DONTCARE|csr5.value;
			if(csr5compare != csr5expect)  return(FAIL);

		}else {

			csr5expect=CSR5_DONTCARE|CSR5_NIS|
				CSR5_TU|CSR5_TS_SUSP|CSR5_RS_RUN|CSR5_RI|CSR5_TI;
			csr5compare=CSR5_DONTCARE|csr5.value;
			if(csr5compare != csr5expect)  return(FAIL);

		}

		for(i=0;i<6;i++)
			rx_resource[i]->frame_length=RDES0_OWN_BIT;
	}

	return(PASS);
}

oneP_nD_test()
{

	initialize();
	NIC_write_reg(&csr6,csr6.value|CSR6_OM_INT|CSR6_PR
		|CSR6_PM|CSR6_PB|CSR6_SF);
	fill_pattern(6);
	tx_resource[0]->command=TDES1_BUFF_FS+0x221;
	tx_resource[1]->command=TDES1_BUFF_MI+0x100;
	tx_resource[2]->command=TDES1_BUFF_LS+0x220;
	tx_resource[3]->command=TDES1_BUFF   +0x502;
	tx_resource[4]->command=TDES1_BUFF_FS+0x323;
	tx_resource[5]->command=TDES1_BUFF_LS+0x100;
	NIC_write_reg(&csr1,0xff);
	delay(10);

	for(;;) {

		if(tx_resource[0]->ownership & TDES0_OWN_BIT) break;
		if(tx_resource[1]->ownership & TDES0_OWN_BIT) break;
		if(tx_resource[2]->ownership & TDES0_OWN_BIT) break;
		if(tx_resource[3]->ownership & TDES0_OWN_BIT) break;
		if(tx_resource[4]->ownership & TDES0_OWN_BIT) break;
		if(tx_resource[5]->ownership & TDES0_OWN_BIT) break;
	
		if( (rx_resource[0]->frame_length!=0x545)||
			(rx_resource[1]->frame_length!=0x506)||
			(rx_resource[2]->frame_length!=0x427)  )         break;
		if( (rx_resource[0]->rstatus&RDES0_ES )||
			(rx_resource[1]->rstatus&RDES0_ES )||
			(rx_resource[2]->rstatus&RDES0_ES )  ) break;
		if( ((rx_resource[0]->rstatus&RDES0_DT0)!=RDES0_DT0)||
			((rx_resource[1]->rstatus&RDES0_DT0)!=RDES0_DT0)||
			((rx_resource[2]->rstatus&RDES0_DT0)!=RDES0_DT0)) break;
	
		return(PASS);
	}
	return(FAIL);
}

decdiag ()
{
	unsigned char escquit;
    unsigned char baserow,basecol;
	unsigned long temp,temp1;
	temp=csr6shadow;
	temp1=csr14shadow;

	if(port=='A') {	  // there is no internal loopback test in autosense mode
		csr6shadow=(TX_THRESHOLD_DEF<<14)+CSR6_HBD+
			CSR6_SR+CSR6_ST+CSR6_SCR+CSR6_PCS+CSR6_SF+CSR6_PS+CSR6_FD;
		csr14shadow = (unsigned long)0xffffff7f;
	}

	baserow=6;
	basecol=20;
	initialize();
	ISR_Setup(PCI3c.value&0xff);
	escquit=0xff;
	prstring ("ͻ",baserow+ 2,basecol, Attr_YE);
	prstring ("    Function         Test         ",baserow+ 3,basecol, Attr_YE);
	prstring ("͹",baserow+ 4,basecol, Attr_YE);
	prstring (" Internal    Loopback             ",baserow+ 5,basecol, Attr_YE);
	prstring (" ISR         Test                 ",baserow+ 6,basecol, Attr_YE);
	prstring (" CSR         Test                 ",baserow+ 7,basecol, Attr_YE);
	prstring (" EEPROM      Test                 ",baserow+ 8,basecol, Attr_YE);
	prstring (" Perfect     Test                 ",baserow+ 9,basecol, Attr_YE);
	prstring (" Inverse     Test                 ",baserow+10,basecol, Attr_YE);
	prstring (" Hash        Test                 ",baserow+11,basecol, Attr_YE);
	prstring (" HashOnly    Test                 ",baserow+12,basecol, Attr_YE);
	prstring (" Multi_PKT   Test                 ",baserow+13,basecol, Attr_YE);
	prstring (" Burst_Len   Test                 ",baserow+14,basecol, Attr_YE);
	prstring ("ͼ",baserow+15,basecol, Attr_YE);

	prstring ("ͻ",19,56, Attr_YE);
	prstring (" Test Step :         ",20,56, Attr_YE);
	prstring ("ͼ",21,56, Attr_YE);

	prstring("TEST",baserow+ 5,basecol+30,Attr_REF);
	if(loopback(CSR6_OM_INT)==PASS) 
		prstring("PASS",baserow+ 5,basecol+30,Attr_YE);
	else{
		prstring("FAIL",baserow+ 5,basecol+30,Attr_WE);
		prstring ("Press to Continue ... ",baserow+16,basecol+4, Attr_YEB);
		if(getch()==0x1b)  return(0);
		prstring ("                      ",baserow+16,basecol+4, Attr_YEB);
	}

	
	prstring("TEST",baserow+ 6,basecol+30,Attr_REF);
	if(ISR_test()==PASS)
		prstring("PASS",baserow+ 6,basecol+30,Attr_YE);
	else{
		prstring("FAIL",baserow+ 6,basecol+30,Attr_WE);
		prstring ("Press to Continue ... ",baserow+16,basecol+4, Attr_YEB);
		if(getch()==0x1b)  return(0);
		prstring ("                      ",baserow+16,basecol+4, Attr_YEB);
	}

	prstring("TEST",baserow+ 7,basecol+30,Attr_REF);
	if((csr0_test()==PASS)&&(csr34_test()==PASS)&&
	   (csr5_test()==PASS)&&(csr6_test()==PASS)&&
	   (csr7_test()==PASS)&&(csr8_test()==PASS)&&
	   (csr11_test()==PASS)&&(csr12_test()==PASS)&&
	   (csr15_test()==PASS))          
		prstring("PASS",baserow+ 7,basecol+30,Attr_YE);
	else{
		prstring("FAIL",baserow+ 7,basecol+30,Attr_WE);
		prstring ("Press to Continue ... ",baserow+16,basecol+4, Attr_YEB);
		if(getch()==0x1b)  return(0);
		prstring ("                      ",baserow+16,basecol+4, Attr_YEB);
	}

	prstring("TEST",baserow+8,basecol+30,Attr_REF);
	if(eeprom_test()==PASS)
		prstring("PASS",baserow+8,basecol+30,Attr_YE);
	else{
		prstring("FAIL",baserow+8,basecol+30,Attr_WE);
		prstring ("Press to Continue ... ",baserow+16,basecol+4, Attr_YEB);
		if(getch()==0x1b)  return(0);
		prstring ("                      ",baserow+16,basecol+4, Attr_YEB);
	}

	prstring("TEST",baserow+9,basecol+30,Attr_REF);
	if(perfect_test()==PASS)
		prstring("PASS",baserow+9,basecol+30,Attr_YE);
	else{
		prstring("FAIL",baserow+9,basecol+30,Attr_WE);
		prstring ("Press to Continue ... ",baserow+16,basecol+4, Attr_YEB);
		if(getch()==0x1b)  return(0);
		prstring ("                      ",baserow+16,basecol+4, Attr_YEB);
	}

	prstring("TEST",baserow+10,basecol+30,Attr_REF);
	if(inverse_test()==PASS)
		prstring("PASS",baserow+10,basecol+30,Attr_YE);
	else{
		prstring("FAIL",baserow+10,basecol+30,Attr_WE);
		prstring ("Press to Continue ... ",baserow+16,basecol+4, Attr_YEB);
		if(getch()==0x1b)  return(0);
		prstring ("                      ",baserow+16,basecol+4, Attr_YEB);
	}

	prstring("TEST",baserow+11,basecol+30,Attr_REF);
	if(hash_test()==PASS)
		prstring("PASS",baserow+11,basecol+30,Attr_YE);
	else{
		prstring("FAIL",baserow+11,basecol+30,Attr_WE);
		prstring ("Press to Continue ... ",baserow+16,basecol+4, Attr_YEB);
		if(getch()==0x1b)  return(0);
		prstring ("                      ",baserow+16,basecol+4, Attr_YEB);
	}

	prstring("TEST",baserow+12,basecol+30,Attr_REF);
	if(hash_only_test()==PASS)
		prstring("PASS",baserow+12,basecol+30,Attr_YE);
	else{
		prstring("FAIL",baserow+12,basecol+30,Attr_WE);
		prstring ("Press to Continue ... ",baserow+16,basecol+4, Attr_YEB);
		if(getch()==0x1b)  return(0);
		prstring ("                      ",baserow+16,basecol+4, Attr_YEB);
	}

	prstring("TEST",baserow+13,basecol+30,Attr_REF);
	if(oneP_nD_test()==PASS)
		prstring("PASS",baserow+13,basecol+30,Attr_YE);
	else{
		prstring("FAIL",baserow+13,basecol+30,Attr_WE);
		prstring ("Press to Continue ... ",baserow+16,basecol+4, Attr_YEB);
		if(getch()==0x1b)  return(0);
		prstring ("                      ",baserow+16,basecol+4, Attr_YEB);
	}

	prstring("TEST",baserow+14,basecol+30,Attr_REF);
	if(burstlength_test()==PASS)
		prstring("PASS",baserow+14,basecol+30,Attr_YE);
	else{
		prstring("FAIL",baserow+14,basecol+30,Attr_WE);
		prstring ("Press to Continue ... ",baserow+16,basecol+4, Attr_YEB);
		if(getch()==0x1b)  return(0);
		prstring ("                      ",baserow+16,basecol+4, Attr_YEB);
	}
	prstring ("Press Esc to Exit ...",baserow+16,basecol+4 , Attr_YEB);
	while (escquit) {
		if (kbhit()) {
			keycode_get();
			if (M_code==0x1b) {
				escquit=0;
				csr6shadow=temp;
				csr14shadow=temp1;
				initialize();
				ISR_restore();
			}
		}
	}
}
