/****************************************************************
 *
 * Copyright (C) 1995 Macronix International Corp.
 * MX98713 Diagnose and Test program.
 * pci.c + bmtx.c + decdiag.c + dwio.asm
 *
 * Revision History:
 * Date     Who                   Comments
 * 07/25/95 Luke Huang
 ******************************************************************/

#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <memory.h>
#include <malloc.h>
#include <time.h>
#include <ctype.h>
#include <stdlib.h>
#include "pci.h"

#define	POLY 	0x04c11db6

extern struct PCI_register   PCI00  ;
struct PCI_register   csr0 ={CSR0 ,0x00, 4,38,DWORD};
struct PCI_register   csr1 ={CSR1 ,0x00, 5,38,DWORD};
struct PCI_register   csr2 ={CSR2 ,0x00, 6,38,DWORD};
struct PCI_register   csr3 ={CSR3 ,0x00, 7,38,DWORD};
struct PCI_register   csr4 ={CSR4 ,0x00, 8,38,DWORD};
struct PCI_register   csr5 ={CSR5 ,0x00, 9,38,DWORD};
struct PCI_register   csr6 ={CSR6 ,0x00,10,38,DWORD};
struct PCI_register   csr7 ={CSR7 ,0x00,11,38,DWORD};
struct PCI_register   csr8 ={CSR8 ,0x00,12,38,DWORD};
struct PCI_register   csr9 ={CSR9 ,0x00,13,38,DWORD};
struct PCI_register   csr10={CSR10,0x00,14,38,DWORD};
struct PCI_register   csr11={CSR11,0x00,15,38,DWORD};
struct PCI_register   csr12={CSR12,0x00,16,38,DWORD};
struct PCI_register   csr13={CSR13,0x00,17,38,DWORD};
struct PCI_register   csr14={CSR14,0x00,18,38,DWORD};
struct PCI_register   csr15={CSR15,0x00,19,38,DWORD};
struct PCI_register   csr16={CSR16,0x00,20,38,DWORD};
struct PCI_register   csr17={CSR17,0x00,21,38,DWORD};
struct PCI_register   csr18={CSR18,0x00,22,38,DWORD};
struct PCI_register   csr19={CSR19,0x00,23,38,DWORD};
struct PCI_register   csr20={CSR20,0x00,24,38,DWORD};
struct PCI_register   csr21={CSR21,0x00,25,38,DWORD};
struct PCI_register   NIC_item[22];

extern long outpdw();
extern long inpdw();

extern struct PCI_register Intline;
extern struct PCI_register PCI08;
extern struct PCI_register VendorID;
extern unsigned int     iobase;
extern unsigned int  	csr12_io_def,	csr12_io_val;
extern unsigned char    hash[96];
extern unsigned char    perfect[96];
extern unsigned char    port;

unsigned int  pkt_size[6]={60,301,907,1211,1503,1514};
unsigned int  rxpkt_size[6]={0x600,0x600,0x600,0x600,0x600,0x600};
unsigned char dest_addr[6]={0,1,2,3,4,5};
unsigned char pkt_type[6]={'N','N','N','N','N','N'};
unsigned char pkt_patt[6]={0x55,0xaa,0x5a,0x0f,0x01,0xef};

unsigned char pic2eoi;
unsigned char mask_pic1;
unsigned char mask_pic2;
unsigned int  VecTblBase;
unsigned long intcount;
unsigned int  intflag;
unsigned char sa[8];
unsigned char far c46[128];
unsigned char active=0; 
char	      buffer[15];
char	      tx_pkt_num=6;
struct TX_RESOURCE      *tx_resource[NumTXBuffers];
struct RX_RESOURCE      *rx_resource[NumRXBuffers];
unsigned char           tx_temp[NumTXBuffers][sizeof(struct TX_RESOURCE )+6];
unsigned char           rx_temp[NumRXBuffers][sizeof(struct TX_RESOURCE )+6];
unsigned long int       miss_pkt,received_pkt,rof,rce,rdb,rrw,rft,rcs,rtl,rmf,rrf,rde,res;
unsigned long int       tx_pkt,tde,tuf,thf,tec,tlc,tnc,tlo,tto,tes,tcc;
unsigned long 		    csr0shadow,csr6shadow,csr16shadow,csr14shadow;
void (interrupt far *oldisr)();
FILE   *fd9;

network_diag()
{
	char  index=0;
	char  i,item;
	unsigned char  editmode;
	unsigned long	csr0temp,csr6temp;
						   
	csr0temp=csr0shadow;
	csr6temp=csr6shadow;
	item=6;
	editmode=1;
	prstring ("Ŀ", 8 , 30, Attr_BEB);
	prstring ("   Network  Diagnose    ", 9 , 30, Attr_BEB);
	prstring ("Ĵ",10 , 30, Attr_BEB);
	prstring (" Transmit Monitor       ",11 , 30, Attr_BEB);
	prstring (" Receive Monitor        ",12 , 30, Attr_BEB);
	prstring (" Ping-Pong Master Mode  ",13 , 30, Attr_BEB);
	prstring (" Ping-Pong Slave  Mode  ",14 , 30, Attr_BEB);
	prstring (" External loopback      ",15 , 30, Attr_BEB);
	prstring (" Internal loopback      ",16 , 30, Attr_BEB);
	prstring ("",17 , 30, Attr_BEB);
	prstring ("<Alt-H> - Help",18, 30, Attr_BEB);
	bar_one(11+index,31,24,Attr_BEBR);
	while(editmode){
		if(kbhit()){
			keycode_get();
			if(M_code==0){
				switch (A_code){
					case 0x23 :                         /*** Alt-h   ***/
						screen_store();
						network_diag_HPpanel();
						screen_restore();
						break;
					case 0x4b :                         /*** Cr LFT ***/
					case 0x48 :                         /*** Cr Up ***/
						bar_one(11+index,31,24,Attr_BEB);
						index--;
						if(index<0) index=item-1;
						bar_one(11+index,31,24,Attr_BEBR);
						break;
					case 0x4d :                         /*** Cr RGT ***/
					case 0x50 :                         /*** Cr Dn ***/
						bar_one(11+index,31,24,Attr_BEB);
						index++;
						if(index>=item) index=0;
						bar_one(11+index,31,24,Attr_BEBR);
						break;
					default   :
						break;
				}
			}
			else {
				switch (M_code)  {
					case 0x0d :                         /*** Enter ***/
						screen_store();
						switch (index)  {
							case 0 :
								bmtx_monitor();
								break;
							case 1 :
								bmrx_monitor();
								break;
							case 2 :
								loopback_monitor(0x00);
								break;
							case 3 :
								bmrxecho_monitor();
								break;
							case 4 :
								loopback_monitor(CSR6_OM_EXT);
								break;
							case 5 :
								loopback_monitor(CSR6_OM_INT);
								break;
							default: break;
						}
						csr0shadow=csr0temp;
						csr6shadow=csr6temp;
						screen_restore();
						break;
					case 0x1b :                         /*** ESC   ***/
						editmode=0;
						csr0shadow=csr0temp;
						csr6shadow=csr6temp;
						break;
					default   :
						break;
				}
			}
		}
	}
	fcloseall();
}

network_diag_HPpanel()
{
	prstring (" ͻ ",3  ,6, Attr_YE);
	prstring ("  Transmit Monitor:                                    ",4  ,6, Attr_YE);
	prstring ("  Transmit 6 consecutive packets repeatly.             ",5  ,6, Attr_YE);
	prstring ("  transmit condition: CAL=8 , TAP=01 , CSR6_SF         ",6  ,6, Attr_YE);
	prstring ("                                                       ",7  ,6, Attr_YE);
	prstring ("  Receive Monitor:                                     ",8  ,6, Attr_YE);
	prstring ("  Receive all packets in the network, and place them   ",9  ,6, Attr_YE);
	prstring ("  into 6 consecutive RX buffers.                       ",10 ,6, Attr_YE);
	prstring ("  Accumulate the error status.                         ",11 ,6, Attr_YE);
	prstring ("  Receive condition: CSR6_PB,CSR6_PR,CSR6_PM           ",12 ,6, Attr_YE);
	prstring ("                                                       ",13 ,6, Attr_YE);
	prstring ("  Ping-Pong Master Mode:                               ",14 ,6, Attr_YE);
	prstring ("  This selection forces adapter to send out packets    ",15 ,6, Attr_YE);
	prstring ("  and wait for echo. After receiving the echo,         ",16 ,6, Attr_YE);
	prstring ("  compare them and accumulate the error status. To do  ",17 ,6, Attr_YE);
	prstring ("  this, a responcer is needed in the network.          ",18 ,6, Attr_YE);
	prstring ("                                                       ",19 ,6, Attr_YE);
	prstring ("  Ping-Pong Slave Mode:                                ",20 ,6, Attr_YE);
	prstring ("  As a network responcer, it echoes all received       ",21 ,6, Attr_YE);
	prstring ("  packets.                                             ",22 ,6, Attr_YE);
	prstring (" ͼ ",23 ,6, Attr_YE);
	while(!kbhit());
	keycode_get();
}

InitializeTheTransmitRing()
{

	unsigned int            i,j;
	unsigned long           physicaladdress;

	for( i=0 ; i<NumTXBuffers ; i++ ){
		/* memory allocation for tx descriptor_buffer  (allign 4)  */
	 	tx_resource[i]=(struct TX_RESOURCE  *)((((unsigned int )tx_temp[i])+4)& 0xfffc);
	}

	for( i=0 ; i<NumTXBuffers ; i++ ){
		/* initialize the own bit to host     tdes0 */
		tx_resource[i]->ownership=0x00;
		tx_resource[i]->tstatus=0x0000;
		tx_resource[i]->tdes0_unused=0x00;
		
		/* fill buffer_1_address              tdes2*/
		get_ea((void far *)(tx_resource[i]->tx_buffer_data),&physicaladdress);
		tx_resource[i]->buff_1_addr=physicaladdress;
		
		/* fill buffer_2_address              tdes3*/
		if(i==NumTXBuffers-1) j=0;
		else  j=i+1;
		get_ea((void far *)tx_resource[j],&physicaladdress);
		tx_resource[i]->buff_2_addr=physicaladdress;
	}
}

InitializeTheReceiveRing()
{
	unsigned int            i,j;
	unsigned long           physicaladdress;

	for( i=0 ; i<NumRXBuffers ; i++ ){
		/* memory allocation for tx descriptor_buffer  (allign 4)  */
		rx_resource[i]=(struct RX_RESOURCE  *)((((unsigned int )rx_temp[i])+4) & 0xfffc);
	}
	
	for( i=0 ; i<NumRXBuffers ; i++ ){
		/* set own bit to chip     rdes0  */
		rx_resource[i]->frame_length=RDES0_OWN_BIT;
		rx_resource[i]->rstatus=0x0000;
		
		/* fill                    rdes1  */
		rx_resource[i]->command=RDES1_BUFF-RX_BUFFER_SIZE+rxpkt_size[i];
		
		/* fill buffer_1_address   rdes2  */
		get_ea((void far *)(rx_resource[i]->rx_buffer_data),&physicaladdress);
		rx_resource[i]->buff_1_addr=physicaladdress;
		
		/* fill buffer_2_address   rdes3  */
		if(i==NumRXBuffers-1) j=0;
		else          j=i+1;
		get_ea((void far *)rx_resource[j],&physicaladdress);
		rx_resource[i]->buff_2_addr=physicaladdress;
	}
}


initialize()
{
	unsigned long  physicaladdress;
	unsigned int 	i;
	InitializeTheTransmitRing ();
	InitializeTheReceiveRing ();
	NIC_read_reg(&csr6);
	NIC_write_reg(&csr6,csr6.value&(~(CSR6_SR|CSR6_ST)));
	delay(10);
	NIC_write_reg(&csr0,CSR0_L_SWR);
	delay(2);
	NIC_write_reg(&csr0,csr0shadow);
	get_ea((void far *)rx_resource[0],&physicaladdress);
	NIC_write_reg(&csr3,physicaladdress);
	get_ea((void far *)tx_resource[0],&physicaladdress);
	NIC_write_reg(&csr4,physicaladdress);
	if((PCI00.value&0xffff)==0x1011) {
		NIC_write_reg(&csr12,csr12_io_def);
		NIC_write_reg(&csr12,csr12_io_val);
	}

	if(((PCI08.value&0xff) >= 0x10)&&((PCI00.value&0xffff)==0x10d9)) {
		NIC_read_reg(&csr6);
		NIC_write_reg(&csr6,csr6.value|CSR6_PS);
		NIC_write_reg(&csr14,(unsigned long)0xfffffffb);
		delay(100);
		NIC_write_reg(&csr14,(unsigned long)0xffffffff);
		NIC_write_reg(&csr14,csr14shadow);
	}
	NIC_write_reg(&csr16,csr16shadow);
	delay(1);
	NIC_write_reg(&csr6,csr6shadow);
	NIC_write_reg(&csr5,(unsigned long)0xffffffff);     //Clear status register
	delay(1);
	NIC_read_reg(&csr6);

	for(i=0;i<6;i++)      perfect[i]=sa[i];
	setup_frame(TDES1_SETUP_LAST,perfect);
	delay(5);
}


get_ea(
void far *address,
unsigned long int  *ea)
{
	*ea=((unsigned long int)FP_SEG(address)<<4)+FP_OFF(address);
}

fill_custom_pattern()
{
	FILE *fd2;
	unsigned int k;
	unsigned int desc_num,last_desc_bytes;
	unsigned char ch;
	fd2=fopen("custom.pkt","rw");     //   Load killer.pkt data
	if (fd2==NULL) {
		prstring(" Custom.pkt not found!",10,30,Attr_YEBF);
		getch();
		return(0);
	}
	k=0;
	while( fscanf(fd2,"%x",&ch) != EOF){
		if( (k/1500) > 5 ) break;
		tx_resource[(k/1500)]->tx_buffer_data[(k%1500)]=ch;
		k++;
	}
	fclose(fd2);
	desc_num = k/1500+1;
	last_desc_bytes = k%1500;
	if(desc_num<=1){
		tx_resource[0]->command=TDES1_BUFF|TDES1_TER_BIT|last_desc_bytes;
	} else{
		tx_resource[0]->command=TDES1_BUFF_FS+1500;
		for(k=1;k<desc_num-1;k++)
			tx_resource[k]->command=TDES1_BUFF_MI+1500;
		tx_resource[desc_num-1]->command=TDES1_BUFF_LS|TDES1_TER_BIT|last_desc_bytes;
	}
	for(k=0;k<desc_num;k++)
		tx_resource[k]->ownership=TDES0_OWN_BIT;
//	tx_pkt_num=desc_num;
}



fill_pattern(pkt_number)
unsigned char pkt_number;
{
	unsigned int i,j;
	for(j=0;j<pkt_number;j++) {
		for(i=0 ;i<TEST_PKT_SIZE;i++){
			if(i%2 == 0)
				tx_resource[j]->tx_buffer_data[i]=0x5a;
			else
				tx_resource[j]->tx_buffer_data[i]=0x0f;
		}
		tx_resource[j]->command=TDES1_BUFF+i;
		tx_resource[j]->ownership=TDES0_OWN_BIT;
	}
	tx_resource[pkt_number-1]->command += TDES1_TER_BIT;
}

fill_txbuffer0(size,pattern)
unsigned int size;
unsigned char pattern;
{
	unsigned int i;
	for(i=0 ;i<6;i++)       //da
		tx_resource[0]->tx_buffer_data[i]=dest_addr[i];
	for(i=6 ;i<12;i++)	    //sa
		tx_resource[0]->tx_buffer_data[i]=sa[i-6];
	for(i=12 ;i<size;i++) {
		if(pattern==VARIABLE){
			if( i%0x100 == 0x00)
				tx_resource[0]->tx_buffer_data[i]=0xff;
			else
				tx_resource[0]->tx_buffer_data[i]=i;
		}
		else
			tx_resource[0]->tx_buffer_data[i]=pattern;
	}
	tx_resource[0]->command = TDES1_BUFF|TDES1_TER_BIT|(unsigned long)size;
	tx_resource[0]->ownership=TDES0_OWN_BIT;
}



setup_frame(setup_type,setup_packet)
unsigned long setup_type;
unsigned char *setup_packet;
{
	unsigned int    i;
	for(i=0;i<96;i++)
		tx_resource[0]->tx_buffer_data[i*2-i%2] = *(setup_packet+i);
	tx_resource[0]->command=setup_type;
	tx_resource[0]->ownership=TDES0_OWN_BIT;
	NIC_write_reg(&csr1,0xff);
	delay(20);
	NIC_read_reg(&csr6);
	delay(20);
}


txrx_monitor_menu()
{
	char i;
	cll(0,0,79,24);
	prstring ("                                                                               ", 0 , 0, Attr_N);
	prstring ("   Ŀ   ", 1 , 0, Attr_N);
	prstring ("            Transmit And Compare With Echo Back Diagnose                     ", 2 , 0, Attr_N);
	prstring ("   Ĵ   ", 3 , 0, Attr_N);
	prstring ("    Transmited Packet Status           Received Packet Status               ", 4 , 0, Attr_N);
	prstring ("                                                                            ", 5 , 0, Attr_N);
	prstring ("    1. Transmit Packet   :             1. Packet Received  :                ", 6 , 0, Attr_N);
	prstring ("    2. Deferred          :             2. FIFO Overflow    :                ", 7 , 0, Attr_N);
	prstring ("    3. Underflow         :             3. CRC Error        :                ", 8 , 0, Attr_N);
	prstring ("    4. Heartbeat_Fail    :             4. Dribbling Bit    :                ", 9 , 0, Attr_N);
	prstring ("    5. Exec_Collisions   :             5. Rx_Watchdog_Jab. :                ",10 , 0, Attr_N);
	prstring ("    6. Late_Collision    :             6  Ethernet Frame   :                ",11 , 0, Attr_N);
	prstring ("    7. No_Carrier        :             7. Collision Seen   :                ",12 , 0, Attr_N);
	prstring ("    8. Loss_Of_Carrier   :             8. Frame_Too_Long   :                ",13 , 0, Attr_N);
	prstring ("    9. Tx_Jabber_Timeout :             9. Multicast Frame  :                ",14 , 0, Attr_N);
	prstring ("   10. Error_Summary     :            10. Runt_Frame       :                ",15 , 0, Attr_N);
	prstring ("   11. Collision_Count   :            11. Descriptor Error :                ",16 , 0, Attr_N);
	prstring ("   **  Non_Echo_Packets  :            12. Error Summary    :                ",17 , 0, Attr_N);
	prstring ("   **  String_Cmp_Error  :            13. Missed Packet    :                ",18 , 0, Attr_N);
	prstring ("   **  Tx_Time_Out       :            **  Echo_Time_Out    :                ",19 , 0, Attr_N);
	prstring ("   Ĵ   ",20 , 0, Attr_N);
	prstring ("   Src.  Address :                     Port:                                 ",21 , 0, Attr_N);
	prstring ("   Dest. Address :                                                           ",22 , 0, Attr_N);
	prstring ("      ",23 , 0, Attr_N);
	prstring ("                                                                               ",24 , 0, Attr_N);
	received_pkt=0;   miss_pkt=0;   tx_pkt=0;
	tde=0;	tuf=0;	thf=0;
	tec=0;	tlc=0;	tnc=0;
	tlo=0;	tto=0;	tes=0;
	tcc=0;	rof=0;	rce=0;
	rdb=0;	rrw=0;	rft=0;
	rcs=0;	rtl=0;	rmf=0;
	rrf=0;	rde=0;	res=0;
	switch(port) {
		case 'Y': prstring ("SYM       ",21,47, Attr_YEB  ); break;
		case 'M': prstring ("MII       ",21,47, Attr_BEB  ); break;
		case 'A': prstring ("AutoSense ",21,47, Attr_YEB); break;
		case 'B': prstring ("100FD     ",21,47, Attr_YEB); break;
		case 'C': prstring ("100HD     ",21,47, Attr_YEB); break;
		case 'D': prstring ("10FD      ",21,47, Attr_YEB); break;
		case 'E': prstring ("10HD      ",21,47, Attr_YEB); break;
		default : break;
	}
	gotoxy(21,20);
	for(i=0;i<6;i++)	printf("%02x ",sa[i]);
}

tx_error_detect(unsigned int status)
{
	tx_pkt++;
	if(status & TDES0_DE    )  tde++;
	if(status & TDES0_UF    )  tuf++;
	if(status & TDES0_HF    )  thf++;
	if(status & TDES0_EC	)  tec++;
	if(status & TDES0_LC	)  tlc++;
	if(status & TDES0_NC    )  tnc++;
	if(status & TDES0_LO    )  tlo++;
	if(status & TDES0_TO    )  tto++;
	if(status & TDES0_ES    )  tes++;
	tcc += (status & TDES0_CC_MASK )>>3 ;
	gotoxy(6, 28);       printf("%ld",tx_pkt);
	gotoxy(7, 28);       printf("%ld",tde);
	gotoxy(8, 28);       printf("%ld",tuf);
	gotoxy(9, 28);       printf("%ld",thf);
	gotoxy(10,28);       printf("%ld",tec);
	gotoxy(11,28);       printf("%ld",tlc);
	gotoxy(12,28);       printf("%ld",tnc);
	gotoxy(13,28);       printf("%ld",tlo);
	gotoxy(14,28);       printf("%ld",tto);
	gotoxy(15,28);       printf("%ld",tes);
	gotoxy(16,28);       printf("%ld",tcc);
}

rx_error_detect(unsigned int  status)
{
	char ch;
	received_pkt++;
	if(status & RDES0_OF  )  rof++;
	if(status & RDES0_CE  )  rce++;
	if(status & RDES0_DB  )  rdb++;
	if(status & RDES0_RW  )  rrw++;
	if(status & RDES0_FT  )  rft++;
	if(status & RDES0_CS  )  rcs++;
	if(status & RDES0_TL  )  rtl++;
	if(status & RDES0_MF  )  rmf++;
	if(status & RDES0_RF  )  rrf++;
	if(status & RDES0_DE  )  rde++;
	if(status & RDES0_ES  )  res++;
	NIC_read_reg(&csr8);
	if(csr8.value&0x010000)
		prstring("Mis_Frame counter overflow !",22,35,Attr_R);
	else
		miss_pkt += csr8.value&0x0ffff;
	gotoxy(6, 63);       printf("%ld",received_pkt);
	gotoxy(7, 63);       printf("%ld",rof);
	gotoxy(8, 63);       printf("%ld",rce);
	gotoxy(9, 63);       printf("%ld",rdb);
	gotoxy(10,63);       printf("%ld",rrw);
	gotoxy(11,63);       printf("%ld",rft);
	gotoxy(12,63);       printf("%ld",rcs);
	gotoxy(13,63);       printf("%ld",rtl);
	gotoxy(14,63);       printf("%ld",rmf);
	gotoxy(15,63);       printf("%ld",rrf);
	gotoxy(16,63);       printf("%ld",rde);
	gotoxy(17,63);       printf("%ld",res);
	gotoxy(18,63);       printf("%ld",miss_pkt);
}



bmrx_monitor()
{
	unsigned char editmode,i,j;
	unsigned long physicaladdress;
	struct RX_RESOURCE   *rcv_pointer;
	initialize();
	txrx_monitor_menu();
	NIC_write_reg(&csr6,csr6.value|CSR6_PB|CSR6_PR|CSR6_PM);
	prstring ("                           Receive  Monitor                              ", 2 , 2, Attr_N);
	prstring ("  <ESC>-Exit                                                               ",24 , 2, Attr_N);
	for(i=4; i<20 ; i++)  for(j=40; j<75 ; j++) pattrib (i,j,Attr_YE);
	rcv_pointer= rx_resource[0];
	j=0;
	editmode=1;
	while (editmode)   {

		/* if data received */
		if(( rcv_pointer->frame_length & 0x8000 )==0)  {
			j++;
			j %= 6;
			if(rcv_pointer->rstatus & RDES0_LS )
			rx_error_detect(rcv_pointer->rstatus);
			rcv_pointer->frame_length|=0x8000;
			rcv_pointer= rx_resource[j];
			get_ea((void far *)rx_resource[j],&physicaladdress);
			gotoxy(4,66);
			printf("%lx",physicaladdress);
		}
		if (kbhit())  {
			keycode_get();
			if (M_code!=0)  {
				switch (M_code) {
					case 0x1b :                         /*** ESC   ***/
						editmode=0;
						cll(0,0,79,24);
						break;
					default   : break;
				}
			}
		}
	}  /* while loop */
}
	
	

bmtx_monitor()
{
	unsigned char editmode,i,j,ch,k;
	unsigned long physicaladdress;
	struct TX_RESOURCE	*tx_pointer;
	NIC_write_reg(&csr1,0xff); 
	initialize();
	NIC_write_reg(&csr1,0xff); 
	txrx_monitor_menu();
	gotoxy(22,20);
	for(i=0;i<6;i++)	printf("%02x ",dest_addr[i]);
	prstring ("                     Transmit  Monitor                                   ", 2 , 2, Attr_N);
	prstring (" <ESC>-Exit  <SPC>-Start/Stop Transmit                                     ",24 , 2, Attr_N);
	for(i=4; i<20 ; i++)   for(j=4; j<39 ; j++)       pattrib (i,j,Attr_YE);
	fill_pattern(6);								// fill pattern
	NIC_write_reg(&csr6,csr6.value&(~CSR6_ST));		// stop
	NIC_read_reg(&csr6);
	NIC_write_reg(&csr6,csr6.value|CSR6_SF);// store and forward
	NIC_read_reg(&csr0);
	NIC_write_reg(&csr0,csr0.value|0x020000);		// TAP=01

	tx_pointer= tx_resource[0];
	j=0;
	k=0;
	editmode=1;
	while (editmode)   {
	
		if( (tx_pointer->ownership & 0x80 )==0 )  {
			j++;
			j %= tx_pkt_num;
			if (tx_pointer->command & TDES1_LS_BIT )
			tx_error_detect(tx_pointer->tstatus);
			tx_pointer->ownership |= 0x80 ;
			tx_pointer= tx_resource[j];
			get_ea((void far *)tx_resource[j],&physicaladdress);
			gotoxy(4,31);
			printf("%lx",physicaladdress);
		}
		if (kbhit()) {
			keycode_get();
			if (M_code!=0)  {
				switch (M_code)  {
					case 0x1b :                         /*** ESC   ***/
						editmode=0;
						cll(0,0,79,24);
						break;
					case 0x20 :
						NIC_read_reg(&csr6);          // CSR6_ST switch
						NIC_write_reg(&csr6,csr6.value^CSR6_ST);
						break;
					default   :
						break;
				}
			}
		}
	}  /* while loop */
}


bmrxecho_monitor()
{
	unsigned char editmode,j,da[6],timeout,brocast_flag,k;
	unsigned int  tx_pkt_size,temp,i;
	unsigned long physicaladdress,echo_time_out;
	struct RX_RESOURCE    *rcv_pointer;
	
	setup_frame(TDES1_SETUP_LAST,hash);              // add to clear fifo
	initialize();
	csr6shadow |= CSR6_SF|CSR6_PB;
	NIC_write_reg(&csr6,csr6shadow); 
	fill_txbuffer0(0x5f0,VARIABLE);
	
	txrx_monitor_menu();
	prstring ("                  Ping-Pong Slave Mode                                   ", 2 , 2, Attr_N);
	prstring ("  <ESC>-Exit                                                               ",24 , 2, Attr_N);
	for(i=4; i<20 ; i++)  for(j=4 ; j<39 ; j++)     pattrib (i,j,Attr_WE);
	for(i=4; i<20 ; i++)  for(j=40; j<75 ; j++)     pattrib (i,j,Attr_YE);
	
	rcv_pointer= rx_resource[0];
	get_ea((void far *)tx_resource[0],&physicaladdress);
	gotoxy(4,31);
	printf("%lx",physicaladdress);
	get_ea((void far *)rx_resource[0],&physicaladdress);
	gotoxy(4,66);
	printf("%lx",physicaladdress);
	editmode=1;
	j=0;
	k=0;
	echo_time_out=0;
	while (editmode)  {
	
		/* if data received */
		if(( rcv_pointer->frame_length & 0x8000 )==0)  {
			brocast_flag = 0xff;
			for(i=0;i<6;i++) 
				brocast_flag &= rcv_pointer->rx_buffer_data[i];
			
			if(brocast_flag!=0xff) 
			   	rx_error_detect(rcv_pointer->rstatus);
					
			/* echo back the received data */
			tx_pkt_size = rcv_pointer->frame_length-4;
					
			/* exchange source and destination address */
			gotoxy(22,20);
			for(i=0;i<6;i++) {
				rcv_pointer->rx_buffer_data[i]=rcv_pointer->rx_buffer_data[i+6];
				printf("%02x ",rcv_pointer->rx_buffer_data[i+6]);
			}
			for(i=6;i<12;i++)
				rcv_pointer->rx_buffer_data[i]=sa[i-6];
					
			tx_resource[0]->command=(TDES1_BUFF|TDES1_TER_BIT)+tx_pkt_size;
			get_ea((void far *)rcv_pointer->rx_buffer_data,&physicaladdress);
			tx_resource[0]->buff_1_addr=physicaladdress;
			tx_resource[0]->ownership=TDES0_OWN_BIT;
			/* issue echo command */
			NIC_write_reg(&csr1,0xff);
					
			/* waiting for echo complete */
			timeout = 0;
			i=0;
			while (!timeout)  {
				i++;
				delay(1);
				if ((tx_resource[0]->ownership & TDES0_OWN_BIT)==0x00) break;
				if (i >= 50) {
					echo_time_out++;
					timeout = 1;
					gotoxy(19,63);
					printf("%ld",echo_time_out);
				}
			}
			if( (timeout!=1) && (brocast_flag!=0xff) )
				tx_error_detect((unsigned int)tx_resource[0]->tstatus);

			j++;
			j %= 6;
			rcv_pointer->frame_length|=0x8000;
			rcv_pointer= rx_resource[j];
			get_ea((void far *)rx_resource[j],&physicaladdress);
			gotoxy(4,66);
			printf("%lx",physicaladdress);
		}//	end of data received

		if (kbhit()) {
			keycode_get();
			if (M_code!=0)  {
				switch (M_code)  {
					case 0x1b :                         /*** ESC   ***/
						editmode=0;
						cll(0,0,79,24);
						break;
					default   :
						break;
				}
			}
		}
	}  /* end of while loop */
}		
		
		
loopback_monitor(unsigned long mode)
{
	unsigned char editmode,timeout,txmode,i,j,da[6],length_chg_flag,ch,errorpage;
	unsigned int tx_pkt_length=60;
	unsigned long physicaladdress,non_echo_num,tx_time_out,str_cmp_err,t1,t2;
	struct RX_RESOURCE    *rcv_pointer;

	initialize();
	txrx_monitor_menu();
	switch (mode)  {
		case CSR6_OM_EXT : 
			csr6shadow |= CSR6_SF|CSR6_FD|mode;
			NIC_write_reg(&csr6,csr6shadow); 
			prstring ("                  External loopback Diagnose              pkt_len        ", 2 , 2, Attr_N);
			break;
		case CSR6_OM_INT : 
			csr6shadow |= CSR6_SF|CSR6_FD|mode;
			NIC_write_reg(&csr6,csr6shadow); 
			prstring ("                  Internal loopback Diagnose              pkt_len        ", 2 , 2, Attr_N);
			if(((PCI08.value&0xff) >= 0x20)&&((PCI00.value&0xffff)==0x10d9)&&(port=='A')) {
				prstring ("                                          ",11 ,18, Attr_YEBF);
				prstring ("    This Test Item is Invalid,            ",12 ,18, Attr_YEBF);
				prstring ("    Please select a Connection Speed !    ",13 ,18, Attr_YEBF);
				prstring ("                                          ",14 ,18, Attr_YEBF);
				getch();
				return(0);
			}
			break;
		default:
			csr6shadow |= CSR6_SF;
			NIC_write_reg(&csr6,csr6shadow); 
			prstring ("                  Ping-Pong Master Mode Diagnose          pkt_len        ", 2 , 2, Attr_N);
			break;
	}
	prstring (" <ESC> - Exit  <SPC> - Start/Stop Transmit                                 ",24 , 2, Attr_N);
	for(i=4; i<20 ; i++)   for(j=4; j<39 ; j++)        pattrib (i,j,Attr_YE);
	for(i=4; i<20 ; i++)   for(j=40;j<75 ; j++)        pattrib (i,j,Attr_WE);
	
	non_echo_num=0;
	tx_time_out=0;
	str_cmp_err=0;
	rcv_pointer= rx_resource[0];
	get_ea((void far *)tx_resource[0],&physicaladdress);
	gotoxy(4,31);
	printf("%lx",physicaladdress);
	get_ea((void far *)rx_resource[0],&physicaladdress);
	gotoxy(4,66);
	printf("%lx",physicaladdress);
	j=0;
	editmode=1;
	txmode=0;
	while (editmode)  {
		if(txmode) {
			tx_pkt_length= random_pkt_length_get();
		   	gotoxy(2,69);
		   	printf("%5d",tx_pkt_length);
			tx_resource[0]->tx_buffer_data[13]=tx_pkt_length & 0xff;
			tx_resource[0]->tx_buffer_data[12]=(tx_pkt_length>>8) & 0xff;
			tx_resource[0]->command &= (unsigned long)0xffff0000;
			tx_resource[0]->command += (unsigned long)tx_pkt_length;
			tx_resource[0]->ownership = TDES0_OWN_BIT;
			
			/* issue tx command */
			NIC_write_reg(&csr1,0xff);
			
			/* waiting for tx complete */
			t1=clock();
			timeout = 0;
			while (!timeout)  {
				if ((tx_resource[0]->ownership & TDES0_OWN_BIT)==0x00) break;
				t2 = clock();
				if ( t2-t1 > 500 ) {
					tx_time_out++;
					timeout = 1;
					gotoxy(19,28);
					printf("%ld",tx_time_out);
					tx_pkt++;
					gotoxy(6, 28);       
					printf("%ld",tx_pkt);
		  		}
			}
			if(timeout!=1)
				tx_error_detect(tx_resource[0]->tstatus);
			
				/* waiting for receive */
			t1=clock();
			timeout = 0;
			while (!timeout)  {
				if ( (rcv_pointer->frame_length & 0x8000)==0) break;
				t2=clock();
				if ( t2-t1 > 900 ) {
					non_echo_num++;
					timeout = 1;
					gotoxy(17,28);
					printf("%ld",non_echo_num);
				} 	
			}
				
				/* data received  */
			if(timeout!=1)  {
				if(rcv_pointer->rstatus & RDES0_LS ){
					rx_error_detect(rcv_pointer->rstatus);
					if(strncmp_test(&rcv_pointer->rx_buffer_data[12],&tx_resource[0]->tx_buffer_data[12],rcv_pointer->frame_length - 16) != 2000){
						str_cmp_err++;
						gotoxy(18,28);
						printf("%ld",str_cmp_err);
					}
				}
				while((rcv_pointer->frame_length & 0x8000)==0){
					rcv_pointer->frame_length|=0x8000;
					j++;
					j %= 6;
					rcv_pointer= rx_resource[j];
				}
				get_ea((void far *)rx_resource[j],&physicaladdress);
				gotoxy(4,66);
				printf("%lx",physicaladdress);
			}
		}
		if (kbhit()) {
			keycode_get();
			if (M_code!=0)  {
				switch (M_code)  {
					case 0x1b :                         /*** ESC   ***/
						editmode=0;
						cll(0,0,79,24);
						break;
					case 0x20 :
						if(txmode==0) {
							txmode=1;
							i=0;
							fill_pattern(6);
							NIC_write_reg(&csr1,0xff);
							while(detect_responcer_address(da)==FAIL) {
								i++;
								if(i>5){
									prstring (" No Responcer !! ",21 ,54, Attr_YEBF);
									while(!kbhit());
									keycode_get();
									editmode=0;
									break;
								}
							}
					   		initialize();
					   		delay(2000);
							csr6shadow |= CSR6_PB;
							NIC_write_reg(&csr6,csr6shadow);    
							fill_txbuffer0(1514,VARIABLE);
							gotoxy(22,20);
							for(i=0;i<6;i++){ 
								tx_resource[0]->tx_buffer_data[i]=da[i];
								printf("%02x ",da[i]);
							}
						} else{
							while(!kbhit());
							keycode_get();
							if(M_code==0x1b){
								editmode=0;
					   			cll(0,0,79,24);
							}
					   	}
						break;
					default   : break;
				}
			}
		}
	}  /* while loop */
}

strncmp_test(
unsigned char *rxdata,
unsigned char *txdata,
unsigned int  bytecount)
{
	unsigned int i;
	for(i=0;i<bytecount;i++){
		if( *(rxdata+i) != *(txdata+i) )
			return(i);
	}
	return(2000);
}

random_pkt_length_get()
{
	unsigned int rand_temp;
	rand_temp = rand();
	rand_temp = (unsigned long)(rand_temp%1455 + 60);
	return(rand_temp);
}


detect_responcer_address(da)
char *da;
{
	unsigned char i;
	unsigned int j=0;

	initialize();
	while(1){
		j++;
		fill_txbuffer0(0x80,VARIABLE);
		for( i=0 ; i<6 ; i++ )   tx_resource[0]->tx_buffer_data[i]=0xff;
		/* issue tx command */
		NIC_write_reg(&csr1,0xff);
		delay(10);
		
		/* waiting for receive */
		if ((rx_resource[0]->frame_length & RDES0_OWN_BIT)!=RDES0_OWN_BIT) {
			for(i=0;i<6;i++) *(da+i)=rx_resource[0]->rx_buffer_data[i+6];
			return(PASS);
		}
		if(j>200)
			return(FAIL);
	}
}


/******************************************************************
 Assume the NIC_item[n] to be the Registers
******************************************************************/
NIC_matrix_reg_assign(unsigned char direction)
{
	if(direction==FORWARD){
		NIC_item[0]  = csr0   ;	       NIC_item[8]  = csr8   ;
		NIC_item[1]  = csr1   ;	       NIC_item[9]  = csr9   ;
		NIC_item[2]  = csr2   ;	       NIC_item[10] = csr10  ;
		NIC_item[3]  = csr3   ;	       NIC_item[11] = csr11  ;
		NIC_item[4]  = csr4   ;	       NIC_item[12] = csr12  ;
		NIC_item[5]  = csr5   ;	       NIC_item[13] = csr13  ;
		NIC_item[6]  = csr6   ;	       NIC_item[14] = csr14  ;
		NIC_item[7]  = csr7   ;	       NIC_item[15] = csr15  ;
		NIC_item[16] = csr16  ;	       NIC_item[17] = csr17  ;
		NIC_item[18] = csr18  ;	       NIC_item[19] = csr19  ;
		NIC_item[20] = csr20  ;	       NIC_item[21] = csr21  ;
	}
	else{
		csr0  =	NIC_item[0]  ;	    csr8    =	NIC_item[8]  ;
		csr1  =	NIC_item[1]  ;	    csr9    =	NIC_item[9]  ;
		csr2  =	NIC_item[2]  ;	    csr10   =	NIC_item[10] ;
		csr3  =	NIC_item[3]  ;	    csr11   =	NIC_item[11] ;
		csr4  =	NIC_item[4]  ;	    csr12   =	NIC_item[12] ;
		csr5  =	NIC_item[5]  ;	    csr13   =	NIC_item[13] ;
		csr6  =	NIC_item[6]  ;	    csr14   =	NIC_item[14] ;
		csr7  =	NIC_item[7]  ;	    csr15   =	NIC_item[15] ;
		csr16 =	NIC_item[16] ;	    csr17   =	NIC_item[17] ;
		csr18 =	NIC_item[18] ;	    csr19   =	NIC_item[19] ;
		csr20 =	NIC_item[20] ;	    csr21   =	NIC_item[21] ;
	}
}

interrupt far csr56()
{
	if(active) return(0);
	active=1;
	intcount++;
	delay(2);
	NIC_read_reg(&NIC_item[5]);
	csr5 = NIC_item[5]  ;
	intflag=0xefef;
	NIC_write_reg(&csr5,0xffffffff);	 //Clear status register
	if(pic2eoi)
	outp (PIC_2, EOI);
	outp (PIC_1, EOI);
	active=0;
}


/******************************************************************
*  NIC register write
*******************************************************************/
NIC_write_reg(
struct PCI_register *registers,
unsigned long int value)
{
	outpdw(iobase+(registers->offset),value);
}

/******************************************************************
*  NIC register read
*******************************************************************/
NIC_read_reg(registers)
struct PCI_register *registers;
{
	registers->value=inpdw(iobase+(registers->offset));
}

/***********************************************************
ISR setup procedure
**********************************************************/
ISR_Setup (unsigned char irqline)
{
	unsigned char far *pc_at;
	unsigned char irqlevel;
	unsigned char temp;
	pc_at = PCAT;
	irqlevel=irqline;
	if ((irqlevel == 2) && (*pc_at == 0xfc)) irqlevel = 9;
	if (irqlevel < 8){
		VecTblBase = 0x08+irqlevel;	   /* IRQ 2 -> INT 0x0A */
		pic2eoi =0x00;
	}
	else{
		VecTblBase = 0x70+irqlevel-8;	    /* IRQ 8 -> INT 0x70 */
		irqlevel -= 8;
		pic2eoi =0xff;
	}
	_disable ();
	oldisr = _dos_getvect (VecTblBase);
	_dos_setvect (VecTblBase, csr56);
	mask_pic1 = inp (PIC_1+1);	     // Turn On PIC1
	temp = mask_pic1;
	temp &=  ~(1 << irqlevel);
	outp ( (PIC_1+1) , temp);
	if(pic2eoi){			 // Turn On PIC2
		mask_pic2 = inp (PIC_2+1);
		temp = mask_pic2;
		temp &= ~(1 << irqlevel);
		outp ((PIC_2+1), temp);
	}
	_enable ();
}

/***********************************************************
ISR Restore procedure
**********************************************************/
ISR_restore ()
{
	_disable ();
	_dos_setvect (VecTblBase, oldisr);
	if(pic2eoi)
		outp (PIC_2+1, mask_pic2);
	outp (PIC_1+1, mask_pic1);
	_enable ();
}


eeprom_HPanel()
{																	 
	prstring (" ͻ ",4  ,10, Attr_YE);
	prstring ("          EEPROM Access Help Description        ",5  ,10, Attr_YE);
	prstring (" ͹ ",6  ,10, Attr_YE);
	prstring ("                                                ",7  ,10, Attr_YE);
	prstring ("  Dump EEPROM:                                  ",8  ,10, Attr_YE);
	prstring ("      Dump the content of EEPROM.               ",9  ,10, Attr_YE);
	prstring ("                                                ",10 ,10, Attr_YE);
	prstring ("  Edit C46.PKT:                                 ",11 ,10, Attr_YE);
	prstring ("      Edit file c46.pkt.                        ",12 ,10, Attr_YE);
	prstring ("                                                ",13 ,10, Attr_YE);
	prstring ("  Upload C46.PKT to EEPROM:                     ",14 ,10, Attr_YE);
	prstring ("      Write EEPROM by c46.pkt content.          ",15 ,10, Attr_YE);
	prstring ("                                                ",16 ,10, Attr_YE);
	prstring ("  Download EEPROM to C46.PKT:                   ",17 ,10, Attr_YE);
	prstring ("      Write file c46.pkt by EEPROM value.       ",18 ,10, Attr_YE);
	prstring ("                                                ",19 ,10, Attr_YE);
	prstring (" ͼ ",20 ,10, Attr_YE);
	while(!kbhit());												   
	keycode_get();
}

c46_crc_calculation()
{
	FILE *fd2;
	unsigned long crc=0xffffffff;
	unsigned long msb;
	unsigned char currentbyte,value;
	char ch;
	int bit,i;
	int shift;
	unsigned int result[2];
	fd2=fopen("c46.pkt","r");     
	for(i=0;i<126;i++){
		fscanf(fd2,"%x",&ch);
		currentbyte=ch;
		for (bit=0; bit<8; bit++) {
			msb=crc>>31;
			crc<<=1;
			if(msb^(currentbyte&1)){
				crc^=POLY;
				crc|=0x00000001;
			}
			currentbyte>>=1;
		}
	}
	fclose(fd2);
	value=0;
	for(bit=0;bit<16;bit++){
		value += ((((crc^0xffffffff)<<bit)&0x80000000)>>31)*(0x01<<(bit%8));
		if(bit%8==7) {
			result[bit/8]=value;
			value=0;
		}
	}
	return(result[0] + 0x100*result[1]);
}

eeprom_process()
{
	int editmode,index,k,i;
	unsigned int eeprom_rw_item[4],temp;
	unsigned char baserow,basecol,item;
	index=0;
	k=0;
	editmode=1;
	baserow=12;
	basecol=26;
	
	eeprom_read();
	item=4;
	get_networkID();
	prstring (" ͻ ", baserow-3 ,basecol, Attr_YE);
	prstring ("    EEPROM    Access          ", baserow-2 ,basecol, Attr_YE);
	prstring (" ͹ ", baserow-1 ,basecol, Attr_YE);
	prstring ("  Dump EEPROM                 ", baserow   ,basecol, Attr_YE);
	prstring ("  Edit C46.PKT                ", baserow+1 ,basecol, Attr_YE);
	prstring ("  Upload C46.PKT to EEPROM    ", baserow+2 ,basecol, Attr_YE);
	prstring ("  Download EEPROM to C46.PKT  ", baserow+3 ,basecol, Attr_YE);
	prstring (" ͼ ", baserow+4 ,basecol, Attr_YE);
	prstring ("   <Alt-H> Help                 ", baserow+5 ,basecol, Attr_YE);
	bar_one(baserow+index,basecol+2,28,Attr_YER);
	while (editmode)  {
		if (kbhit()) {
			keycode_get();
			if (M_code==0)	{
				switch (A_code)  {
					case 0x23 :			     /*** Alt-h   ***/
						screen_store();
						eeprom_HPanel();
						screen_restore();
						break;
					case 0x4b :			    /*** Cr LFT ***/
					case 0x48 :			    /*** Cr Up ***/
						bar_one(baserow+index,basecol+2,28,Attr_YE);
						index--;
						if(index<0) index=item-1;
						bar_one(baserow+index,basecol+2,28,Attr_YER);
						break;
				  	case 0x4d :			    /*** Cr RGT ***/
				  	case 0x50 :			    /*** Cr Dn ***/
						bar_one(baserow+index,basecol+2,28,Attr_YE);
						index++;
						if(index>=item) index=0;
						bar_one(baserow+index,basecol+2,28,Attr_YER);
						break;
					default   :
						break;
				}
			}
			else	{
				switch(M_code) {
					case 0x0d :			    /*** Enter ***/
						eeprom_read();
						screen_store();
						switch (index)	{
							case 0 :
								cll(0,0,79,24);
								eeprom_dump_c46();
								getch();
								break;
							case 1 :
								eeprom_edit_c46();
//								system("edit c46.pkt");
//								cursor_type('E');
								break;
							case 2 :
								eeprom_upload_c46();
								break;
							case 3 :
								eeprom_download_c46();
								break;
							default: break;
						}
						screen_restore();
						break;
					case 0x1b :			    /*** ESC   ***/
						eeprom_read();
						get_networkID();
						editmode=0;
						break;
					default   :
						break;
				}
			}
		}
	}  /* while loop */
}

eeprom_read()
{
	unsigned int i,address,eeval;
	char  bit;
	for (address=0;address<64;address++){
		NIC_write_reg(&csr9,(unsigned long)0x04800);
		eeprom_serial_in(0);
	
		eeprom_serial_in(1);		  // command
		eeprom_serial_in(1);
		eeprom_serial_in(0);
	
		for(i=0;i<6;i++){		   // address serial in
			bit= ((address>>(5-i)) & 0x01) ? 1 :0 ;
			eeprom_serial_in(bit);
		}
		eeval=0;
		for(i=0;i<16;i++){		   // data serial out
			NIC_write_reg(&csr9,(unsigned long)0x04803);
			NIC_read_reg(&csr9);
			eeval += (((unsigned long)0x008 & csr9.value)>>3)<<(15-i);
			NIC_write_reg(&csr9,(unsigned long)0x04801);
		}
		NIC_write_reg(&csr9,(unsigned long)0x04800);

		c46[address*2]= eeval&0x0ff;
		c46[address*2+1]= (eeval>>8)&0x0ff;
	}
}

eeprom_bar(int index, unsigned char attr)
{
	pattrib (6+index/16,3*(index%16), attr);
	pattrib (6+index/16,3*(index%16)+1, attr);
}

eeprom_edit_c46()
{
	unsigned int i,k=0;
	int index;
	unsigned char *tempbuffer,editmode,tempvalue;
	FILE   *fdc46;
	if ((tempbuffer = (char *)malloc((unsigned int)500)) == (char) NULL) printf("Allocation Failed !\n");
	cll(0,0,79,24);
	gotoxy(5,0);
	fdc46 = fopen("c46.pkt", "rw");
	if(fdc46==NULL)  {
		prstring (" ͻ ", 7 ,20, Attr_R);
		prstring ("  Cannot open file c46.pkt !! ", 8 ,20, Attr_R);
		prstring (" ͼ ", 9 ,20, Attr_R);
		prstring (" Execute \"Download EEPROM to C46.PKT\" in the  ", 13 ,20, 0x07);
		prstring (" previous menu to creat file c46.pkt.          ", 14 ,20, 0x07);
		prstring (" Press any key to exit.       ", 16 ,20, 0x07);
		getch();
		return(1);
	}
	for (i=0;i<128;i++){
		fscanf(fdc46,"%x",(tempbuffer+i));
		if((i%16)==0)  printf("\n");
		printf("%02x ",*(tempbuffer+i));
	}
	gotoxy(1,0);
	printf("\n Press 'W' to Save !!");
	gotoxy(2,0);
	printf("\n Press 'Esc' to Abort !!");
	fclose(fdc46);

	editmode=1;
	index=0;
	eeprom_bar(index,Attr_R);

	while (editmode){
		if (kbhit()){
			keycode_get();
			if (M_code==0){
				k=0;
				switch(A_code){
					case 0x3d :			     /*** F3	***/
					case 0x3c :			     /*** F2	***/
					case 0x3b :			     /*** F1	***/
						break;
					case 0x48 :			     /*** Cr Up ***/
						eeprom_bar(index,0x07);
						index-=16;
						if(index<0){
							index=0;
						}
						eeprom_bar(index,Attr_R);
						break;
					case 0x4b :			     /*** Cr LFT ***/
						eeprom_bar(index,0x07);
						index--;
						if(index<0){
							index=0;
						}
						eeprom_bar(index,Attr_R);
						break;
					case 0x50 :			     /*** Cr Dn ***/
						eeprom_bar(index,0x07);
						index+=16;
						if(index>127){
							index=127;
						}
						eeprom_bar(index,Attr_R);
						break;
					case 0x4d :			     /*** Cr RGT ***/
						eeprom_bar(index,0x07);
						index++;
						if(index>127){
							index=127;
						}
						eeprom_bar(index,Attr_R);
						break;
					default   :
						break;
				}
			} 
			else{
				switch (M_code){
					case 0x1b :			     /*** ESC	***/
						editmode=0;
						break;
					case 0x09 :			     /*** TAB	***/
						break;
					case 0x0d :			     /*** Enter ***/
						break;
					case 'W' :			     /*** "w" ***/
					case 'w' :
						fdc46 = fopen("c46.pkt", "w");
						gotoxy(16,0);
						for (i=0;i<128;i++){
							if((i%16)==0)  printf("\n");
							printf("%02x ",*(tempbuffer+i));
							delay(3);
						}
						for (i=0;i<128;i++){
							if((i%16)==0)  fprintf(fdc46,"\n");
							fprintf(fdc46,"%02x ",*(tempbuffer+i));
						}
						fclose(fdc46);
						editmode=0;
						break;
					default   :
						if((isxdigit(M_code)!=0)&&(k<2)){
							if(k==0){
								prchar(6+index/16,3*(index%16),M_code,Attr_R);
								*(tempbuffer+index)= hexvalue(M_code);
							} else {
								prchar(6+index/16,3*(index%16)+1,M_code,Attr_R);
								*(tempbuffer+index)= (*(tempbuffer+index))*16 + hexvalue(M_code);
							}
							k++;
							if(k==2) {
								eeprom_bar(index,0x07);
								index++;
								k=0;
								eeprom_bar(index,Attr_R);
							}
						}
						break;
				}
			} 
		}
	}
	free (tempbuffer);
}
eeprom_dump_c46()
{
	unsigned int i,temp;
	gotoxy(5,0);
	temp=c46[0x70];
	for(i=0;i<6;i++)
		prstring("fff",6+(temp+i)/16,3*((temp+i)%16),Attr_YE);        
	for (i=0;i<128;i++){
		if((i%16)==0)  printf("\n");
		printf("%02x ",c46[i]);
	}

}

eeprom_download_c46()
{
	unsigned int i;
	FILE	*fd1;
	fd1=fopen("c46.pkt","w");
	if(fd1==NULL)  {
		prstring (" ͻ ", 7 ,20, Attr_R);
		prstring ("  Cannot open file c46.pkt !! ", 8 ,20, Attr_R);
		prstring (" ͼ ", 9 ,20, Attr_R);
		getch();
		return(1);
	}
	gotoxy(5,0);
	for (i=0;i<128;i++){
		if((i%16)==0)  fprintf(fd1,"\n");
		fprintf(fd1,"%02x ",c46[i]);
	}
	fclose(fd1);
}
	
eeprom_upload_c46()
{
	FILE	*fd1;
	unsigned int i,eeval;
	unsigned int x,y;
	char		 ch;
	if ((fd1 = fopen("c46.pkt","r")) != NULL){
		prstring(" Program EEPROM (Y/N) ? ",15,29,Attr_REF); 
		ch=getch();
		if(tolower(ch) != 'y') return(FAIL);
		fscanf(fd1,"\n",&x);
		for(i=0; i<64; i++){
			fscanf(fd1,"%x",&x);
			fscanf(fd1,"%x",&y);
			eeval = x + 0x100*y ;
			eeprom_write(i,eeval);
		}
		fclose(fd1);
		eeprom_write(63,c46_crc_calculation());
	}
	else{
		prstring(" Can Not Open C46.PKT !!",15,29,Attr_REF); 
		getch();
	}
}
	
eeprom_auto_upload_c46()
{
	FILE	*fd1;
	unsigned int i,eeval;
	unsigned int x,y;
	char		 ch;
	if ((fd1 = fopen("c46.pkt","r")) != NULL){
		fscanf(fd1,"\n",&x);
		for(i=0; i<64; i++){
			fscanf(fd1,"%x",&x);
			fscanf(fd1,"%x",&y);
			c46[i*2]=x;
			c46[i*2 + 1]=y;
			eeval = x + 0x100*y ;
			eeprom_write(i,eeval);
		}
		fclose(fd1);
		eeprom_write(63,c46_crc_calculation());
		printf("Current Network ID : %02x-%02x-%02x-%02x-%02x-%02x \n",
			c46[c46[0x70]+0],c46[c46[0x70]+1],c46[c46[0x70]+2],
			c46[c46[0x70]+3],c46[c46[0x70]+4],c46[c46[0x70]+5]);
	}
	else{
		prstring(" Can not find C46.PKT !!",15,29,Attr_REF); 
		getch();
	}
}
	
eeprom_write(unsigned int address,unsigned int data)
{
	unsigned int i;
	char  bit;
	eeprom_wen();
	NIC_write_reg(&csr9,(unsigned long)0x04800);
	eeprom_serial_in(0);
	
	eeprom_serial_in(1);		  // command
	eeprom_serial_in(0);
	eeprom_serial_in(1);
	
	for(i=0;i<6;i++){		   // address serial in
		bit= ((address>>(5-i)) & 0x01) ? 1 :0 ;
		eeprom_serial_in(bit);
	}
	for(i=0;i<16;i++){		   // data serial in
		bit= ((data>>(15-i)) & 0x01) ? 1 :0 ;
		eeprom_serial_in(bit);
	}
	NIC_write_reg(&csr9,(unsigned long)0x04800);
	NIC_write_reg(&csr9,(unsigned long)0x04801);
	i=0;
	do{
		i++;
		NIC_read_reg(&csr9);
	} while((!(csr9.value&0x08)) && (i<10000) );
	NIC_write_reg(&csr9,(unsigned long)0x04800);
	if(i==10000)  prstring (" Writing EEPROM error !!",  24, 10, Attr_N);
	eeprom_wds();
}
	
eeprom_wen()
{
	NIC_write_reg(&csr9,(unsigned long)0x04800);
	eeprom_serial_in(0);
	eeprom_serial_in(1);
	eeprom_serial_in(0);
	eeprom_serial_in(0);
	eeprom_serial_in(1);
	eeprom_serial_in(1);
	eeprom_serial_in(0); // X
	eeprom_serial_in(0); // X
	eeprom_serial_in(0); // X
	eeprom_serial_in(0); // X
	NIC_write_reg(&csr9,(unsigned long)0x04800);
}
	
eeprom_wds()
{
	NIC_write_reg(&csr9,(unsigned long)0x04800);
	eeprom_serial_in(0);
	eeprom_serial_in(1);
	eeprom_serial_in(0);
	eeprom_serial_in(0);
	eeprom_serial_in(0);
	eeprom_serial_in(0);
	eeprom_serial_in(0); // X
	eeprom_serial_in(0); // X
	eeprom_serial_in(0); // X
	eeprom_serial_in(0); // X
	NIC_write_reg(&csr9,(unsigned long)0x04800);
}
	
eeprom_serial_in(unsigned int bit2)
{
	NIC_write_reg(&csr9,(unsigned long)0x04801+ 4*bit2);
	NIC_write_reg(&csr9,(unsigned long)0x04803+ 4*bit2);   // x
	NIC_write_reg(&csr9,(unsigned long)0x04801+ 4*bit2);
}

							
mii_read(phyad,regad)
unsigned char phyad,regad;
{
	unsigned int i,value;
	unsigned int bit;
	mii_pre_st();				     // PRE+ST
	mii_serial_in(1);			     // OP
	mii_serial_in(0);
	
	for (i=0;i<5;i++)   {			     // PHYAD
		bit= ((phyad>>(4-i)) & 0x01) ? 1 :0 ;
		mii_serial_in(bit);
	}
	
	for (i=0;i<5;i++)   {			     // REGAD
		bit= ((regad>>(4-i)) & 0x01) ? 1 :0 ;
		mii_serial_in(bit);
	}
	mii_serial_out();			     // TA_Z
	if((bit=mii_serial_out()) !=0 ) 	     // TA_0
	return(FAIL);
	
	value=0;
	for (i=0;i<16;i++)  {			     // READ DATA
		bit=mii_serial_out();
		value += bit<<15-i ;
	}
	mii_serial_in(0);			     // dumy clock
	mii_serial_in(0);			     // dumy clock
	return(value);
}
	
mii_write(phyad,regad,value)
unsigned char phyad,regad;
unsigned int  value;
{
	unsigned int i;
	char  bit;
	mii_pre_st();				     // PRE+ST
	mii_serial_in(0);			     // OP
	mii_serial_in(1);
	
	for (i=0;i<5;i++)   {			     // PHYAD
		bit= ((phyad>>(4-i)) & 0x01) ? 1 :0 ;
		mii_serial_in(bit);
	}
	
	for (i=0;i<5;i++)   {			     // REGAD
		bit= ((regad>>(4-i)) & 0x01) ? 1 :0 ;
		mii_serial_in(bit);
	}
	
	mii_serial_in(1);			     // TA_1
	mii_serial_in(0);			     // TA_0
	
	for (i=0;i<16;i++)  {			     // OUT DATA
		bit= ((value>>(15-i)) & 0x01) ? 1 : 0 ;
		mii_serial_in(bit);
	}
	mii_serial_in(0);			     // dumy clock
	mii_serial_in(0);			     // dumy clock
}
	
mii_pre_st()
{
	unsigned char i;
	NIC_write_reg(&csr9,(unsigned long)0x02000); // SWO+~SSR
	for(i=0;i<32;i++)			     // PREAMBLE
		mii_serial_in(1);
	mii_serial_in(0);			     // ST
	mii_serial_in(1);
}
	
mii_serial_in(char bit_MDO)	 // inject data into mii PHY
{
	if(bit_MDO){
	   	NIC_write_reg(&csr9,(unsigned long)0xfff02000 | CSR9_MDO);//	 SWO
		NIC_write_reg(&csr9,(unsigned long)0xfff12000 | CSR9_MDO);// MDC+SWO
		NIC_write_reg(&csr9,(unsigned long)0xfff02000 | CSR9_MDO);//	 SWO
	}
	else{
		NIC_write_reg(&csr9,(unsigned long)0xfff02000 );//     SWO
		NIC_write_reg(&csr9,(unsigned long)0xfff12000 );// MDC+SWO
		NIC_write_reg(&csr9,(unsigned long)0xfff02000 );//     SWO
	}
}
	
mii_serial_out()			  // read data from mii PHY
{
	unsigned int bit_MDI;
	NIC_write_reg(&csr9,CSR9_MMD|CSR9_SRO );   // MMD+SRO
	NIC_read_reg (&csr9);
	NIC_write_reg(&csr9,CSR9_MMD|CSR9_SRO|CSR9_MDC);  // MMD+MDC+SRO
	NIC_write_reg(&csr9,CSR9_MMD|CSR9_SRO );  // MMD+SRO
	bit_MDI =  (csr9.value & CSR9_MDI) ? 1 : 0 ;
	return(bit_MDI);
}
	
