/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.NTLMAuthSequence;
import sun.net.www.protocol.http.NTLMAuthenticationCallback;

class NTLMAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    private static final NTLMAuthenticationCallback NTLMAuthCallback = NTLMAuthenticationCallback.getNTLMAuthenticationCallback();
    static final char NTLM_AUTH = 'N';
    private String hostname;
    private static String defaultDomain = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            String string = System.getProperty("http.auth.ntlm.domain");
            if (string == null) {
                return "domain";
            }
            return string;
        }
    });
    String username;
    String ntdomain;
    String password;

    private void init0() {
        this.hostname = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string;
                try {
                    string = InetAddress.getLocalHost().getHostName().toUpperCase();
                }
                catch (UnknownHostException unknownHostException) {
                    string = "localhost";
                }
                return string;
            }
        });
        int n = this.hostname.indexOf(46);
        if (n != -1) {
            this.hostname = this.hostname.substring(0, n);
        }
    }

    public NTLMAuthentication(boolean bl, URL uRL, PasswordAuthentication passwordAuthentication) {
        super(bl ? (char)'p' : 's', 'N', uRL, "");
        this.init(passwordAuthentication);
    }

    private void init(PasswordAuthentication passwordAuthentication) {
        this.pw = passwordAuthentication;
        if (passwordAuthentication != null) {
            String string = passwordAuthentication.getUserName();
            int n = string.indexOf(92);
            if (n == -1) {
                this.username = string;
                this.ntdomain = defaultDomain;
            } else {
                this.ntdomain = string.substring(0, n).toUpperCase();
                this.username = string.substring(n + 1);
            }
            this.password = new String(passwordAuthentication.getPassword());
        } else {
            this.username = null;
            this.ntdomain = null;
            this.password = null;
        }
        this.init0();
    }

    public NTLMAuthentication(boolean bl, String string, int n, PasswordAuthentication passwordAuthentication) {
        super(bl ? (char)'p' : 's', 'N', string, n, "");
        this.init(passwordAuthentication);
    }

    boolean supportsPreemptiveAuthorization() {
        return false;
    }

    public static boolean isTrustedSite(URL uRL) {
        return NTLMAuthCallback.isTrustedSite(uRL);
    }

    static boolean supportsTransparentAuth() {
        return true;
    }

    String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-authorization";
    }

    String getHeaderValue(URL uRL, String string) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    boolean isAuthorizationStale(String string) {
        return false;
    }

    synchronized boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser, String string) {
        try {
            NTLMAuthSequence nTLMAuthSequence = (NTLMAuthSequence)httpURLConnection.authObj;
            if (nTLMAuthSequence == null) {
                nTLMAuthSequence = new NTLMAuthSequence(this.username, this.password, this.ntdomain);
                httpURLConnection.authObj = nTLMAuthSequence;
            }
            String string2 = "NTLM " + nTLMAuthSequence.getAuthHeader(string.length() > 6 ? string.substring(5) : null);
            httpURLConnection.setAuthenticationProperty(this.getHeaderName(), string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void checkResponse(String string, String string2, URL uRL) throws IOException {
    }
}

