/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.AbstractMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.swing.ImageCache;

public abstract class CachedPainter {
    private static final Map<Object, ImageCache> cacheMap = new HashMap<Object, ImageCache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageCache getCache(Object object) {
        Class<CachedPainter> clazz = CachedPainter.class;
        synchronized (CachedPainter.class) {
            ImageCache imageCache = cacheMap.get(object);
            if (imageCache == null) {
                imageCache = new ImageCache(1);
                cacheMap.put(object, imageCache);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return imageCache;
        }
    }

    public CachedPainter(int n) {
        CachedPainter.getCache(this.getClass()).setMaxCount(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Component component, Graphics graphics, int n, int n2, int n3, int n4, Object ... objectArray) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        Class<CachedPainter> clazz = CachedPainter.class;
        synchronized (CachedPainter.class) {
            this.paint0(component, graphics, n, n2, n3, n4, objectArray);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    private Image getImage(Object object, Component component, int n, int n2, int n3, int n4, Object ... objectArray) {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration(component);
        ImageCache imageCache = CachedPainter.getCache(object);
        Image image = imageCache.getImage(object, graphicsConfiguration, n3, n4, objectArray);
        int n5 = 0;
        do {
            boolean bl = false;
            if (image instanceof VolatileImage) {
                switch (((VolatileImage)image).validate(graphicsConfiguration)) {
                    case 2: {
                        ((VolatileImage)image).flush();
                        image = null;
                        break;
                    }
                    case 1: {
                        bl = true;
                    }
                }
            }
            if (image == null) {
                image = this.createImage(component, n3, n4, graphicsConfiguration, objectArray);
                imageCache.setImage(object, graphicsConfiguration, n3, n4, objectArray, image);
                bl = true;
            }
            if (!bl) continue;
            Graphics2D graphics2D = (Graphics2D)image.getGraphics();
            if (n3 != n || n4 != n2) {
                graphics2D.scale((double)n3 / (double)n, (double)n4 / (double)n2);
            }
            this.paintToImage(component, image, graphics2D, n, n2, objectArray);
            graphics2D.dispose();
        } while (image instanceof VolatileImage && ((VolatileImage)image).contentsLost() && ++n5 < 3);
        return image;
    }

    private void paint0(Component component, Graphics graphics, int n, int n2, int n3, int n4, Object ... objectArray) {
        Class<?> clazz = this.getClass();
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration(component);
        ImageCache imageCache = CachedPainter.getCache(clazz);
        Image image = imageCache.getImage(clazz, graphicsConfiguration, n3, n4, objectArray);
        if (image == null) {
            image = new PainterMultiResolutionCachedImage(n3, n4);
            imageCache.setImage(clazz, graphicsConfiguration, n3, n4, objectArray, image);
        }
        if (image instanceof PainterMultiResolutionCachedImage) {
            ((PainterMultiResolutionCachedImage)image).setParams(component, objectArray);
        }
        this.paintImage(component, graphics, n, n2, n3, n4, image, objectArray);
    }

    protected abstract void paintToImage(Component var1, Image var2, Graphics var3, int var4, int var5, Object[] var6);

    protected void paintImage(Component component, Graphics graphics, int n, int n2, int n3, int n4, Image image, Object[] objectArray) {
        graphics.drawImage(image, n, n2, null);
    }

    protected Image createImage(Component component, int n, int n2, GraphicsConfiguration graphicsConfiguration, Object[] objectArray) {
        if (graphicsConfiguration == null) {
            return new BufferedImage(n, n2, 1);
        }
        return graphicsConfiguration.createCompatibleVolatileImage(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush() {
        Class<CachedPainter> clazz = CachedPainter.class;
        synchronized (CachedPainter.class) {
            CachedPainter.getCache(this.getClass()).flush();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private GraphicsConfiguration getGraphicsConfiguration(Component component) {
        if (component == null) {
            return null;
        }
        return component.getGraphicsConfiguration();
    }

    class PainterMultiResolutionCachedImage
    extends AbstractMultiResolutionImage {
        private final int baseWidth;
        private final int baseHeight;
        private Component c;
        private Object[] args;

        public PainterMultiResolutionCachedImage(int n, int n2) {
            this.baseWidth = n;
            this.baseHeight = n2;
        }

        public void setParams(Component component, Object[] objectArray) {
            this.c = component;
            this.args = objectArray;
        }

        @Override
        public int getWidth(ImageObserver imageObserver) {
            return this.baseWidth;
        }

        @Override
        public int getHeight(ImageObserver imageObserver) {
            return this.baseHeight;
        }

        @Override
        public Image getResolutionVariant(double d, double d2) {
            int n = (int)Math.ceil(d);
            int n2 = (int)Math.ceil(d2);
            return CachedPainter.this.getImage(this, this.c, this.baseWidth, this.baseHeight, n, n2, this.args);
        }

        @Override
        protected Image getBaseImage() {
            return this.getResolutionVariant(this.baseWidth, this.baseHeight);
        }

        @Override
        public List<Image> getResolutionVariants() {
            return Arrays.asList(this.getResolutionVariant(this.baseWidth, this.baseHeight));
        }
    }
}

