/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathChecker;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.AdjacencyList;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.ForwardBuilder;
import sun.security.provider.certpath.ForwardState;
import sun.security.provider.certpath.PKIX;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.provider.certpath.RevocationChecker;
import sun.security.provider.certpath.SunCertPathBuilderException;
import sun.security.provider.certpath.SunCertPathBuilderResult;
import sun.security.provider.certpath.UntrustedChecker;
import sun.security.provider.certpath.Vertex;
import sun.security.util.Debug;
import sun.security.x509.PKIXExtensions;

public final class SunCertPathBuilder
extends CertPathBuilderSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private PKIX.BuilderParams buildParams;
    private CertificateFactory cf;
    private boolean pathCompleted = false;
    private PolicyNode policyTreeResult;
    private TrustAnchor trustAnchor;
    private PublicKey finalPublicKey;

    public SunCertPathBuilder() throws CertPathBuilderException {
        try {
            this.cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new CertPathBuilderException(certificateException);
        }
    }

    @Override
    public CertPathChecker engineGetRevocationChecker() {
        return new RevocationChecker();
    }

    @Override
    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.engineBuild(" + certPathParameters + ")");
        }
        this.buildParams = PKIX.checkBuilderParams(certPathParameters);
        return this.build();
    }

    private PKIXCertPathBuilderResult build() throws CertPathBuilderException {
        ArrayList<List<Vertex>> arrayList = new ArrayList<List<Vertex>>();
        PKIXCertPathBuilderResult pKIXCertPathBuilderResult = this.buildCertPath(false, arrayList);
        if (pKIXCertPathBuilderResult == null) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild: 2nd pass; try building again searching all certstores");
            }
            arrayList.clear();
            pKIXCertPathBuilderResult = this.buildCertPath(true, arrayList);
            if (pKIXCertPathBuilderResult == null) {
                throw new SunCertPathBuilderException("unable to find valid certification path to requested target", new AdjacencyList(arrayList));
            }
        }
        return pKIXCertPathBuilderResult;
    }

    private PKIXCertPathBuilderResult buildCertPath(boolean bl, List<List<Vertex>> list) throws CertPathBuilderException {
        this.pathCompleted = false;
        this.trustAnchor = null;
        this.finalPublicKey = null;
        this.policyTreeResult = null;
        LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
        try {
            this.buildForward(list, linkedList, bl);
        }
        catch (IOException | GeneralSecurityException exception) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild() exception in build");
                exception.printStackTrace();
            }
            throw new SunCertPathBuilderException("unable to find valid certification path to requested target", exception, new AdjacencyList(list));
        }
        try {
            if (this.pathCompleted) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.engineBuild() pathCompleted");
                }
                Collections.reverse(linkedList);
                return new SunCertPathBuilderResult(this.cf.generateCertPath(linkedList), this.trustAnchor, this.policyTreeResult, this.finalPublicKey, new AdjacencyList(list));
            }
        }
        catch (CertificateException certificateException) {
            if (debug != null) {
                debug.println("SunCertPathBuilder.engineBuild() exception in wrap-up");
                certificateException.printStackTrace();
            }
            throw new SunCertPathBuilderException("unable to find valid certification path to requested target", certificateException, new AdjacencyList(list));
        }
        return null;
    }

    private void buildForward(List<List<Vertex>> list, LinkedList<X509Certificate> linkedList, boolean bl) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildForward()...");
        }
        ForwardState forwardState = new ForwardState();
        forwardState.initState(this.buildParams.certPathCheckers());
        list.clear();
        list.add(new LinkedList());
        forwardState.untrustedChecker = new UntrustedChecker();
        this.depthFirstSearchForward(this.buildParams.targetSubject(), forwardState, new ForwardBuilder(this.buildParams, bl), list, linkedList);
    }

    private void depthFirstSearchForward(X500Principal x500Principal, ForwardState forwardState, ForwardBuilder forwardBuilder, List<List<Vertex>> list, LinkedList<X509Certificate> linkedList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchForward(" + x500Principal + ", " + forwardState.toString() + ")");
        }
        Collection<X509Certificate> collection = forwardBuilder.getMatchingCerts(forwardState, this.buildParams.certStores());
        List<Vertex> list2 = SunCertPathBuilder.addVertices(collection, list);
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchForward(): certs.size=" + list2.size());
        }
        block4: for (Vertex vertex : list2) {
            ForwardState forwardState2 = (ForwardState)forwardState.clone();
            X509Certificate x509Certificate = vertex.getCertificate();
            try {
                forwardBuilder.verifyCert(x509Certificate, forwardState2, linkedList);
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): validation failed: " + generalSecurityException);
                    generalSecurityException.printStackTrace();
                }
                vertex.setThrowable(generalSecurityException);
                continue;
            }
            if (forwardBuilder.isPathCompleted(x509Certificate)) {
                Object object;
                Object object2;
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): commencing final verification");
                }
                ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(linkedList);
                if (forwardBuilder.trustAnchor.getTrustedCert() == null) {
                    arrayList.add(0, x509Certificate);
                }
                Set<String> set = Collections.singleton("2.5.29.32.0");
                PolicyNodeImpl policyNodeImpl = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, set, false);
                ArrayList<PKIXCertPathChecker> arrayList2 = new ArrayList<PKIXCertPathChecker>();
                PolicyChecker policyChecker = new PolicyChecker(this.buildParams.initialPolicies(), arrayList.size(), this.buildParams.explicitPolicyRequired(), this.buildParams.policyMappingInhibited(), this.buildParams.anyPolicyInhibited(), this.buildParams.policyQualifiersRejected(), policyNodeImpl);
                arrayList2.add(policyChecker);
                arrayList2.add(new AlgorithmChecker(forwardBuilder.trustAnchor, this.buildParams.date(), null));
                BasicChecker basicChecker = null;
                if (forwardState2.keyParamsNeeded()) {
                    PublicKey publicKey = x509Certificate.getPublicKey();
                    if (forwardBuilder.trustAnchor.getTrustedCert() == null) {
                        publicKey = forwardBuilder.trustAnchor.getCAPublicKey();
                        if (debug != null) {
                            debug.println("SunCertPathBuilder.depthFirstSearchForward using buildParams public key: " + publicKey.toString());
                        }
                    }
                    object2 = new TrustAnchor(x509Certificate.getSubjectX500Principal(), publicKey, null);
                    basicChecker = new BasicChecker((TrustAnchor)object2, this.buildParams.date(), this.buildParams.sigProvider(), true);
                    arrayList2.add(basicChecker);
                }
                this.buildParams.setCertPath(this.cf.generateCertPath(arrayList));
                boolean bl = false;
                object2 = this.buildParams.certPathCheckers();
                Iterator<PKIXCertPathChecker> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (!(object instanceof PKIXRevocationChecker)) continue;
                    if (bl) {
                        throw new CertPathValidatorException("Only one PKIXRevocationChecker can be specified");
                    }
                    bl = true;
                    if (!(object instanceof RevocationChecker)) continue;
                    ((RevocationChecker)object).init(forwardBuilder.trustAnchor, this.buildParams);
                }
                if (this.buildParams.revocationEnabled() && !bl) {
                    arrayList2.add(new RevocationChecker(forwardBuilder.trustAnchor, this.buildParams));
                }
                arrayList2.addAll((Collection<PKIXCertPathChecker>)object2);
                for (int i = 0; i < arrayList.size(); ++i) {
                    Set<String> set2;
                    object = (X509Certificate)arrayList.get(i);
                    if (debug != null) {
                        debug.println("current subject = " + ((X509Certificate)object).getSubjectX500Principal());
                    }
                    if ((set2 = object.getCriticalExtensionOIDs()) == null) {
                        set2 = Collections.emptySet();
                    }
                    for (PKIXCertPathChecker pKIXCertPathChecker : arrayList2) {
                        if (pKIXCertPathChecker.isForwardCheckingSupported()) continue;
                        if (i == 0) {
                            pKIXCertPathChecker.init(false);
                            if (pKIXCertPathChecker instanceof AlgorithmChecker) {
                                ((AlgorithmChecker)pKIXCertPathChecker).trySetTrustAnchor(forwardBuilder.trustAnchor);
                            }
                        }
                        try {
                            pKIXCertPathChecker.check((Certificate)object, set2);
                        }
                        catch (CertPathValidatorException certPathValidatorException) {
                            if (debug != null) {
                                debug.println("SunCertPathBuilder.depthFirstSearchForward(): final verification failed: " + certPathValidatorException);
                            }
                            if (this.buildParams.targetCertConstraints().match((Certificate)object) && certPathValidatorException.getReason() == CertPathValidatorException.BasicReason.REVOKED) {
                                throw certPathValidatorException;
                            }
                            vertex.setThrowable(certPathValidatorException);
                            continue block4;
                        }
                    }
                    for (PKIXCertPathChecker pKIXCertPathChecker : this.buildParams.certPathCheckers()) {
                        Set<String> set3;
                        if (!pKIXCertPathChecker.isForwardCheckingSupported() || (set3 = pKIXCertPathChecker.getSupportedExtensions()) == null) continue;
                        set2.removeAll(set3);
                    }
                    if (set2.isEmpty()) continue;
                    set2.remove(PKIXExtensions.BasicConstraints_Id.toString());
                    set2.remove(PKIXExtensions.NameConstraints_Id.toString());
                    set2.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                    set2.remove(PKIXExtensions.PolicyMappings_Id.toString());
                    set2.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                    set2.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                    set2.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                    set2.remove(PKIXExtensions.KeyUsage_Id.toString());
                    set2.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                    if (set2.isEmpty()) continue;
                    throw new CertPathValidatorException("unrecognized critical extension(s)", null, null, -1, PKIXReason.UNRECOGNIZED_CRIT_EXT);
                }
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): final verification succeeded - path completed!");
                }
                this.pathCompleted = true;
                if (forwardBuilder.trustAnchor.getTrustedCert() == null) {
                    forwardBuilder.addCertToPath(x509Certificate, linkedList);
                }
                this.trustAnchor = forwardBuilder.trustAnchor;
                if (basicChecker != null) {
                    this.finalPublicKey = basicChecker.getPublicKey();
                } else {
                    Certificate certificate = linkedList.isEmpty() ? forwardBuilder.trustAnchor.getTrustedCert() : (Certificate)linkedList.getLast();
                    this.finalPublicKey = certificate.getPublicKey();
                }
                this.policyTreeResult = policyChecker.getPolicyTree();
                return;
            }
            forwardBuilder.addCertToPath(x509Certificate, linkedList);
            forwardState2.updateState(x509Certificate);
            list.add(new LinkedList());
            vertex.setIndex(list.size() - 1);
            this.depthFirstSearchForward(x509Certificate.getIssuerX500Principal(), forwardState2, forwardBuilder, list, linkedList);
            if (this.pathCompleted) {
                return;
            }
            if (debug != null) {
                debug.println("SunCertPathBuilder.depthFirstSearchForward(): backtracking");
            }
            forwardBuilder.removeFinalCertFromPath(linkedList);
        }
    }

    private static List<Vertex> addVertices(Collection<X509Certificate> collection, List<List<Vertex>> list) {
        List<Vertex> list2 = list.get(list.size() - 1);
        for (X509Certificate x509Certificate : collection) {
            Vertex vertex = new Vertex(x509Certificate);
            list2.add(vertex);
        }
        return list2;
    }

    private static boolean anchorIsTarget(TrustAnchor trustAnchor, CertSelector certSelector) {
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        if (x509Certificate != null) {
            return certSelector.match(x509Certificate);
        }
        return false;
    }
}

