/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.util.ArrayList;
import sun.awt.SunToolkit;
import sun.java2d.pipe.RenderBuffer;

public abstract class RenderQueue {
    private static final int BUFFER_SIZE = 6400000;
    protected RenderBuffer buf;
    protected ArrayList refList = new ArrayList();

    protected RenderQueue() {
        this.buf = RenderBuffer.allocate(6400000);
    }

    public final void lock() {
        SunToolkit.awtLock();
    }

    public final boolean tryLock() {
        return SunToolkit.awtTryLock();
    }

    public final void unlock() {
        SunToolkit.awtUnlock();
    }

    public final void addReference(Object object) {
        this.refList.add(object);
    }

    public final RenderBuffer getBuffer() {
        return this.buf;
    }

    public final void ensureCapacity(int n) {
        if (this.buf.remaining() < n) {
            this.flushNow();
        }
    }

    public final void ensureCapacityAndAlignment(int n, int n2) {
        this.ensureCapacity(n + 4);
        this.ensureAlignment(n2);
    }

    public final void ensureAlignment(int n) {
        int n2 = this.buf.position() + n;
        if ((n2 & 7) != 0) {
            this.buf.putInt(90);
        }
    }

    public abstract void flushNow();

    public abstract void flushAndInvokeNow(Runnable var1);

    public void flushNow(int n) {
        this.buf.position(n);
        this.flushNow();
    }
}

