/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.Composite;
import java.awt.image.BufferedImage;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.FillRect;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.MaskBlit;
import sun.java2d.loops.RenderCache;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.Region;

public class MaskFill
extends GraphicsPrimitive {
    public static final String methodSignature = "MaskFill(...)".toString();
    public static final String fillPgramSignature = "FillAAPgram(...)".toString();
    public static final String drawPgramSignature = "DrawAAPgram(...)".toString();
    public static final int primTypeID = MaskFill.makePrimTypeID();
    private static RenderCache fillcache = new RenderCache(10);

    public static MaskFill locate(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        return (MaskFill)GraphicsPrimitiveMgr.locate(primTypeID, surfaceType, compositeType, surfaceType2);
    }

    public static MaskFill locatePrim(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        return (MaskFill)GraphicsPrimitiveMgr.locatePrim(primTypeID, surfaceType, compositeType, surfaceType2);
    }

    public static MaskFill getFromCache(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        Object object = fillcache.get(surfaceType, compositeType, surfaceType2);
        if (object != null) {
            return (MaskFill)object;
        }
        MaskFill maskFill = MaskFill.locatePrim(surfaceType, compositeType, surfaceType2);
        if (maskFill != null) {
            fillcache.put(surfaceType, compositeType, surfaceType2, maskFill);
        }
        return maskFill;
    }

    protected MaskFill(String string, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        super(string, primTypeID, surfaceType, compositeType, surfaceType2);
    }

    protected MaskFill(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        super(methodSignature, primTypeID, surfaceType, compositeType, surfaceType2);
    }

    public MaskFill(long l, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        super(l, methodSignature, primTypeID, surfaceType, compositeType, surfaceType2);
    }

    public native void MaskFill(SunGraphics2D var1, SurfaceData var2, Composite var3, int var4, int var5, int var6, int var7, byte[] var8, int var9, int var10);

    public native void FillAAPgram(SunGraphics2D var1, SurfaceData var2, Composite var3, double var4, double var6, double var8, double var10, double var12, double var14);

    public native void DrawAAPgram(SunGraphics2D var1, SurfaceData var2, Composite var3, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18);

    public boolean canDoParallelograms() {
        return this.getNativePrim() != 0L;
    }

    @Override
    public GraphicsPrimitive makePrimitive(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        if (SurfaceType.OpaqueColor.equals(surfaceType) || SurfaceType.AnyColor.equals(surfaceType)) {
            if (CompositeType.Xor.equals(compositeType)) {
                throw new InternalError("Cannot construct MaskFill for XOR mode");
            }
            return new General(surfaceType, compositeType, surfaceType2);
        }
        throw new InternalError("MaskFill can only fill with colors");
    }

    @Override
    public GraphicsPrimitive traceWrap() {
        return new TraceMaskFill(this);
    }

    static {
        GraphicsPrimitiveMgr.registerGeneral(new MaskFill(null, null, null));
    }

    private static class TraceMaskFill
    extends MaskFill {
        MaskFill target;
        MaskFill fillPgramTarget;
        MaskFill drawPgramTarget;

        public TraceMaskFill(MaskFill maskFill) {
            super(maskFill.getSourceType(), maskFill.getCompositeType(), maskFill.getDestType());
            this.target = maskFill;
            this.fillPgramTarget = new MaskFill(fillPgramSignature, maskFill.getSourceType(), maskFill.getCompositeType(), maskFill.getDestType());
            this.drawPgramTarget = new MaskFill(drawPgramSignature, maskFill.getSourceType(), maskFill.getCompositeType(), maskFill.getDestType());
        }

        @Override
        public GraphicsPrimitive traceWrap() {
            return this;
        }

        @Override
        public void MaskFill(SunGraphics2D sunGraphics2D, SurfaceData surfaceData, Composite composite, int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
            if ((traceflags & 8) == 0) {
                TraceMaskFill.tracePrimitive(this.target);
            }
            long l = System.nanoTime();
            this.target.MaskFill(sunGraphics2D, surfaceData, composite, n, n2, n3, n4, byArray, n5, n6);
            TraceMaskFill.tracePrimitiveTime(this.target, System.nanoTime() - l);
        }

        @Override
        public void FillAAPgram(SunGraphics2D sunGraphics2D, SurfaceData surfaceData, Composite composite, double d, double d2, double d3, double d4, double d5, double d6) {
            if ((traceflags & 8) == 0) {
                TraceMaskFill.tracePrimitive(this.fillPgramTarget);
            }
            long l = System.nanoTime();
            this.target.FillAAPgram(sunGraphics2D, surfaceData, composite, d, d2, d3, d4, d5, d6);
            TraceMaskFill.tracePrimitiveTime(this.fillPgramTarget, System.nanoTime() - l);
        }

        @Override
        public void DrawAAPgram(SunGraphics2D sunGraphics2D, SurfaceData surfaceData, Composite composite, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
            if ((traceflags & 8) == 0) {
                TraceMaskFill.tracePrimitive(this.drawPgramTarget);
            }
            long l = System.nanoTime();
            this.target.DrawAAPgram(sunGraphics2D, surfaceData, composite, d, d2, d3, d4, d5, d6, d7, d8);
            TraceMaskFill.tracePrimitiveTime(this.drawPgramTarget, System.nanoTime() - l);
        }

        @Override
        public boolean canDoParallelograms() {
            return this.target.canDoParallelograms();
        }
    }

    private static class General
    extends MaskFill {
        FillRect fillop;
        MaskBlit maskop;

        public General(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
            super(surfaceType, compositeType, surfaceType2);
            this.fillop = FillRect.locate(surfaceType, CompositeType.SrcNoEa, SurfaceType.IntArgb);
            this.maskop = MaskBlit.locate(SurfaceType.IntArgb, compositeType, surfaceType2);
        }

        @Override
        public void MaskFill(SunGraphics2D sunGraphics2D, SurfaceData surfaceData, Composite composite, int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
            SurfaceData surfaceData2 = BufImgSurfaceData.createData(bufferedImage);
            Region region = sunGraphics2D.clipRegion;
            sunGraphics2D.clipRegion = null;
            int n7 = sunGraphics2D.pixel;
            sunGraphics2D.pixel = surfaceData2.pixelFor(sunGraphics2D.getColor());
            this.fillop.FillRect(sunGraphics2D, surfaceData2, 0, 0, n3, n4);
            sunGraphics2D.pixel = n7;
            sunGraphics2D.clipRegion = region;
            this.maskop.MaskBlit(surfaceData2, surfaceData, composite, null, 0, 0, n, n2, n3, n4, byArray, n5, n6);
        }
    }
}

