/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AWTError;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Locale;
import java.util.TreeMap;
import sun.awt.DisplayChangedListener;
import sun.awt.SunDisplayChanger;
import sun.font.FontManager;
import sun.font.FontManagerFactory;
import sun.font.FontManagerForSGE;
import sun.font.FontUtilities;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

public abstract class SunGraphicsEnvironment
extends GraphicsEnvironment
implements DisplayChangedListener {
    public static boolean isOpenSolaris;
    private static Font defaultFont;
    private static final boolean uiScaleEnabled;
    private static final double debugScale;
    protected GraphicsDevice[] screens;
    protected SunDisplayChanger displayChanger = new SunDisplayChanger();

    public SunGraphicsEnvironment() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("os.version", "0.0");
                try {
                    float f = Float.parseFloat(string);
                    if (f > 5.1f) {
                        String string2;
                        File file;
                        File file2 = new File("/etc/release");
                        FileInputStream fileInputStream = new FileInputStream(file2);
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "ISO-8859-1");
                        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                        String string3 = bufferedReader.readLine();
                        isOpenSolaris = string3.indexOf("OpenSolaris") >= 0 ? true : !(file = new File(string2 = "/usr/openwin/lib/X11/fonts/TrueType/CourierNew.ttf")).exists();
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                defaultFont = new Font("Dialog", 0, 12);
                return null;
            }
        });
    }

    private static boolean isWindows_8_1_orUpper() {
        if (!FontUtilities.isWindows) {
            return false;
        }
        String string = AccessController.doPrivileged(new GetPropertyAction("os.version"));
        if (string == null) {
            return false;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 1) {
            return false;
        }
        try {
            int n = Integer.parseInt(stringArray[0]);
            if (n > 6) {
                return true;
            }
            if (n < 6) {
                return false;
            }
            if (stringArray.length < 2) {
                return false;
            }
            int n2 = Integer.parseInt(stringArray[1]);
            if (n2 >= 3) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public synchronized GraphicsDevice[] getScreenDevices() {
        GraphicsDevice[] graphicsDeviceArray = this.screens;
        if (graphicsDeviceArray == null) {
            int n = this.getNumScreens();
            graphicsDeviceArray = new GraphicsDevice[n];
            for (int i = 0; i < n; ++i) {
                graphicsDeviceArray[i] = this.makeScreenDevice(i);
            }
            this.screens = graphicsDeviceArray;
        }
        return graphicsDeviceArray;
    }

    protected abstract int getNumScreens();

    protected abstract GraphicsDevice makeScreenDevice(int var1);

    @Override
    public GraphicsDevice getDefaultScreenDevice() {
        GraphicsDevice[] graphicsDeviceArray = this.getScreenDevices();
        if (graphicsDeviceArray.length == 0) {
            throw new AWTError("no screen devices");
        }
        return graphicsDeviceArray[0];
    }

    @Override
    public Graphics2D createGraphics(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new NullPointerException("BufferedImage cannot be null");
        }
        SurfaceData surfaceData = SurfaceData.getPrimarySurfaceData(bufferedImage);
        return new SunGraphics2D(surfaceData, Color.white, Color.black, defaultFont);
    }

    public static FontManagerForSGE getFontManagerForSGE() {
        FontManager fontManager = FontManagerFactory.getInstance();
        return (FontManagerForSGE)fontManager;
    }

    public static void useAlternateFontforJALocales() {
        SunGraphicsEnvironment.getFontManagerForSGE().useAlternateFontforJALocales();
    }

    @Override
    public Font[] getAllFonts() {
        FontManagerForSGE fontManagerForSGE = SunGraphicsEnvironment.getFontManagerForSGE();
        Font[] fontArray = fontManagerForSGE.getAllInstalledFonts();
        Font[] fontArray2 = fontManagerForSGE.getCreatedFonts();
        if (fontArray2 == null || fontArray2.length == 0) {
            return fontArray;
        }
        int n = fontArray.length + fontArray2.length;
        Font[] fontArray3 = Arrays.copyOf(fontArray, n);
        System.arraycopy(fontArray2, 0, fontArray3, fontArray.length, fontArray2.length);
        return fontArray3;
    }

    @Override
    public String[] getAvailableFontFamilyNames(Locale locale) {
        FontManagerForSGE fontManagerForSGE = SunGraphicsEnvironment.getFontManagerForSGE();
        String[] stringArray = fontManagerForSGE.getInstalledFontFamilyNames(locale);
        TreeMap<String, String> treeMap = fontManagerForSGE.getCreatedFontFamilyNames();
        if (treeMap == null || treeMap.size() == 0) {
            return stringArray;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            treeMap.put(stringArray[i].toLowerCase(locale), stringArray[i]);
        }
        String[] stringArray2 = new String[treeMap.size()];
        Object[] objectArray = treeMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray2[i] = treeMap.get(objectArray[i]);
        }
        return stringArray2;
    }

    @Override
    public String[] getAvailableFontFamilyNames() {
        return this.getAvailableFontFamilyNames(Locale.getDefault());
    }

    public static Rectangle getUsableBounds(GraphicsDevice graphicsDevice) {
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        Rectangle rectangle = graphicsConfiguration.getBounds();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    @Override
    public void displayChanged() {
        for (GraphicsDevice graphicsDevice : this.getScreenDevices()) {
            if (!(graphicsDevice instanceof DisplayChangedListener)) continue;
            ((DisplayChangedListener)((Object)graphicsDevice)).displayChanged();
        }
        this.displayChanger.notifyListeners();
    }

    @Override
    public void paletteChanged() {
        this.displayChanger.notifyPaletteChanged();
    }

    public abstract boolean isDisplayLocal();

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.remove(displayChangedListener);
    }

    public boolean isFlipStrategyPreferred(ComponentPeer componentPeer) {
        return false;
    }

    public static boolean isUIScaleEnabled() {
        return uiScaleEnabled;
    }

    public static boolean isUIScaleOn() {
        return SunGraphicsEnvironment.isUIScaleEnabled();
    }

    public static double getDebugScale() {
        return debugScale;
    }

    public static double getScaleFactor(String string) {
        String string2 = AccessController.doPrivileged(new GetPropertyAction(string, "-1"));
        if (string2 == null || string2.equals("-1")) {
            return -1.0;
        }
        try {
            double d = 1.0;
            if (string2.endsWith("x")) {
                string2 = string2.substring(0, string2.length() - 1);
            } else if (string2.endsWith("dpi")) {
                d = 96.0;
                string2 = string2.substring(0, string2.length() - 3);
            } else if (string2.endsWith("%")) {
                d = 100.0;
                string2 = string2.substring(0, string2.length() - 1);
            }
            double d2 = Double.parseDouble(string2);
            return d2 <= 0.0 ? -1.0 : d2 / d;
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0;
        }
    }

    static {
        boolean bl = uiScaleEnabled = FontUtilities.isMacOSX || AccessController.doPrivileged(new GetBooleanAction("sun.java2d.uiScale.enabled")) != false && SunGraphicsEnvironment.isWindows_8_1_orUpper();
        if (uiScaleEnabled && FontUtilities.isWindows) {
            AccessController.doPrivileged(() -> {
                System.setProperty("swing.bufferPerWindow", "false");
                return null;
            });
        }
        debugScale = uiScaleEnabled ? SunGraphicsEnvironment.getScaleFactor("sun.java2d.uiScale") : -1.0;
    }
}

