/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.security.AccessController;
import sun.font.CharToGlyphMapper;
import sun.font.CompositeGlyphMapper;
import sun.font.CompositeStrike;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontManager;
import sun.font.FontManagerFactory;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.PhysicalFont;
import sun.font.SunFontManager;
import sun.security.action.GetPropertyAction;

public class CompositeFont
extends Font2D {
    private boolean[] deferredInitialisation;
    String[] componentFileNames;
    String[] componentNames;
    private PhysicalFont[] components;
    int numSlots;
    int numMetricsSlots;
    int[] exclusionRanges;
    int[] maxIndices;
    int numGlyphs = 0;
    int localeSlot = -1;
    boolean isStdComposite = true;

    public CompositeFont(String string, String[] stringArray, String[] stringArray2, int n, int[] nArray, int[] nArray2, boolean bl, SunFontManager sunFontManager) {
        int n2;
        this.handle = new Font2DHandle(this);
        this.fullName = string;
        this.componentFileNames = stringArray;
        this.componentNames = stringArray2;
        this.numSlots = stringArray2 == null ? this.componentFileNames.length : this.componentNames.length;
        this.numSlots = this.numSlots <= 254 ? this.numSlots : 254;
        this.numMetricsSlots = n;
        this.exclusionRanges = nArray;
        this.maxIndices = nArray2;
        if (sunFontManager.getEUDCFont() != null) {
            ++this.numSlots;
            if (this.componentNames != null) {
                this.componentNames = new String[this.numSlots];
                System.arraycopy(stringArray2, 0, this.componentNames, 0, this.numSlots - 1);
                this.componentNames[this.numSlots - 1] = sunFontManager.getEUDCFont().getFontName(null);
            }
            if (this.componentFileNames != null) {
                this.componentFileNames = new String[this.numSlots];
                System.arraycopy(stringArray, 0, this.componentFileNames, 0, this.numSlots - 1);
            }
            this.components = new PhysicalFont[this.numSlots];
            this.components[this.numSlots - 1] = sunFontManager.getEUDCFont();
            this.deferredInitialisation = new boolean[this.numSlots];
            if (bl) {
                for (n2 = 0; n2 < this.numSlots - 1; ++n2) {
                    this.deferredInitialisation[n2] = true;
                }
            }
        } else {
            this.components = new PhysicalFont[this.numSlots];
            this.deferredInitialisation = new boolean[this.numSlots];
            if (bl) {
                for (n2 = 0; n2 < this.numSlots; ++n2) {
                    this.deferredInitialisation[n2] = true;
                }
            }
        }
        this.fontRank = 2;
        n2 = this.fullName.indexOf(46);
        if (n2 > 0) {
            this.familyName = this.fullName.substring(0, n2);
            if (n2 + 1 < this.fullName.length()) {
                String string2 = this.fullName.substring(n2 + 1);
                if ("plain".equals(string2)) {
                    this.style = 0;
                } else if ("bold".equals(string2)) {
                    this.style = 1;
                } else if ("italic".equals(string2)) {
                    this.style = 2;
                } else if ("bolditalic".equals(string2)) {
                    this.style = 3;
                }
            }
        } else {
            this.familyName = this.fullName;
        }
    }

    CompositeFont(PhysicalFont[] physicalFontArray) {
        this.isStdComposite = false;
        this.handle = new Font2DHandle(this);
        this.fullName = physicalFontArray[0].fullName;
        this.familyName = physicalFontArray[0].familyName;
        this.style = physicalFontArray[0].style;
        this.numMetricsSlots = 1;
        this.numSlots = physicalFontArray.length;
        this.components = new PhysicalFont[this.numSlots];
        System.arraycopy(physicalFontArray, 0, this.components, 0, this.numSlots);
        this.deferredInitialisation = new boolean[this.numSlots];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompositeFont(PhysicalFont physicalFont, CompositeFont compositeFont) {
        this.isStdComposite = false;
        this.handle = new Font2DHandle(this);
        this.fullName = physicalFont.fullName;
        this.familyName = physicalFont.familyName;
        this.style = physicalFont.style;
        this.numMetricsSlots = 1;
        this.numSlots = compositeFont.numSlots + 1;
        FontManager fontManager = FontManagerFactory.getInstance();
        synchronized (fontManager) {
            this.components = new PhysicalFont[this.numSlots];
            this.components[0] = physicalFont;
            System.arraycopy(compositeFont.components, 0, this.components, 1, compositeFont.numSlots);
            if (compositeFont.componentNames != null) {
                this.componentNames = new String[this.numSlots];
                this.componentNames[0] = physicalFont.fullName;
                System.arraycopy(compositeFont.componentNames, 0, this.componentNames, 1, compositeFont.numSlots);
            }
            if (compositeFont.componentFileNames != null) {
                this.componentFileNames = new String[this.numSlots];
                this.componentFileNames[0] = null;
                System.arraycopy(compositeFont.componentFileNames, 0, this.componentFileNames, 1, compositeFont.numSlots);
            }
            this.deferredInitialisation = new boolean[this.numSlots];
            this.deferredInitialisation[0] = false;
            System.arraycopy(compositeFont.deferredInitialisation, 0, this.deferredInitialisation, 1, compositeFont.numSlots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDeferredInitialisation(int n) {
        SunFontManager sunFontManager;
        if (!this.deferredInitialisation[n]) {
            return;
        }
        SunFontManager sunFontManager2 = sunFontManager = SunFontManager.getInstance();
        synchronized (sunFontManager2) {
            if (this.componentNames == null) {
                this.componentNames = new String[this.numSlots];
            }
            if (this.components[n] == null) {
                if (this.componentFileNames != null && this.componentFileNames[n] != null) {
                    this.components[n] = sunFontManager.initialiseDeferredFont(this.componentFileNames[n]);
                }
                if (this.components[n] == null) {
                    this.components[n] = sunFontManager.getDefaultPhysicalFont();
                }
                String string = this.components[n].getFontName(null);
                if (this.componentNames[n] == null) {
                    this.componentNames[n] = string;
                } else if (!this.componentNames[n].equalsIgnoreCase(string)) {
                    try {
                        this.components[n] = (PhysicalFont)sunFontManager.findFont2D(this.componentNames[n], this.style, 1);
                    }
                    catch (ClassCastException classCastException) {
                        this.components[n] = sunFontManager.getDefaultPhysicalFont();
                    }
                }
            }
            this.deferredInitialisation[n] = false;
        }
    }

    void replaceComponentFont(PhysicalFont physicalFont, PhysicalFont physicalFont2) {
        if (this.components == null) {
            return;
        }
        for (int i = 0; i < this.numSlots; ++i) {
            if (this.components[i] != physicalFont) continue;
            this.components[i] = physicalFont2;
            if (this.componentNames == null) continue;
            this.componentNames[i] = physicalFont2.getFontName(null);
        }
    }

    public boolean isExcludedChar(int n, int n2) {
        if (this.exclusionRanges == null || this.maxIndices == null || n >= this.numMetricsSlots) {
            return false;
        }
        int n3 = 0;
        int n4 = this.maxIndices[n];
        if (n > 0) {
            n3 = this.maxIndices[n - 1];
        }
        for (int i = n3; n4 > i; i += 2) {
            if (n2 < this.exclusionRanges[i] || n2 > this.exclusionRanges[i + 1]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getStyleMetrics(float f, float[] fArray, int n) {
        PhysicalFont physicalFont = this.getSlotFont(0);
        if (physicalFont == null) {
            super.getStyleMetrics(f, fArray, n);
        } else {
            physicalFont.getStyleMetrics(f, fArray, n);
        }
    }

    public int getNumSlots() {
        return this.numSlots;
    }

    public PhysicalFont getSlotFont(int n) {
        if (this.deferredInitialisation[n]) {
            this.doDeferredInitialisation(n);
        }
        SunFontManager sunFontManager = SunFontManager.getInstance();
        try {
            PhysicalFont physicalFont = this.components[n];
            if (physicalFont == null) {
                try {
                    this.components[n] = physicalFont = (PhysicalFont)sunFontManager.findFont2D(this.componentNames[n], this.style, 1);
                }
                catch (ClassCastException classCastException) {
                    physicalFont = sunFontManager.getDefaultPhysicalFont();
                }
            }
            return physicalFont;
        }
        catch (Exception exception) {
            return sunFontManager.getDefaultPhysicalFont();
        }
    }

    @Override
    FontStrike createStrike(FontStrikeDesc fontStrikeDesc) {
        return new CompositeStrike(this, fontStrikeDesc);
    }

    public boolean isStdComposite() {
        return this.isStdComposite;
    }

    @Override
    protected int getValidatedGlyphCode(int n) {
        int n2 = n >>> 24;
        if (n2 >= this.numSlots) {
            return this.getMapper().getMissingGlyphCode();
        }
        int n3 = n & 0xFFFFFF;
        PhysicalFont physicalFont = this.getSlotFont(n2);
        if (physicalFont.getValidatedGlyphCode(n3) == physicalFont.getMissingGlyphCode()) {
            return this.getMapper().getMissingGlyphCode();
        }
        return n;
    }

    @Override
    public CharToGlyphMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new CompositeGlyphMapper(this);
        }
        return this.mapper;
    }

    @Override
    public boolean hasSupplementaryChars() {
        for (int i = 0; i < this.numSlots; ++i) {
            if (!this.getSlotFont(i).hasSupplementaryChars()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getNumGlyphs() {
        if (this.numGlyphs == 0) {
            this.numGlyphs = this.getMapper().getNumGlyphs();
        }
        return this.numGlyphs;
    }

    @Override
    public int getMissingGlyphCode() {
        return this.getMapper().getMissingGlyphCode();
    }

    @Override
    public boolean canDisplay(char c) {
        return this.getMapper().canDisplay(c);
    }

    @Override
    public boolean useAAForPtSize(int n) {
        if (this.localeSlot == -1) {
            int n2 = this.numMetricsSlots;
            if (n2 == 1 && !this.isStdComposite()) {
                n2 = this.numSlots;
            }
            for (int i = 0; i < n2; ++i) {
                if (!this.getSlotFont(i).supportsEncoding(null)) continue;
                this.localeSlot = i;
                break;
            }
            if (this.localeSlot == -1) {
                this.localeSlot = 0;
            }
        }
        return this.getSlotFont(this.localeSlot).useAAForPtSize(n);
    }

    public String toString() {
        String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        String string2 = "";
        for (int i = 0; i < this.numSlots; ++i) {
            string2 = string2 + "    Slot[" + i + "]=" + this.getSlotFont(i) + string;
        }
        return "** Composite Font: Family=" + this.familyName + " Name=" + this.fullName + " style=" + this.style + string + string2;
    }
}

