/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.IllegalComponentStateException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import sun.awt.DisplayChangedListener;
import sun.util.logging.PlatformLogger;

public class SunDisplayChanger {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.multiscreen.SunDisplayChanger");
    private Map<DisplayChangedListener, Void> listeners = Collections.synchronizedMap(new WeakHashMap(1));

    public void add(DisplayChangedListener displayChangedListener) {
        if (log.isLoggable(PlatformLogger.Level.FINE) && displayChangedListener == null) {
            log.fine("Assertion (theListener != null) failed");
        }
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("Adding listener: " + displayChangedListener);
        }
        this.listeners.put(displayChangedListener, null);
    }

    public void remove(DisplayChangedListener displayChangedListener) {
        if (log.isLoggable(PlatformLogger.Level.FINE) && displayChangedListener == null) {
            log.fine("Assertion (theListener != null) failed");
        }
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("Removing listener: " + displayChangedListener);
        }
        this.listeners.remove(displayChangedListener);
    }

    public void notifyListeners() {
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("notifyListeners");
        }
        this.notifyChanged(DisplayChangedListener::displayChanged, "displayChanged");
    }

    public void notifyPaletteChanged() {
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("notifyPaletteChanged");
        }
        this.notifyChanged(DisplayChangedListener::paletteChanged, "paletteChanged");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChanged(Consumer<DisplayChangedListener> consumer, String string) {
        WeakHashMap<DisplayChangedListener, Void> weakHashMap;
        Map<DisplayChangedListener, Void> map = this.listeners;
        synchronized (map) {
            weakHashMap = new WeakHashMap<DisplayChangedListener, Void>(this.listeners);
        }
        for (DisplayChangedListener displayChangedListener : weakHashMap.keySet()) {
            try {
                if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                    log.finest(string + " for listener: " + displayChangedListener);
                }
                consumer.accept(displayChangedListener);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                this.listeners.remove(displayChangedListener);
            }
        }
    }
}

