/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.reference.TemplateCssClassOrIdReference;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.resolve.CssSelectorMatcher;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import gnu.trove.THashSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlCssClassOrIdReference
extends PsiPolyVariantCachingReference
implements TemplateCssClassOrIdReference,
ResolvingHint,
EmptyResolveMessageProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.css.impl.util.references.HtmlCssClassOrIdReference");
    private final PsiElement myElement;
    private final int start;
    private final int end;
    private final boolean myCaseSensitive;
    private final boolean mySoft;

    public HtmlCssClassOrIdReference(PsiElement element, int _start, int _end, boolean caseSensitive, boolean soft) {
        this.myElement = element;
        this.start = _start;
        this.end = _end;
        this.myCaseSensitive = caseSensitive;
        this.mySoft = soft;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return new TextRange(this.start, this.end);
    }

    @NotNull
    public String getCanonicalText() {
        String text = this.myElement.getText();
        int _end = this.end > text.length() ? text.length() : this.end;
        String s = text.substring(this.start, _end);
        String string = this.myCaseSensitive ? s : s.toLowerCase(Locale.US);
        if (string == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
        LOG.assertTrue(manipulator != null);
        return manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(1);
        }
        return null;
    }

    private static boolean isId(PsiElement element) {
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
        return xmlAttribute != null && HtmlCssClassOrIdReference.isIdAttribute(xmlAttribute);
    }

    public static boolean isIdAttribute(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(2);
        }
        return attribute.getName().toLowerCase(Locale.US).endsWith("id");
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof CssSelectorSuffix) {
            CssSelectorSuffixType type = ((CssSelectorSuffix)element).getType();
            CssSelectorSuffixType expectedType = HtmlCssClassOrIdReference.isId(this.myElement) ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
            return type == expectedType && this.isEqualName(((CssSelectorSuffix)element).getName()) && this.refersToTheSameObject(element);
        }
        return false;
    }

    private boolean isEqualName(@Nullable String name) {
        return name != null && Comparing.strEqual((String)this.getCanonicalText(), (String)name, (boolean)this.myCaseSensitive);
    }

    private boolean refersToTheSameObject(PsiElement element) {
        XmlTag referringTag;
        ResolveResult[] resolveResults = this.multiResolve(false);
        PsiFile file = element.getContainingFile();
        if (resolveResults.length == 0 && (referringTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class)) != null) {
            CssResolver resolver = this.getCssResolver();
            resolver.setCollectingCompletionVariants(false);
            resolver.setSelectorMatcher(new CssSelectorMatcher(){

                public boolean isMatch(@NotNull CssSelector selector, @NotNull XmlTag tag, @NotNull CssResolver resolver) {
                    HashMap mapping;
                    if (selector == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (tag == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (resolver == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (!selector.isMatch(tag, resolver, mapping = new HashMap())) {
                        return false;
                    }
                    CssSimpleSelector simpleSelector = (CssSimpleSelector)mapping.get(referringTag);
                    return simpleSelector != null && HtmlCssClassOrIdReference.this.containsRelatedClassOrId(simpleSelector);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "selector";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "tag";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "resolver";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference$1";
                    objectArray[2] = "isMatch";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            for (XmlTag subTag : referringTag.getSubTags()) {
                if (!HtmlCssClassOrIdReference.tryToResolveTagOrChildrenToFile(subTag, resolver, file)) continue;
                return true;
            }
        }
        for (ResolveResult result : resolveResults) {
            PsiElement referenceElement = result.getElement();
            if (referenceElement == null || referenceElement.getContainingFile() != file) continue;
            return true;
        }
        return false;
    }

    private static boolean tryToResolveTagOrChildrenToFile(XmlTag tag, CssResolver resolver, PsiFile targetFile) {
        Ref processed = Ref.create((Object)false);
        resolver.processAllRulesetsForTag(tag, ruleset -> {
            if (ruleset.getContainingFile() == targetFile) {
                processed.set((Object)true);
                return false;
            }
            return true;
        });
        if (((Boolean)processed.get()).booleanValue()) {
            return true;
        }
        for (XmlTag subTag : tag.getSubTags()) {
            if (!HtmlCssClassOrIdReference.tryToResolveTagOrChildrenToFile(subTag, resolver, targetFile)) continue;
            return true;
        }
        return false;
    }

    private boolean containsRelatedClassOrId(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(3);
        }
        CssSelectorSuffixType expectedType = HtmlCssClassOrIdReference.isId(this.myElement) ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
        for (CssSelectorSuffix suffix : selector.getSelectorSuffixes()) {
            String name = suffix.getName();
            if (expectedType != suffix.getType() || !this.isEqualName(name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(4);
        }
        return EMPTY_ARRAY;
    }

    public void addCompletions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(5);
        }
        if (result == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(6);
        }
        MyClassCandidatesProcessor processor = new MyClassCandidatesProcessor(result);
        processor.process(parameters.getInvocationCount() > 1);
        if (!processor.isMatchDetected() && !processor.hasProcessedAllCssFiles()) {
            processor.process(true);
        }
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    protected ResolveResult[] resolveInner(boolean incomplete, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(7);
        }
        MyClassResolveProcessor processor = new MyClassResolveProcessor();
        processor.process(false);
        if (!processor.hasProcessedAllCssFiles() && processor.result == null && (processor.results == null || processor.results.isEmpty())) {
            processor.process(true);
        }
        if (processor.results != null) {
            ResolveResult[] resolveResultArray = processor.results.values().toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                HtmlCssClassOrIdReference.$$$reportNull$$$0(8);
            }
            return resolveResultArray;
        }
        if (processor.result != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{processor.result};
            if (resolveResultArray == null) {
                HtmlCssClassOrIdReference.$$$reportNull$$$0(9);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(10);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        return ReflectionUtil.isAssignable(CssClass.class, elementClass) || ReflectionUtil.isAssignable(CssIdSelector.class, elementClass);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)"invalid.css.selector", (Object[])new Object[0]);
        if (string == null) {
            HtmlCssClassOrIdReference.$$$reportNull$$$0(11);
        }
        return string;
    }

    protected CssResolver getCssResolver() {
        return CssResolveManager.getInstance().getNewResolver();
    }

    protected XmlAttribute getContextAttribute() {
        return (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlAttribute.class);
    }

    protected XmlTag getContextTag() {
        return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isIdAttribute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsRelatedClassOrId";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class MyPsiElementProcessor {
        protected final XmlTag myTag;
        private boolean myProcessedAllCssFiles;

        private MyPsiElementProcessor() {
            this.myTag = HtmlCssClassOrIdReference.this.getContextTag();
            this.myProcessedAllCssFiles = false;
        }

        protected abstract boolean isCollectingCompletionVariants();

        public boolean hasProcessedAllCssFiles() {
            return this.myProcessedAllCssFiles;
        }

        void process(boolean forceProcessAllFilesInProject) {
            if (this.myTag == null) {
                return;
            }
            XmlAttribute attribute = HtmlCssClassOrIdReference.this.getContextAttribute();
            CssResolver resolver = HtmlCssClassOrIdReference.this.getCssResolver();
            resolver.setResolvedAttrName(attribute != null ? attribute.getName() : null);
            resolver.setCollectingCompletionVariants(this.isCollectingCompletionVariants());
            resolver.setProcessAllCssFilesMode(forceProcessAllFilesInProject);
            String lowerAttrName = attribute != null ? attribute.getName().toLowerCase(Locale.US) : null;
            CssSelectorSuffixType targetType = lowerAttrName == null || lowerAttrName.contains("class") || lowerAttrName.contains("stylename") ? CssSelectorSuffixType.CLASS : CssSelectorSuffixType.ID;
            resolver.processAllRulesetsForTag(this.myTag, cssRuleset -> {
                for (CssSelector selector : cssRuleset.getSelectors()) {
                    if (!(selector.isAmpersandSelector() ? !selector.processAmpersandEvaluatedSelectors(s -> this.handleMatchedSelectors(targetType, (CssSelector)s, (PsiElement)selector)) : !this.handleMatchedSelectors(targetType, selector, null))) continue;
                    return false;
                }
                return true;
            });
            this.myProcessedAllCssFiles = resolver.hasProcessedAllCssFilesInProject();
        }

        private boolean handleMatchedSelectors(@NotNull CssSelectorSuffixType targetType, @NotNull CssSelector selector, @Nullable PsiElement navigationElement) {
            if (targetType == null) {
                MyPsiElementProcessor.$$$reportNull$$$0(0);
            }
            if (selector == null) {
                MyPsiElementProcessor.$$$reportNull$$$0(1);
            }
            for (CssSimpleSelector simpleSelector : selector.getSimpleSelectors()) {
                for (CssSelectorSuffix selectorSuffix : simpleSelector.getSelectorSuffixes()) {
                    String name;
                    if (targetType != selectorSuffix.getType() || (name = selectorSuffix.getName()) == null || this.handleSelector(name, selectorSuffix, (PsiElement)ObjectUtils.notNull((Object)navigationElement, (Object)selectorSuffix))) continue;
                    return false;
                }
            }
            return true;
        }

        abstract boolean handleSelector(@NotNull String var1, @NotNull CssSelectorSuffix var2, @NotNull PsiElement var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selector";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference$MyPsiElementProcessor";
            objectArray[2] = "handleMatchedSelectors";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyClassCandidatesProcessor
    extends MyPsiElementProcessor {
        @NotNull
        private final Set<String> myProcessedNames;
        @NotNull
        private final CompletionResultSet myCompletionResultSet;
        private boolean myMatchDetected;

        public MyClassCandidatesProcessor(CompletionResultSet completionResultSet) {
            if (completionResultSet == null) {
                MyClassCandidatesProcessor.$$$reportNull$$$0(0);
            }
            this.myProcessedNames = new THashSet();
            this.myCompletionResultSet = completionResultSet;
        }

        @Override
        protected boolean isCollectingCompletionVariants() {
            return true;
        }

        @Override
        boolean handleSelector(@NotNull String name, @NotNull CssSelectorSuffix selectorSuffix, @NotNull PsiElement navigationElement) {
            if (name == null) {
                MyClassCandidatesProcessor.$$$reportNull$$$0(1);
            }
            if (selectorSuffix == null) {
                MyClassCandidatesProcessor.$$$reportNull$$$0(2);
            }
            if (navigationElement == null) {
                MyClassCandidatesProcessor.$$$reportNull$$$0(3);
            }
            if (!this.myProcessedNames.contains(name)) {
                String elementName;
                CssSimpleSelector selector = (CssSimpleSelector)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)selectorSuffix, CssSimpleSelector.class);
                if (selector != null && !(elementName = selector.getElementName()).isEmpty() && Comparing.strEqual((String)this.myTag.getName(), (String)elementName, (boolean)HtmlCssClassOrIdReference.this.myCaseSensitive)) {
                    this.myProcessedNames.add(name);
                    this.myMatchDetected |= this.myCompletionResultSet.getPrefixMatcher().prefixMatches(name);
                    this.myCompletionResultSet.addElement(CssCompletionUtil.lookupForSelectorSuffix(name, selectorSuffix, navigationElement, this.myTag.getContainingFile()));
                    return true;
                }
                this.myProcessedNames.add(name);
                this.myMatchDetected |= this.myCompletionResultSet.getPrefixMatcher().prefixMatches(name);
                this.myCompletionResultSet.addElement(CssCompletionUtil.lookupForSelectorSuffix(name, selectorSuffix, navigationElement, null));
            }
            return true;
        }

        public boolean isMatchDetected() {
            return this.myMatchDetected;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completionResultSet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectorSuffix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationElement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference$MyClassCandidatesProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleSelector";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyClassResolveProcessor
    extends MyPsiElementProcessor {
        final String myReferenceText;
        ResolveResult result;
        HashMap<PsiElement, ResolveResult> results;

        MyClassResolveProcessor() {
            this.myReferenceText = HtmlCssClassOrIdReference.this.getCanonicalText();
        }

        @Override
        protected boolean isCollectingCompletionVariants() {
            return false;
        }

        @Override
        boolean handleSelector(@NotNull String cssSelectorName, @NotNull CssSelectorSuffix selectorSuffix, @NotNull PsiElement navigationElement) {
            PsiElement element;
            if (cssSelectorName == null) {
                MyClassResolveProcessor.$$$reportNull$$$0(0);
            }
            if (selectorSuffix == null) {
                MyClassResolveProcessor.$$$reportNull$$$0(1);
            }
            if (navigationElement == null) {
                MyClassResolveProcessor.$$$reportNull$$$0(2);
            }
            if (this.results != null && this.results.containsKey(navigationElement)) {
                return true;
            }
            if (this.result != null && (element = this.result.getElement()) != null && element.isEquivalentTo(navigationElement)) {
                return true;
            }
            if (Comparing.strEqual((String)this.myReferenceText, (String)cssSelectorName, (boolean)HtmlCssClassOrIdReference.this.myCaseSensitive)) {
                if (this.result != null) {
                    this.results = new HashMap(3);
                    this.results.put(this.result.getElement(), this.result);
                    this.result = null;
                }
                if (this.results == null) {
                    this.result = new PsiElementResolveResult(navigationElement);
                } else {
                    this.results.put(navigationElement, (ResolveResult)new PsiElementResolveResult(navigationElement));
                }
                return true;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cssSelectorName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectorSuffix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "navigationElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/resolve/HtmlCssClassOrIdReference$MyClassResolveProcessor";
            objectArray[2] = "handleSelector";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

