/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.style;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueMatchData;
import com.intellij.psi.css.impl.CssElementType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.descriptor.value.CssIntegerValue;
import com.intellij.psi.css.impl.descriptor.value.CssLengthValue;
import com.intellij.psi.css.impl.descriptor.value.CssPercentageValue;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CssRedundantUnitInspection
extends CssBaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.redundant.unit", (Object[])new Object[0]);
        if (string == null) {
            CssRedundantUnitInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssRedundantUnitInspection.$$$reportNull$$$0(1);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssDeclaration(CssDeclaration cssDeclaration) {
                Collection descriptors = cssDeclaration.getDescriptors();
                if (descriptors.isEmpty()) {
                    return;
                }
                CssTermList termList = cssDeclaration.getValue();
                if (termList == null) {
                    return;
                }
                Set matchDatas = descriptors.stream().map(descriptor -> termList.matchWithValueDescriptor(descriptor.getValueDescriptor())).collect(Collectors.toSet());
                for (CssTerm term : termList.getTerms()) {
                    IElementType iElementType;
                    PsiElement firstTermElement = term.getFirstChild();
                    if (firstTermElement == null) continue;
                    PsiElement child = firstTermElement.getFirstChild();
                    boolean foundNumberTerm = false;
                    if (child instanceof CssTokenImpl && (iElementType = ((CssTokenImpl)child).getElementType()) == CssElementTypes.CSS_NUMBER) {
                        for (CssValueMatchData matchData : matchDatas) {
                            CssValueDescriptor valueDescriptor = matchData.findDeepestDescriptorForElement((PsiElement)term);
                            if (!(valueDescriptor instanceof CssLengthValue) && !(valueDescriptor instanceof CssPercentageValue) && !(valueDescriptor instanceof CssIntegerValue)) continue;
                            foundNumberTerm = true;
                            break;
                        }
                    }
                    if (!foundNumberTerm) continue;
                    boolean zeroValue = "0".equals(child.getText());
                    PsiElement nextSibling = child.getNextSibling();
                    if (!zeroValue || nextSibling == null || nextSibling instanceof PsiWhiteSpace) continue;
                    holder.registerProblem(nextSibling, CssBundle.message((String)"css.inspections.redundant.unit.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveUnitQualifier()});
                }
            }
        };
        if (cssElementVisitor == null) {
            CssRedundantUnitInspection.$$$reportNull$$$0(2);
        }
        return cssElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/style/CssRedundantUnitInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/style/CssRedundantUnitInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveUnitQualifier
    extends LocalQuickFixBase {
        public RemoveUnitQualifier() {
            super(CssBundle.message((String)"css.inspections.redundant.unit.fix.message", (Object[])new Object[0]));
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            if (project == null) {
                RemoveUnitQualifier.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                RemoveUnitQualifier.$$$reportNull$$$0(1);
            }
            if ((psiElement = descriptor.getPsiElement()) != null && psiElement.isValid() && (psiElement instanceof CssElement || psiElement.getNode().getElementType() instanceof CssElementType)) {
                new WriteCommandAction(project, new PsiFile[]{psiElement.getContainingFile()}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (psiElement.isValid()) {
                            psiElement.delete();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/style/CssRedundantUnitInspection$RemoveUnitQualifier$1", "run"));
                    }
                }.execute();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/inspections/style/CssRedundantUnitInspection$RemoveUnitQualifier";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

