/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.google.common.base.Strings;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NotNull;

public class CssHtmlAttributeValueCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        String attributeName;
        if (parameters == null) {
            CssHtmlAttributeValueCompletionProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            CssHtmlAttributeValueCompletionProvider.$$$reportNull$$$0(1);
        }
        PsiElement position = parameters.getPosition();
        CssSimpleSelector simpleSelectors = (CssSimpleSelector)PsiTreeUtil.getParentOfType((PsiElement)position, CssSimpleSelector.class);
        CssAttribute cssAttribute = (CssAttribute)PsiTreeUtil.getParentOfType((PsiElement)position, CssAttribute.class);
        String tagName = simpleSelectors != null ? simpleSelectors.getElementName() : "";
        String string = attributeName = cssAttribute != null ? cssAttribute.getAttributeName() : "";
        if (!Strings.isNullOrEmpty((String)tagName) && !Strings.isNullOrEmpty((String)attributeName)) {
            try {
                String[] enumeratedValues;
                XmlAttributeDescriptor attributeDescriptor;
                XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)position.getProject());
                XmlTag xmlTag = elementFactory.createTagFromText((CharSequence)("<!DOCTYPE html><" + tagName + ">"), (Language)HTMLLanguage.INSTANCE);
                XmlElementDescriptor elementDescriptor = xmlTag.getDescriptor();
                if (elementDescriptor != null && (attributeDescriptor = elementDescriptor.getAttributeDescriptor(attributeName, xmlTag)) != null && (enumeratedValues = attributeDescriptor.getEnumeratedValues()) != null) {
                    for (String attributeValue : enumeratedValues) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)attributeValue));
                    }
                }
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/css/impl/util/completion/provider/CssHtmlAttributeValueCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

