/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.impl.stubs.index.CssCustomPropertyIndex;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.completion.CssCompletionUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssCustomPropertiesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private final int myBasePriority;
    @Nullable
    private final InsertHandler<LookupElement> myInsertHandler;

    public CssCustomPropertiesCompletionProvider(int basePriority, @Nullable InsertHandler<LookupElement> insertHandler) {
        this.myBasePriority = basePriority;
        this.myInsertHandler = insertHandler;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            CssCustomPropertiesCompletionProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            CssCustomPropertiesCompletionProvider.$$$reportNull$$$0(1);
        }
        PsiFile originalFile = parameters.getOriginalFile();
        PsiElement position = parameters.getPosition();
        CssDeclaration originalDeclaration = (CssDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)position, (Class[])new Class[]{CssDeclaration.class});
        originalDeclaration = originalDeclaration != null ? (CssDeclaration)CompletionUtil.getOriginalElement((PsiElement)originalDeclaration) : null;
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement(position);
        Project project = position.getProject();
        for (String name : StubIndex.getInstance().getAllKeys(CssCustomPropertyIndex.KEY, project)) {
            ProgressManager.checkCanceled();
            Collection declarations = StubIndex.getElements(CssCustomPropertyIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, CssDeclaration.class);
            for (CssDeclaration declaration : declarations) {
                if (originalDeclaration == null || originalDeclaration.equals(declaration)) continue;
                result.addElement(CssCompletionUtil.lookupForCustomProperty(name, (CssNamedElement)declaration, originalFile, this.myBasePriority, this.myInsertHandler));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/css/impl/util/completion/provider/CssCustomPropertiesCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

