/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.actions.ruleset.CreateStyleCallback;
import com.intellij.psi.css.actions.ruleset.StyleCreator;
import com.intellij.psi.css.impl.CssLazyStylesheet;
import com.intellij.psi.css.util.AbstractTagUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentFileStyleCreator
extends StyleCreator {
    private static final Logger LOG = Logger.getInstance(CurrentFileStyleCreator.class);
    private static final String SELECTOR_LIST_VARIABLE_NAME = "selectorForNewRuleset";

    public CurrentFileStyleCreator(@NotNull PsiFile contextFile) {
        if (contextFile == null) {
            CurrentFileStyleCreator.$$$reportNull$$$0(0);
        }
        super(CssBundle.message((String)"css.inspections.create.style.current.file", (Object[])new Object[0]), contextFile);
    }

    @Override
    @Nullable
    public CssRuleset createStyleDeclaration(@NotNull String selector, CssDeclaration ... declarations) {
        if (selector == null) {
            CurrentFileStyleCreator.$$$reportNull$$$0(1);
        }
        if (declarations == null) {
            CurrentFileStyleCreator.$$$reportNull$$$0(2);
        }
        return (CssRuleset)WriteAction.compute(() -> {
            CssRuleset result;
            if (selector == null) {
                CurrentFileStyleCreator.$$$reportNull$$$0(11);
            }
            if (declarations == null) {
                CurrentFileStyleCreator.$$$reportNull$$$0(12);
            }
            Project project = this.myContextFile.getProject();
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            XmlDocument document = ((XmlFile)this.myContextFile).getDocument();
            assert (document != null);
            XmlTag styleTag = CurrentFileStyleCreator.getOrCreateStyleTag(document);
            if (styleTag == null) {
                LOG.error((Object)LogMessageEx.createEvent((String)"CSS: Can't create style tag in file", (String)DebugUtil.currentStackTrace(), (Attachment[])new Attachment[]{new Attachment(this.myContextFile.getName(), this.myContextFile.getText())}));
                return null;
            }
            DocumentWindow window = InjectedLanguageUtil.getDocumentWindow((PsiElement)styleTag);
            boolean oneLine = window != null && window.isOneLine();
            CssStylesheet stylesheetElement = (CssStylesheet)PsiTreeUtil.getChildOfType((PsiElement)styleTag, CssStylesheet.class);
            CSSLanguage language = stylesheetElement != null ? stylesheetElement.getLanguage() : CSSLanguage.INSTANCE;
            CssRuleset newRuleset = CssElementFactory.getInstance((Project)project).createRuleset(selector, declarations, (Language)language);
            if (oneLine) {
                newRuleset = CssElementFactory.getInstance((Project)project).createRuleset(newRuleset.getText().replaceAll("\n", ""), (Language)language);
            }
            if (stylesheetElement == null || stylesheetElement.getRulesets().length == 0) {
                ASTNode endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(styleTag.getNode());
                CssStylesheet newStylesheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)newRuleset, CssLazyStylesheet.class);
                if (newStylesheet == null || endTagStart == null) {
                    LogMessageEx.error((Logger)LOG, (String)"CSS: Can't find stylesheet for create ruleset", (String[])new String[]{DebugUtil.currentStackTrace(), newRuleset.getContainingFile().getText()});
                    return null;
                }
                newStylesheet = (CssStylesheet)(stylesheetElement != null ? stylesheetElement.replace((PsiElement)newStylesheet) : styleTag.addBefore((PsiElement)newStylesheet, endTagStart.getPsi()));
                result = (CssRuleset)PsiTreeUtil.findChildOfType((PsiElement)newStylesheet, CssRuleset.class);
                if (result != null && !oneLine) {
                    CssRulesetList rulesetList = newStylesheet.getRulesetList();
                    PsiElement newLine = PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText("\n");
                    rulesetList.addBefore(newLine, (PsiElement)result);
                    rulesetList.addAfter(newLine, (PsiElement)result);
                }
            } else {
                result = stylesheetElement.addRuleset(newRuleset);
                if (!oneLine && stylesheetElement.isValid() && result != null && result.isValid()) {
                    PsiElement newLine = PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText("\n");
                    stylesheetElement.getRulesetList().addAfter(newLine, (PsiElement)result);
                }
            }
            return CurrentFileStyleCreator.postProcessAndRestoreElement(result);
        });
    }

    @Override
    public void createStyleDeclarationInteractively(@NotNull Editor editor, @NotNull String defaultSelector, @NotNull Collection<String> selectorVariants, final @Nullable CreateStyleCallback callback, CssDeclaration ... declarations) {
        if (editor == null) {
            CurrentFileStyleCreator.$$$reportNull$$$0(3);
        }
        if (defaultSelector == null) {
            CurrentFileStyleCreator.$$$reportNull$$$0(4);
        }
        if (selectorVariants == null) {
            CurrentFileStyleCreator.$$$reportNull$$$0(5);
        }
        if (declarations == null) {
            CurrentFileStyleCreator.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            CssSelectorList selectorList;
            if (defaultSelector == null) {
                CurrentFileStyleCreator.$$$reportNull$$$0(7);
            }
            if (declarations == null) {
                CurrentFileStyleCreator.$$$reportNull$$$0(8);
            }
            if (selectorVariants == null) {
                CurrentFileStyleCreator.$$$reportNull$$$0(9);
            }
            if (editor == null) {
                CurrentFileStyleCreator.$$$reportNull$$$0(10);
            }
            final CssRuleset ruleset = this.createStyleDeclaration(defaultSelector, declarations);
            Project project = this.myContextFile.getProject();
            if (ruleset != null && (selectorList = ruleset.getSelectorList()) != null) {
                TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)selectorList);
                builder.replaceElement((PsiElement)selectorList, SELECTOR_LIST_VARIABLE_NAME, (Expression)new SelectorListExpression(selectorVariants), true);
                Template template = builder.buildInlineTemplate();
                template.setToReformat(true);
                editor.getCaretModel().moveToOffset(selectorList.getTextRange().getStartOffset());
                TemplateManager.getInstance((Project)project).startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){
                    public String newSelectorText;
                    {
                        this.newSelectorText = selectorList.getText();
                    }

                    public void beforeTemplateFinished(TemplateState state, Template template) {
                        TextResult variableValue;
                        if (((TemplateImpl)template).getVariableCount() == 1 && (variableValue = state.getVariableValue(((TemplateImpl)template).getVariableNameAt(0))) != null) {
                            this.newSelectorText = variableValue.getText();
                        }
                    }

                    public void templateFinished(Template template, boolean brokenOff) {
                        if (callback != null) {
                            callback.after(this.newSelectorText, ruleset);
                        }
                    }
                });
            }
        });
    }

    @Nullable
    private static XmlTag getOrCreateStyleTag(XmlDocument document) {
        XmlTag styleTag = AbstractTagUtil.findStyleTag(document);
        if (styleTag == null) {
            styleTag = AbstractTagUtil.addCssStyleTag(document, true);
        }
        return styleTag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultSelector";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorVariants";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/actions/ruleset/CurrentFileStyleCreator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createStyleDeclaration";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createStyleDeclarationInteractively";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createStyleDeclarationInteractively$1";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createStyleDeclaration$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SelectorListExpression
    extends Expression {
        private final Collection<String> mySelectorNameCandidates;

        public SelectorListExpression(Collection<String> selectorNameCandidates) {
            this.mySelectorNameCandidates = selectorNameCandidates;
        }

        @Nullable
        public Result calculateResult(ExpressionContext context) {
            Editor editor = context.getEditor();
            if (editor != null) {
                TextResult insertedValue;
                TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
                TextResult textResult = insertedValue = templateState != null ? templateState.getVariableValue(CurrentFileStyleCreator.SELECTOR_LIST_VARIABLE_NAME) : null;
                if (insertedValue != null && !insertedValue.getText().isEmpty()) {
                    return insertedValue;
                }
            }
            return new TextResult((String)Iterables.getFirst(this.mySelectorNameCandidates, (Object)""));
        }

        @Nullable
        public Result calculateQuickResult(ExpressionContext context) {
            return this.calculateResult(context);
        }

        @Nullable
        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            return (LookupElement[])ContainerUtil.map2Array(this.mySelectorNameCandidates, LookupElement.class, s -> LookupElementBuilder.create((String)s));
        }
    }
}

