/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.google.common.base.Preconditions;
import com.intellij.codeInsight.template.emmet.configuration.CssPrefix;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssEmmetUtil {
    public static final Set<CssPrefix> ALL_PREFIXES = ContainerUtil.newHashSet((Object[])CssPrefix.values());
    public static final Map<Character, CssPrefix> KNOWN_PREFIXES = Collections.unmodifiableMap(ContainerUtil.newHashMap((Pair)Pair.pair((Object)Character.valueOf('w'), (Object)((Object)CssPrefix.WEBKIT)), (Pair[])new Pair[]{Pair.pair((Object)Character.valueOf('m'), (Object)((Object)CssPrefix.MOZ)), Pair.pair((Object)Character.valueOf('s'), (Object)((Object)CssPrefix.MS)), Pair.pair((Object)Character.valueOf('o'), (Object)((Object)CssPrefix.O)), Pair.pair((Object)Character.valueOf('k'), (Object)((Object)CssPrefix.KHTML))}));
    private static final Map<String, String> KEYWORD_ALIASES = Collections.unmodifiableMap(ContainerUtil.newHashMap((Pair)Pair.pair((Object)"a", (Object)"auto"), (Pair[])new Pair[]{Pair.pair((Object)"i", (Object)"inherit"), Pair.pair((Object)"s", (Object)"solid"), Pair.pair((Object)"da", (Object)"dashed"), Pair.pair((Object)"do", (Object)"dotted"), Pair.pair((Object)"t", (Object)"transparent")}));
    private static final Map<String, String> UNIT_ALIASES = Collections.unmodifiableMap(ContainerUtil.newHashMap((Pair)Pair.pair((Object)"p", (Object)"%"), (Pair[])new Pair[]{Pair.pair((Object)"e", (Object)"em"), Pair.pair((Object)"x", (Object)"ex"), Pair.pair((Object)"r", (Object)"rem")}));
    private static final String[] KEYWORDS = new String[]{"auto", "all", "inherit"};
    public static final Function<String, String> PREPARE_VALUE = input -> {
        if ("#".equals(input)) {
            return "#000000";
        }
        if (StringUtil.startsWithChar((CharSequence)input, (char)'#')) {
            Color color;
            if ("#t".equals(input)) {
                return "transparent";
            }
            double opacity = -1.0;
            int charIndex = input.indexOf(46);
            if (charIndex > -1) {
                try {
                    opacity = Double.parseDouble("0" + input.substring(charIndex));
                }
                catch (NumberFormatException e) {
                    opacity = -1.0;
                }
                input = input.substring(0, charIndex);
            }
            String normalizedHexColor = CssPsiColorUtil.normalizeHexColor(input);
            if (opacity > -1.0 && (color = ColorUtil.fromHex((String)normalizedHexColor, null)) != null) {
                return CssPsiColorUtil.toRgbColor(ColorUtil.withAlpha((Color)color, (double)opacity));
            }
            return normalizedHexColor;
        }
        if (StringUtil.startsWithChar((CharSequence)input, (char)'-') && (input.length() <= 1 || !CssEmmetUtil.isNumeric(input.charAt(1)))) {
            return input.substring(1);
        }
        return CssEmmetUtil.getKeyword(input);
    };
    private static final Pattern SINGLE_PROPERTY_PATTERN = Pattern.compile("^[A-z0-9-]+\\s*:");
    private static final String FLOAT_UNIT = "em";
    private static final String INT_UNIT = "px";

    public static boolean isNumeric(char ch) {
        return ch == '.' || Character.isDigit(ch);
    }

    public static boolean isValidKeyword(@NotNull String string) {
        if (string == null) {
            CssEmmetUtil.$$$reportNull$$$0(0);
        }
        return ArrayUtil.contains((String)CssEmmetUtil.getKeyword(string), (String[])KEYWORDS);
    }

    @NotNull
    private static String getKeyword(@NotNull String alias) {
        if (alias == null) {
            CssEmmetUtil.$$$reportNull$$$0(1);
        }
        String string = KEYWORD_ALIASES.containsKey(alias) ? KEYWORD_ALIASES.get(alias) : alias;
        if (string == null) {
            CssEmmetUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static String findPatternInSubstring(Pattern pattern, String string, int offset) {
        Preconditions.checkPositionIndex((int)offset, (int)string.length());
        Matcher matcher = pattern.matcher(string.substring(offset));
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private CssEmmetUtil() {
    }

    public static boolean isSingleProperty(@NotNull TemplateImpl template) {
        if (template == null) {
            CssEmmetUtil.$$$reportNull$$$0(3);
        }
        return CssEmmetUtil.getSinglePropertyName(template) != null;
    }

    @Nullable
    public static String getSinglePropertyName(@NotNull TemplateImpl template) {
        String string;
        if (template == null) {
            CssEmmetUtil.$$$reportNull$$$0(4);
        }
        if ((string = template.getString()).contains("\n") || string.contains("/*") || StringUtil.countChars((CharSequence)string, (char)';') > 1) {
            return null;
        }
        if (!SINGLE_PROPERTY_PATTERN.matcher(string).find()) {
            return null;
        }
        return (String)ContainerUtil.getFirstItem((List)StringUtil.split((String)string, (String)":"));
    }

    public static String getUnit(String unit) {
        return UNIT_ALIASES.containsKey(unit) ? UNIT_ALIASES.get(unit) : unit;
    }

    @NotNull
    public static String normalizeValue(@Nullable String value, boolean unitlessProperty) {
        value = StringUtil.notNullize((String)value).trim().toLowerCase(Locale.US);
        Matcher matcher = Pattern.compile("^(-?[0-9.]+)([a-z]*)$").matcher(value);
        if (matcher.find() && matcher.groupCount() > 1) {
            String result = matcher.group(1);
            String unit = matcher.group(2);
            if (unit.isEmpty() && ("0".equals(result) || unitlessProperty)) {
                String string = result;
                if (string == null) {
                    CssEmmetUtil.$$$reportNull$$$0(5);
                }
                return string;
            }
            if (unit.isEmpty()) {
                if (StringUtil.endsWithChar((CharSequence)result, (char)'.')) {
                    String string = result.substring(0, result.length() - 1) + FLOAT_UNIT;
                    if (string == null) {
                        CssEmmetUtil.$$$reportNull$$$0(6);
                    }
                    return string;
                }
                String string = result + (StringUtil.containsChar((String)result, (char)'.') ? FLOAT_UNIT : INT_UNIT);
                if (string == null) {
                    CssEmmetUtil.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = result + CssEmmetUtil.getUnit(unit);
            if (string == null) {
                CssEmmetUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = value;
        if (string == null) {
            CssEmmetUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static Collection<CssPrefix> filterPrefixes(Collection<CssPrefix> prefixes) {
        ArrayList result = ContainerUtil.newArrayList();
        for (CssPrefix prefix : CssPrefix.values()) {
            if (!prefixes.contains((Object)prefix)) continue;
            result.add(prefix);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/CssEmmetUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/CssEmmetUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyword";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidKeyword";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getKeyword";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSingleProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSinglePropertyName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

