/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.localization;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.lang.template.DjangoTemplateElementGenerator;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.lang.template.psi.DjangoTagName;
import com.jetbrains.django.lang.template.psi.DjangoTemplateElementTypes;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.django.lang.template.tags.DjangoIncludeExtendsTag;
import com.jetbrains.django.lang.template.tags.DjangoLoadTag;
import com.jetbrains.django.util.DjangoTemplateUtil;
import com.jetbrains.localization.psi.impl.LocaleFile;
import com.jetbrains.localization.psi.impl.LocaleMsgid;
import com.jetbrains.localization.psi.impl.LocaleSection;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WrapTransTagIntention
extends PyBaseIntentionAction {
    public static final String INTENTION_NAME = "Wrap with 'trans' tag";

    @NotNull
    public String getText() {
        if (INTENTION_NAME == null) {
            WrapTransTagIntention.$$$reportNull$$$0(0);
        }
        return INTENTION_NAME;
    }

    @NotNull
    public String getFamilyName() {
        if (INTENTION_NAME == null) {
            WrapTransTagIntention.$$$reportNull$$$0(1);
        }
        return INTENTION_NAME;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        TemplatesService templatesService;
        if (project == null) {
            WrapTransTagIntention.$$$reportNull$$$0(2);
        }
        if (file == null || !DjangoFacet.isPresent((PsiElement)file)) {
            return false;
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        TemplatesService templatesService2 = templatesService = modules.length == 0 ? null : TemplatesService.getInstance((Module)modules[0]);
        if (templatesService == null || !templatesService.getTemplateLanguage().equals("Django")) {
            return false;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            return false;
        }
        if (file.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
            PsiElement element1 = file.findElementAt(selectionModel.getSelectionStart());
            PsiElement element2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
            if (element1 != null && element2 != null) {
                if (this.isPartOfXmlTag(element1, element2)) {
                    return false;
                }
                if (this.hasTagBetween(element1, element2, file.getViewProvider())) {
                    return false;
                }
                PsiElement tag = DjangoTemplateUtil.findParentXmlTag((PsiElement)element1);
                if (tag != null) {
                    return false;
                }
                tag = this.findTransBlockTag(element1);
                if (tag != null) {
                    return false;
                }
                PsiElement parent = element1.getParent();
                while (!(parent instanceof PsiFile)) {
                    if (this.findTransBlockTag(parent) != null) {
                        return false;
                    }
                    parent = parent.getParent();
                }
                return true;
            }
        }
        return false;
    }

    private boolean isPartOfXmlTag(PsiElement element1, PsiElement element2) {
        IElementType type = element1.getNode().getElementType();
        if (element1 == element2 && type == XmlTokenType.XML_NAME) {
            return true;
        }
        return element1.getNextSibling() == element2 && (type == XmlTokenType.XML_START_TAG_START || type == XmlTokenType.XML_END_TAG_START || type == XmlTokenType.XML_NAME);
    }

    private boolean hasTagBetween(PsiElement element1, PsiElement element2, FileViewProvider viewProvider) {
        for (PsiElement e = element1; e != null && e != element2; e = e.getNextSibling()) {
            PsiElement djangoElem;
            if (e.getNode().getElementType() != DjangoTemplateTokenTypes.DJANGO_INJECTION_IN_HTML || (djangoElem = viewProvider.findElementAt(e.getTextOffset(), (Language)DjangoTemplateLanguage.INSTANCE)) == null || djangoElem.getNode().getElementType() != DjangoTemplateTokenTypes.DJANGO_TAG_START) continue;
            return true;
        }
        return false;
    }

    private PsiElement findTransBlockTag(PsiElement element) {
        for (PsiElement prev = element.getPrevSibling(); prev != null; prev = prev.getPrevSibling()) {
            DjangoTagName tagName = (DjangoTagName)PsiTreeUtil.findChildOfType((PsiElement)prev, DjangoTagName.class);
            if (prev.getNode().getElementType() == DjangoTemplateElementTypes.XML_TAG && tagName != null) {
                if (tagName.getTagName().equals("blocktrans")) {
                    return prev;
                }
                if (tagName.getTagName().equals("endblocktrans")) {
                    return null;
                }
            }
            if (!(prev instanceof DjangoTagName) || !((DjangoTagName)prev).getTagName().equals("blocktrans")) continue;
            return prev;
        }
        return null;
    }

    public void doInvoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        SelectionModel selectionModel;
        if (project == null) {
            WrapTransTagIntention.$$$reportNull$$$0(3);
        }
        if (file.getViewProvider() instanceof TemplateLanguageFileViewProvider && (selectionModel = editor.getSelectionModel()).hasSelection()) {
            PsiElement element1 = file.findElementAt(selectionModel.getSelectionStart());
            PsiElement element2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
            if (element2 instanceof PsiWhiteSpace) {
                element2 = element2.getPrevSibling();
            }
            if (element1 != null && element2 != null) {
                boolean isBlock = true;
                if (element1 == element2) {
                    isBlock = false;
                }
                this.wrap(element1.getTextRange().getStartOffset(), element2.getTextRange().getEndOffset(), isBlock, project, editor, file);
            }
        }
    }

    private void wrap(int startOffset, int endOffset, boolean isBlock, Project project, Editor editor, PsiFile psiFile) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = editor.getDocument();
        PsiElement startElement = psiFile.findElementAt(startOffset);
        this.modifyPoFile(document.getText(new TextRange(startOffset, endOffset)), psiFile, project, editor.getCaretModel().getLogicalPosition().line + 1);
        if (isBlock) {
            document.insertString(startOffset, (CharSequence)"{% blocktrans %}");
            documentManager.commitDocument(editor.getDocument());
            document.insertString(endOffset + "{% blocktrans %}".length(), (CharSequence)"{% endblocktrans %}");
        } else {
            DjangoTemplateElementGenerator elementGenerator = DjangoTemplateElementGenerator.getInstance((Project)project);
            String text = document.getText(new TextRange(startOffset, endOffset));
            DjangoTagElementImpl replacement = StringUtil.isQuotedString((String)text) ? elementGenerator.createTag("trans", text) : elementGenerator.createTag("trans", "\"" + text + "\"");
            startElement.replace((PsiElement)replacement);
        }
        boolean hasLoad = this.hasLoadTag((PsiElement)psiFile, psiFile.getViewProvider());
        if (!hasLoad) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            DjangoIncludeExtendsTag extendTag = DjangoTemplateUtil.getExtends((PsiFile)psiFile);
            int offset = psiFile.getTextOffset();
            String loadString = "{% load i18n %}";
            if (extendTag != null) {
                offset = extendTag.getParent().getTextRange().getEndOffset();
                loadString = "\n" + loadString;
            } else {
                loadString = loadString + "\n";
            }
            document.insertString(offset, (CharSequence)loadString);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
    }

    private void modifyPoFile(String text, PsiFile psiFile, Project project, int lineNumber) {
        DjangoFacet facet = DjangoFacet.getInstance((PsiElement)psiFile);
        if (facet != null) {
            VirtualFile root = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile();
            String id = this.createPoString(text);
            String relativePath = this.getRelativePath(facet, psiFile, lineNumber);
            if (root != null) {
                PsiDirectory rootDir = PsiManager.getInstance((Project)project).findDirectory(root);
                if (rootDir == null) {
                    return;
                }
                PsiDirectory localeDir = rootDir.findSubdirectory("locale");
                if (localeDir == null) {
                    return;
                }
                VirtualFile localeRoot = localeDir.getVirtualFile();
                VfsUtil.processFilesRecursively((VirtualFile)localeRoot, virtualFile -> {
                    PsiFile file = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (file instanceof LocaleFile) {
                        for (LocaleSection section : ((LocaleFile)file).getSections()) {
                            for (LocaleMsgid msgid : section.getIds()) {
                                if (!this.getVariants(id).contains(msgid.getId())) continue;
                                return true;
                            }
                        }
                        Document doc = file.getViewProvider().getDocument();
                        if (doc != null) {
                            if (relativePath != null) {
                                doc.insertString(file.getTextRange().getEndOffset(), (CharSequence)("\n#: " + relativePath));
                                PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
                            }
                            doc.insertString(file.getTextRange().getEndOffset(), (CharSequence)("\nmsgid " + this.getVariant(id, 's') + "\nmsgstr \"\""));
                        }
                    }
                    return true;
                });
            }
        }
    }

    private String getRelativePath(DjangoFacet facet, PsiFile psiFile, int lineNumber) {
        String relativePath = null;
        VirtualFile root = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile();
        VirtualFile vFile = psiFile.getVirtualFile();
        if (root != null && vFile != null) {
            relativePath = VfsUtilCore.getRelativePath((VirtualFile)vFile, (VirtualFile)root, (char)File.separatorChar);
            relativePath = relativePath + ":" + lineNumber;
        }
        return relativePath;
    }

    private String createPoString(String text) {
        StringBuilder stringBuilder = new StringBuilder(StringUtil.escapeQuotes((String)text));
        String[] parts = stringBuilder.toString().split("\n");
        if (parts.length > 1) {
            stringBuilder = new StringBuilder("\"\"");
            int i = 1;
            for (String part : parts) {
                stringBuilder.append("\n\"").append(part);
                if (i != parts.length) {
                    stringBuilder.append("\\n\"");
                } else {
                    stringBuilder.append("\"");
                }
                ++i;
            }
        } else {
            stringBuilder.insert(0, "\"");
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }

    private String getVariant(String toTransform, char ch) {
        return toTransform.replaceAll("\\{\\{ *([^ \n\r\t}{]+) *\\}\\}", "\\%\\($1\\)" + ch);
    }

    private Set<String> getVariants(String toTransform) {
        HashSet<String> result = new HashSet<String>();
        char[] cArray = "sdbcoxXneEfFgG".toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character ch = Character.valueOf(cArray[i]);
            result.add(StringUtil.unquoteString((String)this.getVariant(toTransform, ch.charValue())));
        }
        return result;
    }

    private boolean hasLoadTag(PsiElement element, FileViewProvider viewProvider) {
        boolean hasLoad = false;
        element = viewProvider.getPsi((Language)DjangoTemplateLanguage.INSTANCE);
        if (element == null) {
            return false;
        }
        if ((element = element.getFirstChild()) == null) {
            return false;
        }
        block0: for (PsiElement ee : element.getChildren()) {
            ASTNode[] names;
            DjangoLoadTag load;
            if (ee.getNode().getElementType() != DjangoTemplateElementTypes.XML_TAG || (load = (DjangoLoadTag)PsiTreeUtil.findChildOfType((PsiElement)ee, DjangoLoadTag.class)) == null || (names = load.getLibraryMembers()) == null) continue;
            for (ASTNode name : names) {
                if (!"i18n".equals(name.getText())) continue;
                hasLoad = true;
                continue block0;
            }
        }
        return hasLoad;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/localization/WrapTransTagIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/localization/WrapTransTagIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

