/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.localization;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.lang.template.psi.DjangoTagName;
import com.jetbrains.django.lang.template.psi.impl.DjangoStringLiteralImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.django.lang.template.tags.DjangoBlockTransTag;
import com.jetbrains.django.util.DjangoTemplateUtil;
import com.jetbrains.localization.LocaleFileType;
import com.jetbrains.localization.LocaleLineMarkerUtils;
import com.jetbrains.localization.psi.impl.LocaleMsgid;
import com.jetbrains.python.codeInsight.PyElementListCellRenderer;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class LocaleLineMarkerProvider
implements LineMarkerProvider,
DumbAware {
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            LocaleLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            LocaleLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            LocaleLineMarkerProvider.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (elements.isEmpty() || DumbService.getInstance((Project)elements.get(0).getProject()).isDumb()) {
            return;
        }
        for (int i = 0; i < elements.size(); ++i) {
            DjangoTagName parentTagName;
            DjangoTagElementImpl parent;
            PsiElement element = elements.get(i);
            if (element instanceof DjangoBlockTransTag) {
                PsiElement anchor = PsiTreeUtil.getDeepestFirst((PsiElement)element);
                result.add(new LineMarkerInfo(anchor, anchor.getTextRange(), LocaleFileType.INSTANCE.getIcon(), 11, (Function)new ViewTooltipProvider(), new LocaleNavigationHandler(), GutterIconRenderer.Alignment.LEFT));
                continue;
            }
            if (!(element instanceof DjangoStringLiteralImpl) || (parent = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)element, DjangoTagElementImpl.class, (boolean)false)) == null || (parentTagName = DjangoTemplateUtil.getTagNameElement((DjangoTagElementImpl)parent)) == null || !"trans".equals(parentTagName.getTagName())) continue;
            PsiElement anchor = PsiTreeUtil.getDeepestFirst((PsiElement)element);
            result.add(new LineMarkerInfo(anchor, anchor.getTextRange(), LocaleFileType.INSTANCE.getIcon(), 11, (Function)new ViewTooltipProvider(), new LocaleNavigationHandler(), GutterIconRenderer.Alignment.LEFT));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/localization/LocaleLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class LocaleNavigationHandler<T extends PsiElement>
    implements GutterIconNavigationHandler<T> {
        private LocaleNavigationHandler() {
        }

        public void navigate(MouseEvent e, T elt) {
            Set<LocaleMsgid> references = LocaleLineMarkerUtils.getReferences(elt);
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])references.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY), (String)"Select locale", (String)"Locales", (ListCellRenderer)this.createListCellRenderer());
        }

        protected PyElementListCellRenderer createListCellRenderer() {
            return new PyElementListCellRenderer(){

                public String getElementText(PsiElement element) {
                    if (element instanceof LocaleMsgid) {
                        return ((LocaleMsgid)element).getId();
                    }
                    return super.getElementText(element);
                }
            };
        }
    }

    private static class ViewTooltipProvider
    implements Function<PsiElement, String> {
        private ViewTooltipProvider() {
        }

        public String fun(PsiElement element) {
            Set<LocaleMsgid> usages = LocaleLineMarkerUtils.getReferences(element);
            if (usages.size() == 0) {
                return "Can't find related locale message.";
            }
            if (usages.size() == 1) {
                return "Referenced from " + this.getReferenceLocaleName((PsiElement)usages.iterator().next());
            }
            StringBuilder result = new StringBuilder("<html>Referenced from:");
            for (LocaleMsgid usage : usages) {
                result.append("<br>&nbsp;&nbsp;").append(this.getReferenceLocaleName((PsiElement)usage));
            }
            return result.toString();
        }

        private String getReferenceLocaleName(PsiElement usage) {
            PsiFile file = usage.getContainingFile();
            VirtualFile vFile = file.getVirtualFile();
            Project project = usage.getProject();
            if (vFile == null) {
                return "";
            }
            DjangoFacet facet = DjangoFacet.getInstance((PsiElement)usage);
            VirtualFile root = facet != null ? ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile() : project.getBaseDir();
            String location = "";
            if (root == null) {
                return "";
            }
            if (vFile.getUrl().startsWith(root.getUrl())) {
                location = VfsUtilCore.getRelativePath((VirtualFile)vFile, (VirtualFile)root, (char)File.separatorChar);
            }
            location = ".../" + location;
            return location;
        }
    }
}

