/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.parser.psi.impl;

import com.intellij.docker.dockerFile.parser.DockerParserUtil;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiCommand;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileFromCommand;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileFromStageDeclaration;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileRegularOption;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileRegularValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedList;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerPsiStageReferenceImpl
implements PsiReference {
    private static final Object[] NO_VARIANTS = new Object[0];
    private static final Pattern BY_INDEX_REF = Pattern.compile("\\d+]");
    private final DockerFileRegularValue myValue;
    private final DockerFileRegularOption myHost;

    public DockerPsiStageReferenceImpl(@NotNull DockerFileRegularOption host) {
        if (host == null) {
            DockerPsiStageReferenceImpl.$$$reportNull$$$0(0);
        }
        this.myHost = host;
        this.myValue = host.getRegularValue();
        assert (this.myValue != null);
    }

    public PsiElement getElement() {
        return this.myHost;
    }

    public TextRange getRangeInElement() {
        TextRange hostRange = this.myHost.getTextRange();
        TextRange valueRange = this.myValue.getTextRange();
        return valueRange.shiftRight(-hostRange.getStartOffset());
    }

    @Nullable
    public PsiElement resolve() {
        String lookup = this.getReferencedName();
        DockerPsiCommand contextCommand = (DockerPsiCommand)PsiTreeUtil.getParentOfType((PsiElement)this.myValue, DockerPsiCommand.class);
        if (contextCommand == null) {
            return null;
        }
        DockerFileFromCommand targetFromCommand = BY_INDEX_REF.matcher(lookup).matches() ? DockerPsiStageReferenceImpl.resolveByIndex(lookup, contextCommand) : DockerPsiStageReferenceImpl.resolveByStageName(lookup, contextCommand);
        return Optional.ofNullable(targetFromCommand).map(DockerFileFromCommand::getFromStageDeclaration).orElse(null);
    }

    @Nullable
    private static DockerFileFromCommand resolveByStageName(String lookup, DockerPsiCommand context) {
        DockerFileFromCommand curFrom = DockerPsiStageReferenceImpl.previousFrom(context);
        while (curFrom != null) {
            DockerFileFromStageDeclaration curStageDeclaration = curFrom.getFromStageDeclaration();
            if (curStageDeclaration != null && curStageDeclaration.isDeclarationForName(lookup)) {
                return curFrom;
            }
            curFrom = DockerPsiStageReferenceImpl.previousFrom(curFrom);
        }
        return null;
    }

    @Nullable
    private static DockerFileFromCommand resolveByIndex(String lookup, DockerPsiCommand context) {
        int index;
        try {
            index = Integer.parseInt(lookup);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        LinkedList<DockerFileFromCommand> fromsBefore = new LinkedList<DockerFileFromCommand>();
        DockerFileFromCommand curFrom = DockerPsiStageReferenceImpl.previousFrom(context);
        while (curFrom != null) {
            fromsBefore.addFirst(curFrom);
            curFrom = DockerPsiStageReferenceImpl.previousFrom(curFrom);
        }
        return index < fromsBefore.size() ? (DockerFileFromCommand)fromsBefore.get(index) : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myValue.getText();
        if (string == null) {
            DockerPsiStageReferenceImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ASTNode curNode = this.myValue.getNode();
        ASTNode lastChild = curNode.getLastChildNode();
        ASTNode firstChild = curNode.getFirstChildNode();
        PostprocessReformattingAspect.getInstance((Project)this.getProject()).disablePostprocessFormattingInside(() -> {
            if (lastChild != firstChild) {
                curNode.removeRange(firstChild, lastChild);
            }
            curNode.replaceChild(lastChild, DockerParserUtil.createNewIdentifier(newElementName).getNode());
        });
        return this.myValue;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            DockerPsiStageReferenceImpl.$$$reportNull$$$0(2);
        }
        return this.myValue;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof DockerFileFromStageDeclaration)) {
            return false;
        }
        DockerFileFromStageDeclaration stage = (DockerFileFromStageDeclaration)element;
        return stage.isDeclarationForName(this.getReferencedName());
    }

    @NotNull
    public Object[] getVariants() {
        if (NO_VARIANTS == null) {
            DockerPsiStageReferenceImpl.$$$reportNull$$$0(3);
        }
        return NO_VARIANTS;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    private String getReferencedName() {
        String string = this.myValue.getText().trim();
        if (string == null) {
            DockerPsiStageReferenceImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    private Project getProject() {
        return this.myValue.getProject();
    }

    @Nullable
    private static DockerFileFromCommand previousFrom(@NotNull DockerPsiCommand cmd) {
        if (cmd == null) {
            DockerPsiStageReferenceImpl.$$$reportNull$$$0(5);
        }
        return (DockerFileFromCommand)PsiTreeUtil.getPrevSiblingOfType((PsiElement)cmd, DockerFileFromCommand.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/dockerFile/parser/psi/impl/DockerPsiStageReferenceImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/dockerFile/parser/psi/impl/DockerPsiStageReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "previousFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

