/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.references;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSUtil;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.impl.LESSMixinName;
import org.jetbrains.plugins.less.psi.stubs.LessMixinIndex;

public class LESSMixinReference
extends PsiPolyVariantReferenceBase<LESSMixinInvocation> {
    public LESSMixinReference(LESSMixinInvocation element) {
        super((PsiElement)element);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)this.myElement);
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)((LESSMixinInvocation)this.myElement).getContainingFile(), (PsiElement)this.myElement, (boolean)false);
        LinkedList result = Lists.newLinkedList();
        LinkedList resultResolvedByNameOnly = Lists.newLinkedList();
        String invocationNamespace = ((LESSMixinInvocation)this.myElement).getNamespace();
        LessMixinIndex.process(((LESSMixinInvocation)this.myElement).getFullName(), ((LESSMixinInvocation)this.myElement).getProject(), scope, (Processor<? super LESSMixin>)((Processor)mixin -> {
            if (LESSUtil.isMixinMatchesWithInvocation(mixin, this.myElement, invocationNamespace)) {
                boolean validResult = importedFiles.contains(mixin.getContainingFile().getVirtualFile());
                PsiElementResolveResult resolveResult = new PsiElementResolveResult(mixin.getTargetForReference(), validResult);
                if (validResult) {
                    result.add(resolveResult);
                } else {
                    resultResolvedByNameOnly.add(resolveResult);
                }
            }
            return true;
        }));
        result.addAll(resultResolvedByNameOnly);
        ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            LESSMixinReference.$$$reportNull$$$0(0);
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            LESSMixinReference.$$$reportNull$$$0(1);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    protected TextRange calculateDefaultRangeInElement() {
        LESSMixinName fullNameIdentifier = ((LESSMixinInvocation)this.myElement).getFullNameIdentifier();
        return fullNameIdentifier != null && fullNameIdentifier.getText().length() > 0 ? TextRange.from((int)(fullNameIdentifier.getStartOffsetInParent() + 1), (int)(fullNameIdentifier.getTextLength() - 1)) : TextRange.EMPTY_RANGE;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return ((LESSMixinInvocation)this.myElement).setName(newElementName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/less/references/LESSMixinReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

