/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.parsing.CssMathParser;
import com.intellij.psi.css.impl.parsing.CssParser2;
import com.intellij.psi.css.impl.stubs.CssStylesheetStubElementType;
import com.intellij.psi.css.impl.util.CssStylesheetLazyElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSBundle;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.lexer.LESSTokenTypes;
import org.jetbrains.plugins.less.parser.LessMathParser;

public class LESSParser
extends CssParser2 {
    private static final TokenSet ADD_OPS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_MINUS, CssElementTypes.CSS_PLUS});
    private static final TokenSet MULT_OPS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_ASTERISK, CssElementTypes.CSS_SLASH});
    private static final TokenSet COMPARE_OPS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_GT, LESSTokenTypes.LT, LESSTokenTypes.GEQ, LESSTokenTypes.LEQ, CssElementTypes.CSS_EQ});
    private static final TokenSet MIXIN_INVOCATION_END = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_LPAREN, CssElementTypes.CSS_SEMICOLON, CssElementTypes.CSS_RBRACE, CssElementTypes.CSS_IMPORTANT});
    private final LessMathParser LESS_MATH_PARSER = new LessMathParser(this);
    private boolean rulesetSeen;

    protected TokenSet getCommentTokenTypes() {
        return LESSElementTypes.LESS_COMMENTS;
    }

    public void addToken() {
        if (this.isIdent()) {
            this.addIdentOrError();
        } else {
            this.addSingleToken();
        }
    }

    protected boolean parseRulesetListItem(boolean stopOnRBrace) {
        if (this.parseLessConstructionsDeclarations()) {
            return true;
        }
        if (this.parseRulesetMedia()) {
            return true;
        }
        if (this.parseNamespace()) {
            return true;
        }
        if (this.getTokenType() == LESSTokenTypes.VARIABLE) {
            this.myBuilder.remapCurrentToken(CssElementTypes.CSS_ATKEYWORD);
        }
        return super.parseRulesetListItem(stopOnRBrace);
    }

    protected boolean parseKeyframesRuleset() {
        if (!super.parseKeyframesRuleset()) {
            if (this.parseLessConstructionsDeclarations()) {
                if (this.isSemicolonRequired()) {
                    if (this.getTokenType() == CssElementTypes.CSS_SEMICOLON) {
                        this.addTokenAndSkipWhitespace();
                    } else if (this.getTokenType() != CssElementTypes.CSS_RBRACE) {
                        this.createErrorElement(CssBundle.message((String)"expected", (Object[])new Object[]{Character.valueOf(';')}));
                    }
                }
                return true;
            }
            return false;
        }
        this.rulesetSeen = true;
        return true;
    }

    private boolean parseGtThanMixin() {
        IElementType nextElementType;
        if (this.getTokenType() != CssElementTypes.CSS_HASH && this.getTokenType() != CssElementTypes.CSS_PERIOD) {
            return false;
        }
        int move = 1;
        if (this.getTokenType() == CssElementTypes.CSS_PERIOD) {
            ++move;
        }
        if ((nextElementType = this.myBuilder.lookAhead(move)) != CssElementTypes.CSS_GT && nextElementType != CssElementTypes.CSS_HASH && nextElementType != CssElementTypes.CSS_PERIOD) {
            return false;
        }
        PsiBuilder.Marker gtThanMixin = this.createCompositeElement();
        while (this.getTokenType() == CssElementTypes.CSS_HASH && !MIXIN_INVOCATION_END.contains(this.myBuilder.lookAhead(1)) || this.getTokenType() == CssElementTypes.CSS_PERIOD && !MIXIN_INVOCATION_END.contains(this.myBuilder.lookAhead(2))) {
            PsiBuilder.Marker mixinName = this.createCompositeElement();
            if (this.getTokenType() == CssElementTypes.CSS_PERIOD) {
                this.addSingleToken();
                this.addToken();
            } else {
                this.addTokenAndSkipWhitespace();
            }
            mixinName.done(LESSElementTypes.LESS_NAMESPACE);
            if (CssElementTypes.CSS_GT != this.getTokenType()) continue;
            this.addSingleToken();
        }
        if (this.parseMixinInvocation()) {
            gtThanMixin.done(LESSElementTypes.LESS_GT_MIXIN_INVOCATION);
            return true;
        }
        gtThanMixin.rollbackTo();
        return false;
    }

    private boolean parseMixinParameter(IElementType parameterSeparator) {
        PsiBuilder.Marker parameter = this.createCompositeElement();
        if (this.getTokenType() == LESSTokenTypes.VARIABLE) {
            PsiBuilder.Marker declaration = this.createCompositeElement();
            this.parseVariable();
            if (this.getTokenType() == LESSTokenTypes.THREE_DOTS) {
                declaration.done((IElementType)LESSElementTypes.LESS_VARIABLE_DECLARATION);
                parameter.done((IElementType)LESSElementTypes.LESS_PARAMETER);
                this.addTokenAndSkipWhitespace();
                return true;
            }
            if (this.getTokenType() == CssElementTypes.CSS_COLON) {
                this.addTokenAndSkipWhitespace();
                if (this.getTokenType() == CssElementTypes.CSS_LBRACE) {
                    this.parseDeclarationBlock();
                } else {
                    this.parseTermList(true, false, new IElementType[]{parameterSeparator});
                }
            }
            declaration.done((IElementType)LESSElementTypes.LESS_VARIABLE_DECLARATION);
            parameter.done((IElementType)LESSElementTypes.LESS_PARAMETER);
            return true;
        }
        if (this.getTokenType() == LESSTokenTypes.THREE_DOTS) {
            this.addTokenAndSkipWhitespace();
            parameter.done((IElementType)LESSElementTypes.LESS_PARAMETER);
            return true;
        }
        boolean result = this.parseTermList(true, false, new IElementType[]{parameterSeparator});
        parameter.done((IElementType)LESSElementTypes.LESS_PARAMETER);
        return result;
    }

    private boolean parseMixinParameters() {
        return this.parseMixinParameters(CssElementTypes.CSS_COMMA);
    }

    private boolean parseMixinParameters(IElementType parametersSeparator) {
        PsiBuilder.Marker toRollback = this.myBuilder.mark();
        this.addLParenOrError();
        if (this.getTokenType() == CssElementTypes.CSS_LBRACE) {
            toRollback.rollbackTo();
            return false;
        }
        PsiBuilder.Marker parameterList = this.createCompositeElement();
        if (this.parseMixinParameter(parametersSeparator)) {
            while (this.getTokenType() == parametersSeparator) {
                this.addSingleToken();
                if (this.getTokenType() == CssElementTypes.CSS_LBRACE) {
                    toRollback.rollbackTo();
                    return false;
                }
                PsiBuilder.Marker toRollbackParameter = this.myBuilder.mark();
                if (!this.parseMixinParameter(parametersSeparator)) {
                    if (parametersSeparator == CssElementTypes.CSS_SEMICOLON) {
                        toRollbackParameter.rollbackTo();
                        continue;
                    }
                    toRollbackParameter.drop();
                    this.createErrorElement(CssBundle.message((String)"expected", (Object[])new Object[]{"parameter"}));
                    continue;
                }
                toRollbackParameter.drop();
            }
            parameterList.done((IElementType)LESSElementTypes.LESS_PARAMETER_LIST);
            if (parametersSeparator == CssElementTypes.CSS_COMMA && this.getTokenType() == CssElementTypes.CSS_SEMICOLON) {
                toRollback.rollbackTo();
                return this.parseMixinParameters(CssElementTypes.CSS_SEMICOLON);
            }
        } else {
            parameterList.rollbackTo();
        }
        toRollback.drop();
        this.addRParenOrError();
        return true;
    }

    protected boolean parseClass() {
        if (this.getTokenType() != CssElementTypes.CSS_PERIOD) {
            return false;
        }
        PsiBuilder.Marker cssClass = this.createCompositeElement();
        this.addSingleToken();
        if (!this.hasWhitespaceBefore()) {
            if (this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN) {
                this.addSingleToken();
            } else if (this.parseIdentOrInterpolationSuffix()) {
                this.addAllAmpersandSelectorTokens();
            } else {
                this.myBuilder.error(CssBundle.message((String)"expected", (Object[])new Object[]{"ident or interpolation"}));
            }
        }
        cssClass.done((IElementType)CssElementTypes.CSS_CLASS);
        return true;
    }

    protected boolean parseIdSelector() {
        if (this.getTokenType() != CssElementTypes.CSS_HASH) {
            return false;
        }
        PsiBuilder.Marker idSelector = this.createCompositeElement();
        this.addTokenOrError(CssElementTypes.CSS_HASH, "identifier");
        this.parseIdentOrInterpolationSuffix();
        this.addAllAmpersandSelectorTokens();
        idSelector.done((IElementType)CssElementTypes.CSS_ID_SELECTOR);
        return true;
    }

    private boolean parseIdentOrInterpolationSuffix() {
        boolean result = false;
        boolean afterInterpolation = false;
        while (!this.myBuilder.eof() && !this.hasWhitespaceBefore() && (this.isIdent() || afterInterpolation && LESSTokenTypes.ELEMENTS_AFTER_INTERPOLATION.contains(this.getTokenType()))) {
            result = true;
            if (this.isNewInterpolation()) {
                this.parseNewInterpolation();
                afterInterpolation = true;
                continue;
            }
            this.addSingleToken();
        }
        return result;
    }

    private boolean parseNewInterpolation() {
        if (!this.isNewInterpolation()) {
            return false;
        }
        PsiBuilder.Marker variableInterpolation = this.createCompositeElement();
        this.addTokenOrError(LESSTokenTypes.INTERPOLATION_PREFIX, "interpolation prefix");
        this.parseVariable();
        if (this.getTokenType() == LESSTokenTypes.INTERPOLATION_SUFFIX) {
            this.addSingleToken();
            variableInterpolation.done(LESSElementTypes.LESS_VARIABLE_INTERPOLATION);
            return true;
        }
        variableInterpolation.error("unclosed interpolation");
        return false;
    }

    private boolean isNewInterpolation() {
        return this.getTokenType() == LESSTokenTypes.INTERPOLATION_PREFIX;
    }

    protected boolean isExpectedTokenAfterDeclarationBlock() {
        return true;
    }

    private boolean parseVariableDeclaration() {
        if (this.getTokenType() != LESSTokenTypes.VARIABLE) {
            return false;
        }
        if (this.myBuilder.lookAhead(1) != CssElementTypes.CSS_COLON) {
            return false;
        }
        PsiBuilder.Marker declaration = this.createCompositeElement();
        this.parseVariable();
        if (this.getTokenType() == CssElementTypes.CSS_COLON) {
            this.addTokenAndSkipWhitespace();
            if (this.getTokenType() == CssElementTypes.CSS_LBRACE) {
                this.parseDeclarationBlock();
            } else {
                this.parseTermList(true, new IElementType[0]);
                if (this.getTokenType() == CssElementTypes.CSS_IMPORTANT) {
                    this.addTokenAndSkipWhitespace();
                }
            }
        }
        declaration.done((IElementType)LESSElementTypes.LESS_VARIABLE_DECLARATION);
        return true;
    }

    protected boolean _parseTerm(boolean strict, boolean nameValuePairSyntax) {
        if (this.getTokenType() == LESSTokenTypes.VARIABLE && this.myBuilder.lookAhead(1) == CssElementTypes.CSS_COLON) {
            if (nameValuePairSyntax) {
                return this.parseVariableDeclaration();
            }
            return false;
        }
        return this.parseAdd(strict, nameValuePairSyntax);
    }

    protected CssMathParser getMathParser() {
        return this.LESS_MATH_PARSER;
    }

    protected boolean parsePseudoTerm() {
        if (this.getTokenType() == LESSTokenTypes.VARIABLE) {
            PsiBuilder.Marker term = this.createCompositeElement();
            this.parseVariable();
            term.done(CssElementTypes.CSS_TERM);
            return true;
        }
        return super.parsePseudoTerm();
    }

    protected boolean parseUriContent() {
        return this.parseEscapeString() || this.parseCssString() || this.parseAdd(true, false);
    }

    public boolean supportsNestedBlocks() {
        return true;
    }

    private boolean parseAdd(boolean strict, boolean nameValuePairSyntax) {
        return this.parseBinaryOp((Function<Pair<Boolean, Boolean>, Boolean>)((Function)args -> this.parseMult((Boolean)args.first, (Boolean)args.second)), ADD_OPS, strict, nameValuePairSyntax);
    }

    protected boolean parseMult(boolean strict, boolean nameValuePairSyntax) {
        return this.parseBinaryOp((Function<Pair<Boolean, Boolean>, Boolean>)((Function)args -> this.parseTermInner((Boolean)args.first, (Boolean)args.second)), MULT_OPS, strict, nameValuePairSyntax);
    }

    protected boolean parsePseudoFunction() {
        if (this.getTokenType() != CssElementTypes.CSS_FUNCTION_TOKEN) {
            return false;
        }
        if ("extend".equalsIgnoreCase(this.getTokenText())) {
            PsiBuilder.Marker function = this.createCompositeElement();
            this.addSingleToken();
            this.addTokenAndSkipWhitespace();
            this.parseExtendArgument();
            this.addRParenOrError();
            function.done(CssElementTypes.CSS_FUNCTION);
            return true;
        }
        return super.parsePseudoFunction();
    }

    private void parseExtendArgument() {
        this.parseSelectorList();
    }

    protected void parseSelectorList() {
        super.parseSelectorList();
        this.parseGuard();
    }

    protected void parseSelector() {
        PsiBuilder.Marker selector = this.createCompositeElement();
        boolean firstSelector = true;
        while (!this.isDone() && (firstSelector || this.getTokenType() != LESSTokenTypes.WHEN_KEYWORD)) {
            if (!firstSelector && this.getTokenType() == CssElementTypes.CSS_IDENT && "all".equals(this.getTokenText())) {
                this.addSingleToken();
                break;
            }
            this.parseSimpleSelector();
            firstSelector = false;
            if (SELECTORS_HIERARCHY_TOKENS.contains(this.getTokenType())) {
                this.addTokenAndSkipWhitespace();
            } else if (!this.isRulesetStart()) break;
            if (this.getTokenType() != CssElementTypes.CSS_LBRACE) continue;
        }
        selector.done((IElementType)CssElementTypes.CSS_SELECTOR);
    }

    protected void parseSimpleSelector() {
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN && this.myBuilder.lookAhead(1) == CssElementTypes.CSS_TILDA && this.myBuilder.lookAhead(2) == CssElementTypes.CSS_STRING_TOKEN) {
            PsiBuilder.Marker simpleSelector = this.createCompositeElement();
            this.addTokenAndSkipWhitespace();
            this.parseEscapeString();
            this.addRParenOrError();
            simpleSelector.done((IElementType)CssElementTypes.CSS_SIMPLE_SELECTOR);
        } else if (this.getTokenType() == LESSTokenTypes.AMPERSAND) {
            PsiBuilder.Marker simpleSelector = this.createCompositeElement();
            this.addSingleToken();
            if (!this.hasWhitespaceBefore()) {
                this.innerParseSimpleSelector();
            } else {
                this.parseSelectorSuffixList(true);
            }
            simpleSelector.done((IElementType)CssElementTypes.CSS_SIMPLE_SELECTOR);
        } else {
            PsiBuilder.Marker simpleSelector = this.createCompositeElement();
            this.innerParseSimpleSelector();
            simpleSelector.done((IElementType)CssElementTypes.CSS_SIMPLE_SELECTOR);
        }
    }

    private void innerParseSimpleSelector() {
        boolean hasPrefix = false;
        if (this.isSimpleSelectorStart()) {
            this.addToken();
            hasPrefix = true;
            this.addAllAmpersandSelectorTokens();
        }
        if (this.getTokenType() == CssElementTypes.CSS_PIPE) {
            this.addSingleToken();
            if (this.getTokenType() == CssElementTypes.CSS_ASTERISK) {
                this.addSingleToken();
            } else {
                this.addIdentOrError();
            }
        }
        this.parseSelectorSuffixList(hasPrefix);
    }

    private void addAllAmpersandSelectorTokens() {
        while (!this.hasWhitespaceBefore() && (this.getTokenType() == LESSTokenTypes.AMPERSAND || this.isIdent() || CssElementTypes.CSS_NUMBER == this.getTokenType())) {
            if (this.getTokenType() == LESSTokenTypes.AMPERSAND) {
                this.addSingleToken();
                continue;
            }
            if (this.hasWhitespaceBefore()) continue;
            if (CssElementTypes.CSS_NUMBER == this.getTokenType()) {
                this.addSingleToken();
                continue;
            }
            if (this.parseIdentOrInterpolationSuffix()) continue;
            break;
        }
    }

    public boolean parseEscapeString() {
        if (this.getTokenType() == CssElementTypes.CSS_TILDA || this.getTokenType() == CssElementTypes.CSS_URL && "~".equals(this.getTokenText())) {
            PsiBuilder.Marker string = this.createCompositeElement();
            this.addTokenAndSkipWhitespace();
            if (this.getTokenType() == CssElementTypes.CSS_STRING_TOKEN) {
                this.parseInnerString(true);
            } else {
                if (this.getTokenType() == LESSTokenTypes.JS_CODE_DELIM) {
                    boolean result = this.parseJSInjectionString();
                    string.done(CssElementTypes.CSS_STRING);
                    return result;
                }
                this.createErrorElement("string");
            }
            string.done(CssElementTypes.CSS_STRING);
            return true;
        }
        return false;
    }

    private boolean parseTermInner(boolean strict, boolean nameValuePairSyntax) {
        if (this.parseNewInterpolation()) {
            return true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            PsiBuilder.Marker parens = this.createCompositeElement();
            this.addTokenAndSkipWhitespace();
            this.parseAdd(strict, nameValuePairSyntax);
            this.addRParenOrError();
            parens.done(LESSElementTypes.LESS_OPERATION);
            return true;
        }
        boolean indexExpected = false;
        if (this.getTokenType() == CssElementTypes.CSS_HASH) {
            indexExpected = this.myBuilder.lookAhead(1) == CssElementTypes.CSS_LBRACKET;
        } else if (this.getTokenType() == CssElementTypes.CSS_PERIOD) {
            int offset = 1;
            if (this.myBuilder.rawLookup(1) == CssElementTypes.CSS_IDENT) {
                offset = 2;
            }
            boolean bl = indexExpected = this.myBuilder.lookAhead(offset) == CssElementTypes.CSS_LBRACKET;
        }
        if (indexExpected) {
            PsiBuilder.Marker term = this.createCompositeElement();
            if (this.getTokenType() == CssElementTypes.CSS_HASH) {
                this.addTokenAndSkipWhitespace();
            } else {
                this.addSingleToken();
                this.addSingleToken();
            }
            this.addTokenAndSkipWhitespace();
            this._parseTerm(true, false);
            this.addTokenOrError(CssElementTypes.CSS_RBRACKET, "]");
            term.done(LESSElementTypes.LESS_INDEX);
            return true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_PERCENT) {
            PsiBuilder.Marker term = this.createCompositeElement();
            this.addToken();
            term.done(CssElementTypes.CSS_TERM);
            return true;
        }
        if (this.getTokenType() == LESSTokenTypes.VARIABLE) {
            PsiBuilder.Marker term = this.createCompositeElement();
            this.parseVariable();
            term.done(CssElementTypes.CSS_TERM);
            return true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_PERIOD) {
            PsiBuilder.Marker term = this.createCompositeElement();
            this.addTokenAndSkipWhitespace();
            term.done(CssElementTypes.CSS_TERM);
            return true;
        }
        if (this.getTokenType() == LESSTokenTypes.JS_CODE_DELIM) {
            return this.parseJSInjectionString();
        }
        if (this.parseEscapeString()) {
            return true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_URL) {
            this.addSingleToken();
            return true;
        }
        if (this.getTokenType() == CssElementTypes.CSS_MINUS) {
            PsiBuilder.Marker term = this.createCompositeElement();
            this.addSingleToken();
            if (!this.parseMult(strict, nameValuePairSyntax)) {
                this.createErrorElement("Expression expected");
            }
            term.done(CssElementTypes.CSS_TERM);
            return true;
        }
        return super._parseTerm(strict, nameValuePairSyntax);
    }

    public boolean parseVariable() {
        return this.parseVariable(true);
    }

    public boolean parseVariable(boolean strict) {
        PsiBuilder.Marker variable = this.createCompositeElement();
        if (this.addTokenOrError(LESSTokenTypes.VARIABLE, CssBundle.message((String)"expected", (Object[])new Object[]{"variable"}))) {
            variable.done(LESSElementTypes.LESS_VARIABLE);
            return true;
        }
        variable.rollbackTo();
        if (strict) {
            this.myBuilder.error(CssBundle.message((String)"expected", (Object[])new Object[]{"variable"}));
        }
        return false;
    }

    private boolean parseJSInjectionString() {
        if (this.getTokenType() != LESSTokenTypes.JS_CODE_DELIM) {
            return false;
        }
        PsiBuilder.Marker jsString = this.createCompositeElement();
        this.addSingleToken();
        if (this.getTokenType() == LESSTokenTypes.JS_CODE) {
            this.addSingleToken();
        }
        this.addTokenOrError(LESSTokenTypes.JS_CODE_DELIM, "` expected");
        jsString.done(CssElementTypes.CSS_STRING);
        return true;
    }

    protected boolean parseStylesheetItem() {
        return super.parseStylesheetItem() || this.parsePlugin();
    }

    protected boolean parseSingleDeclarationInBlock(boolean withPageMarginRules, boolean inlineCss, boolean requirePropertyValue, @NotNull IElementType elementType) {
        if (elementType == null) {
            LESSParser.$$$reportNull$$$0(0);
        }
        if (!this.myIsMediaFeature) {
            this.rulesetSeen = false;
            if (this.parseLessConstructionsDeclarations()) {
                return true;
            }
            if (this.parseRulesetMedia() || this.parseStylesheetItemStartingWithSelectorSuffix() || this.parseKeyframes() || this.parseAllSimpleAtRules() || this.parseImport() || this.parsePlugin() || this.parseSupports() || this.parsePage() || this.parseDocument() || this.parseRegion() || this.parseScope() || this.parseCounterStyle() || this.parseKeyframesRuleset() || this.tryToParseRuleset()) {
                this.rulesetSeen = true;
                return true;
            }
        }
        return super.parseSingleDeclarationInBlock(withPageMarginRules, inlineCss, requirePropertyValue, elementType);
    }

    private boolean parsePlugin() {
        if (this.getTokenType() != LESSTokenTypes.PLUGIN_SYM) {
            return false;
        }
        PsiBuilder.Marker anImport = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        if (!this.parseCssString(false)) {
            this.createErrorElement(CssBundle.message((String)"expected.a.uri.or.a.string", (Object[])new Object[0]));
        }
        this.addSemicolonOrError();
        anImport.done(LESSElementTypes.LESS_PLUGIN);
        return true;
    }

    private boolean parseLessConstructionsDeclarations() {
        this.rulesetSeen = false;
        if (this.parseGtThanMixin()) {
            return true;
        }
        if (this.parseVariableDeclaration()) {
            return true;
        }
        if (this.parseMixinDeclaration()) {
            this.rulesetSeen = true;
            return true;
        }
        if (this.parseMixinInvocation()) {
            return true;
        }
        if (this.parseVariableRulesetInvocation()) {
            return true;
        }
        return this.parseExtendStatement();
    }

    private boolean parseStylesheetItemStartingWithSelectorSuffix() {
        if (this.getTokenType() != CssElementTypes.CSS_LBRACKET) {
            return false;
        }
        PsiBuilder.Marker ruleset = this.createCompositeElement();
        this.parseSelectorList();
        this.parseDeclarationBlock();
        ruleset.done((IElementType)CssElementTypes.CSS_RULESET);
        return true;
    }

    protected boolean addCustomMediaQueryIdent() {
        boolean result;
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            this.addLParenOrError();
            result = this.parseVariable();
            this.addRParenOrError();
        } else {
            result = this.parseVariable();
        }
        return result;
    }

    protected boolean isCustomMediaQueryIdent(boolean insideMediaExpression) {
        return this.getTokenType() == CssElementTypes.CSS_LPAREN && this.lookAhead(1) == LESSTokenTypes.VARIABLE || this.getTokenType() == LESSTokenTypes.VARIABLE;
    }

    private boolean parseRulesetMedia() {
        if (this.getTokenType() != CssElementTypes.CSS_MEDIA_SYM) {
            return false;
        }
        PsiBuilder.Marker media = this.createCompositeElement();
        this.addTokenAndSkipWhitespace();
        this.parseMediumList();
        this.expect(CssElementTypes.CSS_LBRACE, "'{'");
        this.parseDeclarationBlock();
        media.done((IElementType)CssElementTypes.CSS_MEDIA);
        return true;
    }

    private boolean parseMixinInvocation() {
        if (this.getTokenType() != CssElementTypes.CSS_PERIOD && this.getTokenType() != CssElementTypes.CSS_HASH) {
            return false;
        }
        if (this.getTokenType() == CssElementTypes.CSS_PERIOD && this.myBuilder.lookAhead(1) != CssElementTypes.CSS_IDENT && this.myBuilder.lookAhead(1) != CssElementTypes.CSS_FUNCTION_TOKEN) {
            return false;
        }
        IElementType nextType = this.myBuilder.lookAhead(this.getTokenType() == CssElementTypes.CSS_PERIOD ? 2 : 1);
        if (nextType != null && !MIXIN_INVOCATION_END.contains(nextType)) {
            return false;
        }
        PsiBuilder.Marker mixinInvocation = this.createCompositeElement();
        PsiBuilder.Marker mixinName = this.createCompositeElement();
        if (this.getTokenType() == CssElementTypes.CSS_PERIOD) {
            this.addSingleToken();
            this.addToken();
        } else {
            this.addTokenOrError(CssElementTypes.CSS_HASH, "mixin name");
        }
        mixinName.done(LESSElementTypes.LESS_MIXIN_NAME);
        this.parseMixinInvocationArguments(CssElementTypes.CSS_COMMA);
        if (this.getTokenType() == CssElementTypes.CSS_IMPORTANT) {
            this.addTokenAndSkipWhitespace();
        }
        mixinInvocation.done(LESSElementTypes.LESS_MIXIN_INVOCATION);
        return true;
    }

    private boolean parseVariableRulesetInvocation() {
        if (this.getTokenType() == LESSTokenTypes.VARIABLE && this.rawLookup(1) == CssElementTypes.CSS_LPAREN) {
            PsiBuilder.Marker marker = this.createCompositeElement();
            this.parseVariable();
            this.addLParenOrError();
            this.addRParenOrError();
            marker.done(LESSElementTypes.LESS_VARIABLE_RULESET_INCLUDE);
            return true;
        }
        return false;
    }

    private boolean parseExtendStatement() {
        if (this.getTokenType() != LESSTokenTypes.AMPERSAND || this.rawLookup(1) != CssElementTypes.CSS_COLON) {
            return false;
        }
        PsiBuilder.Marker extendStatement = this.createCompositeElement();
        this.addSingleToken();
        this.addSingleToken();
        IElementType type = this.getTokenType();
        if (!this.hasWhitespaceBefore() && (type == CssElementTypes.CSS_IDENT || type == CssElementTypes.CSS_FUNCTION_TOKEN) && "extend".equals(this.getTokenText())) {
            this.addSingleToken();
            this.addLParenOrError();
            this.parseExtendArgument();
            this.addRParenOrError();
            if (this.getTokenType() == CssElementTypes.CSS_SEMICOLON) {
                extendStatement.done(LESSElementTypes.LESS_EXTEND_STATEMENT);
                return true;
            }
        }
        extendStatement.rollbackTo();
        return false;
    }

    private void parseMixinInvocationArguments(IElementType argumentsSeparator) {
        PsiBuilder.Marker toRollback = this.myBuilder.mark();
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            this.addLParenOrError();
            if (this.getTokenType() != CssElementTypes.CSS_RPAREN && this.parseMixinInvocationArgument(argumentsSeparator)) {
                while (this.getTokenType() == argumentsSeparator) {
                    this.addSingleToken();
                    PsiBuilder.Marker toRollbackArgument = this.myBuilder.mark();
                    if (!this.parseMixinInvocationArgument(argumentsSeparator)) {
                        if (argumentsSeparator == CssElementTypes.CSS_SEMICOLON) {
                            toRollbackArgument.rollbackTo();
                            continue;
                        }
                        toRollbackArgument.drop();
                        this.createErrorElement(CssBundle.message((String)"expected", (Object[])new Object[]{"argument"}));
                        continue;
                    }
                    toRollbackArgument.drop();
                }
                if (argumentsSeparator == CssElementTypes.CSS_COMMA && this.getTokenType() == CssElementTypes.CSS_SEMICOLON) {
                    toRollback.rollbackTo();
                    this.parseMixinInvocationArguments(CssElementTypes.CSS_SEMICOLON);
                    return;
                }
            }
            this.addRParenOrError();
        }
        toRollback.drop();
    }

    private boolean parseMixinInvocationArgument(IElementType argumentsSeparator) {
        if (this.getTokenType() == CssElementTypes.CSS_LBRACE) {
            return this.parseDeclarationBlock();
        }
        if (this.getTokenType() == LESSTokenTypes.VARIABLE && this.myBuilder.lookAhead(1) == CssElementTypes.CSS_COLON) {
            PsiBuilder.Marker term = this.createCompositeElement();
            this.parseVariable();
            this.addTokenAndSkipWhitespace();
            if (this.getTokenType() == CssElementTypes.CSS_LBRACE) {
                this.parseDeclarationBlock();
            } else {
                this.parseTermList(true, false, new IElementType[]{argumentsSeparator});
            }
            term.done(LESSElementTypes.LESS_NAMED_ARGUMENT);
            return true;
        }
        return this.parseTermList(true, false, new IElementType[]{argumentsSeparator});
    }

    private boolean parseMixinDeclaration() {
        IElementType nextTokenType;
        boolean couldBeRegularMixin = true;
        PsiBuilder.Marker mixin = this.createCompositeElement();
        if (this.getTokenType() == LESSTokenTypes.AMPERSAND || SELECTORS_HIERARCHY_TOKENS.contains(this.getTokenType())) {
            couldBeRegularMixin = false;
            this.addTokenAndSkipWhitespace();
        }
        if (this.getTokenType() != CssElementTypes.CSS_PERIOD && this.getTokenType() != CssElementTypes.CSS_HASH) {
            mixin.rollbackTo();
            return false;
        }
        if (this.getTokenType() == CssElementTypes.CSS_PERIOD && (nextTokenType = this.myBuilder.rawLookup(1)) != CssElementTypes.CSS_IDENT && nextTokenType != CssElementTypes.CSS_FUNCTION_TOKEN) {
            mixin.rollbackTo();
            return false;
        }
        if (this.getTokenType() == CssElementTypes.CSS_HASH) {
            IElementType lookAhead = this.myBuilder.lookAhead(1);
            if (SELECTORS_HIERARCHY_TOKENS.contains(lookAhead)) {
                lookAhead = this.myBuilder.lookAhead(2);
            }
            if (lookAhead == CssElementTypes.CSS_LBRACE) {
                mixin.rollbackTo();
                mixin = this.createCompositeElement();
                if (this.parseRuleset()) {
                    mixin.done((IElementType)LESSElementTypes.LESS_PRIMITIVE_MIXIN);
                    return true;
                }
                mixin.rollbackTo();
                return false;
            }
            PsiBuilder.Marker mixinName = this.createCompositeElement();
            this.addTokenAndSkipWhitespace();
            mixinName.done(LESSElementTypes.LESS_MIXIN_NAME);
            if (this.getTokenType() == CssElementTypes.CSS_LPAREN && !this.parseMixinDeclarationArguments(couldBeRegularMixin)) {
                mixin.rollbackTo();
                return false;
            }
        } else if (this.myBuilder.lookAhead(1) == CssElementTypes.CSS_IDENT) {
            IElementType lookAhead2 = this.myBuilder.lookAhead(2);
            if (SELECTORS_HIERARCHY_TOKENS.contains(lookAhead2)) {
                lookAhead2 = this.myBuilder.lookAhead(3);
            }
            if (lookAhead2 == CssElementTypes.CSS_LBRACE) {
                mixin.rollbackTo();
                mixin = this.createCompositeElement();
                if (this.parseRuleset()) {
                    mixin.done((IElementType)LESSElementTypes.LESS_PRIMITIVE_MIXIN);
                    return true;
                }
                mixin.rollbackTo();
                return false;
            }
            PsiBuilder.Marker mixinName = this.createCompositeElement();
            this.addSingleToken();
            this.addSingleToken();
            mixinName.done(LESSElementTypes.LESS_MIXIN_NAME);
            if (this.getTokenType() == CssElementTypes.CSS_LPAREN && !this.parseMixinDeclarationArguments(couldBeRegularMixin)) {
                mixin.rollbackTo();
                return false;
            }
        } else if (this.myBuilder.lookAhead(1) == CssElementTypes.CSS_FUNCTION_TOKEN) {
            PsiBuilder.Marker mixinName = this.createCompositeElement();
            this.addSingleToken();
            this.addSingleToken();
            mixinName.done(LESSElementTypes.LESS_MIXIN_NAME);
            if (!this.parseMixinDeclarationArguments(couldBeRegularMixin)) {
                mixin.rollbackTo();
                return false;
            }
        } else {
            this.createErrorElement(CssBundle.message((String)"expected", (Object[])new Object[]{"identifier"}));
        }
        if (this.parseGuard() || this.getTokenType() == CssElementTypes.CSS_LBRACE) {
            if (this.getTokenType() != CssElementTypes.CSS_LBRACE) {
                this.createErrorElement(CssBundle.message((String)"expected", (Object[])new Object[]{"{"}));
            }
            this.parseDeclarationBlock();
            mixin.done((IElementType)LESSElementTypes.LESS_MIXIN);
            return true;
        }
        mixin.rollbackTo();
        return false;
    }

    private boolean parseMixinDeclarationArguments(boolean couldBeRegularMixin) {
        if (couldBeRegularMixin) {
            return this.parseMixinParameters();
        }
        PsiBuilder.Marker errorElement = this.createCompositeElement();
        if (this.parseMixinParameters()) {
            errorElement.error(LESSBundle.message("unexpected.arguments.in.mixin.declaration", new Object[0]));
            return true;
        }
        errorElement.drop();
        return false;
    }

    private boolean parseGuard() {
        if (this.getTokenType() == LESSTokenTypes.WHEN_KEYWORD) {
            this.addTokenAndSkipWhitespace();
            if (!this.parseGuardCondition()) {
                this.createErrorElement("Guard expected");
            }
            while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
                this.addTokenAndSkipWhitespace();
                if (this.parseGuardCondition()) continue;
                this.createErrorElement("Guard expected");
            }
            return true;
        }
        return false;
    }

    private boolean parseGuardCondition() {
        return this.parseBinaryOp((Function<Pair<Boolean, Boolean>, Boolean>)((Function)args -> this.parseSingleGuardCondition((Boolean)args.first, (Boolean)args.second)), (Computable<Boolean>)((Computable)() -> this.isAndToken() || this.isOrToken()), true, true);
    }

    protected boolean isOrToken() {
        return this.getTokenType() == LESSTokenTypes.OR_KEYWORD;
    }

    protected boolean isAndToken() {
        return this.getTokenType() == LESSTokenTypes.AND_KEYWORD;
    }

    protected boolean isNotToken() {
        return this.getTokenType() == LESSTokenTypes.NOT_KEYWORD;
    }

    private boolean parseSingleGuardCondition(boolean strict, boolean nameValuePairSyntax) {
        if (!this.isNotToken() && this.getTokenType() != CssElementTypes.CSS_LPAREN) {
            return false;
        }
        PsiBuilder.Marker guard = this.createCompositeElement();
        if (this.isNotToken()) {
            this.addTokenAndSkipWhitespace();
        }
        this.addLParenOrError();
        if (!this.parseOrCondition(strict, nameValuePairSyntax)) {
            this.createErrorElement("Condition expected");
        }
        if (this.getTokenType() != CssElementTypes.CSS_RPAREN) {
            this.createErrorElement("')' expected");
            this.advanceUntil(new IElementType[]{CssElementTypes.CSS_RPAREN, CssElementTypes.CSS_SEMICOLON, CssElementTypes.CSS_LBRACE, CssElementTypes.CSS_RBRACE});
        } else {
            this.addSingleToken();
        }
        guard.done(LESSElementTypes.LESS_GUARD);
        return true;
    }

    private boolean parseOrCondition(boolean strict, boolean syntax) {
        return this.parseBinaryOp((Function<Pair<Boolean, Boolean>, Boolean>)((Function)args -> this.parseAndCondition((Boolean)args.first, (Boolean)args.second)), (Computable<Boolean>)((Computable)() -> this.isOrToken() || this.getTokenType() == CssElementTypes.CSS_COMMA), strict, syntax);
    }

    private boolean parseAndCondition(boolean strict, boolean syntax) {
        return this.parseBinaryOp((Function<Pair<Boolean, Boolean>, Boolean>)((Function)args -> this.parseComparison((Boolean)args.first, (Boolean)args.second)), (Computable<Boolean>)((Computable)this::isAndToken), strict, syntax);
    }

    private boolean parseComparison(boolean strict, boolean syntax) {
        if (this.parseSingleGuardCondition(strict, syntax)) {
            return true;
        }
        PsiBuilder.Marker term = this.createCompositeElement();
        if (!this.parseTermInner(strict, syntax)) {
            this.createErrorElement("Expression expected");
        } else if (COMPARE_OPS.contains(this.getTokenType())) {
            this.addTokenAndSkipWhitespace();
            if (!this.parseTermInner(strict, syntax)) {
                this.createErrorElement("Expression expected");
            }
        }
        term.done(CssElementTypes.CSS_TERM);
        return true;
    }

    protected boolean isRulesetStart() {
        return super.isRulesetStart() || this.getTokenType() == LESSTokenTypes.AMPERSAND || this.getTokenType() == CssElementTypes.CSS_LPAREN && this.myBuilder.lookAhead(1) == CssElementTypes.CSS_TILDA && this.myBuilder.lookAhead(2) == CssElementTypes.CSS_STRING_TOKEN;
    }

    protected boolean shouldIgnoreLbraceAfterDeclaration() {
        return true;
    }

    protected void parsePropertyOfDeclaration() {
        this.addIdentOrError();
        if (this.getTokenType() == CssElementTypes.CSS_PLUS) {
            this.addSingleToken();
        }
        if ("_".equals(this.getTokenText())) {
            if (this.hasWhitespaceBefore()) {
                this.createErrorElement(CssBundle.message((String)"expected", (Object[])new Object[]{"':' or '_'"}));
            }
            this.addSingleToken();
        }
    }

    protected boolean parseRuleset() {
        if (!this.isRulesetStart()) {
            return false;
        }
        PsiBuilder.Marker ruleset = this.createCompositeElement();
        this.parseSelectorList();
        if (!this.parseDeclarationBlock()) {
            this.expect(CssElementTypes.CSS_LBRACE, "'{");
        }
        ruleset.done((IElementType)CssElementTypes.CSS_RULESET);
        return true;
    }

    private boolean tryToParseRuleset() {
        if (!this.isRulesetStart()) {
            return false;
        }
        PsiBuilder.Marker position = this.myBuilder.mark();
        IElementType prevTokenType = null;
        boolean first = true;
        String tokenText = this.getTokenText();
        boolean filterProperty = this.getTokenType() == CssElementTypes.CSS_IDENT && tokenText != null && tokenText.endsWith("filter");
        boolean interpolationBlock = false;
        while (!this.isDone() && (first || this.getTokenType() == CssElementTypes.CSS_HASH || this.getTokenType() == CssElementTypes.CSS_IDENT || this.getTokenType() == CssElementTypes.CSS_PERIOD || this.getTokenType() == CssElementTypes.CSS_COLON || this.getTokenType() == CssElementTypes.CSS_COMMA || SELECTORS_HIERARCHY_TOKENS.contains(this.getTokenType()) || this.getTokenType() == LESSTokenTypes.AMPERSAND || this.getTokenType() == CssElementTypes.CSS_BAD_CHARACTER || this.getTokenType() == CssElementTypes.CSS_RBRACKET || this.getTokenType() == CssElementTypes.CSS_EQ || this.getTokenType() == CssElementTypes.CSS_ASTERISK || this.getTokenType() == CssElementTypes.CSS_FUNCTION_TOKEN || this.getTokenType() == CssElementTypes.CSS_CONTAINS || this.getTokenType() == LESSTokenTypes.INTERPOLATION_PREFIX || this.getTokenType() == CssElementTypes.CSS_STRING_TOKEN) || interpolationBlock) {
            if (this.getTokenType() == LESSTokenTypes.INTERPOLATION_PREFIX) {
                interpolationBlock = true;
            }
            if (this.getTokenType() == LESSTokenTypes.INTERPOLATION_SUFFIX) {
                interpolationBlock = false;
            }
            IElementType rawLookup1 = this.myBuilder.rawLookup(1);
            if (this.getTokenType() == CssElementTypes.CSS_COLON) {
                if ((rawLookup1 == CssElementTypes.CSS_FUNCTION_TOKEN || rawLookup1 == CssElementTypes.CSS_IDENT || rawLookup1 == CssElementTypes.CSS_COLON) && this.parsePseudo()) {
                    if (first) {
                        position.rollbackTo();
                        return this.parseRuleset();
                    }
                    first = false;
                    continue;
                }
                position.rollbackTo();
                return false;
            }
            if (first && this.getTokenType() == CssElementTypes.CSS_HASH) {
                position.rollbackTo();
                return this.parseRuleset();
            }
            first = false;
            if (this.getTokenType() == CssElementTypes.CSS_GT || this.getTokenType() == LESSTokenTypes.AMPERSAND || this.getTokenType() == CssElementTypes.CSS_PERIOD && !filterProperty) {
                position.rollbackTo();
                return this.parseRuleset();
            }
            if (this.getTokenType() == CssElementTypes.CSS_TILDA && prevTokenType == CssElementTypes.CSS_LPAREN) {
                position.rollbackTo();
                return this.parseRuleset();
            }
            prevTokenType = this.getTokenType();
            this.addSingleToken();
        }
        if ((this.getTokenType() == CssElementTypes.CSS_LBRACE || this.getTokenType() == CssElementTypes.CSS_LBRACKET) && prevTokenType != CssElementTypes.CSS_COLON) {
            position.rollbackTo();
            return this.parseRuleset();
        }
        if (prevTokenType == CssElementTypes.CSS_LPAREN && this.getTokenType() == CssElementTypes.CSS_TILDA) {
            position.rollbackTo();
            return this.parseRuleset();
        }
        position.rollbackTo();
        return false;
    }

    protected boolean isSemicolonRequired() {
        return !this.rulesetSeen && super.isSemicolonRequired();
    }

    protected boolean isSimpleSelectorStart() {
        return this.getTokenType() == LESSTokenTypes.AMPERSAND || super.isSimpleSelectorStart();
    }

    public boolean isIdent(IElementType type) {
        return super.isIdent(type) || this.isNewInterpolation() || LESSTokenTypes.GUARD_KEYWORDS.contains(type) || type == CssElementTypes.CSS_MINUS;
    }

    public boolean addIdentOrError() {
        if (this.isIdent()) {
            if (this.isNewInterpolation()) {
                this.parseNewInterpolation();
            } else {
                this.addSingleToken();
            }
            this.parseIdentOrInterpolationSuffix();
            return true;
        }
        this.createErrorElement(CssBundle.message((String)"expected", (Object[])new Object[]{CssBundle.message((String)"an.identifier", (Object[])new Object[0])}));
        return false;
    }

    private boolean parseBinaryOp(Function<Pair<Boolean, Boolean>, Boolean> parseOperandFunc, TokenSet operandTypes, boolean strict, boolean nameValuePairSyntax) {
        return this.parseBinaryOp(parseOperandFunc, (Computable<Boolean>)((Computable)() -> operandTypes.contains(this.getTokenType())), strict, nameValuePairSyntax);
    }

    protected boolean parseImportReference() {
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            PsiBuilder.Marker importType = this.createCompositeElement();
            this.addSingleToken();
            if (this.addIdentOrError()) {
                while (this.getTokenType() == CssElementTypes.CSS_COMMA) {
                    this.addSingleToken();
                    this.addIdentOrError();
                }
            }
            this.addRParenOrError();
            importType.done(LESSElementTypes.LESS_IMPORT_TYPE);
        }
        return super.parseImportReference();
    }

    private boolean parseBinaryOp(Function<Pair<Boolean, Boolean>, Boolean> parseOperandFunc, Computable<Boolean> parseOperand, boolean strict, boolean nameValuePairSyntax) {
        PsiBuilder.Marker operation = this.createCompositeElement();
        Boolean operand = (Boolean)parseOperandFunc.fun((Object)Pair.create((Object)strict, (Object)nameValuePairSyntax));
        if (operand == Boolean.FALSE) {
            operation.drop();
            return false;
        }
        while (((Boolean)parseOperand.compute()).booleanValue()) {
            this.addTokenAndSkipWhitespace();
            operand = (Boolean)parseOperandFunc.fun((Object)Pair.create((Object)strict, (Object)nameValuePairSyntax));
            if (operand == Boolean.FALSE) {
                this.createErrorElement(CssBundle.message((String)"expected", (Object[])new Object[]{"operand"}));
            }
            operation.done(LESSElementTypes.LESS_OPERATION);
            operation = operation.precede();
        }
        operation.drop();
        return operand;
    }

    protected boolean parseCssString() {
        return this.parseCssString(true);
    }

    protected boolean parseNamespaceName() {
        return super.parseNamespaceName() || this.parseVariable(false);
    }

    protected boolean parseKeyframesName() {
        return super.parseKeyframesName() || this.parseVariable(false);
    }

    private boolean parseCssString(boolean withInterpolation) {
        PsiBuilder.Marker string = this.createCompositeElement();
        if (this.getTokenType() != CssElementTypes.CSS_STRING_TOKEN) {
            string.rollbackTo();
            return false;
        }
        this.parseInnerString(withInterpolation);
        string.done(CssElementTypes.CSS_STRING);
        return true;
    }

    private void parseInnerString(boolean withInterpolation) {
        this.addSingleToken();
        while (!this.myBuilder.eof() && !CssElementTypes.WHITESPACES.contains(this.myBuilder.rawLookup(-1))) {
            PsiBuilder.Marker possibleError = this.myBuilder.mark();
            if (this.parseNewInterpolation()) {
                if (!withInterpolation) {
                    possibleError.error("unexpected interpolation");
                    continue;
                }
                possibleError.drop();
                continue;
            }
            possibleError.drop();
            if (this.getTokenType() != CssElementTypes.CSS_STRING_TOKEN) break;
            this.addSingleToken();
        }
    }

    protected CssStylesheetLazyElementType getStylesheetLazyElementType() {
        return LESSElementTypes.LESS_LAZY_STYLESHEET;
    }

    protected CssStylesheetStubElementType getStylesheetElementType() {
        return LESSElementTypes.LESS_STYLESHEET;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/plugins/less/parser/LESSParser", "parseSingleDeclarationInBlock"));
    }
}

