/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.psi.LESSMixin;

public class LessLangUtil {
    private LessLangUtil() {
    }

    public static boolean isVisibleDeclaration(@NotNull PsiElement declaration, @NotNull PsiElement reference) {
        PsiElement rulesetParent;
        if (declaration == null) {
            LessLangUtil.$$$reportNull$$$0(0);
        }
        if (reference == null) {
            LessLangUtil.$$$reportNull$$$0(1);
        }
        if (LessLangUtil.getStubParentOfType(reference, false, CssSelectorList.class) != null && (rulesetParent = LessLangUtil.getStubParentOfType(reference, true, CssRuleset.class)) != null) {
            reference = rulesetParent;
        }
        PsiElement declarationScope = LessLangUtil.getOriginalScope(declaration);
        PsiElement originalScope = LessLangUtil.getOriginalScope(reference);
        return declarationScope instanceof PsiFile || originalScope != null && PsiTreeUtil.isAncestor((PsiElement)declarationScope, (PsiElement)originalScope, (boolean)false);
    }

    @Nullable
    public static PsiElement getOriginalScope(PsiElement reference) {
        PsiElement myElementScope = LessLangUtil.getStubParentOfType(reference, true, PsiFile.class, CssRuleset.class, LESSMixin.class);
        PsiElement originalScope = myElementScope != null ? CompletionUtil.getOriginalElement((PsiElement)myElementScope) : null;
        return originalScope == null && myElementScope != null ? LessLangUtil.getOriginalScope(myElementScope) : originalScope;
    }

    @Nullable
    public static ResolveResult filterOverridedResults(Collection<ResolveResult> result, PsiElement reference) {
        ResolveResult singleResult = null;
        PsiFile originalFile = reference.getContainingFile();
        for (ResolveResult resolveResult : result) {
            PsiElement resolvedResultScope;
            PsiElement resolvedElement = resolveResult.getElement();
            if (resolvedElement == null || originalFile != resolvedElement.getContainingFile()) continue;
            if (singleResult == null) {
                singleResult = resolveResult;
                continue;
            }
            PsiElement singleResultElement = singleResult.getElement();
            if (singleResultElement == null) continue;
            PsiElement singleResultScope = LessLangUtil.getOriginalScope(singleResultElement);
            if (singleResultScope == (resolvedResultScope = LessLangUtil.getOriginalScope(resolvedElement))) {
                if (resolvedElement.getTextOffset() <= singleResultElement.getTextOffset()) continue;
                singleResult = resolveResult;
                continue;
            }
            if (resolvedResultScope == null || !PsiTreeUtil.isAncestor((PsiElement)singleResultScope, (PsiElement)resolvedResultScope, (boolean)false)) continue;
            singleResult = resolveResult;
        }
        return singleResult;
    }

    @Nullable
    public static PsiElement getStubParentOfType(@Nullable PsiElement element, boolean strict, Class<? extends PsiElement> ... classes) {
        StubBase stub;
        if (element instanceof StubBasedPsiElement && (stub = (StubBase)((StubBasedPsiElement)element).getStub()) != null) {
            StubBase parentStub;
            Object object = parentStub = strict ? stub.getParentStub() : stub;
            while (parentStub != null) {
                PsiElement psi = parentStub.getPsi();
                for (Class<? extends PsiElement> aClass : classes) {
                    if (!aClass.isInstance(psi)) continue;
                    return psi;
                }
                parentStub = parentStub.getParentStub();
            }
            return null;
        }
        return strict ? PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])classes) : PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])classes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "declaration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "reference";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/less/LessLangUtil";
        objectArray[2] = "isVisibleDeclaration";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

