/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.stats;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSourceType;
import com.intellij.docker.dockerFile.DockerFileType;
import com.intellij.docker.registry.DockerRegistryManager;
import com.intellij.docker.stats.AbstractDockerUsageCollector;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DockerFeatureUsageCollector
extends AbstractDockerUsageCollector {
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            DockerFeatureUsageCollector.$$$reportNull$$$0(0);
        }
        AbstractDockerUsageCollector.Registrar registrar = new AbstractDockerUsageCollector.Registrar();
        DockerFeatureUsageCollector.visitRunConfigurations(project, registrar);
        DockerFeatureUsageCollector.visitAccounts(registrar);
        DockerFeatureUsageCollector.visitFileTypes(registrar);
        Set set = registrar.getCollectedResults();
        if (set == null) {
            DockerFeatureUsageCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"Docker Integration");
        if (groupDescriptor == null) {
            DockerFeatureUsageCollector.$$$reportNull$$$0(2);
        }
        return groupDescriptor;
    }

    private static void visitFileTypes(@NotNull AbstractDockerUsageCollector.Registrar registrar) {
        if (registrar == null) {
            DockerFeatureUsageCollector.$$$reportNull$$$0(3);
        }
        FileTypeManager manager = FileTypeManager.getInstance();
        registrar.histogram("docker.fileType.dockerfile.patterns", manager.getAssociations((FileType)DockerFileType.DOCKER_FILE_TYPE).size(), new int[]{0, 1, 2, 5});
    }

    private static void visitAccounts(@NotNull AbstractDockerUsageCollector.Registrar registrar) {
        if (registrar == null) {
            DockerFeatureUsageCollector.$$$reportNull$$$0(4);
        }
        List<DockerCloudConfiguration> dockers = RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance()).stream().map(RemoteServer::getConfiguration).filter(Objects::nonNull).collect(Collectors.toList());
        registrar.histogram("docker.accounts.total", dockers.size(), new int[]{0, 1, 2});
        dockers.forEach(c -> {
            if (registrar == null) {
                DockerFeatureUsageCollector.$$$reportNull$$$0(8);
            }
            registrar.histogram("docker.accounts.pathMappings", c.getPathMappings().size(), new int[]{0, 1, 3});
        });
        registrar.advance("docker.accounts.machines", dockers.stream().filter(c -> !StringUtil.isEmpty((String)c.getMachine())).count());
        List registries = DockerRegistryManager.getInstance().getRegistries();
        registrar.histogram("docker.accounts.registry", registries.size(), new int[]{0, 2, 5});
    }

    private static void visitRunConfigurations(@NotNull Project project, @NotNull AbstractDockerUsageCollector.Registrar registrar) {
        if (project == null) {
            DockerFeatureUsageCollector.$$$reportNull$$$0(5);
        }
        if (registrar == null) {
            DockerFeatureUsageCollector.$$$reportNull$$$0(6);
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        List dockerRunConfigs = runManager.getConfigurationSettingsList((ConfigurationType)DockerCloudType.getRunConfigurationType()).stream().map(RunnerAndConfigurationSettings::getConfiguration).map(o -> (DeployToServerRunConfiguration)ObjectUtils.tryCast((Object)o, DeployToServerRunConfiguration.class)).filter(Objects::nonNull).filter(rc -> rc.getDeploymentSource() != null).collect(Collectors.toList());
        registrar.histogram("docker.runConfigs.total", dockerRunConfigs.size(), new int[]{0, 2, 5});
        List sourceTypes = dockerRunConfigs.stream().map(DeployToServerRunConfiguration::getDeploymentSource).filter(Objects::nonNull).map(DeploymentSource::getType).collect(Collectors.toList());
        registrar.registerByType("docker.runConfigs.dockerfile", DockerFileDeploymentSourceType.class, sourceTypes);
        registrar.registerByType("docker.runConfigs.image", DockerImageDeploymentSourceType.class, sourceTypes);
        registrar.registerByType("docker.runConfigs.compose", DockerComposeDeploymentSourceType.class, sourceTypes);
        List<DockerDeploymentConfiguration> deployConfigs = dockerRunConfigs.stream().map(DeployToServerRunConfiguration::getDeploymentConfiguration).map(o -> (DockerDeploymentConfiguration)ObjectUtils.tryCast((Object)o, DockerDeploymentConfiguration.class)).filter(Objects::nonNull).collect(Collectors.toList());
        registrar.advanceIfNotNull("docker.runConfigs.debug", deployConfigs, DockerDeploymentConfiguration::getDebugPort);
        registrar.advanceIfNotEmpty("docker.runConfigs.jsonFile", deployConfigs, DockerDeploymentConfiguration::getJSONFilePath);
        registrar.advanceIfNotEmpty("docker.runConfigs.entrypoint", deployConfigs, DockerDeploymentConfiguration::getEntrypoint);
        registrar.advanceIfNotEmpty("docker.runConfigs.command", deployConfigs, DockerDeploymentConfiguration::getCommand);
        registrar.advanceIfNotEmpty("docker.runConfigs.cliOptions", deployConfigs, DockerDeploymentConfiguration::getCommandLineOptions);
        registrar.advance("docker.runConfigs.publishAllPorts", deployConfigs.stream().filter(DockerDeploymentConfiguration::isPublishAllPorts).count());
        deployConfigs.forEach(dc -> {
            if (registrar == null) {
                DockerFeatureUsageCollector.$$$reportNull$$$0(7);
            }
            registrar.histogram("docker.runConfigs.ports", dc.getPortBindings().size(), new int[]{0, 2, 5});
            registrar.histogram("docker.runConfigs.links", dc.getLinks().size(), new int[]{0, 1, 2});
            registrar.histogram("docker.runConfigs.volumes", dc.getVolumeBindings().size(), new int[]{0, 2, 5});
            registrar.histogram("docker.runConfigs.envs", dc.getEnvVars().size(), new int[]{0, 2, 5});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/stats/DockerFeatureUsageCollector";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/stats/DockerFeatureUsageCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectUsages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectUsages";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitFileTypes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitAccounts";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitRunConfigurations";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$visitRunConfigurations$5";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$visitAccounts$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

