/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManagerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PublishConfig", storages={@Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public class OldPublishConfigStateHolder
implements PersistentStateComponent<State> {
    private static final String EXCLUDE_DELIM = ";";
    private static final int PRESERVE_PERMISSIONS = -1;
    @Nullable
    private final Project myProject;
    private volatile State myState;

    public static OldPublishConfigStateHolder getInstance(Project project) {
        return (OldPublishConfigStateHolder)ServiceManager.getService((Project)project, OldPublishConfigStateHolder.class);
    }

    public OldPublishConfigStateHolder(@Nullable Project project) {
        this.myProject = project;
        this.myState = new State();
    }

    public State getState() {
        return this.myProject != null && this.myProject.isDefault() ? this.myState.copyForDefaultProject() : this.myState.clone();
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            OldPublishConfigStateHolder.$$$reportNull$$$0(0);
        }
        this.myState = state;
        Map<String, WebServerConfig> idToServerMap = WebServersConfigManagerImpl.collectUnpatchedServers(this.myProject);
        if (StringUtil.isEmpty((String)this.myState.myDefaultServerId) && StringUtil.isNotEmpty((String)this.myState.myDefaultServerName)) {
            for (WebServerConfig server : idToServerMap.values()) {
                if (!this.myState.myDefaultServerName.equals(server.getName())) continue;
                this.myState.myDefaultServerId = server.getId();
                break;
            }
        }
        if (!this.myState.myPathMappingsDummy.isEmpty()) {
            ServerData data;
            if (StringUtil.isNotEmpty((String)this.myState.myDefaultServerId) && (data = this.myState.myServerData.get(this.myState.myDefaultServerId)) == null) {
                data = new ServerData();
                this.myState.myServerData.put(this.myState.myDefaultServerId, data);
                data.myPathMappings = OldPublishConfigStateHolder.cloneMappings(this.myState.myPathMappingsDummy, true);
            }
            this.myState.myPathMappingsDummy.clear();
        }
        if (Boolean.valueOf(this.myState.myUploadOnCheckinId).booleanValue()) {
            this.myState.myUploadOnCheckinId = this.myState.myDefaultServerId;
            this.myState.myUploadOnCheckinName = this.myState.myDefaultServerName;
        }
        Iterator<String> i = this.myState.myServerData.keySet().iterator();
        while (i.hasNext()) {
            String serverId = i.next();
            if (idToServerMap.get(serverId) != null) continue;
            i.remove();
        }
        for (WebServerConfig server : idToServerMap.values()) {
            this.getServerData(server.getId());
        }
        for (ServerData data : this.myState.myServerData.values()) {
            for (DeploymentPathMapping mapping : data.myPathMappings) {
                mapping.setLocalPath(mapping.getPresentableLocalPath());
            }
        }
    }

    private ServerData getServerData(String serverId) {
        ServerData data = this.myState.myServerData.get(serverId);
        if (data == null) {
            data = new ServerData();
            this.myState.myServerData.put(serverId, data);
            OldPublishConfigStateHolder.addDefaultMappings(this.myProject, data.myPathMappings);
        }
        return data;
    }

    public static void addDefaultMappings(@Nullable Project project, List<DeploymentPathMapping> result) {
        if (project != null && !project.isDefault()) {
            for (VirtualFile root : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                DeploymentPathMapping mapping = new DeploymentPathMapping();
                mapping.setSerializedLocalPath(root.getPresentableUrl());
                result.add(mapping);
            }
        }
    }

    public Map<String, List<DeploymentPathMapping>> getAllPathMappings() {
        HashMap<String, List<DeploymentPathMapping>> result = new HashMap<String, List<DeploymentPathMapping>>();
        for (Map.Entry<String, ServerData> entry : this.myState.myServerData.entrySet()) {
            result.put(entry.getKey(), OldPublishConfigStateHolder.cloneMappings(entry.getValue().myPathMappings, false));
        }
        return result;
    }

    public Map<String, List<ExcludedPath>> getAllExcludedPaths() {
        HashMap<String, List<ExcludedPath>> result = new HashMap<String, List<ExcludedPath>>();
        for (Map.Entry<String, ServerData> entry : this.myState.myServerData.entrySet()) {
            result.put(entry.getKey(), OldPublishConfigStateHolder.cloneExcludedPaths(entry.getValue().myExcludedPaths));
        }
        return result;
    }

    public void setPathMappings(Map<String, List<DeploymentPathMapping>> mappings) {
        for (Map.Entry<String, List<DeploymentPathMapping>> entry : mappings.entrySet()) {
            this.setPathMappings(entry.getKey(), entry.getValue());
        }
    }

    private void setPathMappings(String serverId, List<DeploymentPathMapping> mappings) {
        this.getServerData((String)serverId).myPathMappings = OldPublishConfigStateHolder.cloneMappings(mappings, false);
    }

    public void setExcludedPaths(Map<String, List<ExcludedPath>> excludedPaths) {
        for (Map.Entry<String, List<ExcludedPath>> entry : excludedPaths.entrySet()) {
            this.setExcludedPaths(entry.getKey(), entry.getValue());
        }
    }

    private void setExcludedPaths(String serverId, List<ExcludedPath> excludedPaths) {
        this.getServerData((String)serverId).myExcludedPaths = OldPublishConfigStateHolder.cloneExcludedPaths(excludedPaths);
    }

    public static List<DeploymentPathMapping> cloneMappings(List<DeploymentPathMapping> pathMappings, boolean filterEmpty) {
        ArrayList<DeploymentPathMapping> result = new ArrayList<DeploymentPathMapping>(pathMappings.size());
        for (DeploymentPathMapping pathMapping : pathMappings) {
            if (filterEmpty && pathMapping.isDegenerate()) continue;
            result.add(pathMapping.clone());
        }
        return result;
    }

    public static List<ExcludedPath> cloneExcludedPaths(@NotNull List<ExcludedPath> excludedPaths) {
        if (excludedPaths == null) {
            OldPublishConfigStateHolder.$$$reportNull$$$0(1);
        }
        ArrayList<ExcludedPath> result = new ArrayList<ExcludedPath>(excludedPaths.size());
        for (ExcludedPath pathMapping : excludedPaths) {
            if (StringUtil.isEmpty((String)pathMapping.getPath())) continue;
            result.add(pathMapping.clone());
        }
        return result;
    }

    public Pair<String, String> getDefaultServerIdAndName() {
        return Pair.create((Object)this.myState.myDefaultServerId, (Object)this.myState.myDefaultServerName);
    }

    public void setDefaultServer(@Nullable WebServerConfig server, @Nullable String serverName) {
        this.myState.myDefaultServerName = serverName;
        this.myState.myDefaultServerId = server != null ? server.getId() : null;
    }

    public void setDefaultServerIdAndName(@Nullable String serverId, @Nullable String serverName) {
        this.myState.myDefaultServerName = serverName;
        this.myState.myDefaultServerId = serverId;
    }

    @Nullable
    public WebServerConfig findDefaultServer() {
        WebServerConfig server;
        Map<String, WebServerConfig> idToServerMap = WebServersConfigManagerImpl.collectUnpatchedServers(this.myProject);
        if (StringUtil.isEmpty((String)this.myState.myDefaultServerId)) {
            server = idToServerMap.get(this.myState.myDefaultServerName);
            if (server != null) {
                this.setDefaultServer(server, server.getName());
            }
        } else {
            server = idToServerMap.get(this.myState.myDefaultServerId);
        }
        return server;
    }

    public boolean isStopOnFirstError() {
        return this.myState.myStopOnFirstError;
    }

    public void setStopOnFirstError(boolean stopOnFirstError) {
        this.myState.myStopOnFirstError = stopOnFirstError;
    }

    public boolean isOverwriteAll() {
        return this.myState.myOverwriteAll;
    }

    public void setOverwriteAll(boolean overwriteAll) {
        this.myState.myOverwriteAll = overwriteAll;
    }

    public boolean isPreserveTimestamps() {
        return this.myState.myPreserveTimestamps;
    }

    public void setPreserveTimestamps(boolean preserveTimestamps) {
        this.myState.myPreserveTimestamps = preserveTimestamps;
    }

    public boolean isDeleteMissingItems() {
        return this.myState.myDeleteMissingItems;
    }

    public void setDeleteMissingItems(boolean value) {
        this.myState.myDeleteMissingItems = value;
    }

    public boolean isCreateEmptyDirectories() {
        return this.myState.myCreateEmptyDirectories;
    }

    public void setCreateEmptyDirectories(boolean value) {
        this.myState.myCreateEmptyDirectories = value;
    }

    public boolean isPromptOnLocalOverwrite() {
        return this.myState.myPromptOnLocalOverwrite;
    }

    public void setPromptOnLocalOverwrite(boolean value) {
        this.myState.myPromptOnLocalOverwrite = value;
    }

    @Nullable
    public Pair<String, String> getUploadOnCheckin() {
        return this.myState.myUploadOnCheckinId != null ? Pair.create((Object)this.myState.myUploadOnCheckinId, (Object)this.myState.myUploadOnCheckinName) : null;
    }

    public void setUploadOnCheckin(@Nullable WebServerConfig server) {
        this.myState.myUploadOnCheckinId = server != null ? server.getId() : null;
        this.myState.myUploadOnCheckinName = server != null ? server.getName() : null;
    }

    public String getExcludeMask() {
        return this.myState.myExcludeMask;
    }

    public void setExcludeMask(String value) {
        this.myState.myExcludeMask = value;
    }

    public int getFilePermissions() {
        return this.myState.myFilePermissions;
    }

    public void setFilePermissions(int value) {
        this.myState.myFilePermissions = value;
    }

    public int getFolderPermissions() {
        return this.myState.myFolderPermissions;
    }

    public void setFolderPermissions(int value) {
        this.myState.myFolderPermissions = value;
    }

    public PublishConfig.AutoUploadState getAutoUploadState() {
        if (this.myState.myAutoUpload && this.myState.myUploadOnSaveAll) {
            return PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE;
        }
        if (this.myState.myAutoUpload) {
            return PublishConfig.AutoUploadState.ALWAYS;
        }
        return PublishConfig.AutoUploadState.NEVER;
    }

    public void setAutoUploadState(PublishConfig.AutoUploadState state) {
        this.myState.myAutoUpload = state != PublishConfig.AutoUploadState.NEVER;
        this.myState.myUploadOnSaveAll = state == PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE;
    }

    public boolean isAutoUploadExternalChanges() {
        return this.myState.myAutoUploadExternalChanges;
    }

    public void setAutoUploadExternalChanges(boolean value) {
        this.myState.myAutoUploadExternalChanges = value;
    }

    public PublishConfig.TraceLevel getTraceLevel() {
        return this.myState.myTraceLevel;
    }

    public void setTraceLevel(PublishConfig.TraceLevel value) {
        this.myState.myTraceLevel = value;
    }

    @Nullable
    public DeploymentPathMapping getNearestMappingForWeb(String webPath, boolean strict, boolean checkLocalPath, boolean checkDeployPath, WebServerConfig server) {
        DeploymentPathMapping result = null;
        for (DeploymentPathMapping mapping : this.getServerData((String)server.getId()).myPathMappings) {
            if (!mapping.isParentForWebPath(webPath, strict) || checkLocalPath && !mapping.isLocalPathValid() || checkDeployPath && !mapping.isDeployPathValid(server.getFileTransferConfig().getAccessType().isProtocolBased()) || result != null && !result.isParentByWebPath(mapping)) continue;
            result = mapping;
        }
        return result;
    }

    public PublishConfig.PromptOnRemoteOverwrite getPromptOnRemoteOverwrite() {
        return this.myState.myPromptOnRemoteOverwrite;
    }

    public void setPromptOnRemoteOverwrite(PublishConfig.PromptOnRemoteOverwrite value) {
        this.myState.myPromptOnRemoteOverwrite = value;
    }

    public boolean isPersistUploadOnCheckin() {
        return this.myState.myPersistUploadOnCheckin;
    }

    public void setPersistUploadOnCheckin(boolean value) {
        this.myState.myPersistUploadOnCheckin = value;
    }

    public boolean isNotifyRemoteChanges() {
        return this.myState.myNotifyRemoteChanges;
    }

    public void setNotifyRemoteChanges(boolean notifyRemoteChanges) {
        this.myState.myNotifyRemoteChanges = notifyRemoteChanges;
    }

    public DirDiffSettings.CompareMode getCompareModeInSync() {
        return this.myState.myCompareModeInSync;
    }

    public void setCompareModeInSync(DirDiffSettings.CompareMode compareModeInSync) {
        this.myState.myCompareModeInSync = compareModeInSync;
    }

    public boolean isShowEqualInSync() {
        return this.myState.myShowEqualInSync;
    }

    public void setShowEqualInSync(boolean show) {
        this.myState.myShowEqualInSync = show;
    }

    public boolean isShowDifferentInSync() {
        return this.myState.myShowDifferentInSync;
    }

    public void setShowDifferentInSync(boolean show) {
        this.myState.myShowDifferentInSync = show;
    }

    public boolean isShowNewOnSourceInSync() {
        return this.myState.myShowNewOnSourceInSync;
    }

    public void setShowNewOnSourceInSync(boolean show) {
        this.myState.myShowNewOnSourceInSync = show;
    }

    public boolean isShowNewOnTargetInSync() {
        return this.myState.myShowNewOnTargetInSync;
    }

    public void setShowNewOnTargetInSync(boolean show) {
        this.myState.myShowNewOnTargetInSync = show;
    }

    public boolean isShowExcludedInSync() {
        return this.myState.myShowExcludedInSync;
    }

    public void setShowExcludedInSync(boolean show) {
        this.myState.myShowExcludedInSync = show;
    }

    public void eraseData() {
        this.myState = new State();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedPaths";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/OldPublishConfigStateHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "cloneExcludedPaths";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class State
    implements Cloneable {
        @Attribute(value="serverName")
        public String myDefaultServerName;
        @Attribute(value="serverId")
        public String myDefaultServerId;
        private List<DeploymentPathMapping> myPathMappingsDummy = new ArrayList<DeploymentPathMapping>();
        @XMap(propertyElementName="servers", keyAttributeName="id", entryTagName="server")
        public Map<String, ServerData> myServerData = new HashMap<String, ServerData>();
        @Attribute(value="stopOnFirstError")
        public boolean myStopOnFirstError = false;
        @Attribute(value="overwriteAll")
        public boolean myOverwriteAll = true;
        @Attribute(value="preserveTimestamps")
        public boolean myPreserveTimestamps = true;
        @Attribute(value="deleteMissingItems")
        public boolean myDeleteMissingItems = false;
        @Attribute(value="createEmptyFolders")
        public boolean myCreateEmptyDirectories = false;
        @Attribute(value="traceLevel")
        public PublishConfig.TraceLevel myTraceLevel = PublishConfig.TraceLevel.BRIEF;
        @Attribute(value="promptOnLocalOverwrite")
        public boolean myPromptOnLocalOverwrite = true;
        @Attribute(value="uploadOnCheckin")
        public String myUploadOnCheckinId;
        public String myUploadOnCheckinName;
        @Attribute(value="persistUploadOnCheckin")
        public boolean myPersistUploadOnCheckin = true;
        @Attribute(value="exclude")
        public String myExcludeMask = StringUtil.join((String[])PublishConfig.DEFAULT_EXCLUDES, (String)";");
        @Attribute(value="filePermissions")
        public int myFilePermissions = -1;
        @Attribute(value="folderPermissions")
        public int myFolderPermissions = -1;
        @Attribute(value="autoUpload")
        public boolean myAutoUpload = false;
        @Attribute(value="uploadOnSaveAll")
        public boolean myUploadOnSaveAll = false;
        @Attribute(value="autoUploadExternalChanges")
        public boolean myAutoUploadExternalChanges = false;
        private PublishConfig.PromptOnRemoteOverwrite myPromptOnRemoteOverwrite = PublishConfig.PromptOnRemoteOverwrite.NONE;
        @Attribute(value="notifyRemoteChanges")
        public boolean myNotifyRemoteChanges = false;
        @Attribute(value="compareModeInSync")
        public DirDiffSettings.CompareMode myCompareModeInSync = DirDiffSettings.CompareMode.CONTENT;
        @Attribute(value="showEqualInSync")
        public boolean myShowEqualInSync = false;
        @Attribute(value="showDifferentInSync")
        public boolean myShowDifferentInSync = true;
        @Attribute(value="showNewOnSourceInSync")
        public boolean myShowNewOnSourceInSync = true;
        @Attribute(value="showNewOnTargetInSync")
        public boolean myShowNewOnTargetInSync = true;
        @Attribute(value="showExcludedInSync")
        public boolean myShowExcludedInSync = false;

        @Attribute(value="server")
        public String getServerDummy() {
            return null;
        }

        public void setServerDummy(String server) {
            this.myDefaultServerName = server;
        }

        @XCollection(propertyElementName="mappings")
        public List<DeploymentPathMapping> getPathMappingsDummy() {
            return this.myPathMappingsDummy;
        }

        public void setPathMappingsDummy(List<DeploymentPathMapping> pathMappings) {
            this.myPathMappingsDummy = pathMappings;
        }

        @Attribute(value="detailedLogs")
        public boolean isDetailedLogs() {
            return false;
        }

        public void setDetailedLogs(boolean value) {
            this.myTraceLevel = value ? PublishConfig.TraceLevel.DETAILS : PublishConfig.TraceLevel.BRIEF;
        }

        @Attribute(value="promptOnRemoteOverwrite")
        public String getPromptOnRemoteOverwrite() {
            return this.myPromptOnRemoteOverwrite.name();
        }

        public void setPromptOnRemoteOverwrite(String promptOnRemoteOverwrite) {
            try {
                this.myPromptOnRemoteOverwrite = PublishConfig.PromptOnRemoteOverwrite.valueOf(promptOnRemoteOverwrite);
            }
            catch (IllegalArgumentException e) {
                this.myPromptOnRemoteOverwrite = PublishConfig.PromptOnRemoteOverwrite.NONE;
            }
        }

        protected State clone() {
            try {
                State clone = (State)super.clone();
                clone.myServerData = new HashMap<String, ServerData>(this.myServerData.size());
                for (Map.Entry<String, ServerData> entry : this.myServerData.entrySet()) {
                    clone.myServerData.put(entry.getKey(), entry.getValue().clone());
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        private State copyForDefaultProject() {
            try {
                State clone = (State)super.clone();
                clone.myServerData = new HashMap<String, ServerData>();
                clone.myDefaultServerId = null;
                clone.myDefaultServerName = null;
                clone.myPathMappingsDummy = new ArrayList<DeploymentPathMapping>();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    @Tag(value="ExcludedPath")
    public static class OldExcludedPath
    implements Cloneable {
        private String myPath;
        private boolean isLocal;

        public OldExcludedPath() {
        }

        public OldExcludedPath(String path, boolean local) {
            this.myPath = path;
            this.isLocal = local;
        }

        public String getPath() {
            return this.myPath;
        }

        public void setPath(String path) {
            this.myPath = path;
        }

        public void setLocal(boolean local) {
            this.isLocal = local;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public ExcludedPath transformInto() {
            return new ExcludedPath(this.myPath, this.isLocal);
        }

        public static OldExcludedPath transformFrom(ExcludedPath path) {
            return new OldExcludedPath(path.getPath(), path.isLocal());
        }
    }

    @Tag(value="serverdata")
    public static class ServerData
    implements Cloneable {
        @XCollection(propertyElementName="mappings")
        public List<DeploymentPathMapping> myPathMappings = new ArrayList<DeploymentPathMapping>();
        public List<ExcludedPath> myExcludedPaths = new ArrayList<ExcludedPath>();

        @XCollection(style=XCollection.Style.v2)
        public List<OldExcludedPath> getExcludedPaths() {
            ArrayList<OldExcludedPath> result = new ArrayList<OldExcludedPath>(this.myExcludedPaths.size());
            for (ExcludedPath path : this.myExcludedPaths) {
                result.add(OldExcludedPath.transformFrom(path));
            }
            return result;
        }

        public void setExcludedPaths(List<OldExcludedPath> excludedPaths) {
            this.myExcludedPaths = new ArrayList<ExcludedPath>(excludedPaths.size());
            for (OldExcludedPath path : excludedPaths) {
                this.myExcludedPaths.add(path.transformInto());
            }
        }

        protected ServerData clone() {
            try {
                ServerData clone = (ServerData)super.clone();
                clone.myPathMappings = PublishConfig.cloneMappings(this.myPathMappings, false);
                clone.myExcludedPaths = PublishConfig.cloneExcludedPaths(this.myExcludedPaths);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

