/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.CompareLocalVsRemoteAction;
import com.jetbrains.plugins.webDeployment.actions.LoadFilesAction;
import com.jetbrains.plugins.webDeployment.actions.LocalVsRemoteActionBase;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.ui.LocalMappingDiffRoot;
import java.util.Collection;
import java.util.Collections;

public class CompareLocalVsRemoteWithAction
extends CompareLocalVsRemoteAction {
    @Override
    public void update(AnActionEvent e) {
        boolean enabled = true;
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        if (files == null || files.length != 1 || files[0] == null || files[0].isDirectory()) {
            enabled = false;
        }
        if (enabled) {
            Collection<Deployable> servers = LoadFilesAction.getExtraServers(e, false, true, true);
            boolean bl = enabled = !servers.isEmpty();
        }
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setEnabled(enabled);
        }
    }

    @Override
    protected void actionPerformedOnProjectView(AnActionEvent event) {
        Project project = CompareLocalVsRemoteWithAction.getValidProject(event.getDataContext());
        if (project == null) {
            return;
        }
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(event);
        if (files == null || files.length != 1 || files[0] == null || files[0].isDirectory()) {
            return;
        }
        Collection<Deployable> servers = LoadFilesAction.getExtraServers(event, false, true, true);
        if (servers.isEmpty()) {
            return;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        VirtualFile file = files[0];
        PublishActionUtil.chooseServer(publishConfig, servers, event, WDBundle.message("choose.server.to.compare.with", new Object[0])).doWhenDone(server -> {
            DeploymentPathMapping mapping = (DeploymentPathMapping)publishConfig.getNearestMappingForLocal(file.getPath(), false, true, false, (Mappable)server, true).getFirst();
            if (mapping == null || StringUtil.isEmpty((String)mapping.getDeployPath())) {
                return;
            }
            LocalVsRemoteActionBase.LocalData localData = new LocalVsRemoteActionBase.LocalData(project, (Deployable)server, Collections.singletonList(LocalMappingDiffRoot.create(file, mapping)));
            this.createTask(localData).queue();
        });
    }
}

