/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class DeploymentNotificationsComponent
implements ProjectComponent {
    private final Project myProject;

    public DeploymentNotificationsComponent(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
        PublishConfig publishConfig = PublishConfig.getInstance(this.myProject);
        Pair<String, String> idAndName = publishConfig.getDefaultServerIdAndName();
        StringBuilder message = new StringBuilder();
        int page = 0;
        if (idAndName.first != null) {
            WebServerConfig server = WebServersConfigManager.getInstance(this.myProject).findServer((String)idAndName.first);
            if (server == null) {
                message.append(WDBundle.message("default.server.not.exists", idAndName.second));
            } else {
                String error = server.validateFast();
                if (error != null) {
                    message.append(WDBundle.message("default.server.invalid", idAndName.second, error));
                }
            }
        }
        if (message.length() == 0) {
            return;
        }
        message.append("\n").append(WDBundle.message("review.deployment.config", new Object[0]));
        final int page_ = page;
        NotificationListener listener = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    DeploymentConfigurable.show(null, false, DeploymentNotificationsComponent.this.myProject, page_);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/plugins/webDeployment/DeploymentNotificationsComponent$1";
                objectArray[2] = "hyperlinkUpdate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DeploymentNotifier.notifyWithBalloon(null, message.toString(), NotificationType.WARNING, listener, this.myProject, FileTransferToolWindow.ID_PROVIDER);
    }
}

