/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentCache
implements Disposable {
    private volatile Triple<PublishConfig, Change[], Collection<Deployable>> myDefaultServersForChanges;
    private volatile Triple<PublishConfig, Change[], Collection<Deployable>> mySelectableServersForChanges;
    private volatile Triple<PublishConfig, VirtualFile[], Collection<Deployable>> myDefaultServersForFiles;
    private volatile Triple<PublishConfig, VirtualFile[], Collection<Deployable>> mySelectableServersForFiles;

    public static DeploymentCache getInstance(@NotNull Project project) {
        if (project == null) {
            DeploymentCache.$$$reportNull$$$0(0);
        }
        return (DeploymentCache)ServiceManager.getService((Project)project, DeploymentCache.class);
    }

    public DeploymentCache(@NotNull Project project) {
        if (project == null) {
            DeploymentCache.$$$reportNull$$$0(1);
        }
        Disposer.register((Disposable)project, (Disposable)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void deploymentConfigChanged() {
                DeploymentCache.this.clean();
            }

            @Override
            public void optionsChanged() {
                DeploymentCache.this.clean();
            }

            @Override
            public void excludedPathsChanged() {
                DeploymentCache.this.clean();
            }
        });
    }

    private void clean() {
        this.myDefaultServersForFiles = null;
        this.mySelectableServersForFiles = null;
        this.myDefaultServersForChanges = null;
        this.mySelectableServersForChanges = null;
    }

    public void dispose() {
        this.clean();
    }

    @Nullable
    public Collection<Deployable> getSuitableServersForChanges(@NotNull PublishConfig publishConfig, boolean chooseServer, @NotNull Change[] changes) {
        Triple<PublishConfig, Change[], Collection<Deployable>> cache;
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(2);
        }
        if (changes == null) {
            DeploymentCache.$$$reportNull$$$0(3);
        }
        Triple<PublishConfig, Change[], Collection<Deployable>> triple = cache = chooseServer ? this.mySelectableServersForChanges : this.myDefaultServersForChanges;
        if (cache != null && cache.getFirst() == publishConfig && Arrays.equals((Object[])cache.getSecond(), changes)) {
            return (Collection)cache.getThird();
        }
        return null;
    }

    public void setSuitableServersForChanges(@NotNull PublishConfig publishConfig, boolean chooseServer, @NotNull Change[] changes, @NotNull Collection<Deployable> servers) {
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(4);
        }
        if (changes == null) {
            DeploymentCache.$$$reportNull$$$0(5);
        }
        if (servers == null) {
            DeploymentCache.$$$reportNull$$$0(6);
        }
        Triple cache = new Triple((Object)publishConfig, (Object)changes, servers);
        if (chooseServer) {
            this.mySelectableServersForChanges = cache;
        } else {
            this.myDefaultServersForChanges = cache;
        }
    }

    @Nullable
    public Collection<Deployable> getSuitableServersForFiles(@NotNull PublishConfig publishConfig, boolean chooseServer, @NotNull VirtualFile[] files) {
        Triple<PublishConfig, VirtualFile[], Collection<Deployable>> cache;
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(7);
        }
        if (files == null) {
            DeploymentCache.$$$reportNull$$$0(8);
        }
        Triple<PublishConfig, VirtualFile[], Collection<Deployable>> triple = cache = chooseServer ? this.mySelectableServersForFiles : this.myDefaultServersForFiles;
        if (cache != null && cache.getFirst() == publishConfig && Arrays.equals((Object[])cache.getSecond(), files)) {
            return (Collection)cache.getThird();
        }
        return null;
    }

    public void setSuitableServersForFiles(@NotNull PublishConfig publishConfig, boolean chooseServer, @NotNull VirtualFile[] files, @NotNull Collection<Deployable> servers) {
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(9);
        }
        if (files == null) {
            DeploymentCache.$$$reportNull$$$0(10);
        }
        if (servers == null) {
            DeploymentCache.$$$reportNull$$$0(11);
        }
        Triple cache = new Triple((Object)publishConfig, (Object)files, servers);
        if (chooseServer) {
            this.mySelectableServersForFiles = cache;
        } else {
            this.myDefaultServersForFiles = cache;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servers";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/DeploymentCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableServersForChanges";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setSuitableServersForChanges";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableServersForFiles";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "setSuitableServersForFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

