/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.util;

import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.ui.SimpleColoredText;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class UmlDataModelDumper<T> {
    private TransformerHandler myHandler;
    private final DiagramProvider<T> myProvider;
    private final DiagramDataModel<T> myModel;
    private final Comparator<DiagramNode> myNodeComparator;
    private final Comparator<DiagramEdge> myEdgeComparator;
    private static final String XML_ENTITIES_URL = "com.sun.org.apache.xml.internal.serializer.XMLEntities";
    private static final String XML_ENTITIES_CONTENT = "lt 60\ngt 62\nquot 34\namp 38";
    private final DiagramCategory[] myContentCategories;

    public static <T> String dumpToString(DiagramProvider<T> provider, DiagramDataModel<T> umlDataModel) {
        try {
            BufferExposingByteArrayOutputStream s = new BufferExposingByteArrayOutputStream();
            super.dump();
            return new String(s.getInternalBuffer(), 0, s.size(), CharsetToolkit.UTF8_CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void dump(Result result, DiagramProvider<T> provider, DiagramDataModel<T> umlDataModel, Comparator<DiagramNode> nodeComparator, Comparator<DiagramEdge> edgeComparator) throws Exception {
        super.dump();
    }

    public static <T> void dump(Result result, DiagramProvider<T> provider, DiagramDataModel<T> umlDataModel) throws Exception {
        UmlDataModelDumper.dump(result, provider, umlDataModel, new NodesIdComparator<T>(provider), new EdgesIdComparator<T>(provider));
    }

    private UmlDataModelDumper(Result handler, DiagramProvider<T> provider, DiagramDataModel<T> umlDataModel, Comparator<DiagramNode> nodeComparator, Comparator<DiagramEdge> edgeComparator) throws Exception {
        this.myProvider = provider;
        this.myModel = umlDataModel;
        this.myNodeComparator = nodeComparator;
        this.myEdgeComparator = edgeComparator;
        this.myContentCategories = this.myProvider.getNodeContentManager().getContentCategories();
        ClassLoaderUtil.runWithClassLoader((ClassLoader)new URLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader()){

            @Override
            public InputStream getResourceAsStream(String name) {
                if (UmlDataModelDumper.XML_ENTITIES_URL.equals(name)) {
                    String resource = UmlDataModelDumper.XML_ENTITIES_CONTENT;
                    return new ByteArrayInputStream(resource.getBytes(CharsetToolkit.UTF8_CHARSET));
                }
                return super.getResourceAsStream(name);
            }
        }, () -> {
            SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", new Integer(2));
            this.myHandler = transformerFactory.newTransformerHandler();
            Transformer serializer = this.myHandler.getTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            this.myHandler.setResult(handler);
        });
    }

    private void dump() throws SAXException {
        this.myHandler.startDocument();
        this.startElement("umlModel");
        ArrayList<DiagramNode<T>> nodes = new ArrayList<DiagramNode<T>>(this.myModel.getNodes());
        Collections.sort(nodes, this.myNodeComparator);
        for (DiagramNode diagramNode : nodes) {
            this.dumpNode(diagramNode);
        }
        ArrayList<DiagramEdge<T>> edges = new ArrayList<DiagramEdge<T>>(this.myModel.getEdges());
        Collections.sort(edges, this.myEdgeComparator);
        for (DiagramEdge diagramEdge : edges) {
            this.dumpEdge(diagramEdge);
        }
        this.endElement("umlModel");
        this.myHandler.endDocument();
    }

    private void dumpNode(DiagramNode<T> node) throws SAXException {
        ArrayList<Couple<String>> attrs = new ArrayList<Couple<String>>();
        attrs.add(Couple.of((Object)"id", (Object)this.myProvider.getVfsResolver().getQualifiedName(node.getIdentifyingElement())));
        attrs.add(Couple.of((Object)"nodeName", (Object)this.myModel.getNodeName(node)));
        attrs.add(Couple.of((Object)"name", (Object)node.getTooltip()));
        this.startElement("node", attrs);
        for (Object element : this.myProvider.getElementManager().getNodeItems(node.getIdentifyingElement())) {
            this.dumpElement(element);
        }
        this.endElement("node");
    }

    private void dumpEdge(DiagramEdge<T> edge) throws SAXException {
        ArrayList<Couple<String>> attrs = new ArrayList<Couple<String>>();
        attrs.add(Couple.of((Object)"from", (Object)this.myProvider.getVfsResolver().getQualifiedName(edge.getSource().getIdentifyingElement())));
        attrs.add(Couple.of((Object)"to", (Object)this.myProvider.getVfsResolver().getQualifiedName(edge.getTarget().getIdentifyingElement())));
        attrs.add(Couple.of((Object)"name", (Object)this.myModel.getEdgeName(edge)));
        attrs.add(Couple.of((Object)"idElement", (Object)this.myProvider.getVfsResolver().getQualifiedName(edge.getIdentifyingElement())));
        attrs.add(Couple.of((Object)"tooltip", (Object)edge.getName()));
        attrs.add(Couple.of((Object)"relship", (Object)edge.getRelationship().toString()));
        attrs.add(Couple.of((Object)"relshipLabel", (Object)edge.getRelationship().getLabel()));
        this.writeElement("edge", attrs);
    }

    private void dumpElement(Object element) throws SAXException {
        SimpleColoredText presentableType;
        ArrayList<Couple<String>> elementAttrs = new ArrayList<Couple<String>>();
        SimpleColoredText presentableName = this.myProvider.getElementManager().getItemName(element, this.myModel.getBuilder().getPresentation());
        if (presentableName != null) {
            elementAttrs.add(Couple.of((Object)"name", (Object)presentableName.toString()));
        }
        if ((presentableType = this.myProvider.getElementManager().getItemType(element)) != null) {
            elementAttrs.add(Couple.of((Object)"type", (Object)presentableType.toString()));
        }
        for (DiagramCategory category : this.myContentCategories) {
            if (!this.myProvider.getNodeContentManager().isInCategory(element, category, this.myModel.getBuilder().getPresentation())) continue;
            elementAttrs.add((Couple<String>)Couple.of((Object)"category", (Object)category.getName()));
            break;
        }
        DiagramVisibilityManager visibilityManager = this.myModel.getVisibilityManager();
        elementAttrs.add(Couple.of((Object)"visibility", (Object)visibilityManager.getVisibilityLevel(element).getName()));
        this.writeElement("element", elementAttrs);
    }

    private void startElement(String name) throws SAXException {
        this.startElement(name, Collections.emptyList());
    }

    private void startElement(String name, List<Couple<String>> attributes) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        for (Couple<String> attr : attributes) {
            if (!StringUtil.isNotEmpty((String)((String)attr.second))) continue;
            attrs.addAttribute("", "", (String)attr.first, "string", (String)attr.second);
        }
        this.myHandler.startElement("", "", name, attrs);
    }

    private void endElement(String name) throws SAXException {
        this.myHandler.endElement("", "", name);
    }

    public void writeElement(String name, List<Couple<String>> attributes) throws SAXException {
        this.startElement(name, attributes);
        this.endElement(name);
    }

    public static class EdgesIdComparator<T>
    implements Comparator<DiagramEdge<T>> {
        private final DiagramProvider<T> myProvider;

        public EdgesIdComparator(DiagramProvider<T> provider) {
            this.myProvider = provider;
        }

        @Override
        public int compare(DiagramEdge<T> o1, DiagramEdge<T> o2) {
            String toId2;
            String fromId2;
            String fromId1 = this.myProvider.getVfsResolver().getQualifiedName(o1.getSource().getIdentifyingElement());
            int result = fromId1.compareTo(fromId2 = this.myProvider.getVfsResolver().getQualifiedName(o2.getSource().getIdentifyingElement()));
            if (result != 0) {
                return result;
            }
            String toId1 = this.myProvider.getVfsResolver().getQualifiedName(o1.getTarget().getIdentifyingElement());
            result = toId1.compareTo(toId2 = this.myProvider.getVfsResolver().getQualifiedName(o2.getTarget().getIdentifyingElement()));
            if (result != 0) {
                return result;
            }
            DiagramRelationshipInfo r1 = o1.getRelationship();
            DiagramRelationshipInfo r2 = o2.getRelationship();
            result = r1.toString().compareTo(r2.toString());
            if (result != 0) {
                return result;
            }
            String label1 = r1.getLabel();
            String label2 = r2.getLabel();
            if (label1 != null && label2 != null) {
                return label1.compareTo(label2);
            }
            return label1 == null ? -1 : 1;
        }
    }

    public static class NodesIdComparator<T>
    implements Comparator<DiagramNode<T>> {
        private final DiagramProvider<T> myProvider;

        public NodesIdComparator(DiagramProvider<T> provider) {
            this.myProvider = provider;
        }

        @Override
        public int compare(DiagramNode<T> o1, DiagramNode<T> o2) {
            String id1 = this.myProvider.getVfsResolver().getQualifiedName(o1.getIdentifyingElement());
            String id2 = this.myProvider.getVfsResolver().getQualifiedName(o2.getIdentifyingElement());
            return id1.compareTo(id2);
        }
    }
}

