/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.components.DiagramNodeBodyComponent;
import com.intellij.diagram.components.DiagramNodeHeaderComponent;
import com.intellij.openapi.graph.builder.renderer.GradientFilledPanel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.ui.Gray;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class DiagramNodeContainer
extends CellRendererPanel {
    private final GradientFilledPanel myHeader;
    private final JPanel myBody;
    private final DiagramNode myNode;
    private BufferedImage myCache;
    private int myCacheWidth;
    private int myCacheHeight;
    private Boolean myCacheSelected;
    private Icon myCacheIcon;
    private final DiagramNodeBodyComponent myNodeBodyComponent;

    public DiagramNodeContainer(DiagramNode node, DiagramBuilder builder, Point point) {
        this.setLayout(new BorderLayout(0, 0));
        this.setFocusable(false);
        this.setBorder((Border)JBUI.Borders.empty());
        this.myNode = node;
        this.myHeader = new DiagramNodeHeaderComponent(node, builder);
        this.myBody = new CellRendererPanel();
        this.myBody.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myBody.setBorder((Border)JBUI.Borders.empty());
        this.myNodeBodyComponent = new DiagramNodeBodyComponent(this.myNode, builder, point);
        this.myBody.add((Component)((Object)this.myNodeBodyComponent));
        if (UIUtil.isUnderDarcula() && this.myNodeBodyComponent.getComponentCount() > 0) {
            this.myHeader.setBorder((Border)new CustomLineBorder((Color)(GraphViewUtil.isPrintMode() ? Gray._168 : Gray._90), 0, 0, 1, 0));
        }
        if (GraphViewUtil.isPrintMode() && this.myNodeBodyComponent.getComponentCount() == 0) {
            this.myHeader.setBorder((Border)JBUI.Borders.empty());
        }
        this.add(this.getHeader(), "North");
        if (this.getBody().getComponentCount() > 0) {
            this.add(this.getBody(), "Center");
        }
    }

    public JPanel getHeader() {
        return this.myHeader;
    }

    public JPanel getBody() {
        return this.myBody;
    }

    public DiagramNodeBodyComponent getNodeBodyComponent() {
        return this.myNodeBodyComponent;
    }

    public void paint(Graphics g) {
        Boolean isSelected = (Boolean)this.myNode.getUserData(DiagramNode.SELECTED_NODE_KEY);
        if (this.getClientProperty("cell.editor") == Boolean.TRUE) {
            this.doPaint(g, isSelected);
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        Icon icon = this.myNode.getIcon();
        if (this.myCache == null || this.myCacheWidth != width || this.myCacheHeight != height || !Comparing.equal((Object)this.myCacheSelected, (Object)isSelected) || !Comparing.equal((Object)this.myCacheIcon, (Object)icon)) {
            this.myCacheWidth = width;
            this.myCacheHeight = height;
            this.myCacheSelected = isSelected;
            this.myCacheIcon = icon;
            this.myCache = UIUtil.createImage((Graphics)g, (int)width, (int)height, (int)(g instanceof Graphics2DDelegate ? 2 : 1));
            this.doPaint(this.myCache, isSelected);
        }
        UIUtil.drawImage((Graphics)g, (BufferedImage)this.myCache, null, (int)0, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPaint(BufferedImage image, Boolean isSelected) {
        boolean wasDoubleBuffered = this.isDoubleBuffered();
        if (wasDoubleBuffered) {
            this.setDoubleBuffered(false);
        }
        Graphics2D g = image.createGraphics();
        try {
            if (SystemInfo.isJetBrainsJvm) {
                g.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, DiagramNodeContainer.getContrastForColor(this.getForeground()));
            }
            GraphicsUtil.setupAAPainting((Graphics)g);
            GraphicsUtil.setupAntialiasing((Graphics)g);
            this.doPaint(g, isSelected);
        }
        finally {
            g.dispose();
        }
        if (wasDoubleBuffered) {
            this.setDoubleBuffered(true);
        }
    }

    private static int getContrastForColor(Color color) {
        int yiqValue = (color.getRed() * 299 + color.getGreen() * 587 + color.getBlue() * 114) / 1000;
        return yiqValue * 150 / 255 + 100;
    }

    private void doPaint(Graphics g, Boolean isSelected) {
        Color color = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(color);
        if (isSelected != null && !isSelected.booleanValue()) {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.4f));
        }
        super.paint(g);
    }
}

