/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.RevisionRange;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.integrate.ByNumberChangeListComparator;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.jetbrains.idea.svn.update.UpdateEventHandler;

public class Merger
implements IMerger {
    protected final List<CommittedChangeList> myChangeLists;
    protected final File myTarget;
    @Nullable
    protected final ProgressTracker myHandler;
    private final ProgressIndicator myProgressIndicator;
    protected final Url myCurrentBranchUrl;
    private final StringBuilder myCommitMessage;
    protected final SvnConfiguration mySvnConfig;
    private final Project myProject;
    @NotNull
    protected final SvnVcs myVcs;
    private final String myBranchName;
    private final boolean myRecordOnly;
    private final boolean myInvertRange;
    private final boolean myGroupSequentialChangeLists;
    private MergeChunk myMergeChunk;
    public static final Topic<CommittedChangesMergedStateChanged> COMMITTED_CHANGES_MERGED_STATE = new Topic("COMMITTED_CHANGES_MERGED_STATE", CommittedChangesMergedStateChanged.class);

    public Merger(SvnVcs vcs, List<CommittedChangeList> changeLists, File target, UpdateEventHandler handler, Url currentBranchUrl, String branchName) {
        this(vcs, changeLists, target, handler, currentBranchUrl, branchName, false, false, false);
    }

    public Merger(@NotNull SvnVcs vcs, List<CommittedChangeList> changeLists, File target, UpdateEventHandler handler, Url currentBranchUrl, String branchName, boolean recordOnly, boolean invertRange, boolean groupSequentialChangeLists) {
        if (vcs == null) {
            Merger.$$$reportNull$$$0(0);
        }
        this.myBranchName = branchName;
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.mySvnConfig = vcs.getSvnConfiguration();
        this.myCurrentBranchUrl = currentBranchUrl;
        this.myChangeLists = ContainerUtil.sorted(changeLists, (Comparator)ByNumberChangeListComparator.getInstance());
        this.myTarget = target;
        this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
        this.myHandler = handler;
        this.myCommitMessage = new StringBuilder();
        this.myRecordOnly = recordOnly;
        this.myInvertRange = invertRange;
        this.myGroupSequentialChangeLists = groupSequentialChangeLists;
    }

    @Override
    public boolean hasNext() {
        return this.isInBounds(this.getNextChunkStart());
    }

    @Override
    public void mergeNext() throws VcsException {
        this.myMergeChunk = this.getNextChunk();
        assert (this.myMergeChunk != null);
        this.setMergeIndicator();
        this.doMerge();
        this.appendComment();
    }

    private void setMergeIndicator() {
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.setText2("Merging changelist(s) " + this.myMergeChunk);
        }
    }

    private int getNextChunkStart() {
        return this.myMergeChunk == null ? 0 : this.myMergeChunk.nextChunkStart();
    }

    @Nullable
    private MergeChunk getNextChunk() {
        int start = this.getNextChunkStart();
        int size = 0;
        if (this.isInBounds(start)) {
            size = this.myGroupSequentialChangeLists ? this.getGroupSize(start) : 1;
        }
        return size > 0 ? new MergeChunk(start, size) : null;
    }

    private int getGroupSize(int start) {
        assert (this.isInBounds(start));
        int size = 1;
        while (this.isInBounds(start + size) && Merger.areSequential(this.listAt(start + size - 1), this.listAt(start + size))) {
            ++size;
        }
        return size;
    }

    private void appendComment() {
        Merger.appendComment(this.myCommitMessage, this.myBranchName, this.myMergeChunk.changeLists());
    }

    public static void appendComment(@NotNull StringBuilder builder, @NotNull String branch, @NotNull Iterable<CommittedChangeList> changeLists) {
        if (builder == null) {
            Merger.$$$reportNull$$$0(1);
        }
        if (branch == null) {
            Merger.$$$reportNull$$$0(2);
        }
        if (changeLists == null) {
            Merger.$$$reportNull$$$0(3);
        }
        if (builder.length() == 0) {
            builder.append("Merged from ").append(branch);
        }
        for (CommittedChangeList list : changeLists) {
            builder.append('\n').append(list.getComment().trim()).append(" [from revision ").append(list.getNumber()).append("]");
        }
    }

    protected void doMerge() throws VcsException {
        Target source = Target.on(this.myCurrentBranchUrl);
        MergeClient client = this.myVcs.getFactory(this.myTarget).createMergeClient();
        client.merge(source, this.myMergeChunk.revisionRange(), this.myTarget, Depth.INFINITY, this.mySvnConfig.isMergeDryRun(), this.myRecordOnly, true, this.mySvnConfig.getMergeOptions(), this.myHandler);
    }

    @Override
    @Nullable
    public String getInfo() {
        String result = null;
        if (this.myMergeChunk != null) {
            StringBuilder builder = new StringBuilder("Changelist(s) :");
            for (CommittedChangeList list : this.myMergeChunk.changeLists()) {
                String nextComment = list.getComment().trim().replace('\n', '|');
                builder.append("\n").append(list.getNumber()).append(" (").append(nextComment).append(")");
            }
            builder.append(" merging faced problems");
            result = builder.toString();
        }
        return result;
    }

    @Override
    @Nullable
    public String getSkipped() {
        return Merger.getSkippedMessage(this.myMergeChunk != null ? this.myMergeChunk.chunkAndAfterLists() : ContainerUtil.emptyList());
    }

    @Nullable
    public static String getSkippedMessage(@NotNull List<CommittedChangeList> changeLists) {
        if (changeLists == null) {
            Merger.$$$reportNull$$$0(4);
        }
        String result = null;
        if (!changeLists.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < changeLists.size(); ++i) {
                CommittedChangeList list = changeLists.get(i);
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(list.getNumber()).append(" (").append(list.getComment().replace('\n', '|')).append(')');
            }
            result = SvnBundle.message("action.Subversion.integrate.changes.warning.skipped.lists.text", sb.toString());
        }
        return result;
    }

    @Override
    public String getComment() {
        return this.myCommitMessage.toString();
    }

    @Override
    @Nullable
    public File getMergeInfoHolder() {
        return this.myTarget;
    }

    @Override
    public void afterProcessing() {
        if (!this.myGroupSequentialChangeLists) {
            List processed = this.myMergeChunk != null ? ContainerUtil.newArrayList(this.myMergeChunk.chunkAndBeforeLists()) : ContainerUtil.emptyList();
            ((CommittedChangesMergedStateChanged)BackgroundTaskUtil.syncPublisher((Project)this.myProject, COMMITTED_CHANGES_MERGED_STATE)).event(processed);
        }
    }

    @NotNull
    private CommittedChangeList listAt(int index) {
        CommittedChangeList committedChangeList = this.myChangeLists.get(index);
        if (committedChangeList == null) {
            Merger.$$$reportNull$$$0(5);
        }
        return committedChangeList;
    }

    private boolean isInBounds(int index) {
        return index >= 0 && index < this.myChangeLists.size();
    }

    private static boolean areSequential(@NotNull CommittedChangeList list1, @NotNull CommittedChangeList list2) {
        if (list1 == null) {
            Merger.$$$reportNull$$$0(6);
        }
        if (list2 == null) {
            Merger.$$$reportNull$$$0(7);
        }
        return list1.getNumber() + 1L == list2.getNumber();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/integrate/Merger";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/integrate/Merger";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "listAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendComment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSkippedMessage";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "areSequential";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MergeChunk {
        private final int myStart;
        private final int mySize;

        public MergeChunk(int start, int size) {
            this.myStart = start;
            this.mySize = size;
        }

        public int start() {
            return this.myStart;
        }

        public int end() {
            return this.myStart + this.mySize - 1;
        }

        public int size() {
            return this.mySize;
        }

        public int nextChunkStart() {
            return this.end() + 1;
        }

        public long lowestNumber() {
            return Merger.this.myChangeLists.get(this.start()).getNumber();
        }

        public long highestNumber() {
            return Merger.this.myChangeLists.get(this.end()).getNumber();
        }

        @NotNull
        public List<CommittedChangeList> changeLists() {
            List<CommittedChangeList> list = Merger.this.myChangeLists.subList(this.start(), this.nextChunkStart());
            if (list == null) {
                MergeChunk.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public List<CommittedChangeList> chunkAndBeforeLists() {
            List<CommittedChangeList> list = Merger.this.myChangeLists.subList(0, this.nextChunkStart());
            if (list == null) {
                MergeChunk.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public List<CommittedChangeList> chunkAndAfterLists() {
            List list = ContainerUtil.subList(Merger.this.myChangeLists, (int)this.start());
            if (list == null) {
                MergeChunk.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public RevisionRange revisionRange() {
            Revision startRevision = Revision.of(this.lowestNumber() - 1L);
            Revision endRevision = Revision.of(this.highestNumber());
            RevisionRange revisionRange = Merger.this.myInvertRange ? new RevisionRange(endRevision, startRevision) : new RevisionRange(startRevision, endRevision);
            if (revisionRange == null) {
                MergeChunk.$$$reportNull$$$0(3);
            }
            return revisionRange;
        }

        public String toString() {
            return this.highestNumber() == this.lowestNumber() ? String.valueOf(this.lowestNumber()) : this.lowestNumber() + "-" + this.highestNumber();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/idea/svn/integrate/Merger$MergeChunk";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "changeLists";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "chunkAndBeforeLists";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "chunkAndAfterLists";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "revisionRange";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static interface CommittedChangesMergedStateChanged {
        public void event(List<CommittedChangeList> var1);
    }
}

