/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ForNestedRootChecker;
import org.jetbrains.idea.svn.NestedCopiesHolder;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.status.Status;

public class SvnRootsDetector {
    private static final Logger LOG = Logger.getInstance(SvnRootsDetector.class);
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final SvnFileUrlMappingImpl myMapping;
    @NotNull
    private final Result myResult;
    @NotNull
    private final RepositoryRoots myRepositoryRoots;
    @NotNull
    private final NestedCopiesHolder myNestedCopiesHolder;

    public SvnRootsDetector(@NotNull SvnVcs vcs, @NotNull SvnFileUrlMappingImpl mapping, @NotNull NestedCopiesHolder holder) {
        if (vcs == null) {
            SvnRootsDetector.$$$reportNull$$$0(0);
        }
        if (mapping == null) {
            SvnRootsDetector.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            SvnRootsDetector.$$$reportNull$$$0(2);
        }
        this.myVcs = vcs;
        this.myMapping = mapping;
        this.myResult = new Result();
        this.myNestedCopiesHolder = holder;
        this.myRepositoryRoots = new RepositoryRoots(this.myVcs);
    }

    public void detectCopyRoots(VirtualFile[] roots, boolean clearState, Runnable callback) {
        for (VirtualFile vcsRoot : roots) {
            List<Node> foundRoots = new ForNestedRootChecker(this.myVcs).getAllNestedWorkingCopies(vcsRoot);
            this.registerLonelyRoots(vcsRoot, foundRoots);
            this.registerTopRoots(vcsRoot, foundRoots);
        }
        this.addNestedRoots(clearState, callback);
    }

    private void registerLonelyRoots(VirtualFile vcsRoot, List<Node> foundRoots) {
        if (foundRoots.isEmpty()) {
            this.myResult.myLonelyRoots.add(vcsRoot);
        }
    }

    private void registerTopRoots(@NotNull VirtualFile vcsRoot, @NotNull List<Node> foundRoots) {
        if (vcsRoot == null) {
            SvnRootsDetector.$$$reportNull$$$0(3);
        }
        if (foundRoots == null) {
            SvnRootsDetector.$$$reportNull$$$0(4);
        }
        for (Node foundRoot : foundRoots) {
            RootUrlInfo root = new RootUrlInfo(foundRoot, SvnFormatSelector.findRootAndGetFormat(foundRoot.getIoFile()), vcsRoot);
            if (!foundRoot.hasError()) {
                this.myRepositoryRoots.register(foundRoot.getRepositoryRootUrl());
                this.myResult.myTopRoots.add(root);
                continue;
            }
            this.myResult.myErrorRoots.add(root);
        }
    }

    private void addNestedRoots(boolean clearState, Runnable callback) {
        List basicVfRoots = ContainerUtil.map((Collection)this.myResult.myTopRoots, RootUrlInfo::getVirtualFile);
        ChangeListManager clManager = ChangeListManager.getInstance((Project)this.myVcs.getProject());
        if (clearState) {
            this.myNestedCopiesHolder.getAndClear();
            VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject()).filesDirty(null, (Collection)basicVfRoots);
        }
        clManager.invokeAfterUpdate(() -> {
            ArrayList<RootUrlInfo> nestedRoots = new ArrayList<RootUrlInfo>();
            for (NestedCopyInfo info : this.myNestedCopiesHolder.getAndClear()) {
                if (NestedCopyType.external.equals((Object)info.getType()) || NestedCopyType.switched.equals((Object)info.getType())) {
                    RootUrlInfo topRoot = this.findTopRoot(VfsUtilCore.virtualToIoFile((VirtualFile)info.getFile()));
                    if (topRoot != null) {
                        topRoot.setType(info.getType());
                        continue;
                    }
                    if (!this.refreshPointInfo(info)) continue;
                }
                this.registerRootUrlFromNestedPoint(info, nestedRoots);
            }
            this.myResult.myTopRoots.addAll(nestedRoots);
            SvnRootsDetector.putWcDbFilesToVfs(this.myResult.myTopRoots);
            this.myMapping.applyDetectionResult(this.myResult);
            callback.run();
        }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, null, null);
    }

    private static void putWcDbFilesToVfs(@NotNull Collection<RootUrlInfo> infos) {
        if (infos == null) {
            SvnRootsDetector.$$$reportNull$$$0(5);
        }
        if (!SvnVcs.ourListenToWcDb) {
            return;
        }
        List wcDbFiles = infos.stream().filter(info -> info.getFormat().isOrGreater(WorkingCopyFormat.ONE_DOT_SEVEN)).filter(info -> !NestedCopyType.switched.equals((Object)info.getType())).map(RootUrlInfo::getIoFile).map(SvnUtil::getWcDb).collect(Collectors.toList());
        LocalFileSystem.getInstance().refreshIoFiles(wcDbFiles);
    }

    private void registerRootUrlFromNestedPoint(@NotNull NestedCopyInfo info, @NotNull List<RootUrlInfo> nestedRoots) {
        RootUrlInfo topRoot;
        if (info == null) {
            SvnRootsDetector.$$$reportNull$$$0(6);
        }
        if (nestedRoots == null) {
            SvnRootsDetector.$$$reportNull$$$0(7);
        }
        if ((topRoot = this.findAncestorTopRoot(info.getFile())) != null) {
            Url repoRoot = info.getRootURL();
            Url url = repoRoot = repoRoot == null ? this.myRepositoryRoots.ask(info.getUrl(), info.getFile()) : repoRoot;
            if (repoRoot != null) {
                Node node = new Node(info.getFile(), info.getUrl(), repoRoot);
                nestedRoots.add(new RootUrlInfo(node, info.getFormat(), topRoot.getRoot(), info.getType()));
            }
        }
    }

    private boolean refreshPointInfo(@NotNull NestedCopyInfo info) {
        if (info == null) {
            SvnRootsDetector.$$$reportNull$$$0(8);
        }
        boolean refreshed = false;
        try {
            File infoFile = VfsUtilCore.virtualToIoFile((VirtualFile)info.getFile());
            Status svnStatus = SvnUtil.getStatus(this.myVcs, infoFile);
            if (svnStatus != null && svnStatus.getURL() != null) {
                info.setUrl(svnStatus.getURL());
                info.setFormat(this.myVcs.getWorkingCopyFormat(infoFile, false));
                if (svnStatus.getRepositoryRootURL() != null) {
                    info.setRootURL(svnStatus.getRepositoryRootURL());
                }
                refreshed = true;
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        return refreshed;
    }

    @Nullable
    private RootUrlInfo findTopRoot(@NotNull File file) {
        if (file == null) {
            SvnRootsDetector.$$$reportNull$$$0(9);
        }
        return (RootUrlInfo)ContainerUtil.find((Iterable)this.myResult.myTopRoots, topRoot -> {
            if (file == null) {
                SvnRootsDetector.$$$reportNull$$$0(12);
            }
            return FileUtil.filesEqual((File)topRoot.getIoFile(), (File)file);
        });
    }

    @Nullable
    private RootUrlInfo findAncestorTopRoot(@NotNull VirtualFile file) {
        if (file == null) {
            SvnRootsDetector.$$$reportNull$$$0(10);
        }
        return (RootUrlInfo)ContainerUtil.find((Iterable)this.myResult.myTopRoots, topRoot -> {
            if (file == null) {
                SvnRootsDetector.$$$reportNull$$$0(11);
            }
            return VfsUtilCore.isAncestor((VirtualFile)topRoot.getVirtualFile(), (VirtualFile)file, (boolean)true);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundRoots";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedRoots";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/SvnRootsDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerTopRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "putWcDbFilesToVfs";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "registerRootUrlFromNestedPoint";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshPointInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findTopRoot";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findAncestorTopRoot";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findAncestorTopRoot$4";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findTopRoot$3";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Result {
        @NotNull
        private final List<VirtualFile> myLonelyRoots;
        @NotNull
        private final List<RootUrlInfo> myTopRoots = new ArrayList<RootUrlInfo>();
        @NotNull
        private final List<RootUrlInfo> myErrorRoots = new ArrayList<RootUrlInfo>();

        public Result() {
            this.myLonelyRoots = new ArrayList<VirtualFile>();
        }

        @NotNull
        public List<VirtualFile> getLonelyRoots() {
            List<VirtualFile> list = this.myLonelyRoots;
            if (list == null) {
                Result.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public List<RootUrlInfo> getTopRoots() {
            List<RootUrlInfo> list = this.myTopRoots;
            if (list == null) {
                Result.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public List<RootUrlInfo> getErrorRoots() {
            List<RootUrlInfo> list = this.myErrorRoots;
            if (list == null) {
                Result.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/idea/svn/SvnRootsDetector$Result";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLonelyRoots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTopRoots";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorRoots";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class RepositoryRoots {
        private final SvnVcs myVcs;
        private final Set<Url> myRoots;

        private RepositoryRoots(SvnVcs vcs) {
            this.myVcs = vcs;
            this.myRoots = new HashSet<Url>();
        }

        public void register(Url url) {
            this.myRoots.add(url);
        }

        public Url ask(Url url, VirtualFile file) {
            for (Url root : this.myRoots) {
                if (!SvnUtil.isAncestor(root, url)) continue;
                return root;
            }
            Url newUrl = SvnUtil.getRepositoryRoot(this.myVcs, VfsUtilCore.virtualToIoFile((VirtualFile)file));
            if (newUrl != null) {
                this.myRoots.add(newUrl);
                return newUrl;
            }
            return null;
        }
    }
}

