/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.deployment.ui.DockerRemoteDebugExtensionEditor;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfigurationExtension;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRemoteDebugRunConfigurationExtension
extends DeployToServerRunConfigurationExtension {
    private static final Boolean IS_IDEA_173089_FIXED = Boolean.FALSE;

    @Nullable
    protected String getEditorTitle() {
        return "Java Remote Debug";
    }

    protected boolean isApplicableFor(@NotNull DeployToServerRunConfiguration configuration) {
        if (configuration == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        return IS_IDEA_173089_FIXED != false && DockerCloudType.getInstance().isDebugSupported() && configuration.getServerType() == DockerCloudType.getInstance() && DockerRemoteDebugRunConfigurationExtension.isSupportedDeploymentSource(configuration) && DockerRemoteDebugRunConfigurationExtension.hasJavaModule(configuration.getProject());
    }

    private static boolean isSupportedDeploymentSource(@NotNull DeployToServerRunConfiguration configuration) {
        DeploymentSourceType type;
        if (configuration == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        return (type = (DeploymentSourceType)Optional.ofNullable(configuration.getDeploymentSource()).map(DeploymentSource::getType).orElse(null)) == DockerFileDeploymentSourceType.getInstance();
    }

    private static boolean hasJavaModule(@NotNull Project project) {
        if (project == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        return Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).anyMatch(m -> ModuleType.is((Module)m, (ModuleType)JavaModuleType.getModuleType()));
    }

    protected boolean isEnabledFor(@NotNull DeployToServerRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(3);
        }
        return true;
    }

    @NotNull
    protected SettingsEditor<DeployToServerRunConfiguration> createEditor(@NotNull DeployToServerRunConfiguration configuration) {
        if (configuration == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(4);
        }
        DockerRemoteDebugExtensionEditor dockerRemoteDebugExtensionEditor = new DockerRemoteDebugExtensionEditor();
        if (dockerRemoteDebugExtensionEditor == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(5);
        }
        return dockerRemoteDebugExtensionEditor;
    }

    protected void patchCommandLine(@NotNull DeployToServerRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        if (configuration == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(6);
        }
        if (cmdLine == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(7);
        }
        if (runnerId == null) {
            DockerRemoteDebugRunConfigurationExtension.$$$reportNull$$$0(8);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerRemoteDebugRunConfigurationExtension";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerRemoteDebugRunConfigurationExtension";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedDeploymentSource";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasJavaModule";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

