/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IoKt;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u001a$\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0007\u001a\u0012\u0010\u0016\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007\u001a\n\u0010\u0018\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u0019\u001a\u00020\r*\u00020\u0007\u001a\u0012\u0010\u001a\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007\u001a\n\u0010\u001b\u001a\u00020\r*\u00020\u0007\u001a\u0012\u0010\u001c\u001a\u00020\r*\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0006\u001a\u0014\u0010\u001e\u001a\n \u001f*\u0004\u0018\u00010\u00070\u0007*\u00020\u0007H\u0002\u001a\u001c\u0010 \u001a\u00020\u0013*\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\b\b\u0002\u0010\"\u001a\u00020\u0013\u001ah\u0010#\u001a\u0004\u0018\u0001H$\"\u0004\b\u0000\u0010$*\u00020\u00072#\b\b\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b'\u0012\b\b\u0010\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u00130&2'\u0010(\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00070)\u00a2\u0006\f\b'\u0012\b\b\u0010\u0012\u0004\b\b(*\u0012\u0004\u0012\u0002H$0&H\u0086\b\u00a2\u0006\u0002\u0010+\u001aC\u0010#\u001a\u0004\u0018\u0001H$\"\u0004\b\u0000\u0010$*\u00020\u00072'\u0010(\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00070)\u00a2\u0006\f\b'\u0012\b\b\u0010\u0012\u0004\b\b(*\u0012\u0004\u0012\u0002H$0&H\u0086\b\u00a2\u0006\u0002\u0010,\u001a\n\u0010-\u001a\u00020\u0013*\u00020\u0007\u001a\n\u0010.\u001a\u00020/*\u00020\u0007\u001a\f\u00100\u001a\u0004\u0018\u00010/*\u00020\u0007\u001a\n\u00101\u001a\u00020\u0013*\u00020\u0007\u001a\n\u0010\"\u001a\u00020\u0013*\u00020\u0007\u001a\n\u00102\u001a\u00020\u0013*\u00020\u0007\u001a\n\u00103\u001a\u000204*\u00020\u0007\u001a\u0012\u00105\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007\u001a\n\u00106\u001a\u000207*\u00020\u0007\u001a\n\u00108\u001a\u000209*\u00020\u0007\u001a\n\u0010:\u001a\u00020;*\u00020\u0007\u001a\n\u0010<\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010=\u001a\u00020>*\u00020\u0007\u001a\n\u0010?\u001a\u00020>*\u00020\u0007\u001a&\u0010@\u001a\u00020\u0007*\u00020\u00072\u0006\u0010A\u001a\u0002092\b\b\u0002\u0010B\u001a\u00020C2\b\b\u0002\u0010=\u001a\u00020C\u001a\u0012\u0010@\u001a\u00020\u0007*\u00020\u00072\u0006\u0010A\u001a\u00020\u0006\u001a\u001a\u0010D\u001a\u00020\u0007*\u00020\u00072\u0006\u0010E\u001a\u00020\u00062\u0006\u0010A\u001a\u000209\u001a\u001a\u0010D\u001a\u00020\u0007*\u00020\u00072\u0006\u0010E\u001a\u00020\u00062\u0006\u0010A\u001a\u00020\u0006\u001a\u001e\u0010F\u001a\u00020\u0007*\u00020\u00072\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\r0&\u001a&\u0010F\u001a\u00020\u0007*\u00020\u00072\u0006\u0010A\u001a\u0002092\b\b\u0002\u0010B\u001a\u00020C2\b\b\u0002\u0010=\u001a\u00020C\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006H"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "illegalChars", "", "", "parentSystemIndependentPath", "", "Ljava/nio/file/Path;", "getParentSystemIndependentPath", "(Ljava/nio/file/Path;)Ljava/lang/String;", "systemIndependentPath", "getSystemIndependentPath", "doCreateDirectories", "", "path", "sanitizeFileName", "name", "replacement", "isTruncate", "", "basicAttributesIfExists", "Ljava/nio/file/attribute/BasicFileAttributes;", "copy", "target", "createDirectories", "createFile", "createSymbolicLink", "delete", "deleteChildrenStartingWith", "prefix", "deleteRecursively", "kotlin.jvm.PlatformType", "deleteWithParentsIfEmpty", "root", "isFile", "directoryStreamIfExists", "R", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "task", "Ljava/nio/file/DirectoryStream;", "stream", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "exists", "inputStream", "Ljava/io/InputStream;", "inputStreamIfExists", "isDirectory", "isHidden", "lastModified", "Ljava/nio/file/attribute/FileTime;", "move", "outputStream", "Ljava/io/OutputStream;", "readBytes", "", "readChars", "", "readText", "size", "", "sizeOrNull", "write", "data", "offset", "", "writeChild", "relativePath", "writeSafe", "outConsumer", "intellij.platform.projectModel"})
public final class PathKt {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.util.io.FileUtil");
    private static final Set<Character> illegalChars = SetsKt.setOf((Object[])new Character[]{Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('?'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('*'), Character.valueOf('|'), Character.valueOf('\"'), Character.valueOf(':')});

    public static final boolean exists(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.exists($receiver, new LinkOption[0]);
    }

    @NotNull
    public static final Path createDirectories(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!Files.isDirectory($receiver, new LinkOption[0])) {
            Path path2 = $receiver.toAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"toAbsolutePath()");
            PathKt.doCreateDirectories(path2);
        }
        return $receiver;
    }

    private static final void doCreateDirectories(Path path2) {
        Path path3;
        Path it;
        Path path4 = path2.getParent();
        if (path4 != null && !Files.isDirectory(it = (path3 = path4), new LinkOption[0])) {
            PathKt.doCreateDirectories(it);
        }
        Files.createDirectory(path2, new FileAttribute[0]);
    }

    @NotNull
    public static final OutputStream outputStream(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path2 = $receiver.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        OutputStream outputStream = Files.newOutputStream($receiver, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"Files.newOutputStream(this)");
        return outputStream;
    }

    @NotNull
    public static final InputStream inputStream(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream inputStream = Files.newInputStream($receiver, new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Files.newInputStream(this)");
        return inputStream;
    }

    @Nullable
    public static final InputStream inputStreamIfExists(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            return PathKt.inputStream($receiver);
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    @NotNull
    public static final Path createSymbolicLink(@NotNull Path $receiver, @NotNull Path target) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Path path2 = $receiver.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Files.createSymbolicLink($receiver, target, new FileAttribute[0]);
        return $receiver;
    }

    public static final void delete(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists($receiver);
        if (basicFileAttributes == null) {
            return;
        }
        BasicFileAttributes attributes = basicFileAttributes;
        try {
            if (attributes.isDirectory()) {
                PathKt.deleteRecursively($receiver);
            } else {
                Files.delete($receiver);
            }
        }
        catch (Exception e) {
            FileUtil.delete((File)$receiver.toFile());
        }
    }

    public static final boolean deleteWithParentsIfEmpty(@NotNull Path $receiver, @NotNull Path root, boolean isFile) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        try {
            PathKt.delete($receiver);
        }
        catch (NoSuchFileException e) {
            return false;
        }
        for (Path parent = isFile ? $receiver.getParent() : null; parent != null && Intrinsics.areEqual((Object)parent, (Object)root) ^ true; parent = parent.getParent()) {
            try {
                Files.delete(parent);
                continue;
            }
            catch (IOException e) {
                break;
            }
        }
        return true;
    }

    public static /* bridge */ /* synthetic */ boolean deleteWithParentsIfEmpty$default(Path path2, Path path3, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PathKt.deleteWithParentsIfEmpty(path2, path3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deleteChildrenStartingWith(@NotNull Path $receiver, @NotNull String prefix) {
        Iterable iterable;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Path path2 = $receiver;
        Function1 filter$iv = (Function1)new Function1<Path, Boolean>(prefix){
            final /* synthetic */ String $prefix;

            public final boolean invoke(@NotNull Path it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)this.$prefix, (boolean)false, (int)2, null);
            }
            {
                this.$prefix = string;
                super(1);
            }
        };
        try {
            Closeable closeable = Files.newDirectoryStream((Path)$receiver$iv, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter$iv){
                final /* synthetic */ Function1 $filter;

                public final boolean accept(Path it) {
                    Path path2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)path2);
                }
                {
                    this.$filter = function1;
                }
            });
            Throwable throwable = null;
            try {
                Iterable it = (DirectoryStream)closeable;
                it = CollectionsKt.toList((Iterable)it);
                iterable = it;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            iterable = null;
        }
        if (iterable != null) {
            $receiver$iv = iterable;
            for (Object element$iv : $receiver$iv) {
                Path it;
                Path path3 = it = (Path)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"it");
                PathKt.delete(path3);
            }
        }
    }

    private static final Path deleteRecursively(@NotNull Path $receiver) {
        return Files.walkFileTree($receiver, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
                try {
                    Files.delete(file);
                }
                catch (Exception e) {
                    FileUtil.delete((File)file.toFile());
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) {
                Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                try {
                    Files.delete(dir);
                }
                catch (Exception e) {
                    FileUtil.delete((File)dir.toFile());
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @NotNull
    public static final FileTime lastModified(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        FileTime fileTime = Files.getLastModifiedTime($receiver, new LinkOption[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTime, (String)"Files.getLastModifiedTime(this)");
        return fileTime;
    }

    @NotNull
    public static final String getSystemIndependentPath(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.replace$default((String)((Object)$receiver).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String getParentSystemIndependentPath(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path2 = $receiver.getParent();
        if (path2 == null) {
            Intrinsics.throwNpe();
        }
        return StringsKt.replace$default((String)((Object)path2).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] byArray = Files.readAllBytes($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.readAllBytes(this)");
        return byArray;
    }

    @NotNull
    public static final String readText(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] byArray = PathKt.readBytes($receiver);
        Charset charset = Charsets.UTF_8;
        return new String(byArray, charset);
    }

    @NotNull
    public static final CharSequence readChars(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream inputStream = PathKt.inputStream($receiver);
        Charset charset = Charsets.UTF_8;
        return IoKt.readCharSequence(new InputStreamReader(inputStream, charset), (int)PathKt.size($receiver));
    }

    @NotNull
    public static final Path writeChild(@NotNull Path $receiver, @NotNull String relativePath, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Path path2 = $receiver.resolve(relativePath);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"resolve(relativePath)");
        return PathKt.write$default(path2, data, 0, 0, 6, null);
    }

    @NotNull
    public static final Path writeChild(@NotNull Path $receiver, @NotNull String relativePath, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = data;
        String string2 = relativePath;
        Path path2 = $receiver;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        return PathKt.writeChild(path2, string2, byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Path write(@NotNull Path $receiver, @NotNull byte[] data, int offset, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Closeable closeable = PathKt.outputStream($receiver);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            it.write(data, offset, size);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return $receiver;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Path write$default(Path path2, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return PathKt.write(path2, byArray, n, n2);
    }

    @NotNull
    public static final Path writeSafe(@NotNull Path $receiver, @NotNull byte[] data, int offset, int size) {
        Path tempFile;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Path path2 = tempFile = $receiver.getParent().resolve("" + $receiver.getFileName() + '.' + UUID.randomUUID() + ".tmp");
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"tempFile");
        PathKt.write(path2, data, offset, size);
        try {
            Files.move(tempFile, $receiver, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            FileUtil.rename((File)tempFile.toFile(), (File)$receiver.toFile());
        }
        return $receiver;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Path writeSafe$default(Path path2, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return PathKt.writeSafe(path2, byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Path writeSafe(@NotNull Path $receiver, @NotNull Function1<? super OutputStream, Unit> outConsumer) {
        Path tempFile;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(outConsumer, (String)"outConsumer");
        Path path2 = tempFile = $receiver.getParent().resolve("" + $receiver.getFileName() + '.' + UUID.randomUUID() + ".tmp");
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"tempFile");
        Closeable closeable = PathKt.outputStream(path2);
        Throwable throwable = null;
        try {
            Object object = outConsumer.invoke((Object)closeable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        try {
            Files.move(tempFile, $receiver, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            FileUtil.rename((File)tempFile.toFile(), (File)$receiver.toFile());
        }
        return $receiver;
    }

    @NotNull
    public static final Path write(@NotNull Path $receiver, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Path path2 = $receiver.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        String string = data;
        Path path3 = $receiver;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        Files.write(path3, byArray2, new OpenOption[0]);
        return $receiver;
    }

    public static final long size(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.size($receiver);
    }

    @Nullable
    public static final BasicFileAttributes basicAttributesIfExists(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            return Files.readAttributes($receiver, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException ignored) {
            return null;
        }
    }

    public static final long sizeOrNull(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists($receiver);
        return basicFileAttributes != null ? basicFileAttributes.size() : -1L;
    }

    public static final boolean isHidden(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isHidden($receiver);
    }

    public static final boolean isDirectory(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isDirectory($receiver, new LinkOption[0]);
    }

    public static final boolean isFile(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Files.isRegularFile($receiver, new LinkOption[0]);
    }

    @NotNull
    public static final Path move(@NotNull Path $receiver, @NotNull Path target) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Path path2 = Files.move($receiver, target, StandardCopyOption.REPLACE_EXISTING);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Files.move(this, target,\u2026yOption.REPLACE_EXISTING)");
        return path2;
    }

    @NotNull
    public static final Path copy(@NotNull Path $receiver, @NotNull Path target) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Path path2 = $receiver.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Path path3 = Files.copy($receiver, target, StandardCopyOption.REPLACE_EXISTING);
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Files.copy(this, target,\u2026yOption.REPLACE_EXISTING)");
        return path3;
    }

    public static final void createFile(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Path path2 = $receiver.getParent();
        if (path2 != null) {
            PathKt.createDirectories(path2);
        }
        Files.createFile($receiver, new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $receiver, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            Object object;
            Closeable closeable = Files.newDirectoryStream($receiver);
            Throwable throwable = null;
            try {
                object = task.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> R directoryStreamIfExists(@NotNull Path $receiver, @NotNull Function1<? super Path, Boolean> filter, @NotNull Function1<? super DirectoryStream<Path>, ? extends R> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            Object object;
            Closeable closeable = Files.newDirectoryStream($receiver, (DirectoryStream.Filter<? super Path>)new /* invalid duplicate definition of identical inner class */);
            Throwable throwable = null;
            try {
                object = task.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            return (R)object;
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeFileName(@NotNull String name, @Nullable String replacement, boolean isTruncate) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        StringBuilder result2 = null;
        int last = 0;
        int length = name.length();
        int n = 0;
        int n2 = length;
        while (n < n2) {
            char c;
            void i;
            char c2 = name.charAt((int)i);
            if (illegalChars.contains(Character.valueOf(c2)) || Character.isISOControl(c = c2)) {
                if (result2 == null) {
                    result2 = new StringBuilder();
                }
                if (last < i) {
                    result2.append(name, last, (int)i);
                }
                if (replacement != null) {
                    result2.append(replacement);
                }
                last = i + true;
            }
            ++i;
        }
        Function1<String, String> truncateFileName$ = new Function1<String, String>(isTruncate, length){
            final /* synthetic */ boolean $isTruncate;
            final /* synthetic */ int $length;

            @NotNull
            public final String invoke(@NotNull String $receiver) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                if (this.$isTruncate) {
                    String string2 = $receiver;
                    int n = 0;
                    int n2 = Math.min(this.$length, 255);
                    String string3 = string2.substring(n, n2);
                    string = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string = $receiver;
                }
                return string;
            }
            {
                this.$isTruncate = bl;
                this.$length = n;
                super(1);
            }
        };
        if (result2 == null) {
            return truncateFileName$.invoke(name);
        }
        if (last < length) {
            result2.append(name, last, length);
        }
        String string = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
        return truncateFileName$.invoke(string);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String sanitizeFileName$default(String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "_";
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return PathKt.sanitizeFileName(string, string2, bl);
    }
}

